/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.server;

import com.dataiku.dss.shadelib.org.eclipse.jetty.http.pathmap.PathSpec;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Handler;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Request;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Response;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.Callback;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.Configuration;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.WebSocketComponents;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.server.WebSocketMappings;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.server.WebSocketNegotiator;
import java.util.function.Consumer;

public class WebSocketUpgradeHandler
extends Handler.Wrapper {
    private final WebSocketMappings _mappings;
    private final Configuration.ConfigurationCustomizer _customizer = new Configuration.ConfigurationCustomizer();
    private final Consumer<WebSocketUpgradeHandler> _configurator;

    public WebSocketUpgradeHandler() {
        this(null, null);
    }

    public WebSocketUpgradeHandler(WebSocketComponents components) {
        this(components, null);
    }

    public WebSocketUpgradeHandler(Consumer<WebSocketUpgradeHandler> configurator) {
        this(null, configurator);
    }

    public WebSocketUpgradeHandler(WebSocketComponents components, Consumer<WebSocketUpgradeHandler> configurator) {
        this._mappings = new WebSocketMappings(components == null ? new WebSocketComponents() : components);
        this._configurator = configurator;
        this.installBean(this._mappings);
        this.setHandler(new Handler.Abstract.NonBlocking(){

            @Override
            public boolean handle(Request request, Response response, Callback callback) {
                Response.writeError(request, response, callback, 404);
                return true;
            }
        });
    }

    public void addMapping(String pathSpec, WebSocketNegotiator negotiator) {
        this._mappings.addMapping(WebSocketMappings.parsePathSpec(pathSpec), negotiator);
    }

    public void addMapping(PathSpec pathSpec, WebSocketNegotiator negotiator) {
        this._mappings.addMapping(pathSpec, negotiator);
    }

    @Override
    protected void doStart() throws Exception {
        if (this._configurator != null) {
            this._configurator.accept(this);
        }
        super.doStart();
    }

    public Configuration getConfiguration() {
        return this._customizer;
    }

    @Override
    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        try {
            if (this._mappings.upgrade(request, response, callback, this._customizer)) {
                return true;
            }
            return super.handle(request, response, callback);
        }
        catch (Throwable x) {
            Response.writeError(request, response, callback, x);
            return true;
        }
    }
}

