/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.executor.etree.relation;

import com.databricks.client.dsi.dataengine.interfaces.IColumn;
import com.databricks.client.dsi.dataengine.utilities.CursorType;
import com.databricks.client.sqlengine.executor.etree.ETDataRequest;
import com.databricks.client.sqlengine.executor.etree.IETNode;
import com.databricks.client.sqlengine.executor.etree.IETNodeVisitor;
import com.databricks.client.sqlengine.executor.etree.relation.ETAggregate;
import com.databricks.client.sqlengine.executor.etree.relation.ETDistinctMove;
import com.databricks.client.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.databricks.client.sqlengine.executor.etree.value.ETValueExpr;
import com.databricks.client.sqlengine.executor.etree.value.ETValueExprList;
import com.databricks.client.support.exceptions.ErrorException;
import java.util.List;

public class ETStreamAggregate
extends ETAggregate {
    private final ETValueExprList m_aggregateList;
    private final List<? extends IColumn> m_metadata;
    private final boolean m_hasGroupBy;
    private boolean m_hasMoved = false;

    public ETStreamAggregate(ETRelationalExpr eTRelationalExpr, ETValueExprList eTValueExprList, List<? extends IColumn> list, boolean bl, boolean[] blArray) {
        super(blArray, eTRelationalExpr);
        this.m_aggregateList = eTValueExprList;
        this.m_metadata = list;
        this.m_hasGroupBy = bl;
    }

    @Override
    public <T> T acceptVisitor(IETNodeVisitor<T> iETNodeVisitor) throws ErrorException {
        return iETNodeVisitor.visit(this);
    }

    @Override
    public IColumn getColumn(int n) {
        return this.m_metadata.get(n);
    }

    @Override
    public int getColumnCount() {
        return this.m_aggregateList.getNumChildren();
    }

    @Override
    public long getRowCount() throws ErrorException {
        return -1L;
    }

    public ETDistinctMove.ETRowListener getRowListener() {
        return new UpdateRowListener();
    }

    @Override
    public void open(CursorType cursorType) throws ErrorException {
        super.open(cursorType);
        this.m_aggregateList.open();
        this.m_hasMoved = false;
    }

    @Override
    public void close(boolean bl) {
        super.close(bl);
        this.m_aggregateList.close(bl);
    }

    @Override
    public void reset() throws ErrorException {
        super.reset();
        this.m_aggregateList.reset();
        this.m_hasMoved = false;
    }

    @Override
    public int getNumChildren() {
        return 2;
    }

    @Override
    protected IETNode getChild(int n) throws IndexOutOfBoundsException {
        if (0 == n) {
            return this.getOperand();
        }
        if (1 == n) {
            return this.m_aggregateList;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public boolean retrieveData(int n, ETDataRequest eTDataRequest) throws ErrorException {
        return this.m_aggregateList.retrieveData(n, eTDataRequest);
    }

    protected final void updateRow() throws ErrorException {
        for (ETValueExpr eTValueExpr : this.m_aggregateList) {
            eTValueExpr.update();
        }
    }

    @Override
    protected boolean doMove() throws ErrorException {
        this.m_aggregateList.reset();
        if (this.m_hasGroupBy) {
            return this.getOperand().move();
        }
        if (!this.m_hasMoved) {
            while (this.getOperand().move()) {
                this.updateRow();
            }
            this.m_hasMoved = true;
            return true;
        }
        return false;
    }

    private class UpdateRowListener
    implements ETDistinctMove.ETRowListener {
        private UpdateRowListener() {
        }

        @Override
        public void onNewRow() throws ErrorException {
            ETStreamAggregate.this.updateRow();
        }
    }
}

