/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.BuiltinsLoader;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSBackendInitializer;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.MiscCodes;
import com.dataiku.dip.MockableSystem;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.HadoopSettings;
import com.dataiku.dip.dataflow.jobrunner.PerJobBackendLoggingAppender;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.hadoop.HadoopLoader;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.remoterun.RemoteRunNetworkingUtils;
import com.dataiku.dip.security.rpc.EncryptedRPC;
import com.dataiku.dip.server.JettyUtils;
import com.dataiku.dip.server.SharedSecretUtils;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.spark.yarnaware.YarnClusterSSHTunnelRegistry;
import com.dataiku.dip.transactions.git.jgit.DSSGitUtils;
import com.dataiku.dip.util.PoiUtils;
import com.dataiku.dip.util.ServletUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.MainUtils;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.websocket.server.config.JettyWebSocketServletContainerInitializer;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.ConnectionFactory;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Connector;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.HttpConfiguration;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.HttpConnectionFactory;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.SecureRequestCustomizer;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Server;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.ServerConnector;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.SslConnectionFactory;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.handler.ContextHandler;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.ssl.SslContextFactory;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.thread.QueuedThreadPool;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.thread.ThreadPool;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.WebSocketComponents;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.server.WebSocketServerComponents;
import jakarta.servlet.ServletException;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class DSSBackendMain {
    public static final long BACKEND_STARTUP_TIME = System.currentTimeMillis();
    private static Logger logger;

    public static void main(String[] args) throws Exception {
        System.setProperty("DIP_HOME", System.getenv("DIP_HOME"));
        ApplicationConfigurator.autoconfigure();
        MainLoggingConfigurator.configure((MainLoggingConfigurator.ProcessType)MainLoggingConfigurator.ProcessType.BACKEND);
        Logger.getLogger((String)"com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.webapp.WebAppClassLoader").setLevel(Level.INFO);
        if (System.getenv("DKU_BACKEND_PORT") == null) {
            throw new IllegalArgumentException("Missing DKU_BACKEND_PORT environment variable");
        }
        if (System.getenv("DKUINSTALLDIR") == null) {
            throw new IllegalArgumentException("Missing DKUINSTALLDIR environment variable");
        }
        System.setProperty("h2.bindAddress", "127.0.0.1");
        ApplicationConfigurator.setProcessType((MainLoggingConfigurator.ProcessType)MainLoggingConfigurator.ProcessType.BACKEND);
        ClusterSelector.setContext(MainLoggingConfigurator.ProcessType.BACKEND);
        MainUtils.printHello((String)"backend");
        BuiltinsLoader.load();
        MainLoggingConfigurator.configureLimits();
        DKUtils.startLogAppender((Appender)new PerJobBackendLoggingAppender());
        Integer backendPort = Integer.parseInt(System.getenv("DKU_BACKEND_PORT"));
        RemoteRunNetworkingUtils.setServer(MainLoggingConfigurator.ProcessType.BACKEND, backendPort);
        logger.info((Object)("Starting on port " + backendPort));
        int minThreads = DKUApp.getParams().getIntParam("dku.backend.server.threadPool.minThreads", Integer.valueOf(8));
        int maxThreads = DKUApp.getParams().getIntParam("dku.backend.server.threadPool.maxThreads", Integer.valueOf(400));
        QueuedThreadPool tp = new QueuedThreadPool(maxThreads, minThreads);
        Server server = new Server((ThreadPool)tp);
        server.setOpenEarly(false);
        HttpConfiguration config = JettyUtils.createHttpConfiguration();
        String requestHeaderSize = DKUApp.getIniValue((String)"server", (String)"backend_max_request_headers_size_kb");
        if (requestHeaderSize != null) {
            int requestHeaderSizeKB = Integer.valueOf(requestHeaderSize) * 1024;
            if (requestHeaderSizeKB < 8192) {
                logger.warn((Object)"backend_max_request_headers_size_kb must be higher than 8KB, the configuration will be ignored ");
            }
            config.setRequestHeaderSize(Math.max(8192, requestHeaderSizeKB));
        }
        ServerConnector sc = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(config)});
        sc.setIdleTimeout(-1L);
        sc.setPort(backendPort.intValue());
        server.setConnectors(new Connector[]{sc});
        if (EncryptedRPC.enabled()) {
            HttpConfiguration httpConfig = JettyUtils.createHttpConfiguration();
            httpConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer(DKUApp.getParams().getBoolParam("sni.enabled", true)));
            HttpConnectionFactory http11 = new HttpConnectionFactory(httpConfig);
            SslContextFactory.Server sslContextFactory = EncryptedRPC.getSSLContextFactoryServer();
            SslConnectionFactory tls = new SslConnectionFactory(sslContextFactory, http11.getProtocol());
            ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{tls, http11});
            connector.setIdleTimeout(-1L);
            Integer backendRPCPort = Integer.parseInt(System.getenv("DKU_BACKEND_RPC_PORT"));
            RemoteRunNetworkingUtils.setServer(MainLoggingConfigurator.ProcessType.BACKEND, backendRPCPort);
            logger.info((Object)("Starting encrypted RPC server on port " + backendRPCPort));
            connector.setPort(backendRPCPort.intValue());
            server.addConnector((Connector)connector);
        }
        logger.info((Object)"Creating the DSS servlet context");
        ServletContextHandler sch = ServletUtils.createServletContext((int)500000000, (String)"/dip");
        DSSBackendMain.registerInitializer(sch);
        JettyUtils.addHandlers((Server)server, (ServletContextHandler)sch);
        DSSGitUtils.generateDkuProjectsGitignore();
        SharedSecretUtils.getSharedSecret((boolean)true);
        HadoopSettings hadoopSettings = new ClusterSelector(true).selectGlobal().getHadoopSettings();
        HadoopLoader.initializeSecurity(hadoopSettings, true, true);
        DSSMetrics.registerJVMMetrics();
        DSSMetrics.startJMXReporter();
        YarnClusterSSHTunnelRegistry.setLocalPort(backendPort);
        if (BuiltinsLoader.apachePoiAvailable()) {
            PoiUtils.initializePoi();
        }
        try {
            server.start();
        }
        catch (Exception e) {
            logger.error((Object)"Server start failed", (Throwable)e);
            CodedSQLException internalDBFailure = DSSBackendMain.getCausedByInternalDBFailure(e);
            if (internalDBFailure != null) {
                logger.error((Object)"----------------------------------------");
                logger.error((Object)("DSS INTERNAL DATABASE ERROR: " + ExceptionUtils.getMessageWithCauses((Throwable)internalDBFailure)));
                logger.error((Object)"----------------------------------------");
            }
            System.exit(1);
        }
        SpringUtils.onDSSStarted();
        server.join();
    }

    private static CodedSQLException getCausedByInternalDBFailure(Throwable e) {
        if (e == null) {
            return null;
        }
        if (e instanceof CodedSQLException && ((CodedSQLException)e).getCode() == MiscCodes.ERR_MISC_EIDB) {
            return (CodedSQLException)e;
        }
        return DSSBackendMain.getCausedByInternalDBFailure(e.getCause());
    }

    private static void registerInitializer(ServletContextHandler contextHandler) throws ServletException {
        contextHandler.addServletContainerInitializer((webAppInitializerClasses, servletContext) -> {
            DSSBackendInitializer initializer = new DSSBackendInitializer();
            initializer.onStartup(servletContext);
        });
        JettyWebSocketServletContainerInitializer.configure((ServletContextHandler)contextHandler, (context, container) -> {
            WebSocketComponents components = WebSocketServerComponents.getWebSocketComponents((ContextHandler)contextHandler);
            String opt = DKUApp.getIniValue((String)"server", (String)"websocket_permessage_deflate", (String)"true");
            if ("false".equalsIgnoreCase(opt)) {
                components.getExtensionRegistry().unregister("permessage-deflate");
            }
        });
    }

    static {
        System.setProperty("DIP_HOME", MockableSystem.getenv((String)"DIP_HOME"));
        logger = Logger.getLogger((String)"dku");
    }
}

