/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.activity;

import com.codahale.metrics.CachedGauge;
import com.codahale.metrics.Metric;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.Params;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ObjectsCountsMetricsService {
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private ProjectsService projectsDAO;
    @Autowired
    private TransactionService transactionService;

    @PostConstruct
    void init() {
        Params p = ApplicationConfigurator.getParams();
        if (!p.getBoolParam("dku.metrics.objectsCounts.enabled", true)) {
            return;
        }
        long refreshDelay = p.getLongParam("dku.metrics.objectsCounts.refreshDelayS", 21600L);
        DSSMetrics.registry().register("dku.objectsCounts.global.datasets", (Metric)new ProjectGaugeCounter(refreshDelay){

            @Override
            public int countForProject(String key) throws IOException {
                return ObjectsCountsMetricsService.this.datasetsDAO.approximateCount(key);
            }
        });
        DSSMetrics.registry().register("dku.objectsCounts.global.recipes", (Metric)new ProjectGaugeCounter(refreshDelay){

            @Override
            public int countForProject(String key) throws IOException {
                return ObjectsCountsMetricsService.this.recipesDAO.approximateCount(key);
            }
        });
    }

    private abstract class ProjectGaugeCounter
    extends CachedGauge<Integer> {
        protected ProjectGaugeCounter(long timeout) {
            super(timeout, TimeUnit.SECONDS);
        }

        public Integer loadValue() {
            Integer n;
            block9: {
                Transaction t = ObjectsCountsMetricsService.this.transactionService.beginRead();
                try {
                    int count = 0;
                    for (String key : ObjectsCountsMetricsService.this.projectsDAO.listKeys()) {
                        count += this.countForProject(key);
                    }
                    n = count;
                    if (t == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (t != null) {
                            try {
                                t.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        return -1;
                    }
                }
                t.close();
            }
            return n;
        }

        public abstract int countForProject(String var1) throws IOException;
    }
}

