/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.aigenerations.recipes;

import com.dataiku.dip.aigenerations.AIRecipeGenerationService;
import com.dataiku.dip.aigenerations.recipes.AIRecipe;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.grouping.GroupingRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.pivot.PivotElement;
import com.dataiku.dip.dataflow.exec.pivot.PivotRecipePayloadParams;
import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.server.SpringUtils;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class AIPivot
extends AIRecipe {
    public static final String type = "pivot";
    public Params params;

    @Override
    public List<AIRecipeGenerationService.CreationMessage> validate(List<Dataset> datasets, String contextProjectKey, String lang) {
        ArrayList<AIRecipeGenerationService.CreationMessage> creationMessages = new ArrayList<AIRecipeGenerationService.CreationMessage>();
        this.params.checkSingleInputDataset(datasets, type, contextProjectKey);
        this.params.checkSingleOutputDataset(type);
        TranslationService ts = (TranslationService)SpringUtils.getBean(TranslationService.class);
        if (this.params.pivoted_columns == null || this.params.pivoted_columns.isEmpty()) {
            creationMessages.add(new AIRecipeGenerationService.CreationMessage(AIRecipeGenerationService.CreationMessage.Level.WARNING, ts.translateNoContext(lang, "RIGHT_PANEL.TABS.GENERATE_RECIPE.PIVOT.UNABLE_TO_DETERMINE_COLUMN", "We were unable to determine which column(s) to use as pivot", new Object[0])));
        }
        if (this.params.pivoted_values == null) {
            this.params.pivoted_values = PivotedMode.ALL;
        }
        if ((this.params.pivoted_values.equals((Object)PivotedMode.MOST_FREQUENT) || this.params.pivoted_values.equals((Object)PivotedMode.OCCURRING_MORE_THAN)) && this.params.pivoted_values_threshold == null) {
            creationMessages.add(new AIRecipeGenerationService.CreationMessage(AIRecipeGenerationService.CreationMessage.Level.WARNING, ts.translateNoContext(lang, "RIGHT_PANEL.TABS.GENERATE_RECIPE.PIVOT.UNABLE_TO_DETERMINE_THRESHOLD", "We were unable to determine the threshold value on the pivoted column(s). Default value will be 20.", new Object[0])));
        }
        if (this.params.row_identifier_mode == null) {
            this.params.row_identifier_mode = RowIdentifierMode.EXPLICIT;
        }
        if (this.params.pivoted_value_aggregations == null) {
            this.params.pivoted_value_aggregations = new ArrayList<AIRecipe.Aggregation>();
        }
        if (this.params.original_column_aggregations == null) {
            this.params.original_column_aggregations = new ArrayList<AIRecipe.Aggregation>();
        }
        if (this.params.row_identifier_mode.equals((Object)RowIdentifierMode.EXPLICIT) && (this.params.row_identifier_columns == null || this.params.row_identifier_columns.isEmpty())) {
            creationMessages.add(new AIRecipeGenerationService.CreationMessage(AIRecipeGenerationService.CreationMessage.Level.WARNING, ts.translateNoContext(lang, "RIGHT_PANEL.TABS.GENERATE_RECIPE.PIVOT.UNABLE_TO_DETERMINE_ROW_IDENTIFIER", "We were unable to determine the row identifiers column(s), the output dataset will have a single row.", new Object[0])));
        }
        Dataset dataset = AIRecipe.AIRecipeParams.getDataset(datasets, this.params.input_dataset, contextProjectKey);
        this.validateAggregationFunctions(creationMessages, this.params.original_column_aggregations, dataset, false, lang);
        this.validateAggregationFunctions(creationMessages, this.params.pivoted_value_aggregations, dataset, false, lang);
        return creationMessages;
    }

    @Override
    public AIRecipeGenerationService.AIMetaCreation generateRecipeMetaPayload(AIRecipeGenerationService.RecipeGenerationContext recipeGenerationContext) {
        AIRecipeGenerationService.AIMetaCreation metaCreation = new AIRecipeGenerationService.AIMetaCreation();
        metaCreation.messages = this.validate(recipeGenerationContext.datasets, recipeGenerationContext.contextProjectKey, recipeGenerationContext.lang);
        PivotRecipePayloadParams pivotRecipePayloadParams = new PivotRecipePayloadParams();
        this.enrichParams(pivotRecipePayloadParams, recipeGenerationContext.datasets, recipeGenerationContext.contextProjectKey);
        metaCreation.datasetInputNames = List.of(this.params.input_dataset);
        metaCreation.datasetOutputNames = List.of(this.params.output_dataset);
        metaCreation.payload = new Gson().toJson((Object)pivotRecipePayloadParams);
        return metaCreation;
    }

    public void enrichParams(PivotRecipePayloadParams recipeParams, List<Dataset> datasets, String contextProjectKey) {
        GroupingRecipePayloadParams.GroupingValue gv;
        Dataset dataset = AIRecipe.AIRecipeParams.getDataset(datasets, this.params.input_dataset, contextProjectKey);
        Set validColumnName = dataset.getSchema().columns.stream().map(SchemaColumn::getName).collect(Collectors.toSet());
        Map<String, SchemaColumn> columnNameToSchemaColumn = dataset.getSchema().columns.stream().collect(Collectors.toMap(SchemaColumn::getName, sc -> sc));
        PivotElement pivot = new PivotElement();
        if (this.params.pivoted_values.equals((Object)PivotedMode.ALL)) {
            pivot.valueLimit = PivotElement.PivotValueLimit.NO_LIMIT;
        } else if (this.params.pivoted_values.equals((Object)PivotedMode.MOST_FREQUENT)) {
            pivot.valueLimit = PivotElement.PivotValueLimit.TOP_N;
            pivot.topnLimit = this.params.pivoted_values_threshold == null ? 20 : this.params.pivoted_values_threshold;
        } else {
            pivot.valueLimit = PivotElement.PivotValueLimit.AT_LEAST_N_OCC;
            int n = pivot.minOccLimit = this.params.pivoted_values_threshold == null ? 20 : this.params.pivoted_values_threshold;
        }
        if (this.params.pivoted_columns != null && !this.params.pivoted_columns.isEmpty()) {
            pivot.keyColumns = this.params.pivoted_columns.stream().filter(validColumnName::contains).collect(Collectors.toList());
        }
        PivotRecipePayloadParams.IdentifierColumnsSelection identifierColumnsSelection = recipeParams.identifierColumnsSelection = this.params.row_identifier_mode.equals((Object)RowIdentifierMode.EXPLICIT) ? PivotRecipePayloadParams.IdentifierColumnsSelection.EXPLICIT : PivotRecipePayloadParams.IdentifierColumnsSelection.ALL_BUT_USED;
        if (recipeParams.identifierColumnsSelection.equals((Object)PivotRecipePayloadParams.IdentifierColumnsSelection.EXPLICIT)) {
            List<Object> list = recipeParams.explicitIdentifiers = this.params.row_identifier_columns == null ? Collections.emptyList() : this.params.row_identifier_columns.stream().filter(validColumnName::contains).collect(Collectors.toList());
        }
        if (this.params.pivoted_value_aggregations.isEmpty()) {
            pivot.globalCount = true;
        } else {
            HashMap<String, GroupingRecipePayloadParams.GroupingValue> columnNameToPivotAggregation = new HashMap<String, GroupingRecipePayloadParams.GroupingValue>();
            for (AIRecipe.Aggregation agg : this.params.pivoted_value_aggregations) {
                if (!validColumnName.contains(agg.column)) continue;
                gv = columnNameToPivotAggregation.getOrDefault(agg.column, new GroupingRecipePayloadParams.GroupingValue(agg.column, false, false, false, false, false, false, false, false, null));
                gv.type = columnNameToSchemaColumn.get(agg.column).getTypeString();
                this.addAggregationFunctionToGroupingValue(gv, agg.function);
                columnNameToPivotAggregation.put(gv.column, gv);
            }
            if (columnNameToPivotAggregation.isEmpty()) {
                pivot.globalCount = true;
            } else {
                pivot.valueColumns = new ArrayList(columnNameToPivotAggregation.values());
            }
        }
        if (this.params.original_column_aggregations != null && !this.params.original_column_aggregations.isEmpty()) {
            HashMap<String, GroupingRecipePayloadParams.GroupingValue> columnNameToAggregation = new HashMap<String, GroupingRecipePayloadParams.GroupingValue>();
            for (AIRecipe.Aggregation agg : this.params.original_column_aggregations) {
                if (!validColumnName.contains(agg.column)) continue;
                gv = columnNameToAggregation.getOrDefault(agg.column, new GroupingRecipePayloadParams.GroupingValue(agg.column, false, false, false, false, false, false, false, false, null));
                this.addAggregationFunctionToGroupingValue(gv, agg.function);
                gv.type = columnNameToSchemaColumn.get(agg.column).getTypeString();
                columnNameToAggregation.put(gv.column, gv);
            }
            recipeParams.otherColumns = new ArrayList(columnNameToAggregation.values());
        }
        recipeParams.pivots.add(pivot);
    }

    private void addAggregationFunctionToGroupingValue(GroupingRecipePayloadParams.GroupingValue gv, String function) {
        if (function.equals("MAX")) {
            gv.max = true;
        } else if (function.equals("STD_DEV")) {
            gv.stddev = true;
        } else if (function.equals("CONCAT_DISTINCT")) {
            gv.concatDistinct = true;
        } else if (function.equals("CONCAT")) {
            gv.concat = true;
        } else if (function.equals("COUNT")) {
            gv.count = true;
        } else if (function.equals("COUNT_DISTINCT")) {
            gv.countDistinct = true;
        } else if (function.equals("FIRST")) {
            gv.first = true;
        } else if (function.equals("LAST")) {
            gv.last = true;
        } else if (function.equals("SUM")) {
            gv.sum = true;
        } else if (function.equals("MIN")) {
            gv.min = true;
        } else if (function.equals("AVG")) {
            gv.avg = true;
        }
    }

    public static class Params
    extends AIRecipe.AIRecipeParams {
        public PivotedMode pivoted_values;
        public List<String> pivoted_columns;
        public Integer pivoted_values_threshold;
        public RowIdentifierMode row_identifier_mode;
        public List<String> row_identifier_columns;
        public List<AIRecipe.Aggregation> pivoted_value_aggregations;
        public List<AIRecipe.Aggregation> original_column_aggregations;
    }

    public static enum PivotedMode {
        ALL,
        MOST_FREQUENT,
        OCCURRING_MORE_THAN;

    }

    public static enum RowIdentifierMode {
        ALL_OTHERS,
        EXPLICIT;

    }
}

