/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.extractor;

import com.dataiku.dip.analysis.docgen.extractor.GenericTimeseriesExtractor;
import com.dataiku.dip.analysis.docgen.transform.Placeholder;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.dataiku.dip.analysis.model.prediction.PreTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelDetails;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelIntrinsicPerf;
import com.jayway.jsonpath.DocumentContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class InformationCriteriaSingleExtractor
extends GenericTimeseriesExtractor {
    @Override
    public List<List<String>> extract(DocumentContext documentContext, ModelDetailsBase model) throws IOException {
        this.canExtract(model, Arrays.asList(PreTrainPredictionModelingParams.Algorithm.AUTO_ARIMA, PreTrainPredictionModelingParams.Algorithm.SEASONAL_LOESS));
        TimeseriesForecastingModelDetails timeseriesModelDetails = (TimeseriesForecastingModelDetails)model;
        if (timeseriesModelDetails.getCoreParams().timeseriesIdentifiers.size() != 0) {
            throw new IOException(String.format("Wrong placeholder. Extractor '%s' does not support multiple time series. Use {{%s}} instead.", this.getClass().getSimpleName(), Placeholder.RESULT_INFORMATION_CRITERIA_MULTI_TABLE.placeholderName));
        }
        List<TimeseriesForecastingModelIntrinsicPerf.InformationCriterion> informationCriteria = ((TimeseriesForecastingModelDetails)model).iperf.informationCriteria;
        if (informationCriteria == null) {
            throw new IOException(String.format("Information criteria was not computed on this model. Compute them to display it in your model report.", new Object[0]));
        }
        ArrayList<List<String>> output = new ArrayList<List<String>>();
        informationCriteria.forEach(c2 -> output.add(Arrays.asList(c2.displayName, c2.values.values().stream().findFirst().get().toString())));
        return output;
    }
}

