/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.clustering.flow;

import com.dataiku.dip.analysis.coreservices.AnalysisDataService;
import com.dataiku.dip.analysis.coreservices.flow.SavedModelsCRUDService;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLFlowUtils;
import com.dataiku.dip.analysis.ml.clustering.ClusteringResultsReader;
import com.dataiku.dip.analysis.ml.clustering.flow.ClusteringRecipesBasicService;
import com.dataiku.dip.analysis.ml.clustering.flow.ClusteringRecipesMeta;
import com.dataiku.dip.analysis.ml.clustering.flow.ClusteringSMMgmtService;
import com.dataiku.dip.analysis.ml.clustering.flow.ClusteringScoringRecipePayloadParams;
import com.dataiku.dip.analysis.ml.prediction.MLSchemaComparator;
import com.dataiku.dip.analysis.model.clustering.ClusteringModelDetails;
import com.dataiku.dip.analysis.model.core.ResolvedCoreParams;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dataflow.exec.ContainerRecipeParams;
import com.dataiku.dip.recipes.ManagedDatasetsCreationService;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.recipes.services.PDepsFixuper;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.recipes.RecipeSaveService;
import com.dataiku.dip.server.recipes.ShakerRecipeService;
import com.dataiku.dip.server.services.FlowZonesService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.WithMessages;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class ClusteringRecipesHelper
extends ClusteringRecipesBasicService {
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private DatasetSaveService datasetSaveService;
    @Autowired
    private ClusteringSMMgmtService savedModelsMgmtService;
    @Autowired
    private SavedModelsCRUDService savedModelsService;
    @Autowired
    private RecipeSaveService recipeSaveService;
    @Autowired
    private ShakerRecipeService shakerRecipeService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private AnalysisDataService dataService;
    @Autowired
    private ManagedDatasetsCreationService mdcService;
    @Autowired
    private FlowZonesService flowZonesService;
    private static Logger logger = Logger.getLogger((String)"dku.analysis.flow");

    public RecipeCreator.CreationResult createScoringRecipe_NT(AuthCtx u, String projectKey, String savedModelSM, String inputDatasetSM, boolean createOutputDataset, String outputDatasetSM, ManagedDatasetsCreationService.ManagedDatasetCreationSettings outputDatasetSettings) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        RecipeCreator.CreationResult ret = new RecipeCreator.CreationResult();
        AnyLoc savedModelLoc = AnyLoc.resolveSmart(projectKey, savedModelSM);
        DatasetLocUtils.DatasetLoc inputDatasetLoc = DatasetLocUtils.resolveSmart(projectKey, inputDatasetSM);
        DatasetLocUtils.DatasetLoc outputDatasetLoc = new DatasetLocUtils.DatasetLoc(projectKey, outputDatasetSM);
        SavedModel sm = null;
        Dataset inputDataset = null;
        Dataset outputDataset = null;
        try (Transaction t = this.transactionService.beginRead();){
            sm = this.savedModelsService.getMandatory(savedModelLoc.getProjectKey(), savedModelLoc.getId());
            inputDataset = this.datasetAccessService.getMandatory(inputDatasetLoc);
            if (createOutputDataset) {
                outputDataset = this.mdcService.prepareCopyPartitioning(u, outputDatasetLoc.getProjectKey(), outputDatasetLoc.getName(), outputDatasetSettings);
            }
        }
        FullModelId fmi = this.savedModelsMgmtService.getActiveVersionFMI(sm);
        ClusteringModelDetails details = ClusteringResultsReader.makeDetails(fmi);
        ClusteringScoringRecipePayloadParams desc = new ClusteringScoringRecipePayloadParams();
        ResolvedCoreParams rcp = fmi.getResolvedCoreParams();
        desc.backendType = rcp.backendType;
        desc.sparkParams.sparkConf = rcp.executionParams.sparkParams.sparkConf;
        desc.sparkParams.sparkExecutionEngine = rcp.executionParams.sparkParams.sparkExecutionEngine;
        desc.sparkParams.sparkUseGlobalMetastore = rcp.executionParams.sparkParams.sparkUseGlobalMetastore;
        desc.sparkParams.sparkPreparedDFStorageLevel = rcp.executionParams.sparkParams.sparkPreparedDFStorageLevel;
        SerializedShakerScript script = details.trainedWithScript;
        if (createOutputDataset) {
            assert (outputDataset != null);
            Schema inferredPreparationOutputSchema = this.dataService.getInferredSchemaForML_NT(script, projectKey, inputDataset, outputDataset.getType(), u);
            List<InfoMessage> messages = MLSchemaComparator.checkForScore(details.preprocessing, inferredPreparationOutputSchema);
            if (InfoMessage.anyFatal(messages)) {
                throw ErrorContext.iae((String)("Wrong schema: " + InfoMessage.firstFatal(messages).message));
            }
            Schema usedPreparationOutputSchema = MLFlowUtils.getSchemaToUseForPreparedScoringInput(details.preprocessing, details.splitDesc.schema, inferredPreparationOutputSchema);
            outputDataset.setSchema(this.getOutputSchema(usedPreparationOutputSchema, null, details.modeling.algorithm.meta.additionalScoringColumns()));
            logger.info((Object)("Creating dataset " + JSON.pretty((Object)outputDataset.serialize())));
        }
        SerializedRecipe sr = new SerializedRecipe();
        sr.addInput("model", savedModelLoc.getSmartName(outputDatasetLoc.getProjectKey()));
        sr.addInput("main", inputDatasetLoc.getSmartName(outputDatasetLoc.getProjectKey()));
        sr.addOutput("main", outputDatasetLoc.getName(), false);
        sr.type = ClusteringRecipesMeta.SCORING_META.getType();
        sr.params = new ContainerRecipeParams();
        try (RWTransaction rwt = this.transactionService.beginWriteAsLoggedInUser(u);){
            String recipeName;
            sr.name = recipeName = this.recipeSaveService.transmogrifyName(outputDatasetLoc.getProjectKey(), "score_" + inputDatasetLoc.getName());
            sr.projectKey = outputDatasetLoc.getProjectKey();
            if (outputDatasetSettings != null) {
                if (StringUtils.isBlank((String)outputDatasetSettings.zone)) {
                    outputDatasetSettings.zone = this.flowZonesService.retrieveInputZone(sr);
                }
                if (createOutputDataset) {
                    assert (outputDataset != null);
                    DatasetSaveService.DatasetCreationContext dsCtx = DatasetSaveService.DatasetCreationContext.buildFromRecipe(sr);
                    SerializedDataset sds = outputDataset.serialize();
                    this.flowZonesService.attachObjectToZone(outputDatasetSettings.zone, projectKey, sds);
                    WithMessages<SerializedDataset> dsWithMsg = this.datasetSaveService.create(outputDatasetLoc.getProjectKey(), sds, dsCtx, u);
                    ret.messages.mergeFrom(dsWithMsg.messages);
                }
            }
            this.shakerRecipeService.updateDependenciesOnAnyRecipe(outputDatasetLoc.getProjectKey(), sr, script);
            new PDepsFixuper().fixupInPlace(sr);
            if (outputDatasetSettings != null) {
                if (StringUtils.isBlank((String)outputDatasetSettings.zone)) {
                    outputDatasetSettings.zone = this.flowZonesService.retrieveInputZone(sr);
                }
                this.flowZonesService.attachObjectToZone(outputDatasetSettings.zone, projectKey, sr);
            }
            this.recipeSaveService.create(outputDatasetLoc.getProjectKey(), sr, JSON.pretty((Object)desc));
            rwt.commit("Created scoring recipe for scoring " + inputDatasetLoc.getName() + ":" + sr.projectKey + "." + sr.name);
            ret.id = recipeName;
            RecipeCreator.CreationResult creationResult = ret;
            return creationResult;
        }
    }
}

