/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.distributed.workers;

import com.dataiku.dip.analysis.ml.distributed.workers.WorkerPool;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractWorkerService {
    protected static final String REMOTE_WORKER_PYTHON_PACKAGE_ENTRY_POINT = "dataiku.doctor.distributed.remote_worker_server";
    protected final Map<String, WorkerPool> workerPools = new HashMap<String, WorkerPool>();
    private static final DKULogger logger = DKULogger.getLogger((String)"com.dataiku.dip.analysis.ml.distributed.workers");

    protected synchronized WorkerPool getWorkerPool(String poolId) {
        if (!this.workerPools.containsKey(poolId)) {
            throw new RuntimeException("Worker pool " + poolId + " does not exist");
        }
        return this.workerPools.get(poolId);
    }

    protected synchronized Runnable getCloseCallBack(String workerPoolId) {
        return () -> {
            AbstractWorkerService abstractWorkerService = this;
            synchronized (abstractWorkerService) {
                logger.info((Object)("Unregistered worker pool: " + workerPoolId));
                this.workerPools.remove(workerPoolId);
            }
        };
    }

    protected synchronized String generateId() {
        String newWorkerPoolId;
        while (this.workerPools.containsKey(newWorkerPoolId = "pool-" + SecretKeyGenerator.generate((int)16).toLowerCase())) {
        }
        return newWorkerPoolId;
    }
}

