/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.clustering.algorithms.python;

import com.dataiku.dip.analysis.model.ClusteringModelingParams;
import com.dataiku.dip.analysis.model.clustering.ClusteringMLTask;
import com.dataiku.dip.analysis.model.clustering.ClusteringParameterChecks;
import com.dataiku.dip.analysis.model.clustering.PreTrainClusteringModelingParams;
import com.dataiku.dip.analysis.model.clustering.algorithms.python.ScikitAlgorithmMeta;
import com.dataiku.dip.analysis.model.core.WorkSet;
import com.dataiku.dip.utils.ErrorContext;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class SpectralMeta
extends ScikitAlgorithmMeta {
    @Override
    public String generateName(PreTrainClusteringModelingParams rpmp) {
        return "Spectral clustering (k=" + rpmp.k + ")";
    }

    @Override
    public String generateDescription(PreTrainClusteringModelingParams rpmp) {
        return "K=" + rpmp.k + ", " + rpmp.affinity + ", gamma=" + rpmp.gamma + ", c0=" + rpmp.coef0;
    }

    @Override
    public void validateParameters(ClusteringModelingParams pmp, ClusteringMLTask task, ClusteringParameterChecks checks) {
        ClusteringModelingParams.SpectralParams sc = task.modeling.spectral_clustering;
        if (sc.enabled) {
            checks.checkAllPositive(sc.kValues(), "Spectral clustering requires a (positive) number of clusters");
            List<String> affinities = SpectralMeta.expandSpectralAffinities(task.modeling.spectral_clustering);
            ErrorContext.checkNotEmpty(affinities, (String)"Spectral clustering requires an affinity measure");
        }
    }

    private static List<String> expandSpectralAffinities(ClusteringModelingParams.SpectralParams sp) {
        ArrayList<String> affinities = new ArrayList<String>();
        if (sp.affinity_nearest_neighbors) {
            affinities.add("nearest_neighbors");
        }
        if (sp.affinity_polynomial) {
            affinities.add("polynomial");
        }
        if (sp.affinity_sigmoid) {
            affinities.add("sigmoid");
        }
        if (sp.affinity_rbf) {
            affinities.add("rbf");
        }
        return affinities;
    }

    @Override
    public List<WorkSet.ModelingSet> expandModeling(ClusteringModelingParams pmp, ClusteringMLTask task) {
        ArrayList<WorkSet.ModelingSet> ret = new ArrayList<WorkSet.ModelingSet>();
        ClusteringModelingParams.SpectralParams sc = task.modeling.spectral_clustering;
        if (sc.enabled) {
            List<String> affinities = SpectralMeta.expandSpectralAffinities(task.modeling.spectral_clustering);
            for (String s : affinities) {
                Logger.getLogger(this.getClass()).info((Object)("found affinity : " + s));
            }
            for (Object k : (Object)sc.kValues()) {
                for (String affinity : affinities) {
                    if ("rbf-sigmoid-polynomial".contains(affinity)) {
                        for (double gamma : task.modeling.spectral_clustering.gamma) {
                            PreTrainClusteringModelingParams rcmp = new PreTrainClusteringModelingParams(PreTrainClusteringModelingParams.Algorithm.SPECTRAL);
                            rcmp.k = (int)k;
                            rcmp.affinity = affinity;
                            rcmp.gamma = gamma;
                            if (sc.seed != 0) {
                                rcmp.seed = sc.seed;
                            }
                            if ("sigmoid-polynomial".contains(affinity)) {
                                rcmp.coef0 = task.modeling.spectral_clustering.coef0;
                                ret.add(new WorkSet.ModelingSet(rcmp));
                                continue;
                            }
                            ret.add(new WorkSet.ModelingSet(rcmp));
                        }
                        continue;
                    }
                    PreTrainClusteringModelingParams rcmp = new PreTrainClusteringModelingParams(PreTrainClusteringModelingParams.Algorithm.SPECTRAL);
                    rcmp.k = (int)k;
                    rcmp.affinity = affinity;
                    if (sc.seed != 0) {
                        rcmp.seed = sc.seed;
                    }
                    ret.add(new WorkSet.ModelingSet(rcmp));
                }
            }
        }
        return ret;
    }
}

