/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.llm;

import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.llm.LLMSavedModelInfo;
import com.dataiku.dip.analysis.ml.llm.LLMSavedModelVersionDeployment;
import com.dataiku.dip.analysis.ml.llm.LLMStepwiseTrainingMetrics;
import com.dataiku.dip.analysis.model.ModelTrainInfo;
import com.dataiku.dip.analysis.model.core.ModelUserMeta;
import java.io.IOException;

public class LLMModelDetails {
    public String fullModelId;
    public LLMSavedModelInfo llmSMInfo;
    public ModelTrainInfo trainInfo;
    public LLMStepwiseTrainingMetrics llmStepwiseTrainingMetrics;
    public ModelUserMeta userMeta;
    public LLMSavedModelVersionDeployment deployment;
    public String sessionId;
    public long sessionDate;

    public static LLMModelDetails fromFullModelId(FullModelId id, Boolean withStepwiseMetrics) throws IOException {
        LLMModelDetails modelDetails = new LLMModelDetails();
        modelDetails.fullModelId = id.toString();
        modelDetails.trainInfo = id.getTrainModelInfo().orElseGet(ModelTrainInfo::new);
        modelDetails.userMeta = id.getUserMetaOpt().orElseGet(ModelUserMeta::new);
        if (modelDetails.trainInfo.state == ModelTrainInfo.ModelTrainState.DONE) {
            LLMSavedModelInfo info = id.getLlmSavedModelInfo();
            if (withStepwiseMetrics.booleanValue()) {
                modelDetails.llmStepwiseTrainingMetrics = id.getLLMStepwiseTrainingMetricsFile().exists() ? FullModelId.parseJsonFile(id.getLLMStepwiseTrainingMetricsFile(), LLMStepwiseTrainingMetrics.class) : null;
            }
            if (id.getLLMDeploymentFile().exists()) {
                modelDetails.deployment = FullModelId.parseJsonFile(id.getLLMDeploymentFile(), LLMSavedModelVersionDeployment.class);
            }
            modelDetails.llmSMInfo = info;
            switch (modelDetails.llmSMInfo.llmType) {
                case ANTHROPIC: 
                case AZURE_OPENAI_MODEL: 
                case AZURE_OPENAI_DEPLOYMENT: 
                case AZURE_AI_FOUNDRY_DEPLOYMENT: 
                case COHERE: 
                case HUGGINGFACE_API: 
                case HUGGINGFACE_TRANSFORMER_LOCAL: 
                case OPENAI: 
                case NVIDIA_NIM: 
                case MISTRALAI: 
                case VERTEX: 
                case BEDROCK: 
                case MOSAICML: 
                case DATABRICKS: 
                case SAGEMAKER_GENERICLLM: {
                    throw new IllegalArgumentException("This foundational LLM cannot be in a generic saved model");
                }
                case SAVED_MODEL_AGENT: {
                    throw new IllegalArgumentException("Unexpected branch for Agent");
                }
            }
        }
        return modelDetails;
    }
}

