/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.prediction;

public abstract class NumericalHyperparameterDimension<T extends Number> {
    public ValueMode gridMode = ValueMode.EXPLICIT;
    public ValueMode randomMode = ValueMode.RANGE;
    public Limit<T> limit;
    public T[] values;
    public Range<T> range;

    NumericalHyperparameterDimension(T limitMin, T limitMax, T min, T max, Integer nbValues, Scaling scaling, T[] values) {
        this.limit = new Limit<T>(limitMin, limitMax);
        this.range = new Range<T>(min, max, nbValues, scaling);
        this.values = values;
    }

    public T getMinValue() {
        if (this.values == null || this.values.length == 0) {
            return null;
        }
        T min = this.values[0];
        for (T e : this.values) {
            if (!(((Number)e).doubleValue() < ((Number)min).doubleValue())) continue;
            min = e;
        }
        return min;
    }

    public T getMaxValue() {
        if (this.values == null || this.values.length == 0) {
            return null;
        }
        T max = this.values[0];
        for (T e : this.values) {
            if (!(((Number)e).doubleValue() > ((Number)max).doubleValue())) continue;
            max = e;
        }
        return max;
    }

    public void updateRange(T min, T max) {
        this.range.min = min;
        this.range.max = max;
    }

    public int getLength() {
        if (ValueMode.EXPLICIT == this.gridMode) {
            return this.values != null ? this.values.length : 0;
        }
        return this.range.nbValues;
    }

    public static enum ValueMode {
        EXPLICIT,
        RANGE;

    }

    public static class Limit<T> {
        public T min;
        public T max;

        Limit(T min, T max) {
            this.min = min;
            this.max = max;
        }
    }

    public static class Range<T> {
        public T min;
        public T max;
        public Integer nbValues;
        public Scaling scaling;

        Range(T min, T max, Integer nbValues, Scaling scaling) {
            this.min = min;
            this.max = max;
            this.nbValues = nbValues;
            this.scaling = scaling;
        }

        private Range() {
        }
    }

    public static enum Scaling {
        LINEAR,
        LOGARITHMIC;

    }
}

