/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.prediction;

import com.dataiku.dip.analysis.ml.prediction.LoadedCustomPythonPredictionAlgoDesc;
import com.dataiku.dip.analysis.model.prediction.CategoricalHyperparameterDimension;
import com.dataiku.dip.analysis.model.prediction.CategoricalHyperparameterValue;
import com.dataiku.dip.analysis.model.prediction.FloatHyperparameterDimension;
import com.dataiku.dip.analysis.model.prediction.IntegerHyperparameterDimension;
import com.dataiku.dip.analysis.model.prediction.MetricParams;
import com.dataiku.dip.analysis.model.prediction.NumericalHyperparameterDimension;
import com.dataiku.dip.analysis.model.prediction.OddIntegerHyperparameterDimension;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.plugins.model.PluginDesc;
import com.dataiku.dip.utils.ErrorContext;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class PredictionModelingParams {
    public boolean skipExpensiveReports;
    public RandomForestHyperparametersSpace random_forest_regression = new RandomForestHyperparametersSpace(true);
    public RandomForestHyperparametersSpace random_forest_classification = new RandomForestHyperparametersSpace();
    public RandomForestHyperparametersSpace extra_trees = new RandomForestHyperparametersSpace(new IntegerHyperparameterDimension(1L, null, 50L, 150L, NumericalHyperparameterDimension.Scaling.LINEAR, 100L));
    public GBTClassificationHyperparametersSpace gbt_classification = new GBTClassificationHyperparametersSpace();
    public GBTRegressionHyperparametersSpace gbt_regression = new GBTRegressionHyperparametersSpace();
    public DecisionTreeHyperparametersSpace decision_tree_classification = new DecisionTreeHyperparametersSpace();
    public DecisionTreeHyperparametersSpace decision_tree_regression = new DecisionTreeHyperparametersSpace();
    public RidgeRegressionHyperparametersSpace ridge_regression = new RidgeRegressionHyperparametersSpace();
    public LassoHyperparametersSpace lasso_regression = new LassoHyperparametersSpace();
    public LeastSquareHyperparametersSpace leastsquare_regression = new LeastSquareHyperparametersSpace();
    public SGDRegressionHyperparametersSpace sgd_regression = new SGDRegressionHyperparametersSpace();
    public SGDClassificationHyperparametersSpace sgd_classifier = new SGDClassificationHyperparametersSpace();
    public KNNHyperparametersSpace knn = new KNNHyperparametersSpace();
    public LogisticRegressionHyperparametersSpace logistic_regression = new LogisticRegressionHyperparametersSpace();
    public NeuralNetworkHyperparametersSpace neural_network = new NeuralNetworkHyperparametersSpace();
    public SVMHyperparametersSpace svc_classifier = new SVMHyperparametersSpace();
    public SVMHyperparametersSpace svm_regression = new SVMHyperparametersSpace();
    public LarsHyperparametersSpace lars_params = new LarsHyperparametersSpace();
    public LightGBMHyperParametersSpace lightgbm_regression = new LightGBMHyperParametersSpace();
    public LightGBMHyperParametersSpace lightgbm_classification = new LightGBMHyperParametersSpace();
    public XGBoostHyperparametersSpace xgboost = new XGBoostHyperparametersSpace();
    public DeepNeuralNetworkHyperParameterSpace deep_neural_network_regression = new DeepNeuralNetworkHyperParameterSpace();
    public DeepNeuralNetworkHyperParameterSpace deep_neural_network_classification = new DeepNeuralNetworkHyperParameterSpace();
    public H2ODeepLearningGridParams deep_learning_sparkling = new H2ODeepLearningGridParams();
    public H2OGBMGridParams gbm_sparkling = new H2OGBMGridParams();
    public H2OGLMGridParams glm_sparkling = new H2OGLMGridParams();
    public H2ORandomForestGridParams rf_sparkling = new H2ORandomForestGridParams();
    public H2ONaiveBayesGridParams nb_sparkling = new H2ONaiveBayesGridParams();
    public MLLibNaiveBayesGridParams mllib_naive_bayes = new MLLibNaiveBayesGridParams();
    public MLLibLogisticRegressionGridParams mllib_logit = new MLLibLogisticRegressionGridParams();
    public MLLibLinearRegressionGridParams mllib_linreg = new MLLibLinearRegressionGridParams();
    public MLLibDecisionTreeGridParams mllib_dt = new MLLibDecisionTreeGridParams();
    public MLLibTreesEnsembleGridParams mllib_rf = new MLLibTreesEnsembleGridParams();
    public MLLibTreesEnsembleGridParams mllib_gbt = new MLLibTreesEnsembleGridParams();
    @Deprecated
    public VerticaLinearRegParams vertica_linear_regression = new VerticaLinearRegParams();
    @Deprecated
    public VerticaLogisticRegParams vertica_logistic_regression = new VerticaLogisticRegParams();
    public List<CustomPythonParams> custom_python = new ArrayList<CustomPythonParams>();
    public Map<String, CustomPythonPluginParams> plugin_python = new HashMap<String, CustomPythonPluginParams>();
    public KerasCodeParams keras = new KerasCodeParams();
    public TrivialIdentityTimeseriesSpace trivial_identity_timeseries = new TrivialIdentityTimeseriesSpace();
    public SeasonalNaiveSpace seasonal_naive_timeseries = new SeasonalNaiveSpace();
    public ArimaSpace arima_timeseries = new ArimaSpace();
    public AutoArimaSpace autoarima_timeseries = new AutoArimaSpace();
    public CrostonSpace croston_timeseries = new CrostonSpace();
    public ETSSpace ets_timeseries = new ETSSpace();
    public SeasonalLoessSpace seasonal_loess_timeseries = new SeasonalLoessSpace();
    public ProphetSpace prophet_timeseries = new ProphetSpace();
    public GluonTSNPTSForecasterSpace gluonts_npts_timeseries = new GluonTSNPTSForecasterSpace();
    public GluonTSTorchDeepARSpace gluonts_torch_deepar_timeseries = new GluonTSTorchDeepARSpace();
    public GluonTSTorchSimpleFeedForwardSpace gluonts_torch_simple_feed_forward_timeseries = new GluonTSTorchSimpleFeedForwardSpace();
    public GluonTSMXNetSimpleFeedForwardSpace gluonts_simple_feed_forward_timeseries = new GluonTSMXNetSimpleFeedForwardSpace();
    public GluonTSMXNetDeepARSpace gluonts_deepar_timeseries = new GluonTSMXNetDeepARSpace();
    public GluonTSMXNetTransformerSpace gluonts_transformer_timeseries = new GluonTSMXNetTransformerSpace();
    public GluonTSMXNetMQCNNSpace gluonts_mqcnn_timeseries = new GluonTSMXNetMQCNNSpace();
    public CausalForestHyperparameterSpace causal_forest = new CausalForestHyperparameterSpace();
    public Set<CausalMetaLearner> meta_learners;
    public PropensityModeling propensityModeling = new PropensityModeling();
    public boolean grid_search;
    public GridSearchParams gridSearchParams = new GridSearchParams();
    public MetricParams metrics;
    public List<MLLibCustomGridParams> custom_mllib = new ArrayList<MLLibCustomGridParams>();
    public int max_ensemble_nodes_serialized = 6000;

    private PredictionModelingParams() {
    }

    public PredictionModelingParams(PredictionMLTask.PredictionType predictionType) {
        this.xgboost = new XGBoostHyperparametersSpace(predictionType == PredictionMLTask.PredictionType.REGRESSION || predictionType == PredictionMLTask.PredictionType.CAUSAL_REGRESSION);
        if (predictionType == PredictionMLTask.PredictionType.TIMESERIES_FORECAST) {
            this.gridSearchParams.mode = GridSearchCrossValidationMode.TIME_SERIES_KFOLD;
            this.gridSearchParams.nFolds = 3;
        }
    }

    public PredictionModelingParams(PredictionMLTask.PredictionType predictionType, PredictionModelingParams modeling) {
        this(predictionType);
        this.metrics = modeling != null && modeling.metrics != null ? new MetricParams(modeling.metrics.getCustomMetrics()) : new MetricParams();
    }

    public static PredictionModelingParams fromPredictionModelingParamsNoEnabledAlgos(PredictionModelingParams from, PredictionMLTask.PredictionType predictionType) {
        PredictionModelingParams newPredictionModelingParams = new PredictionModelingParams(predictionType);
        newPredictionModelingParams.metrics = from.metrics;
        newPredictionModelingParams.gridSearchParams = from.gridSearchParams;
        newPredictionModelingParams.max_ensemble_nodes_serialized = from.max_ensemble_nodes_serialized;
        newPredictionModelingParams.skipExpensiveReports = from.skipExpensiveReports;
        newPredictionModelingParams.meta_learners = from.meta_learners;
        newPredictionModelingParams.propensityModeling = from.propensityModeling;
        return newPredictionModelingParams;
    }

    public static PredictionModelingParams newWithoutAnyAlgorithmSettings() {
        PredictionModelingParams pmp = new PredictionModelingParams();
        pmp.glm_sparkling = null;
        pmp.gbm_sparkling = null;
        pmp.deep_learning_sparkling = null;
        pmp.mllib_linreg = null;
        pmp.mllib_logit = null;
        pmp.logistic_regression = null;
        pmp.mllib_rf = null;
        pmp.random_forest_regression = null;
        pmp.rf_sparkling = null;
        pmp.mllib_naive_bayes = null;
        pmp.random_forest_classification = null;
        pmp.xgboost = null;
        pmp.lightgbm_classification = null;
        pmp.lightgbm_regression = null;
        pmp.decision_tree_classification = null;
        pmp.lars_params = null;
        pmp.nb_sparkling = null;
        pmp.ridge_regression = null;
        pmp.decision_tree_regression = null;
        pmp.deep_neural_network_classification = null;
        pmp.deep_neural_network_regression = null;
        pmp.keras = null;
        pmp.mllib_dt = null;
        pmp.mllib_gbt = null;
        pmp.lasso_regression = null;
        pmp.svc_classifier = null;
        pmp.vertica_logistic_regression = null;
        pmp.vertica_linear_regression = null;
        pmp.gbt_classification = null;
        pmp.gbt_regression = null;
        pmp.knn = null;
        pmp.leastsquare_regression = null;
        pmp.sgd_classifier = null;
        pmp.svm_regression = null;
        pmp.extra_trees = null;
        pmp.neural_network = null;
        pmp.sgd_regression = null;
        pmp.trivial_identity_timeseries = null;
        pmp.seasonal_naive_timeseries = null;
        pmp.autoarima_timeseries = null;
        pmp.arima_timeseries = null;
        pmp.croston_timeseries = null;
        pmp.ets_timeseries = null;
        pmp.seasonal_loess_timeseries = null;
        pmp.gluonts_npts_timeseries = null;
        pmp.gluonts_torch_simple_feed_forward_timeseries = null;
        pmp.gluonts_torch_deepar_timeseries = null;
        pmp.gluonts_simple_feed_forward_timeseries = null;
        pmp.gluonts_deepar_timeseries = null;
        pmp.gluonts_transformer_timeseries = null;
        pmp.gluonts_mqcnn_timeseries = null;
        pmp.causal_forest = null;
        pmp.meta_learners = null;
        return pmp;
    }

    public void disableAll() {
        this.glm_sparkling.enabled = false;
        this.gbm_sparkling.enabled = false;
        this.deep_learning_sparkling.enabled = false;
        this.mllib_linreg.enabled = false;
        this.mllib_logit.enabled = false;
        this.logistic_regression.enabled = false;
        this.mllib_rf.enabled = false;
        this.random_forest_regression.enabled = false;
        this.rf_sparkling.enabled = false;
        this.mllib_naive_bayes.enabled = false;
        this.random_forest_classification.enabled = false;
        this.xgboost.enabled = false;
        this.lightgbm_classification.enabled = false;
        this.lightgbm_regression.enabled = false;
        this.decision_tree_classification.enabled = false;
        this.lars_params.enabled = false;
        this.nb_sparkling.enabled = false;
        this.ridge_regression.enabled = false;
        this.decision_tree_regression.enabled = false;
        this.deep_neural_network_regression.enabled = false;
        this.deep_neural_network_classification.enabled = false;
        this.keras.enabled = false;
        this.mllib_dt.enabled = false;
        this.mllib_gbt.enabled = false;
        this.lasso_regression.enabled = false;
        this.svc_classifier.enabled = false;
        this.vertica_logistic_regression.enabled = false;
        this.vertica_linear_regression.enabled = false;
        this.gbt_classification.enabled = false;
        this.gbt_regression.enabled = false;
        this.knn.enabled = false;
        this.leastsquare_regression.enabled = false;
        this.sgd_classifier.enabled = false;
        this.svm_regression.enabled = false;
        this.extra_trees.enabled = false;
        this.neural_network.enabled = false;
        this.sgd_regression.enabled = false;
        this.trivial_identity_timeseries.enabled = false;
        this.seasonal_naive_timeseries.enabled = false;
        this.autoarima_timeseries.enabled = false;
        this.arima_timeseries.enabled = false;
        this.croston_timeseries.enabled = false;
        this.ets_timeseries.enabled = false;
        this.seasonal_loess_timeseries.enabled = false;
        this.gluonts_npts_timeseries.enabled = false;
        this.gluonts_torch_simple_feed_forward_timeseries.enabled = false;
        this.gluonts_torch_deepar_timeseries.enabled = false;
        this.gluonts_simple_feed_forward_timeseries.enabled = false;
        this.gluonts_deepar_timeseries.enabled = false;
        this.gluonts_transformer_timeseries.enabled = false;
        this.gluonts_mqcnn_timeseries.enabled = false;
        this.causal_forest.enabled = false;
        this.meta_learners = new HashSet<CausalMetaLearner>();
        for (CustomPythonPluginParams algo : this.plugin_python.values()) {
            algo.enabled = false;
        }
        for (CustomPythonParams customPythonParams : this.custom_python) {
            customPythonParams.enabled = false;
        }
        for (MLLibCustomGridParams customMLLib : this.custom_mllib) {
            customMLLib.enabled = false;
        }
    }

    public List<ClassicalMLHyperparametersSpace> listAllClassicalPythonHyperparametersSpace() {
        ArrayList<ClassicalMLHyperparametersSpace> ret = new ArrayList<ClassicalMLHyperparametersSpace>();
        ret.add(this.logistic_regression);
        ret.add(this.random_forest_regression);
        ret.add(this.random_forest_classification);
        ret.add(this.xgboost);
        ret.add(this.lightgbm_classification);
        ret.add(this.lightgbm_regression);
        ret.add(this.decision_tree_classification);
        ret.add(this.lars_params);
        ret.add(this.ridge_regression);
        ret.add(this.decision_tree_regression);
        ret.add(this.deep_neural_network_regression);
        ret.add(this.deep_neural_network_classification);
        ret.add(this.lasso_regression);
        ret.add(this.svc_classifier);
        ret.add(this.gbt_classification);
        ret.add(this.gbt_regression);
        ret.add(this.knn);
        ret.add(this.leastsquare_regression);
        ret.add(this.sgd_classifier);
        ret.add(this.svm_regression);
        ret.add(this.extra_trees);
        ret.add(this.neural_network);
        ret.add(this.sgd_regression);
        ret.addAll(this.plugin_python.values());
        ret.addAll(this.custom_python);
        return ret;
    }

    public List<ClassicalMLHyperparametersSpace> listAllEnabledClassicalPythonHyperparametersSpace() {
        ArrayList<ClassicalMLHyperparametersSpace> ret = new ArrayList<ClassicalMLHyperparametersSpace>();
        for (ClassicalMLHyperparametersSpace space : this.listAllClassicalPythonHyperparametersSpace()) {
            if (!space.enabled) continue;
            ret.add(space);
        }
        return ret;
    }

    public static class RandomForestHyperparametersSpace
    extends ClassicalMLHyperparametersSpace {
        public IntegerHyperparameterDimension n_estimators = new IntegerHyperparameterDimension(1L, null, 80L, 200L, NumericalHyperparameterDimension.Scaling.LINEAR, 100L);
        public int n_jobs = 4;
        public IntegerHyperparameterDimension max_tree_depth = new IntegerHyperparameterDimension(1L, null, 6L, 20L, NumericalHyperparameterDimension.Scaling.LINEAR, 8L);
        public IntegerHyperparameterDimension min_samples_leaf = new IntegerHyperparameterDimension(1L, null, 1L, 20L, NumericalHyperparameterDimension.Scaling.LINEAR, 1L);
        public TreeSelectionMode selection_mode = TreeSelectionMode.SQRT;
        public IntegerHyperparameterDimension max_features = new IntegerHyperparameterDimension(1L, null, 1L, 20L, NumericalHyperparameterDimension.Scaling.LINEAR, 5L);
        public FloatHyperparameterDimension max_feature_prop = new FloatHyperparameterDimension(FloatHyperparameterDimension.minPositive, 1.0, 0.1, 0.7, NumericalHyperparameterDimension.Scaling.LINEAR, 0.3);
        public boolean allow_sparse_matrices = true;

        public RandomForestHyperparametersSpace() {
        }

        public RandomForestHyperparametersSpace(IntegerHyperparameterDimension n_estimators) {
            this.n_estimators = n_estimators;
        }

        public RandomForestHyperparametersSpace(boolean regression) {
            if (regression) {
                this.max_tree_depth.updateRange(10L, 20L);
                this.selection_mode = TreeSelectionMode.PROP;
                this.max_feature_prop.setToSingleValueGrid(1.0);
            }
        }

        @Override
        public boolean isCompatibleWithMonotonicConstraints() {
            return true;
        }

        @Override
        public String getAlgorithmName() {
            return "Random Forest";
        }
    }

    public static class GBTClassificationHyperparametersSpace
    extends GradientBoostedTreeHyperparametersSpace {
        public GBTClassificationHyperparametersSpace() {
            this.loss.withValue("deviance", true).withValue("exponential", false);
        }
    }

    public static class GBTRegressionHyperparametersSpace
    extends GradientBoostedTreeHyperparametersSpace {
        public GBTRegressionHyperparametersSpace() {
            this.loss.withValue("ls", true).withValue("lad", false).withValue("huber", false);
            this.selection_mode = TreeSelectionMode.PROP;
            this.max_feature_prop.setToSingleValueGrid(1.0);
        }
    }

    public static class DecisionTreeHyperparametersSpace
    extends ClassicalMLHyperparametersSpace {
        public IntegerHyperparameterDimension max_depth = new IntegerHyperparameterDimension(1L, null, 3L, 10L, NumericalHyperparameterDimension.Scaling.LINEAR, 5L);
        public IntegerHyperparameterDimension min_samples_leaf = new IntegerHyperparameterDimension(1L, null, 1L, 20L, NumericalHyperparameterDimension.Scaling.LINEAR, 1L);
        public CategoricalHyperparameterDimension criterion = new CategoricalHyperparameterDimension().withValue("gini", true).withValue("entropy", false);
        public CategoricalHyperparameterDimension splitter = new CategoricalHyperparameterDimension().withValue("best", true).withValue("random", false);

        @Override
        public boolean isCompatibleWithMonotonicConstraints() {
            return true;
        }

        @Override
        public String getAlgorithmName() {
            return "Decision Tree";
        }
    }

    public static class RidgeRegressionHyperparametersSpace
    extends ClassicalMLHyperparametersSpace {
        public RidgeSelectAlphaMode alphaMode = RidgeSelectAlphaMode.MANUAL;
        public FloatHyperparameterDimension alpha = new FloatHyperparameterDimension(FloatHyperparameterDimension.minPositive, null, 0.1, 3.0, NumericalHyperparameterDimension.Scaling.LOGARITHMIC, 0.1, 1.0, 3.0);

        @Override
        public String getAlgorithmName() {
            return "Ridge Regression";
        }
    }

    public static class LassoHyperparametersSpace
    extends ClassicalMLHyperparametersSpace {
        public LassoSelectAlphaMode alphaMode = LassoSelectAlphaMode.AUTO_CV;
        public FloatHyperparameterDimension alpha = new FloatHyperparameterDimension(FloatHyperparameterDimension.minPositive, null, 0.1, 10.0, NumericalHyperparameterDimension.Scaling.LOGARITHMIC, 0.1, 1.0, 10.0);

        @Override
        public String getAlgorithmName() {
            return "LASSO Regression";
        }
    }

    public static class LeastSquareHyperparametersSpace
    extends ClassicalMLHyperparametersSpace {
        public int n_jobs = 2;

        @Override
        public String getAlgorithmName() {
            return "Least Square Regression";
        }
    }

    public static class SGDRegressionHyperparametersSpace
    extends SGDHyperparametersSpace {
        public FloatHyperparameterDimension epsilon = new FloatHyperparameterDimension(FloatHyperparameterDimension.minPositive, null, 0.01, 0.1, NumericalHyperparameterDimension.Scaling.LOGARITHMIC, 0.01);

        SGDRegressionHyperparametersSpace() {
            this.loss.withValue("squared_loss", true).withValue("huber", false);
            this.penalty.withValue("l1", true).withValue("l2", false).withValue("elasticnet", false);
        }
    }

    public static class SGDClassificationHyperparametersSpace
    extends SGDHyperparametersSpace {
        SGDClassificationHyperparametersSpace() {
            this.loss.withValue("log", true).withValue("modified_huber", false);
            this.penalty.withValue("l1", true).withValue("l2", false).withValue("elasticnet", false);
        }
    }

    public static class KNNHyperparametersSpace
    extends ClassicalMLHyperparametersSpace {
        public IntegerHyperparameterDimension k = new IntegerHyperparameterDimension(1L, null, 3L, 7L, NumericalHyperparameterDimension.Scaling.LINEAR, 5L);
        public boolean distance_weighting = false;
        public KNNAlgorithm algorithm = KNNAlgorithm.AUTO;
        public int p = 2;
        public int leaf_size = 30;

        @Override
        public String getAlgorithmName() {
            return "K Nearest Neighbors";
        }
    }

    public static class LogisticRegressionHyperparametersSpace
    extends ClassicalMLHyperparametersSpace {
        public LogisticRegressionClassifierMultiClass multi_class = LogisticRegressionClassifierMultiClass.OVR;
        public CategoricalHyperparameterDimension penalty = new CategoricalHyperparameterDimension().withValue("l2", true).withValue("l1", false);
        public FloatHyperparameterDimension C = new FloatHyperparameterDimension(FloatHyperparameterDimension.minPositive, null, 0.01, 100.0, NumericalHyperparameterDimension.Scaling.LOGARITHMIC, 0.01, 0.1, 1.0, 10.0, 100.0);
        public int n_jobs = 2;

        @Override
        public String getAlgorithmName() {
            return "Logistic Regression";
        }
    }

    public static class NeuralNetworkHyperparametersSpace
    extends ClassicalMLHyperparametersSpace {
        public IntegerHyperparameterDimension layer_sizes = new IntegerHyperparameterDimension(1L, null, 8L, 16L, NumericalHyperparameterDimension.Scaling.LINEAR, 10L);
        public String activation = "relu";
        public String solver = "adam";
        public float alpha = 0.001f;
        public int batch_size = 200;
        public boolean auto_batch = true;
        public int max_iter = 200;
        public int seed = 1337;
        public float tol = 1.0E-4f;
        public boolean early_stopping = false;
        public float validation_fraction = 0.1f;
        public float beta_1 = 0.9f;
        public float beta_2 = 0.999f;
        public float epsilon = 1.0E-8f;
        public String learning_rate = "constant";
        public float power_t = 0.5f;
        public float momentum = 0.8f;
        public boolean nesterovs_momentum = true;
        public boolean shuffle = true;
        public float learning_rate_init = 0.001f;

        @Override
        public String getAlgorithmName() {
            return "Single Hidden Layer Perceptron";
        }
    }

    public static class SVMHyperparametersSpace
    extends ClassicalMLHyperparametersSpace {
        public FloatHyperparameterDimension C = new FloatHyperparameterDimension(FloatHyperparameterDimension.minPositive, null, 0.1, 10.0, NumericalHyperparameterDimension.Scaling.LOGARITHMIC, 1.0);
        public CategoricalHyperparameterDimension gamma = new CategoricalHyperparameterDimension().withValue("scale", true).withValue("auto", false).withValue("custom", false);
        public FloatHyperparameterDimension custom_gamma = new FloatHyperparameterDimension(FloatHyperparameterDimension.minPositive, null, 1.0E-4, 1.0, NumericalHyperparameterDimension.Scaling.LOGARITHMIC, 0.001);
        public CategoricalHyperparameterDimension kernel = new CategoricalHyperparameterDimension().withValue("rbf", true).withValue("linear", false).withValue("poly", false).withValue("sigmoid", false);
        public float coef0 = 0.0f;
        public float tol = 0.001f;
        public int max_iter = -1;

        public static boolean isGammaCompatibleKernel(String kernel) {
            return Arrays.asList("rbf", "sigmoid", "poly").contains(kernel);
        }

        public int countGammaCompatibleKernels() {
            int ret = 0;
            for (Map.Entry<String, CategoricalHyperparameterValue> kernelEntry : this.kernel.values.entrySet()) {
                if (!kernelEntry.getValue().enabled || !SVMHyperparametersSpace.isGammaCompatibleKernel(kernelEntry.getKey())) continue;
                ++ret;
            }
            return ret;
        }

        @Override
        public String getAlgorithmName() {
            return "Support Vector Machine";
        }
    }

    public static class LarsHyperparametersSpace
    extends ClassicalMLHyperparametersSpace {
        public int max_features = 0;
        public int K = 100;

        @Override
        public String getAlgorithmName() {
            return "Least Angle Regression";
        }
    }

    public static class LightGBMHyperParametersSpace
    extends ClassicalMLHyperparametersSpace {
        public CategoricalHyperparameterDimension boosting_type = new CategoricalHyperparameterDimension().withValue("gbdt", true).withValue("goss", false);
        public IntegerHyperparameterDimension num_leaves = new IntegerHyperparameterDimension(1L, null, 20L, 500L, NumericalHyperparameterDimension.Scaling.LINEAR, 31L);
        public FloatHyperparameterDimension learning_rate = new FloatHyperparameterDimension(FloatHyperparameterDimension.minPositive, 1.0, 0.1, 0.6, NumericalHyperparameterDimension.Scaling.LINEAR, 0.1, 0.2);
        public IntegerHyperparameterDimension n_estimators = new IntegerHyperparameterDimension(1L, null, 50L, 200L, NumericalHyperparameterDimension.Scaling.LINEAR, 75L);
        public FloatHyperparameterDimension min_split_gain = new FloatHyperparameterDimension(0.0, 1.0, 0.0, 1.0, NumericalHyperparameterDimension.Scaling.LINEAR, 0.0);
        public FloatHyperparameterDimension min_child_weight = new FloatHyperparameterDimension(FloatHyperparameterDimension.minPositive, 1.0, 0.001, 1.0, NumericalHyperparameterDimension.Scaling.LINEAR, 0.001);
        public IntegerHyperparameterDimension min_child_samples = new IntegerHyperparameterDimension(1L, null, 1L, 100L, NumericalHyperparameterDimension.Scaling.LINEAR, 10L, 30L);
        public FloatHyperparameterDimension colsample_bytree = new FloatHyperparameterDimension(FloatHyperparameterDimension.minPositive, 1.0, 0.5, 1.0, NumericalHyperparameterDimension.Scaling.LINEAR, 0.7, 0.9);
        public FloatHyperparameterDimension reg_alpha = new FloatHyperparameterDimension(0.0, null, 0.0, 1.0, NumericalHyperparameterDimension.Scaling.LINEAR, 0.0);
        public FloatHyperparameterDimension reg_lambda = new FloatHyperparameterDimension(0.0, null, 0.0, 1.0, NumericalHyperparameterDimension.Scaling.LINEAR, 0.0);
        public boolean early_stopping = true;
        public int early_stopping_rounds = 4;
        public int random_state = 1337;
        public int n_jobs = 4;
        public int max_depth = -1;
        public float subsample = 0.9f;
        public int subsample_freq = 1;
        public boolean use_bagging = false;
        public boolean allow_sparse_matrices = true;

        @Override
        public boolean isCompatibleWithMonotonicConstraints() {
            return true;
        }

        @Override
        public String getAlgorithmName() {
            return "LightGBM";
        }
    }

    public static class XGBoostHyperparametersSpace
    extends ClassicalMLHyperparametersSpace {
        public IntegerHyperparameterDimension max_depth = new IntegerHyperparameterDimension(1L, null, 3L, 10L, NumericalHyperparameterDimension.Scaling.LINEAR, 3L);
        public FloatHyperparameterDimension learning_rate = new FloatHyperparameterDimension(FloatHyperparameterDimension.minPositive, 1.0, 0.1, 0.5, NumericalHyperparameterDimension.Scaling.LINEAR, 0.2);
        public FloatHyperparameterDimension gamma = new FloatHyperparameterDimension(0.0, null, 0.0, 1.0, NumericalHyperparameterDimension.Scaling.LINEAR, 0.0);
        public FloatHyperparameterDimension min_child_weight = new FloatHyperparameterDimension(0.0, null, 0.5, 5.0, NumericalHyperparameterDimension.Scaling.LINEAR, 1.0);
        public FloatHyperparameterDimension max_delta_step = new FloatHyperparameterDimension(0.0, null, 0.0, 1.0, NumericalHyperparameterDimension.Scaling.LINEAR, 0.0);
        public FloatHyperparameterDimension subsample = new FloatHyperparameterDimension(FloatHyperparameterDimension.minPositive, 1.0, 0.5, 1.0, NumericalHyperparameterDimension.Scaling.LINEAR, 1.0);
        public FloatHyperparameterDimension colsample_bytree = new FloatHyperparameterDimension(FloatHyperparameterDimension.minPositive, 1.0, 0.5, 1.0, NumericalHyperparameterDimension.Scaling.LINEAR, 1.0);
        public FloatHyperparameterDimension colsample_bylevel = new FloatHyperparameterDimension(FloatHyperparameterDimension.minPositive, 1.0, 0.5, 1.0, NumericalHyperparameterDimension.Scaling.LINEAR, 1.0);
        public FloatHyperparameterDimension alpha = new FloatHyperparameterDimension(0.0, null, 0.0, 1.0, NumericalHyperparameterDimension.Scaling.LINEAR, 0.0);
        public FloatHyperparameterDimension lambda = new FloatHyperparameterDimension(FloatHyperparameterDimension.minPositive, null, 0.01, 1.0, NumericalHyperparameterDimension.Scaling.LINEAR, 1.0);
        public CategoricalHyperparameterDimension booster = new CategoricalHyperparameterDimension().withValue("gbtree", true).withValue("dart", false);
        public CategoricalHyperparameterDimension objective = new CategoricalHyperparameterDimension().withValue("reg_linear", true).withValue("reg_logistic", false).withValue("reg_gamma", false).withValue("reg_tweedie", false).withValue("count_poisson", false).withValue("binary_logistic", false).withValue("multi_softprob", false);
        public int n_estimators = 300;
        public int nthread = 4;
        public float scale_pos_weight = 1.0f;
        public float base_score = 0.5f;
        public boolean impute_missing;
        public float missing;
        public String tree_method = "auto";
        public int seed = 1337;
        public boolean enable_early_stopping = true;
        public int early_stopping_rounds = 4;
        public float tweedie_variance_power = 1.5f;
        public boolean allow_sparse_matrices = true;

        public XGBoostHyperparametersSpace() {
            this.max_delta_step.randomMode = NumericalHyperparameterDimension.ValueMode.EXPLICIT;
        }

        public XGBoostHyperparametersSpace(boolean isRegression) {
            this.max_delta_step.randomMode = NumericalHyperparameterDimension.ValueMode.EXPLICIT;
            if (isRegression) {
                this.learning_rate.updateRange(0.01, 0.5);
                this.gamma.updateRange(0.0, 0.4);
            }
        }

        @Override
        public boolean isCompatibleWithMonotonicConstraints() {
            return true;
        }

        @Override
        public String getAlgorithmName() {
            return "XGBoost";
        }
    }

    public static class DeepNeuralNetworkHyperParameterSpace
    extends ClassicalMLHyperparametersSpace {
        public FloatHyperparameterDimension learning_rate = new FloatHyperparameterDimension(FloatHyperparameterDimension.minPositive, 1.0, 1.0E-5, 0.1, NumericalHyperparameterDimension.Scaling.LOGARITHMIC, 0.001);
        public IntegerHyperparameterDimension hidden_layers = new IntegerHyperparameterDimension(1L, null, 1L, 10L, NumericalHyperparameterDimension.Scaling.LINEAR, 1L);
        public IntegerHyperparameterDimension units = new IntegerHyperparameterDimension(1L, null, 1L, 256L, NumericalHyperparameterDimension.Scaling.LINEAR, 32L);
        public int batch_size = 32;
        public int max_epochs = 50;
        public boolean early_stopping_enabled = true;
        public int early_stopping_patience = 5;
        public float early_stopping_threshold = 1.0E-4f;
        public float dropout = 0.0f;
        public float reg_l2 = 0.0f;
        public float reg_l1 = 0.0f;

        @Override
        public String getAlgorithmName() {
            return "Deep Neural Network";
        }
    }

    public static class H2ODeepLearningGridParams
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public boolean enabled;
        public int[] hidden = new int[]{10, 10};
        public String activation = "RECTIFIER";
        public float epochs = 10.0f;
        public float l1 = 0.0f;
        public float l2 = 0.0f;
        public float max_w2 = -1.0f;
        public boolean dropout = false;
        public float input_dropout_ratio = 0.0f;
        public double[] hidden_dropout_ratios = new double[]{0.1, 0.2};
        public boolean use_adaptative = true;
        public float rho = 0.99f;
        public float epsilon = 1.0E-8f;
        public float rate = 0.005f;
        public float rate_annealing = 1.0E-6f;
        public float rate_decay = 1.0f;
        public float momentum_start = 0.0f;
        public float momentum_ramp = 1000000.0f;
        public float momentum_stable = 0.0f;

        public void validate() {
            ErrorContext.checkNotEmpty((int[])this.hidden, (String)"No hidden layers specified !");
            for (int h : this.hidden) {
                ErrorContext.check((h > 0 ? 1 : 0) != 0, (String)"Hidden layers must have a positive number of elements !");
            }
            ErrorContext.check((this.l1 >= 0.0f ? 1 : 0) != 0, (String)"L1 parameter must be positive.");
            ErrorContext.check((this.l2 >= 0.0f ? 1 : 0) != 0, (String)"L2 parameter must be positive.");
            ErrorContext.check((this.input_dropout_ratio >= 0.0f && this.input_dropout_ratio < 1.0f ? 1 : 0) != 0, (String)"Input dropout must be between 0 (inclusive) and 1 (exclusive).");
            if (this.dropout && this.hidden_dropout_ratios != null) {
                ErrorContext.check((this.hidden_dropout_ratios.length == this.hidden.length ? 1 : 0) != 0, (String)"Must have as many hidden dropout ratios as hidden layers !");
                for (double d : this.hidden_dropout_ratios) {
                    ErrorContext.check((d >= 0.0 && d < 1.0 ? 1 : 0) != 0, (String)"Hidden dropouts must be between 0 (inclusive) and 1 (exclusive).");
                }
            }
        }
    }

    public static class H2OGBMGridParams
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public boolean enabled;
        public float learn_rate = 0.1f;
        public int ntrees = 50;
        public int max_depth = 5;
        public int min_rows = 10;
        public String family = "AUTO";
        public int nbins = 20;
        public int nbins_cats = 1024;
        public boolean balance_classes = false;
        public float max_after_balance_size = 2.0f;
        public float tweedie_power = 1.5f;
        private static Set<String> legalFamilies = new HashSet<String>(Arrays.asList("AUTO", "bernoulli", "multinomial", "gaussian", "poisson", "gamma", "tweedie"));

        public void validate() {
            ErrorContext.check((this.learn_rate > 0.0f && this.learn_rate < 1.0f ? 1 : 0) != 0, (String)"GBM learning rate should be between 0 and 1, exclusive.");
            ErrorContext.check((this.ntrees > 0 ? 1 : 0) != 0, (String)"Should have at least one tree.");
            ErrorContext.check((this.max_depth > 0 ? 1 : 0) != 0, (String)"Trees should have at least depth 1.");
            ErrorContext.check((boolean)legalFamilies.contains(this.family), (String)("Unknown family : " + this.family));
            ErrorContext.check((this.nbins > 0 ? 1 : 0) != 0, (String)"Number of bins should be positive");
            ErrorContext.check((this.nbins_cats > 0 ? 1 : 0) != 0, (String)"Number of cat bins should be positive");
        }
    }

    public static class H2OGLMGridParams
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public boolean enabled;
        public String family = "gaussian";
        public float alpha = 0.5f;
        public float lambda = 0.0f;
        public int max_iter = 100;
        public float beta_epsilon = 1.0E-4f;
        public float tweedie_variance_power = 0.5f;
        private static Set<String> legalFamilies = new HashSet<String>(Arrays.asList("binomial", "gaussian", "poisson", "gamma", "tweedie", "multinomial"));

        public void validate() {
            ErrorContext.check((boolean)legalFamilies.contains(this.family), (String)("Unknown family : " + this.family));
            ErrorContext.check((this.alpha <= 1.0f && this.alpha >= 0.0f ? 1 : 0) != 0, (String)"Alpha should be between 0 and 1, inclusive");
            ErrorContext.check((this.lambda >= 0.0f ? 1 : 0) != 0, (String)"Lambda should be nonnegative.");
            ErrorContext.check((this.beta_epsilon >= 0.0f ? 1 : 0) != 0, (String)"Beta epsilon should be nonnegative");
        }
    }

    public static class H2ORandomForestGridParams
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public boolean enabled;
        public int ntrees = 50;
        public int max_depth = 5;
        public int min_rows = 1;
        public int mtries = -1;
        public float sample_rate = 0.6666f;
        public int nbins = 20;
        public int nbins_cats = 1024;

        public void validate() {
            ErrorContext.check((this.ntrees > 0 ? 1 : 0) != 0, (String)"Should have at least one tree.");
            ErrorContext.check((this.max_depth > 0 ? 1 : 0) != 0, (String)"Trees should have at least depth 1.");
            ErrorContext.check((this.nbins > 0 ? 1 : 0) != 0, (String)"Number of bins should be positive");
            ErrorContext.check((this.nbins_cats > 0 ? 1 : 0) != 0, (String)"Number of cat bins should be positive");
            ErrorContext.check((this.mtries == -1 || this.mtries > 0 ? 1 : 0) != 0, (String)"Number of tries should be -1 or a positive integer.");
            ErrorContext.check((this.sample_rate > 0.0f && this.sample_rate <= 1.0f ? 1 : 0) != 0, (String)"Sampling rate should be between 0 exclusive and 1 inclusive.");
            ErrorContext.check((this.min_rows > 0 ? 1 : 0) != 0, (String)"Min rows should be a positive integer.");
        }
    }

    public static class H2ONaiveBayesGridParams
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public boolean enabled;
        public float laplace = 0.0f;
        public float min_std_dev = 0.001f;

        public void validate() {
            ErrorContext.check(((double)this.laplace >= 0.0 ? 1 : 0) != 0, (String)"Laplace parameter should be nonnegative");
            ErrorContext.check((this.min_std_dev >= 0.0f ? 1 : 0) != 0, (String)"min_std_dev should be nonnegative");
        }
    }

    public static class MLLibNaiveBayesGridParams {
        public boolean enabled;
        public FloatHyperparameterDimension lambda = new FloatHyperparameterDimension(FloatHyperparameterDimension.minPositive, null, 0.1, 10.0, NumericalHyperparameterDimension.Scaling.LOGARITHMIC, 1.0);
    }

    public static class MLLibLogisticRegressionGridParams {
        public boolean enabled;
        public int max_iter = 30;
        public FloatHyperparameterDimension reg_param = new FloatHyperparameterDimension(0.0, null, 0.001, 10.0, NumericalHyperparameterDimension.Scaling.LOGARITHMIC, 0.1);
        public FloatHyperparameterDimension enet_param = new FloatHyperparameterDimension(0.0, null, 0.0, 1.0, NumericalHyperparameterDimension.Scaling.LINEAR, 0.0);
    }

    public static class MLLibLinearRegressionGridParams {
        public boolean enabled;
        public int max_iter = 30;
        public FloatHyperparameterDimension reg_param = new FloatHyperparameterDimension(0.0, null, 0.001, 10.0, NumericalHyperparameterDimension.Scaling.LOGARITHMIC, 0.1);
        public FloatHyperparameterDimension enet_param = new FloatHyperparameterDimension(0.0, null, 0.0, 1.0, NumericalHyperparameterDimension.Scaling.LINEAR, 0.0);
    }

    public static class MLLibDecisionTreeGridParams {
        public boolean enabled;
        public IntegerHyperparameterDimension max_depth = new IntegerHyperparameterDimension(1L, null, 3L, 8L, NumericalHyperparameterDimension.Scaling.LINEAR, 3L);
        public int max_bins = 32;
        public int max_memory_mb = 256;
        public double min_info_gain = 0.0;
        public int min_instance_per_node = 1;
        public boolean cache_node_ids;
        public int checkpoint_interval = 10;
    }

    public static class MLLibTreesEnsembleGridParams {
        public boolean enabled;
        public boolean cache_node_ids;
        public int checkpoint_interval = 10;
        public MLLibRfImpurity impurity = MLLibRfImpurity.gini;
        public int max_bins = 32;
        public IntegerHyperparameterDimension max_depth = new IntegerHyperparameterDimension(1L, null, 3L, 8L, NumericalHyperparameterDimension.Scaling.LINEAR, 3L);
        public int max_memory_mb = 256;
        public float min_info_gain = 0.0f;
        public int min_instance_per_node = 1;
        public long seed = 1337L;
        public float subsampling_rate = 1.0f;
        public IntegerHyperparameterDimension num_trees = new IntegerHyperparameterDimension(1L, null, 10L, 50L, NumericalHyperparameterDimension.Scaling.LINEAR, 20L);
        public MLLibRfFeatureSubsetStrategy subset_strategy = MLLibRfFeatureSubsetStrategy.auto;
        public FloatHyperparameterDimension step_size = new FloatHyperparameterDimension(FloatHyperparameterDimension.minPositive, 1.0, 0.05, 0.5, NumericalHyperparameterDimension.Scaling.LINEAR, 0.1);
    }

    @Deprecated
    public static class VerticaLinearRegParams {
        public boolean enabled;
        public int maxIterations = 200;
        public double epsilon = 1.0E-6;
        public String optimizer = "BFGS";
    }

    @Deprecated
    public static class VerticaLogisticRegParams {
        public boolean enabled;
        public int maxIterations = 200;
        public double epsilon = 1.0E-6;
        public String optimizer = "BFGS";
    }

    public static class KerasCodeParams {
        public int epochs = 10;
        public int batchSize = 32;
        public boolean trainOnAllData = true;
        public int stepsPerEpoch = 100;
        public boolean shuffleData = true;
        public boolean cachePreprocessedData = true;
        public boolean advancedFitMode = false;
        public boolean enabled;
        public List<String> kerasInputs = Lists.newArrayList(Collections.singletonList("main"));
        public String buildCode;
        public String fitCode;
    }

    public static class TrivialIdentityTimeseriesSpace
    extends HyperparametersSpace {
    }

    public static class SeasonalNaiveSpace
    extends HyperparametersSpace {
        public IntegerHyperparameterDimension season_length = new IntegerHyperparameterDimension(1L, null, 1L, 7L, NumericalHyperparameterDimension.Scaling.LINEAR, 1L);
    }

    public static class ArimaSpace
    extends HyperparametersSpace {
        public int p = 0;
        public int d = 0;
        public int q = 0;
        public int P = 0;
        public int D = 0;
        public int Q = 0;
        public int s = 7;
        public String trend = "n";
        public int trend_offset = 1;
        public boolean enforce_stationarity = true;
        public boolean enforce_invertibility = true;
        public boolean concentrate_scale = false;
    }

    public static class AutoArimaSpace
    extends HyperparametersSpace {
        public IntegerHyperparameterDimension m = new IntegerHyperparameterDimension(1L, null, 1L, 7L, NumericalHyperparameterDimension.Scaling.LINEAR, 1L);
        public CategoricalHyperparameterDimension information_criterion = new CategoricalHyperparameterDimension().withValue("aic", true).withValue("aicc", false).withValue("bic", false).withValue("hqic", false).withValue("oob", false);
        public CategoricalHyperparameterDimension test = new CategoricalHyperparameterDimension().withValue("kpss", true).withValue("adf", false).withValue("pp", false);
        public CategoricalHyperparameterDimension seasonal_test = new CategoricalHyperparameterDimension().withValue("ocsb", true).withValue("ch", false);
        public CategoricalHyperparameterDimension method = new CategoricalHyperparameterDimension().withValue("lbfgs", true).withValue("newton", false).withValue("nm", false).withValue("bfgs", false).withValue("powell", false).withValue("cg", false).withValue("ncg", false).withValue("basinhopping", false);
        public int start_p = 1;
        public int max_p = 5;
        @Nullable
        public Integer d;
        public int max_d = 2;
        public int start_q = 1;
        public int max_q = 5;
        public int start_P = 1;
        public int max_P = 2;
        @Nullable
        public Integer D;
        public int max_D = 1;
        public int start_Q = 1;
        public int max_Q = 2;
        public int max_order = 5;
        public boolean stationary = false;
        public int maxiter = 50;
    }

    public static class CrostonSpace
    extends HyperparametersSpace {
        public CategoricalHyperparameterDimension variant = new CategoricalHyperparameterDimension().withValue("CLASSIC", false).withValue("SBA", true).withValue("TSB", false);
        public FloatHyperparameterDimension alpha_d = new FloatHyperparameterDimension(0.0, 1.0, 0.0, 1.0, NumericalHyperparameterDimension.Scaling.LINEAR, 0.1);
        public FloatHyperparameterDimension alpha_p = new FloatHyperparameterDimension(0.0, 1.0, 0.0, 1.0, NumericalHyperparameterDimension.Scaling.LINEAR, 0.1);
    }

    public static class ETSSpace
    extends HyperparametersSpace {
        public CategoricalHyperparameterDimension trend = new CategoricalHyperparameterDimension().withValue("none", true).withValue("add", false).withValue("mul", false);
        public CategoricalHyperparameterDimension damped_trend = new CategoricalHyperparameterDimension().withValue("false", true).withValue("true", false);
        public CategoricalHyperparameterDimension seasonal = new CategoricalHyperparameterDimension().withValue("none", true).withValue("add", false).withValue("mul", false);
        public CategoricalHyperparameterDimension error = new CategoricalHyperparameterDimension().withValue("add", true).withValue("mul", false);
        public int seasonal_periods = 7;
        public boolean include_unstable = false;
        public int seed = 1337;
    }

    public static class SeasonalLoessSpace
    extends HyperparametersSpace {
        public IntegerHyperparameterDimension period = new IntegerHyperparameterDimension(2L, null, 2L, 7L, NumericalHyperparameterDimension.Scaling.LINEAR, 2L);
        public IntegerHyperparameterDimension seasonal = new OddIntegerHyperparameterDimension(3L, null, 3L, 31L, NumericalHyperparameterDimension.Scaling.LINEAR, 7L);
        public IntegerHyperparameterDimension trend = new OddIntegerHyperparameterDimension(3L, null, 3L, 11L, NumericalHyperparameterDimension.Scaling.LINEAR, 3L);
        public IntegerHyperparameterDimension low_pass = new OddIntegerHyperparameterDimension(3L, null, 3L, 11L, NumericalHyperparameterDimension.Scaling.LINEAR, 3L);
        public CategoricalHyperparameterDimension seasonal_deg = new CategoricalHyperparameterDimension().withValue("0", false).withValue("1", true);
        public CategoricalHyperparameterDimension trend_deg = new CategoricalHyperparameterDimension().withValue("0", false).withValue("1", true);
        public CategoricalHyperparameterDimension low_pass_deg = new CategoricalHyperparameterDimension().withValue("0", false).withValue("1", true);
        public IntegerHyperparameterDimension seasonal_jump = new IntegerHyperparameterDimension(1L, null, 1L, 10L, NumericalHyperparameterDimension.Scaling.LINEAR, 1L);
        public IntegerHyperparameterDimension trend_jump = new IntegerHyperparameterDimension(1L, null, 1L, 10L, NumericalHyperparameterDimension.Scaling.LINEAR, 1L);
        public IntegerHyperparameterDimension low_pass_jump = new IntegerHyperparameterDimension(1L, null, 1L, 10L, NumericalHyperparameterDimension.Scaling.LINEAR, 1L);
        public boolean auto_trend = true;
        public boolean auto_low_pass = true;
    }

    public static class ProphetSpace
    extends HyperparametersSpace {
        public FloatHyperparameterDimension changepoint_prior_scale = new FloatHyperparameterDimension(FloatHyperparameterDimension.minPositive, null, 0.001, 0.05, NumericalHyperparameterDimension.Scaling.LOGARITHMIC, 0.005, 0.05);
        public FloatHyperparameterDimension seasonality_prior_scale = new FloatHyperparameterDimension(FloatHyperparameterDimension.minPositive, null, 0.01, 10.0, NumericalHyperparameterDimension.Scaling.LOGARITHMIC, 10.0);
        public CategoricalHyperparameterDimension seasonality_mode = new CategoricalHyperparameterDimension().withValue("additive", true).withValue("multiplicative", false);
        public FloatHyperparameterDimension holidays_prior_scale = new FloatHyperparameterDimension(FloatHyperparameterDimension.minPositive, null, 0.01, 10.0, NumericalHyperparameterDimension.Scaling.LOGARITHMIC, 10.0);
        public ProphetGrowth growth = ProphetGrowth.LINEAR;
        public double floor = 0.0;
        public Double cap;
        public int n_changepoints = 25;
        public double changepoint_range = 0.8;
        public ProphetSeasonality yearly_seasonality = ProphetSeasonality.AUTO;
        public ProphetSeasonality weekly_seasonality = ProphetSeasonality.AUTO;
        public ProphetSeasonality daily_seasonality = ProphetSeasonality.AUTO;
        public int seed = 1337;
        public boolean _use_external_features = false;
    }

    public static class GluonTSNPTSForecasterSpace
    extends HyperparametersSpace {
        public IntegerHyperparameterDimension context_length = new IntegerHyperparameterDimension(1L, null, 10L, 20L, NumericalHyperparameterDimension.Scaling.LINEAR, 1L);
        public CategoricalHyperparameterDimension kernel_type = new CategoricalHyperparameterDimension().withValue("exponential", true).withValue("uniform", false);
        public FloatHyperparameterDimension exp_kernel_weights = new FloatHyperparameterDimension(FloatHyperparameterDimension.minPositive, null, 0.1, 10.0, NumericalHyperparameterDimension.Scaling.LINEAR, 0.5, 1.0, 2.0);
        public FloatHyperparameterDimension feature_scale = new FloatHyperparameterDimension(FloatHyperparameterDimension.minPositive, null, 0.1, 10000.0, NumericalHyperparameterDimension.Scaling.LINEAR, 1000.0);
        public boolean full_context = true;
        public boolean use_seasonal_model = true;
        public boolean use_default_time_features = true;
        public int seed = 1337;
    }

    public static class GluonTSTorchDeepARSpace
    extends HyperparametersSpace {
        public IntegerHyperparameterDimension context_length = new IntegerHyperparameterDimension(1L, null, 10L, 20L, NumericalHyperparameterDimension.Scaling.LINEAR, 1L);
        public IntegerHyperparameterDimension num_layers = new IntegerHyperparameterDimension(1L, null, 1L, 4L, NumericalHyperparameterDimension.Scaling.LINEAR, 2L);
        public IntegerHyperparameterDimension num_cells = new IntegerHyperparameterDimension(1L, null, 30L, 50L, NumericalHyperparameterDimension.Scaling.LINEAR, 40L);
        public FloatHyperparameterDimension dropout_rate = new FloatHyperparameterDimension(FloatHyperparameterDimension.minPositive, 1.0, 0.05, 0.2, NumericalHyperparameterDimension.Scaling.LINEAR, 0.1);
        public CategoricalHyperparameterDimension distr_output = new CategoricalHyperparameterDimension().withValue("StudentTOutput", true);
        public FloatHyperparameterDimension learning_rate = new FloatHyperparameterDimension(FloatHyperparameterDimension.minPositive, null, 1.0E-4, 0.1, NumericalHyperparameterDimension.Scaling.LOGARITHMIC, 0.001);
        public FloatHyperparameterDimension weight_decay = new FloatHyperparameterDimension(FloatHyperparameterDimension.minPositive, null, 1.0E-12, 0.1, NumericalHyperparameterDimension.Scaling.LOGARITHMIC, 1.0E-8);
        public boolean full_context = true;
        public boolean use_timeseries_identifiers_as_features = false;
        public boolean scaling = true;
        public int patience = 10;
        public int num_parallel_samples = 100;
        public int batch_size = 32;
        public int epochs = 10;
        public boolean auto_num_batches_per_epoch = true;
        public int num_batches_per_epoch = 50;
        public int seed = 1337;
    }

    public static class GluonTSTorchSimpleFeedForwardSpace
    extends HyperparametersSpace {
        public IntegerHyperparameterDimension context_length = new IntegerHyperparameterDimension(1L, null, 1L, 10L, NumericalHyperparameterDimension.Scaling.LINEAR, 1L);
        public CategoricalHyperparameterDimension distr_output = new CategoricalHyperparameterDimension().withValue("StudentTOutput", true);
        public CategoricalHyperparameterDimension batch_normalization = new CategoricalHyperparameterDimension().withValue("false", false).withValue("true", true);
        public FloatHyperparameterDimension learning_rate = new FloatHyperparameterDimension(FloatHyperparameterDimension.minPositive, null, 1.0E-4, 0.1, NumericalHyperparameterDimension.Scaling.LOGARITHMIC, 0.001, 0.01);
        public FloatHyperparameterDimension weight_decay = new FloatHyperparameterDimension(FloatHyperparameterDimension.minPositive, null, 1.0E-12, 0.1, NumericalHyperparameterDimension.Scaling.LOGARITHMIC, 1.0E-8);
        public List<Long> num_hidden_dimensions = Arrays.asList(40L, 40L);
        public boolean full_context = true;
        public int batch_size = 32;
        public int epochs = 10;
        public boolean auto_num_batches_per_epoch = true;
        public int num_batches_per_epoch = 50;
        public int seed = 1337;
    }

    public static class GluonTSMXNetSimpleFeedForwardSpace
    extends HyperparametersSpace {
        public IntegerHyperparameterDimension context_length = new IntegerHyperparameterDimension(1L, null, 1L, 10L, NumericalHyperparameterDimension.Scaling.LINEAR, 1L);
        public CategoricalHyperparameterDimension distr_output = new CategoricalHyperparameterDimension().withValue("StudentTOutput", true).withValue("GaussianOutput", false).withValue("NegativeBinomialOutput", false);
        public CategoricalHyperparameterDimension batch_normalization = new CategoricalHyperparameterDimension().withValue("false", false).withValue("true", true);
        public CategoricalHyperparameterDimension mean_scaling = new CategoricalHyperparameterDimension().withValue("true", true).withValue("false", false);
        public FloatHyperparameterDimension learning_rate = new FloatHyperparameterDimension(FloatHyperparameterDimension.minPositive, null, 1.0E-4, 0.1, NumericalHyperparameterDimension.Scaling.LOGARITHMIC, 0.001, 0.01);
        public List<Long> num_hidden_dimensions = Arrays.asList(40L, 40L);
        public boolean full_context = true;
        public int num_parallel_samples = 100;
        public int batch_size = 32;
        public int epochs = 10;
        public boolean auto_num_batches_per_epoch = true;
        public int num_batches_per_epoch = 50;
        public int seed = 1337;
    }

    public static class GluonTSMXNetDeepARSpace
    extends HyperparametersSpace {
        public IntegerHyperparameterDimension context_length = new IntegerHyperparameterDimension(1L, null, 10L, 20L, NumericalHyperparameterDimension.Scaling.LINEAR, 1L);
        public IntegerHyperparameterDimension num_layers = new IntegerHyperparameterDimension(1L, null, 1L, 4L, NumericalHyperparameterDimension.Scaling.LINEAR, 2L);
        public IntegerHyperparameterDimension num_cells = new IntegerHyperparameterDimension(1L, null, 30L, 50L, NumericalHyperparameterDimension.Scaling.LINEAR, 40L);
        public CategoricalHyperparameterDimension cell_type = new CategoricalHyperparameterDimension().withValue("lstm", true).withValue("gru", false);
        public CategoricalHyperparameterDimension dropoutcell_type = new CategoricalHyperparameterDimension().withValue("ZoneoutCell", true).withValue("RNNZoneoutCell", false).withValue("VariationalDropoutCell", false).withValue("VariationalZoneoutCell", false);
        public FloatHyperparameterDimension dropout_rate = new FloatHyperparameterDimension(FloatHyperparameterDimension.minPositive, 1.0, 0.05, 0.2, NumericalHyperparameterDimension.Scaling.LINEAR, 0.1);
        public FloatHyperparameterDimension alpha = new FloatHyperparameterDimension(0.0, 1.0, 0.0, 0.2, NumericalHyperparameterDimension.Scaling.LINEAR, 0.0);
        public FloatHyperparameterDimension beta = new FloatHyperparameterDimension(0.0, 1.0, 0.0, 0.2, NumericalHyperparameterDimension.Scaling.LINEAR, 0.0);
        public CategoricalHyperparameterDimension distr_output = new CategoricalHyperparameterDimension().withValue("StudentTOutput", true).withValue("GaussianOutput", false).withValue("NegativeBinomialOutput", false);
        public FloatHyperparameterDimension learning_rate = new FloatHyperparameterDimension(FloatHyperparameterDimension.minPositive, null, 1.0E-4, 0.1, NumericalHyperparameterDimension.Scaling.LOGARITHMIC, 0.001);
        public boolean full_context = true;
        public boolean use_timeseries_identifiers_as_features = false;
        public boolean scaling = true;
        public int num_parallel_samples = 100;
        public double minimum_scale = 1.0E-10;
        public int batch_size = 32;
        public int epochs = 10;
        public boolean auto_num_batches_per_epoch = true;
        public int num_batches_per_epoch = 50;
        public int seed = 1337;
    }

    public static class GluonTSMXNetTransformerSpace
    extends HyperparametersSpace {
        public IntegerHyperparameterDimension context_length = new IntegerHyperparameterDimension(1L, null, 10L, 20L, NumericalHyperparameterDimension.Scaling.LINEAR, 1L);
        public IntegerHyperparameterDimension model_dim = new IntegerHyperparameterDimension(1L, null, 16L, 64L, NumericalHyperparameterDimension.Scaling.LINEAR, 32L);
        public IntegerHyperparameterDimension inner_ff_dim_scale = new IntegerHyperparameterDimension(1L, null, 1L, 10L, NumericalHyperparameterDimension.Scaling.LINEAR, 4L);
        public IntegerHyperparameterDimension num_heads = new IntegerHyperparameterDimension(1L, null, 4L, 8L, NumericalHyperparameterDimension.Scaling.LINEAR, 8L);
        public FloatHyperparameterDimension dropout_rate = new FloatHyperparameterDimension(FloatHyperparameterDimension.minPositive, 1.0, 0.05, 0.2, NumericalHyperparameterDimension.Scaling.LINEAR, 0.1);
        public CategoricalHyperparameterDimension distr_output = new CategoricalHyperparameterDimension().withValue("StudentTOutput", true).withValue("GaussianOutput", false).withValue("NegativeBinomialOutput", false);
        public FloatHyperparameterDimension learning_rate = new FloatHyperparameterDimension(FloatHyperparameterDimension.minPositive, null, 1.0E-4, 0.1, NumericalHyperparameterDimension.Scaling.LOGARITHMIC, 0.001);
        public boolean full_context = true;
        public boolean use_timeseries_identifiers_as_features = false;
        public int num_parallel_samples = 100;
        public int batch_size = 32;
        public int epochs = 10;
        public boolean auto_num_batches_per_epoch = true;
        public int num_batches_per_epoch = 50;
        public int seed = 1337;
    }

    public static class GluonTSMXNetMQCNNSpace
    extends HyperparametersSpace {
        public IntegerHyperparameterDimension context_length = new IntegerHyperparameterDimension(1L, null, 10L, 20L, NumericalHyperparameterDimension.Scaling.LINEAR, 1L);
        public FloatHyperparameterDimension learning_rate = new FloatHyperparameterDimension(FloatHyperparameterDimension.minPositive, null, 1.0E-4, 0.1, NumericalHyperparameterDimension.Scaling.LOGARITHMIC, 0.001);
        public boolean full_context = true;
        public boolean use_timeseries_identifiers_as_features = false;
        public List<Long> decoder_mlp_dim_seq = Arrays.asList(30L);
        public List<Long> channels_seq = Arrays.asList(30L, 30L, 30L);
        public List<Long> dilation_seq = Arrays.asList(1L, 3L, 5L);
        public List<Long> kernel_size_seq = Arrays.asList(7L, 3L, 3L);
        public boolean scaling = true;
        public int batch_size = 32;
        public int epochs = 10;
        public boolean auto_num_batches_per_epoch = true;
        public int num_batches_per_epoch = 50;
        public int seed = 1337;
    }

    public static class CausalForestHyperparameterSpace
    extends HyperparametersSpace {
        public IntegerHyperparameterDimension n_estimators = new IntegerHyperparameterDimension(1L, null, 10L, 100L, NumericalHyperparameterDimension.Scaling.LINEAR, 30L, 100L);
        public CategoricalHyperparameterDimension criterion = new CategoricalHyperparameterDimension().withValue("mse", true).withValue("het", false);
        public IntegerHyperparameterDimension max_depth = new IntegerHyperparameterDimension(1L, null, 3L, 8L, NumericalHyperparameterDimension.Scaling.LINEAR, 3L);
        public IntegerHyperparameterDimension min_samples_leaf = new IntegerHyperparameterDimension(1L, null, 2L, 20L, NumericalHyperparameterDimension.Scaling.LINEAR, 5L);
        public TreeSelectionMode selection_mode = TreeSelectionMode.AUTO;
        public IntegerHyperparameterDimension max_features = new IntegerHyperparameterDimension(1L, null, 5L, 20L, NumericalHyperparameterDimension.Scaling.LINEAR, 10L);
        public FloatHyperparameterDimension max_feature_prop = new FloatHyperparameterDimension(FloatHyperparameterDimension.minPositive, 1.0, 0.1, 0.7, NumericalHyperparameterDimension.Scaling.LINEAR, 0.3);
        public boolean honest = true;
        public int n_jobs = 4;
    }

    public static class PropensityModeling {
        public boolean enabled = true;
        public boolean calibrateProbabilities;
        public float calibrationDataRatio = 0.1f;
    }

    public static class GridSearchParams {
        public GridSearchCrossValidationMode mode = GridSearchCrossValidationMode.KFOLD;
        public float splitRatio = 0.8f;
        public int shuffleIterations = 1;
        public int nFolds = 5;
        public int cvSeed = 1337;
        public boolean stratified = true;
        public boolean grouped = false;
        public String groupColumnName;
        public String code;
        public Strategy strategy = Strategy.GRID;
        public BayesianOptimizer bayesianOptimizer = BayesianOptimizer.SCIKIT_OPTIMIZE;
        public boolean randomized = true;
        public int seed = 1337;
        public int nIter = 0;
        public int nIterRandom = 10;
        public int timeout = 0;
        public int nJobs = 4;
        public boolean distributed;
        public int nContainers = 4;
        public boolean foldOffset = true;
        public boolean equalDurationFolds = false;

        public static enum Strategy {
            GRID,
            RANDOM,
            BAYESIAN;

        }

        public static enum BayesianOptimizer {
            SCIKIT_OPTIMIZE;

        }
    }

    public static enum GridSearchCrossValidationMode {
        SHUFFLE,
        KFOLD,
        TIME_SERIES_KFOLD,
        TIME_SERIES_SINGLE_SPLIT,
        CUSTOM;

    }

    public static class CustomPythonPluginParams
    extends ClassicalMLHyperparametersSpace {
        public String pluginId;
        public String pluginVersion;
        public String elementId;
        public String name;
        public JsonObject params = new JsonObject();
        public boolean supportsSampleWeights;
        public boolean acceptsSparseMatrix;

        public CustomPythonPluginParams(PluginDesc pluginDesc, LoadedCustomPythonPredictionAlgoDesc algoDesc) {
            this.pluginId = pluginDesc.id;
            this.pluginVersion = pluginDesc.version;
            this.elementId = algoDesc.id;
            this.name = algoDesc.desc.meta.label;
        }

        @Override
        public String getAlgorithmName() {
            return this.name;
        }
    }

    public static class CustomPythonParams
    extends ClassicalMLHyperparametersSpace {
        public String code;
        public String name = "Custom Python model";

        @Override
        public String getAlgorithmName() {
            return this.name;
        }
    }

    public static class MLLibCustomGridParams {
        public boolean enabled;
        public String initializationCode;
        public String name = "Custom Mllib model";
    }

    public static abstract class ClassicalMLHyperparametersSpace
    extends HyperparametersSpace {
        public boolean isCompatibleWithMonotonicConstraints() {
            return false;
        }

        public abstract String getAlgorithmName();
    }

    public static enum CausalMetaLearner {
        S_LEARNER("S-learner"),
        T_LEARNER("T-learner"),
        X_LEARNER("X-learner");

        public final String displayName;

        private CausalMetaLearner(String name) {
            this.displayName = name;
        }
    }

    public static enum CausalLearningMethod {
        META_LEARNER,
        CAUSAL_FOREST;

    }

    public static enum ProphetSeasonality {
        AUTO("auto"),
        ALWAYS("always"),
        NEVER("never");

        private final String paramName;

        private ProphetSeasonality(String paramName) {
            this.paramName = paramName;
        }

        public String toString() {
            return this.paramName;
        }
    }

    public static enum ProphetGrowth {
        LINEAR("linear"),
        LOGISTIC("logistic"),
        FLAT("flat");

        private final String paramName;

        private ProphetGrowth(String paramName) {
            this.paramName = paramName;
        }

        public String toString() {
            return this.paramName;
        }
    }

    public static enum MLLibRfImpurity {
        gini,
        entropy,
        variance;

    }

    public static enum MLLibRfFeatureSubsetStrategy {
        auto,
        all,
        onethird,
        sqrt,
        log2;

    }

    public static enum LogisticRegressionClassifierMultiClass {
        MULTINOMIAL("multinomial"),
        OVR("ovr");

        private final String name;

        private LogisticRegressionClassifierMultiClass(String s) {
            this.name = s;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum KNNAlgorithm {
        AUTO("auto"),
        KD_TREE("kd_tree"),
        BALL_TREE("ball_tree"),
        BRUTE("brute");

        private final String name;

        private KNNAlgorithm(String s) {
            this.name = s;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class SGDHyperparametersSpace
    extends ClassicalMLHyperparametersSpace {
        public CategoricalHyperparameterDimension loss = new CategoricalHyperparameterDimension();
        public CategoricalHyperparameterDimension penalty = new CategoricalHyperparameterDimension();
        public FloatHyperparameterDimension alpha = new FloatHyperparameterDimension(FloatHyperparameterDimension.minPositive, null, 1.0E-5, 0.001, NumericalHyperparameterDimension.Scaling.LOGARITHMIC, 0.001, 1.0E-4, 1.0E-5);
        public float l1_ratio = 0.15f;
        public int max_iter = 1000;
        public double tol = 0.001;
        public int n_jobs = 2;

        @Override
        public String getAlgorithmName() {
            return "Linear Stochastic Gradient Descent";
        }
    }

    public static enum LassoSelectAlphaMode {
        MANUAL,
        AUTO_CV,
        AUTO_IC;

    }

    public static enum RidgeSelectAlphaMode {
        MANUAL,
        AUTO;

    }

    public static class GradientBoostedTreeHyperparametersSpace
    extends ClassicalMLHyperparametersSpace {
        public IntegerHyperparameterDimension n_estimators = new IntegerHyperparameterDimension(1L, null, 80L, 300L, NumericalHyperparameterDimension.Scaling.LINEAR, 100L);
        public IntegerHyperparameterDimension max_depth = new IntegerHyperparameterDimension(1L, null, 3L, 10L, NumericalHyperparameterDimension.Scaling.LINEAR, 3L);
        public IntegerHyperparameterDimension min_samples_leaf = new IntegerHyperparameterDimension(1L, null, 1L, 20L, NumericalHyperparameterDimension.Scaling.LINEAR, 1L);
        public TreeSelectionMode selection_mode = TreeSelectionMode.SQRT;
        public IntegerHyperparameterDimension max_features = new IntegerHyperparameterDimension(1L, null, 1L, 20L, NumericalHyperparameterDimension.Scaling.LINEAR, 0L);
        public FloatHyperparameterDimension max_feature_prop = new FloatHyperparameterDimension(FloatHyperparameterDimension.minPositive, 1.0, 0.1, 0.7, NumericalHyperparameterDimension.Scaling.LINEAR, 0.3);
        public FloatHyperparameterDimension learning_rate = new FloatHyperparameterDimension(FloatHyperparameterDimension.minPositive, 1.0, 0.05, 0.5, NumericalHyperparameterDimension.Scaling.LINEAR, 0.1);
        public CategoricalHyperparameterDimension loss = new CategoricalHyperparameterDimension();
        public boolean allow_sparse_matrices = true;

        @Override
        public String getAlgorithmName() {
            return "Gradient Boosted Trees";
        }
    }

    public static enum TreeSelectionMode {
        AUTO("auto"),
        SQRT("sqrt"),
        LOG2("log2"),
        NUMBER("number"),
        PROP("prop");

        private final String name;

        private TreeSelectionMode(String s) {
            this.name = s;
        }

        public String toString() {
            return this.name;
        }
    }

    public static abstract class HyperparametersSpace {
        public boolean enabled;
    }
}

