/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.preprocessing;

import com.dataiku.dip.analysis.model.ParameterChecks;
import com.dataiku.dip.analysis.model.preprocessing.TabularPredictionPreprocessingParams;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TimeseriesForecastingPreprocessingParams
extends TabularPredictionPreprocessingParams {
    public TimeseriesSamplingParams timeseriesSampling = new TimeseriesSamplingParams();

    @Override
    public void validate(ParameterChecks checks) {
        super.validate(checks);
        if (!this.timeseriesSampling.numericalInterpolateMethod.isCompatibleWithNumericalInterpolation()) {
            checks.addError("Invalid imputation method", "'" + this.timeseriesSampling.numericalInterpolateMethod.name() + "' imputation method is not available for numerical features interpolation.");
        }
        if (!this.timeseriesSampling.numericalExtrapolateMethod.isCompatibleWithNumericalExtrapolation()) {
            checks.addError("Invalid imputation method", "'" + this.timeseriesSampling.numericalExtrapolateMethod.name() + "' imputation method is not available for numerical features extrapolation.");
        }
        if (!this.timeseriesSampling.categoricalImputeMethod.isCompatibleWithCategorical()) {
            checks.addError("Invalid imputation method", "'" + this.timeseriesSampling.numericalInterpolateMethod.name() + "' imputation method is not available for categorical features.");
        }
    }

    public static class TimeseriesSamplingParams {
        private final transient SimpleDateFormat boundaryDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        TimeseriesImputeMethod numericalInterpolateMethod = TimeseriesImputeMethod.LINEAR;
        TimeseriesImputeMethod numericalExtrapolateMethod = TimeseriesImputeMethod.NO_EXTRAPOLATION;
        Double numericalInterpolateConstantValue;
        Double numericalExtrapolateConstantValue;
        TimeseriesImputeMethod categoricalImputeMethod = TimeseriesImputeMethod.PREVIOUS_NEXT;
        String categoricalConstantValue;
        DuplicateTimestampsHandlingMethod duplicateTimestampsHandlingMethod = DuplicateTimestampsHandlingMethod.FAIL_IF_CONFLICTING;
        BoundaryDateMode startDateMode = BoundaryDateMode.AUTO;
        String customStartDate;
        BoundaryDateMode endDateMode = BoundaryDateMode.AUTO;
        String customEndDate;

        public void setCustomStartDate(Date date) {
            this.customStartDate = this.boundaryDateFormat.format(date);
        }

        public void setCustomEndDate(Date date) {
            this.customEndDate = this.boundaryDateFormat.format(date);
        }

        public static enum TimeseriesImputeMethod {
            NEAREST(true, false, false),
            PREVIOUS(true, false, true),
            NEXT(true, false, true),
            LINEAR(true, true, false),
            QUADRATIC(true, true, false),
            CUBIC(true, true, false),
            CONSTANT(true, true, true),
            STAIRCASE(true, false, false),
            PREVIOUS_NEXT(false, true, true),
            NO_EXTRAPOLATION(false, true, false),
            MOST_COMMON(false, false, true),
            NULL(false, false, true);

            private final boolean numericalInterpolate;
            private final boolean numericalExtrapolate;
            private final boolean categorical;

            private TimeseriesImputeMethod(boolean numericalInterpolate, boolean numericalExtrapolate, boolean categorical) {
                this.numericalInterpolate = numericalInterpolate;
                this.numericalExtrapolate = numericalExtrapolate;
                this.categorical = categorical;
            }

            boolean isCompatibleWithCategorical() {
                return this.categorical;
            }

            boolean isCompatibleWithNumericalExtrapolation() {
                return this.numericalExtrapolate;
            }

            boolean isCompatibleWithNumericalInterpolation() {
                return this.numericalInterpolate;
            }
        }

        public static enum DuplicateTimestampsHandlingMethod {
            FAIL_IF_CONFLICTING,
            DROP_IF_CONFLICTING,
            MEAN_MODE;

        }

        public static enum BoundaryDateMode {
            AUTO,
            CUSTOM;

        }
    }
}

