/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.datamodel.config;

import com.dataiku.dip.apideployer.datamodel.config.AbstractAPIDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.exceptions.IllegalConfigurationException;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.lambda.model.serverconfig.LambdaServerConfig;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractAPIDockerDeploymentInfra
extends AbstractAPIDeploymentInfra {
    public String baseImageTag;
    public ContainerExecUtils.ContainerBaseConfig.DockerPrepushHookMode prePushMode = ContainerExecUtils.ContainerBaseConfig.DockerPrepushHookMode.NONE;
    public String prePushScript;
    private String registryHost;
    private String pullRegistryHost;
    public String imagePullSecretName;
    public String imagesNamePrefix = "dataiku-mad";
    public DockerAPINodeLogging defaultApiNodeLogging = new DockerAPINodeLogging();
    public boolean hideStackTracesAndLogTails;
    public boolean enableDkuHttpRequestVariable;
    public APINodeGraphiteConfig graphiteConfig = new APINodeGraphiteConfig();
    public LambdaServerConfig.APINodeCodeEnvsSettings codeEnvsSettings = new LambdaServerConfig.APINodeCodeEnvsSettings();
    public Map<String, DSSConnection> remappedConnections = new HashMap<String, DSSConnection>();
    public DSSConnection bundledConnection;
    public boolean buildIntermediateImageWithCodeEnvs = false;

    AbstractAPIDockerDeploymentInfra() {
    }

    AbstractAPIDockerDeploymentInfra(String id, String stage, String userIdentifier, AbstractDeploymentInfra.GovernCheckPolicy governCheckPolicy) {
        super(id, stage, userIdentifier, governCheckPolicy);
    }

    @Nullable
    public String getRegistryHost() {
        return this.registryHost;
    }

    public void setRegistryHost(String registryHost) {
        this.registryHost = registryHost;
    }

    @Nullable
    public String getPullRegistryHost() {
        return this.pullRegistryHost;
    }

    public void setPullRegistryHost(String registryHost) {
        this.pullRegistryHost = registryHost;
    }

    @Override
    @Nonnull
    public DockerAPINodeLogging getNodeLogging() {
        return this.defaultApiNodeLogging;
    }

    public String getPrePushScript() {
        return this.prePushScript;
    }

    @Nonnull
    public String getImageAliasInRegistryHost(String imageName, String imageTag) throws IllegalConfigurationException {
        if (StringUtils.isBlank((String)this.getRegistryHost())) {
            throw ErrorContext.ice((String)"The 'Registry host' is not defined in the infrastructure settings.");
        }
        return String.format("%s/%s:%s", this.getRegistryHost(), imageName, imageTag);
    }

    public String getImageAliasInPullRegistryHost(String imageName, String imageTag) throws IllegalConfigurationException {
        String host = StringUtils.defaultIfBlank((String)this.getPullRegistryHost(), (String)this.getRegistryHost());
        if (StringUtils.isBlank((String)host)) {
            throw ErrorContext.ice((String)"Neither the 'Pull registry host' nor 'Registry host' are defined in the infrastructure settings.");
        }
        return String.format("%s/%s:%s", host, imageName, imageTag);
    }

    public static class DockerAPINodeLogging
    extends AbstractAPIDeploymentInfra.APINodeLogging {
        public LambdaServerConfig.AuditLog auditLog = new LambdaServerConfig.AuditLog();
        public boolean redirectToPod = false;
        public String log4jConfiguration;
    }

    public static class APINodeGraphiteConfig {
        public String graphiteCarbonServerURL;
        public String graphiteCarbonCommonPrefix;
        public int graphiteCarbonIntervalMinutes = 2;
    }
}

