/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cli;

import com.dataiku.dip.cli.CLICommand;
import com.dataiku.dip.cli.CLISetup;
import com.dataiku.dip.cli.DKU;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.datasets.twitter.TwitterDatasetConfig;
import com.dataiku.dip.datasets.twitter.TwitterStreamManager;
import com.dataiku.dip.server.services.DKUTransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.google.common.base.Joiner;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class TwitterCommand
extends CLICommand {
    @Override
    public String usageString() {
        return "dku twitter dataset_name connection_name running_time_in_s" + String.format("%n", new Object[0]) + String.format("%n", new Object[0]) + "Warning : Do NOT run several instances at once or your IP could be banned by twitter";
    }

    @Override
    public String description() {
        return "Manage twitter streaming";
    }

    @Override
    public Options opts() {
        Options opts = new Options();
        DKU.addGlobalOptions(opts);
        return opts;
    }

    @Override
    public int execute(String[] args) throws Exception {
        CommandLine cmdLine = this.parseAndMiniSetup(args, "twitter");
        if (cmdLine.getArgs().length < 2) {
            return this.usage(1, "Missing 'dataset_name' argument");
        }
        if (cmdLine.getArgs().length < 3) {
            return this.usage(1, "Missing 'connection_name' argument");
        }
        if (cmdLine.getArgs().length < 4) {
            return this.usage(1, "Missing 'running_time_in_s' argument");
        }
        String datasetName = cmdLine.getArgs()[1];
        String connectionName = cmdLine.getArgs()[2];
        int timeOut = Integer.parseInt(cmdLine.getArgs()[3]);
        CLISetup.doSpringUtilsAndCoreServicesSetupForTestsAndCLI();
        try (DKUTransactionService transactionService = new DKUTransactionService();){
            Dataset dataset;
            try (Transaction ignored = transactionService.beginRead();){
                SerializedDataset sd = (SerializedDataset)CLISetup.getDatasetsDAO().getMandatory(DatasetLocUtils.resolveFull(datasetName));
                dataset = Dataset.fromSerialized(sd);
            }
            if (!dataset.getType().equals("Twitter")) {
                throw ErrorContext.iae((String)"Dataset is not a twitter dataset");
            }
            List<String> keywords = dataset.getParamsAs(TwitterDatasetConfig.class).keywords;
            System.out.println("Keywords filtered in : " + Joiner.on((String)",").join(keywords));
            TwitterStreamManager manager = new TwitterStreamManager();
            manager.registerDataset(dataset);
            manager.setConnection(connectionName);
            manager.startStreaming();
            TimeUnit.SECONDS.sleep(timeOut);
            manager.stopStreaming();
            manager.removeDataset(datasetName);
        }
        return 0;
    }
}

