/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.codestudio.blocks;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.codestudio.CodeStudioMeta;
import com.dataiku.dip.codestudio.blocks.CodeStudioBlock;
import com.dataiku.dip.codestudio.blocks.CodeStudioBlockMeta;
import com.dataiku.dip.codestudio.blocks.CodeStudioBlockParams;
import com.dataiku.dip.codestudio.template.CodeStudioTemplate;
import com.dataiku.dip.codestudio.template.CodeStudioTemplatesService;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AppendDockerfileCodeStudioBlockMeta
implements CodeStudioBlockMeta {
    private static Logger logger = Logger.getLogger((String)"dip.codestudio.block.append");

    @Override
    public String getType() {
        return "append_dockerfile";
    }

    @Override
    public void newTemplateInitialization(CodeStudioBlock block) {
    }

    @Override
    public Class<? extends CodeStudioBlockParams> blockParamsClass() {
        return AppendDockerfileCodeStudioBlockParams.class;
    }

    @Override
    public CodeStudioBlock.CodeStudioBlockType getBlockType() {
        CodeStudioBlock.CodeStudioBlockType ret = new CodeStudioBlock.CodeStudioBlockType();
        ret.type = this.getType();
        ret.label = "Append to Dockerfile";
        ret.description = "Append commands to the Dockerfile";
        ret.icon = "icon-terminal";
        ret.isUnique = false;
        ret.isLocked = false;
        ret.isAdvanced = true;
        ret.uiDisplayPriority = 1020;
        return ret;
    }

    @Override
    public CodeStudioMeta.ImageBuildSpec apply(AuthCtx authCtx, CodeStudioBlock block, CodeStudioMeta.ImageBuildSpec buildSpec, CodeStudioMeta.ImageBuildEnv buildEnv, CodeStudioTemplate template) throws IOException {
        AppendDockerfileCodeStudioBlockParams params = block.getParamsAs(AppendDockerfileCodeStudioBlockParams.class);
        Object dockerfile = StringUtils.defaultIfBlank((String)buildSpec.dockerfile, (String)"");
        dockerfile = (String)dockerfile + "\n\n##### APPEND TO DOCKERFILE " + StringUtils.defaultIfBlank((String)params.label, (String)"") + " #####";
        if (params.runAsRoot) {
            dockerfile = (String)dockerfile + "\n\nUSER root\nWORKDIR /opt/dataiku\n";
        }
        dockerfile = (String)dockerfile + "\n\n" + StringUtils.defaultIfBlank((String)params.dockerfile, (String)"");
        if (params.runAsRoot) {
            String uid = DKUApp.getParams().getParam("dku.container.dataiku.uid", "500");
            dockerfile = (String)dockerfile + "\n\nUSER " + uid + "\nWORKDIR /home/dataiku\n";
        }
        buildSpec.dockerfile = dockerfile;
        VariablesContext templateVariablesContext = CodeStudioTemplatesService.getTemplateVariablesContext(template.id);
        for (SimpleKeyValue copy : params.resources) {
            File from = CodeStudioTemplatesService.getReadableFileOrThrow(copy.key, templateVariablesContext, "Append to Dockerfile resource");
            String toPath = copy.value;
            File to = new File(buildEnv.buildDir, toPath);
            if (toPath.endsWith("/")) {
                to = new File(to, from.getName());
            }
            logger.info((Object)("Copying " + from.getAbsolutePath() + " to " + to.getAbsolutePath()));
            if (from.isDirectory()) {
                DKUFileUtils.copyDirectory((File)from, (File)to);
            } else {
                FileUtils.copyFile((File)from, (File)to);
            }
            if (to.setExecutable(from.canExecute())) continue;
            logger.warn((Object)("Cannot set execute permission on" + to.getName()));
        }
        return buildSpec;
    }

    @Override
    public CodeStudioMeta.CodeStudioLaunchSpec apply(AuthCtx authCtx, CodeStudioBlock block, CodeStudioMeta.CodeStudioLaunchSpec launchSpec, CodeStudioMeta.CodeStudioLaunchEnv launchEnv) {
        return launchSpec;
    }

    @Override
    public CodeStudioMeta.TemplateExportSpec exportBlock(AuthCtx authCtx, CodeStudioBlock block, CodeStudioMeta.TemplateExportSpec exportSpec) {
        AppendDockerfileCodeStudioBlockParams params = block.getParamsAs(AppendDockerfileCodeStudioBlockParams.class);
        for (SimpleKeyValue resource : params.resources) {
            if (CodeStudioTemplatesService.isInTemplateResourcesDir(resource.key)) continue;
            CodeStudioMeta.TemplateExportResource exportResource = new CodeStudioMeta.TemplateExportResource();
            exportResource.localPath = resource.key;
            exportSpec.resourcesMap.put(resource.key, exportResource);
        }
        return exportSpec;
    }

    @Override
    public CodeStudioBlock importBlock(AuthCtx authCtx, CodeStudioBlock srcBlock, CodeStudioMeta.TemplateExportSpec exportSpec, CodeStudioMeta.TemplateImportSpec importSpec) {
        CodeStudioBlock block = (CodeStudioBlock)JSON.deepCopy((Object)srcBlock);
        AppendDockerfileCodeStudioBlockParams params = block.getParamsAs(AppendDockerfileCodeStudioBlockParams.class);
        for (SimpleKeyValue resource : params.resources) {
            if (CodeStudioTemplatesService.isInTemplateResourcesDir(resource.key)) continue;
            CodeStudioMeta.TemplateExportResource exportResource = exportSpec.resourcesMap.get(resource.key);
            if (exportResource == null) {
                throw new IllegalArgumentException("Resource missing from export " + resource.key);
            }
            resource.key = exportResource.localPath;
        }
        return block;
    }

    @Override
    public CodeStudioMeta.CreationSpec apply(AuthCtx authCtx, CodeStudioBlock block, CodeStudioMeta.CreationSpec creationSpec, CodeStudioMeta.CreationEnv creationEnv) throws IOException, DKUSecurityException {
        return creationSpec;
    }

    @Override
    public List<CodeEnvModel.CodeEnvUsage> collectUsages(CodeStudioBlock block, CodeStudioTemplate template) {
        return Lists.newArrayList();
    }

    public static class AppendDockerfileCodeStudioBlockParams
    implements CodeStudioBlockParams {
        public String dockerfile;
        public String label;
        public boolean runAsRoot;
        public List<SimpleKeyValue> resources = Lists.newArrayList();

        @Override
        public void checkValid(VariablesContext templateVariablesContext) throws Exception {
            for (SimpleKeyValue file : this.resources) {
                if (StringUtils.isBlank((String)file.key)) {
                    throw ErrorContext.ice((String)"Resource source file cannot be empty");
                }
                if (StringUtils.isBlank((String)file.value)) {
                    throw ErrorContext.ice((String)"Resource target file cannot be empty");
                }
                CodeStudioTemplatesService.getReadableFileOrThrow(file.key, templateVariablesContext, "Append to Dockerfile resource");
            }
        }
    }
}

