/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.codestudio.blocks;

import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.codestudio.CodeStudioMeta;
import com.dataiku.dip.codestudio.blocks.CodeStudioBlock;
import com.dataiku.dip.codestudio.blocks.CodeStudioBlockMeta;
import com.dataiku.dip.codestudio.blocks.CodeStudioBlockParams;
import com.dataiku.dip.codestudio.template.CodeStudioTemplate;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.variables.VariablesContext;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SimpleDeploymentCodeStudioBlockMeta
implements CodeStudioBlockMeta {
    @Override
    public String getType() {
        return "simple_deployment";
    }

    @Override
    public void newTemplateInitialization(CodeStudioBlock block) {
    }

    @Override
    public Class<? extends CodeStudioBlockParams> blockParamsClass() {
        return SimpleDeploymentCodeStudioBlockParams.class;
    }

    @Override
    public CodeStudioBlock.CodeStudioBlockType getBlockType() {
        CodeStudioBlock.CodeStudioBlockType ret = new CodeStudioBlock.CodeStudioBlockType();
        ret.type = this.getType();
        ret.label = "Kubernetes Parameters";
        ret.description = "Run Code Studio as a deployment with basic DSS annotations";
        ret.isLocked = true;
        ret.isUnique = true;
        ret.isAdvanced = false;
        ret.uiDisplayPriority = 1;
        return ret;
    }

    @Override
    public CodeStudioMeta.ImageBuildSpec apply(AuthCtx authCtx, CodeStudioBlock block, CodeStudioMeta.ImageBuildSpec buildSpec, CodeStudioMeta.ImageBuildEnv buildEnv, CodeStudioTemplate template) throws IOException {
        return buildSpec;
    }

    @Override
    public CodeStudioMeta.CodeStudioLaunchSpec apply(AuthCtx authCtx, CodeStudioBlock block, CodeStudioMeta.CodeStudioLaunchSpec launchSpec, CodeStudioMeta.CodeStudioLaunchEnv launchEnv) {
        SimpleDeploymentCodeStudioBlockParams params = block.getParamsAs(SimpleDeploymentCodeStudioBlockParams.class);
        launchSpec.exposedPorts.addAll(params.exposedPorts);
        launchSpec.exposedServices.addAll(params.exposedServices);
        launchSpec.readinessProbeUrl = params.readinessProbeUrl;
        launchSpec.readinessProbeHeaders = params.readinessProbeHeaders;
        launchSpec.useTcpReadiness = params.useTcpReadiness;
        launchSpec.initialSyncTimeoutInMinutes = params.initialSyncTimeoutInMinutes;
        launchSpec.k8sHeadObjectName = "dataiku-kub-" + launchEnv.executionId;
        launchSpec.selector = Lists.newArrayList((Object[])new String[]{"dataiku.com/dku-execution-id: " + launchEnv.executionId, "dataiku.com/dku-role: main"});
        for (SimpleKeyValue kv : params.annotations) {
            if (!StringUtils.isNotBlank((String)kv.key)) continue;
            launchSpec.extraAnnotations.put(kv.key, kv.value);
        }
        for (SimpleKeyValue kv : params.labels) {
            launchSpec.extraLabels.put(kv.key, kv.value);
        }
        return launchSpec;
    }

    @Override
    public CodeStudioMeta.TemplateExportSpec exportBlock(AuthCtx authCtx, CodeStudioBlock block, CodeStudioMeta.TemplateExportSpec exportSpec) {
        return exportSpec;
    }

    @Override
    public CodeStudioBlock importBlock(AuthCtx authCtx, CodeStudioBlock srcBlock, CodeStudioMeta.TemplateExportSpec exportSpec, CodeStudioMeta.TemplateImportSpec importSpec) {
        return srcBlock;
    }

    @Override
    public CodeStudioMeta.CreationSpec apply(AuthCtx authCtx, CodeStudioBlock block, CodeStudioMeta.CreationSpec creationSpec, CodeStudioMeta.CreationEnv creationEnv) throws IOException, DKUSecurityException {
        return creationSpec;
    }

    @Override
    public List<CodeEnvModel.CodeEnvUsage> collectUsages(CodeStudioBlock block, CodeStudioTemplate template) {
        return Lists.newArrayList();
    }

    public static class SimpleDeploymentCodeStudioBlockParams
    implements CodeStudioBlockParams {
        public List<CodeStudioMeta.ExposedCodeStudioPort> exposedPorts = Lists.newArrayList();
        public List<CodeStudioMeta.ExposedCodeStudioService> exposedServices = Lists.newArrayList();
        public String readinessProbeUrl;
        public List<SimpleKeyValue> readinessProbeHeaders = Lists.newArrayList();
        public List<SimpleKeyValue> annotations = Lists.newArrayList();
        public List<SimpleKeyValue> labels = Lists.newArrayList();
        public boolean useTcpReadiness = true;
        public Integer initialSyncTimeoutInMinutes = 10;

        @Override
        public void checkValid(VariablesContext templateVariablesContext) throws Exception {
            if (this.exposedPorts.stream().anyMatch(e -> e.port == 0 || e.port > 65535)) {
                throw ErrorContext.ice((String)"Kubernetes exposed ports must be between 1 and 65535.");
            }
            if (this.exposedPorts.stream().anyMatch(e -> StringUtils.isBlank((String)e.label))) {
                throw ErrorContext.ice((String)"Kubernetes exposed ports label must not be empty.");
            }
        }
    }
}

