/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dashboards.export.execution;

import com.dataiku.dip.dashboards.export.execution.DashboardEnrichedExport;
import com.dataiku.dip.dashboards.model.Dashboard;
import com.dataiku.dip.dashboards.model.DashboardPage;
import com.dataiku.dip.export.ZipUnzipDir;
import com.dataiku.dip.graphicsexport.execution.AlphanumComparator;
import com.dataiku.dip.graphicsexport.execution.GraphicsExportUtils;
import com.dataiku.dip.graphicsexport.execution.PdfMerger;
import com.dataiku.dip.graphicsexport.model.ExportFormat;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.io.PatternFilenameFilter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class DashboardExportPostProcessor {
    private static final Pattern SLIDE_FILENAME_PATTERN = Pattern.compile("Slide-(?<slideIndex>\\d+)(_Part-(?<partIndex>\\d+))?\\.\\w+");
    private static final int MAX_FILENAME_LENGTH = 100;
    private final DashboardEnrichedExport export;
    private final File finalDirectory;
    private final File rawExportDirectory;
    private final File postProcessDirectory;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.dashboards.export");

    public DashboardExportPostProcessor(DashboardEnrichedExport export, File rawExportDirectory, File postProcessDirectory, File finalDirectory) {
        this.export = export;
        this.rawExportDirectory = rawExportDirectory;
        this.postProcessDirectory = postProcessDirectory;
        this.finalDirectory = finalDirectory;
    }

    public File execute() throws Exception {
        if (ExportFormat.FileType.PDF.equals((Object)this.export.format.fileType)) {
            return this.postProcessPdfs();
        }
        return this.postProcessImages();
    }

    private File postProcessPdfs() throws IOException {
        File finalFile;
        ArrayList<File> postProcessedFiles = new ArrayList<File>();
        for (DashboardEnrichedExport.EnrichedDashboardExportTarget dashboardExportItem : this.export.dashboards) {
            ArrayList<PdfMerger.PdfSource> sourcePdfs = new ArrayList<PdfMerger.PdfSource>();
            for (File file : DashboardExportPostProcessor.listSlides(new File(this.rawExportDirectory, dashboardExportItem.dashboardId))) {
                sourcePdfs.add(new PdfMerger.PdfSource(file, this.getDashboardBackgroundColor(dashboardExportItem, file)));
            }
            Collections.sort(sourcePdfs, new AlphanumPdfSourceComparator());
            logger.debug((Object)("Processing " + sourcePdfs.size() + " pages"));
            File mergedPdfFile = DashboardExportPostProcessor.newUniqueFile(this.postProcessDirectory, DashboardExportPostProcessor.filenameForDashboard(dashboardExportItem) + ".pdf");
            new PdfMerger().merge(sourcePdfs, mergedPdfFile);
            postProcessedFiles.add(mergedPdfFile);
        }
        if (postProcessedFiles.size() > 1) {
            finalFile = new File(this.finalDirectory, DashboardExportPostProcessor.filenameForMultipleExportZip(this.export.projectKey) + ".zip");
            ZipUnzipDir.zipDirectory(this.postProcessDirectory, finalFile);
        } else {
            File singleFile = (File)postProcessedFiles.get(0);
            finalFile = new File(this.finalDirectory, singleFile.getName());
            DashboardExportPostProcessor.move(singleFile, finalFile);
        }
        return finalFile;
    }

    private File postProcessImages() throws IOException {
        File finalFile;
        if (this.export.dashboards.size() == 1) {
            DashboardEnrichedExport.EnrichedDashboardExportTarget dashboardExportItem = this.export.dashboards.get(0);
            File rawDashboardDirectory = new File(this.rawExportDirectory, dashboardExportItem.dashboardId);
            List<File> rawDashboardFiles = DashboardExportPostProcessor.listSlides(rawDashboardDirectory);
            if (rawDashboardFiles.size() == 1) {
                File dashboardFile = rawDashboardFiles.get(0);
                String extension = GraphicsExportUtils.getFileExtension(dashboardFile.getName());
                finalFile = new File(this.finalDirectory, DashboardExportPostProcessor.filenameForDashboard(dashboardExportItem) + extension);
                DashboardExportPostProcessor.move(dashboardFile, finalFile);
            } else {
                File postProcessDashboardDirectory = DashboardExportPostProcessor.createIfMissing(new File(this.postProcessDirectory, DashboardExportPostProcessor.filenameForDashboard(dashboardExportItem)));
                for (File slideFile : DashboardExportPostProcessor.listSlides(new File(this.rawExportDirectory, dashboardExportItem.dashboardId))) {
                    DashboardExportPostProcessor.move(slideFile, DashboardExportPostProcessor.newUniqueFile(postProcessDashboardDirectory, this.fileNameForSlide(dashboardExportItem, slideFile.getName())));
                }
                finalFile = new File(this.finalDirectory, DashboardExportPostProcessor.filenameForDashboard(dashboardExportItem) + ".zip");
                ZipUnzipDir.zipDirectory(postProcessDashboardDirectory, finalFile);
            }
        } else {
            for (DashboardEnrichedExport.EnrichedDashboardExportTarget dashboardExportItem : this.export.dashboards) {
                File postProcessDashboardDirectory = DashboardExportPostProcessor.createIfMissing(DashboardExportPostProcessor.newUniqueFile(this.postProcessDirectory, DashboardExportPostProcessor.filenameForDashboard(dashboardExportItem)));
                for (File slideFile : DashboardExportPostProcessor.listSlides(new File(this.rawExportDirectory, dashboardExportItem.dashboardId))) {
                    DashboardExportPostProcessor.move(slideFile, new File(postProcessDashboardDirectory, this.fileNameForSlide(dashboardExportItem, slideFile.getName())));
                }
            }
            finalFile = new File(this.finalDirectory, DashboardExportPostProcessor.filenameForMultipleExportZip(this.export.projectKey) + ".zip");
            ZipUnzipDir.zipDirectory(this.postProcessDirectory, finalFile);
        }
        return finalFile;
    }

    private String fileNameForSlide(DashboardEnrichedExport.EnrichedDashboardExportTarget dashboardExportItem, String originalFileName) {
        int slideIndex = DashboardExportPostProcessor.getSlideIndex(originalFileName);
        if (slideIndex >= 0 && slideIndex < dashboardExportItem.dashboard.pages.size()) {
            DashboardPage dashboardPage = dashboardExportItem.dashboard.pages.get(slideIndex);
            if (!StringUtils.isBlank((String)dashboardPage.title)) {
                Integer partIndex = DashboardExportPostProcessor.getPartIndex(originalFileName);
                String partNumber = partIndex == null ? "" : "_Part-" + (partIndex + 1);
                String pageName = GraphicsExportUtils.sanitize(dashboardPage.title);
                if (pageName.length() + partNumber.length() > 100) {
                    pageName = pageName.substring(0, 100 - partNumber.length());
                }
                return pageName + partNumber + GraphicsExportUtils.getFileExtension(originalFileName);
            }
        }
        return originalFileName;
    }

    private String getDashboardBackgroundColor(DashboardEnrichedExport.EnrichedDashboardExportTarget target, File file) {
        Dashboard dashboard = target.dashboard;
        int slideIndex = DashboardExportPostProcessor.getSlideIndex(file.getName());
        if (dashboard == null || dashboard.pages == null || slideIndex < 0 || slideIndex >= dashboard.pages.size()) {
            logger.warn((Object)("Cannot retrieve background color of dashboard " + this.export.projectKey + "." + target.dashboardId + "."));
            return null;
        }
        return dashboard.pages.get((int)slideIndex).backgroundColor;
    }

    private static int getSlideIndex(String fileName) {
        Matcher matcher = SLIDE_FILENAME_PATTERN.matcher(fileName);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid slide filename: " + fileName);
        }
        return Integer.parseInt(matcher.group("slideIndex")) - 1;
    }

    private static Integer getPartIndex(String fileName) {
        Matcher matcher = SLIDE_FILENAME_PATTERN.matcher(fileName);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid slide filename: " + fileName);
        }
        String strPartIndex = matcher.group("partIndex");
        if (strPartIndex == null) {
            return null;
        }
        return Integer.parseInt(strPartIndex) - 1;
    }

    private static List<File> listSlides(File dashboardDirectory) {
        return GraphicsExportUtils.listFiles(dashboardDirectory, (FilenameFilter)new PatternFilenameFilter(SLIDE_FILENAME_PATTERN));
    }

    private static File newUniqueFile(File parent, String child) {
        return GraphicsExportUtils.makeUniqueFile(new File(parent, child));
    }

    private static File createIfMissing(File directory) throws IOException {
        if (!directory.exists() && !directory.mkdirs()) {
            throw new IOException("Unable to create directory " + String.valueOf(directory));
        }
        return directory;
    }

    private static void move(File srcFile, File destFile) throws IOException {
        Files.move(srcFile.toPath(), destFile.toPath(), StandardCopyOption.ATOMIC_MOVE);
    }

    private static String filenameForDashboard(DashboardEnrichedExport.EnrichedDashboardExportTarget dashboardExportItem) {
        String result = GraphicsExportUtils.sanitize(dashboardExportItem.dashboard.name);
        if (result.length() > 100) {
            result = result.substring(0, 100);
        }
        return result;
    }

    private static String filenameForMultipleExportZip(String projectKey) {
        return GraphicsExportUtils.sanitize(projectKey) + "-multiple-dashboards-export";
    }

    private static class AlphanumPdfSourceComparator
    implements Comparator<PdfMerger.PdfSource> {
        private AlphanumComparator alphanumComparator = new AlphanumComparator();

        private AlphanumPdfSourceComparator() {
        }

        @Override
        public int compare(PdfMerger.PdfSource o1, PdfMerger.PdfSource o2) {
            return this.alphanumComparator.compare(o1.file.getName(), o2.file.getName());
        }
    }
}

