/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datacatalog;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.InterestsInternalDB;
import com.dataiku.dip.datacollections.DataCollection;
import com.dataiku.dip.dataquality.DataQualityDailyStatus;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.datasets.dynamic.VariablesExpansionLoopConfig;
import com.dataiku.dip.featurestore.Usages;
import com.dataiku.dip.partitioning.DimensionType;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.datasets.DatasetMetricsStatusService;
import com.dataiku.dip.server.services.ExposedObjectsService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils;
import com.dataiku.j2ts.annotations.UIModel;
import com.dataiku.j2ts.annotations.UINullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class UIDataCatalog {

    public static class DiscoverableDatasetDetails
    extends AbstractDatasetDetails {
        private DiscoverableDatasetDetails() {
        }

        public DiscoverableDatasetDetails(SerializedProject project, SerializedDataset dataset, ExposedObjectsService.ObjectAuthorizations objectAuthorizations, PublicUser dataSteward, PublicUser defaultDataSteward, DataQualityDailyStatus dataQualityStatus, List<DataCollection> dataCollections, int totalDataCollectionCount) {
            super(project, dataset, objectAuthorizations, dataSteward, defaultDataSteward, dataQualityStatus, dataCollections, totalDataCollectionCount);
        }
    }

    public static class DatasetDetails
    extends AbstractDatasetDetails {
        public InterestsInternalDB.Interest interest;
        public boolean canExportData;
        public boolean isFeatureGroup;
        public Map<ITaggingService.TaggableType, List<TaggableObjectsService.TaggableObjectRefWithName>> splitInputsByType;
        public Map<ITaggingService.TaggableType, List<TaggableObjectsService.TaggableObjectRefWithName>> splitOutputsByType;
        public Usages usages;
        public long creationDate;
        public long lastModificationDate;
        public DatasetMetricsStatusService.DatasetSummaryStatus status;
        public Schema schema;
        public List<DetailsDimension> partitioningDimensions;
        public long lastBuiltOn;
        public PublicUser createdBy;
        public PublicUser lastModifiedBy;

        private DatasetDetails() {
        }

        public DatasetDetails(SerializedProject project, SerializedDataset dataset, ExposedObjectsService.ObjectAuthorizations objectAuthorizations, PublicUser dataSteward, PublicUser defaultDataSteward, InterestsInternalDB.Interest interest, boolean canExportData, DatasetMetricsStatusService.DatasetSummaryStatus status, Usages usages, List<DetailsDimension> partitioningDimensions, long lastBuiltOn, DataQualityDailyStatus dataQualityStatus, List<DataCollection> dataCollections, int totalDataCollectionCount) {
            super(project, dataset, objectAuthorizations, dataSteward, defaultDataSteward, dataQualityStatus, dataCollections, totalDataCollectionCount);
            this.interest = interest;
            this.canExportData = canExportData;
            this.isFeatureGroup = dataset.featureGroup;
            this.status = status;
            this.splitOutputsByType = new HashMap<ITaggingService.TaggableType, List<TaggableObjectsService.TaggableObjectRefWithName>>();
            this.splitInputsByType = new HashMap<ITaggingService.TaggableType, List<TaggableObjectsService.TaggableObjectRefWithName>>();
            this.usages = usages;
            this.lastModificationDate = dataset.versionTag == null ? -1L : dataset.versionTag.getLastModifiedOn();
            this.creationDate = dataset.creationTag == null ? -1L : dataset.creationTag.getLastModifiedOn();
            this.schema = dataset.getSchema();
            this.partitioningDimensions = partitioningDimensions;
            this.lastBuiltOn = lastBuiltOn;
            this.createdBy = null;
            this.lastModifiedBy = null;
        }
    }

    public static abstract class AbstractDatasetDetails
    extends AbstractDataCatalogItemDetails {
        public String name;
        public String datasetType;
        public boolean isPartitioned;
        public boolean isRepeating;
        public String sourceProjectKey;
        public String sourceProjectName;
        public ExposedObjectsService.ObjectAuthorizations objectAuthorizations;
        public List<String> tags;
        public String shortDesc;
        public String description;
        @UINullable
        public PublicUser dataSteward;
        @UINullable
        public PublicUser defaultDataSteward;
        public DataQualityDailyStatus dataQualityStatus;
        public List<TaggableObjectsService.TaggableObjectRefWithName> dataCollections;
        public int totalDataCollectionCount;

        private AbstractDatasetDetails() {
        }

        protected AbstractDatasetDetails(SerializedProject project, SerializedDataset dataset, ExposedObjectsService.ObjectAuthorizations objectAuthorizations, PublicUser dataSteward, PublicUser defaultDataSteward, DataQualityDailyStatus dataQualityStatus, List<DataCollection> dataCollections, int totalDataCollectionCount) {
            this.name = dataset.name;
            this.datasetType = dataset.type;
            this.isPartitioned = dataset.isPartitioned();
            VariablesExpansionLoopConfig veLoopConfig = DatasetUtils.getDatasetVeLoopConfig(dataset.getParams());
            if (veLoopConfig != null) {
                this.isRepeating = veLoopConfig.isEnabled();
            }
            this.sourceProjectKey = project.getProjectKey();
            this.sourceProjectName = project.getDisplayName();
            this.objectAuthorizations = objectAuthorizations;
            this.shortDesc = (String)StringUtils.defaultIfBlank((CharSequence)dataset.shortDesc, (CharSequence)"");
            this.description = (String)StringUtils.defaultIfBlank((CharSequence)dataset.description, (CharSequence)"");
            this.tags = dataset.tags;
            this.dataSteward = dataSteward;
            this.defaultDataSteward = defaultDataSteward;
            this.dataQualityStatus = dataQualityStatus;
            this.dataCollections = dataCollections.stream().map(dataCollection -> new TaggableObjectsService.TaggableObjectRefWithName(dataCollection.getRef(), dataCollection.displayName)).collect(Collectors.toList());
            this.totalDataCollectionCount = totalDataCollectionCount;
        }
    }

    @PolyJSON(value={@Mapping(value=DatasetDetails.class, type="DATASET"), @Mapping(value=DiscoverableDatasetDetails.class, type="DISCOVERABLE-DATASET")})
    @UIModel
    public static abstract class AbstractDataCatalogItemDetails {
    }

    @UIModel
    public static class DetailsDimension {
        public final String name;
        public final DimensionType type;

        public DetailsDimension(String name, DimensionType type) {
            this.name = name;
            this.type = type;
        }
    }
}

