/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec;

import com.dataiku.common.server.APIError;
import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.ClusterSettings;
import com.dataiku.dip.cluster.HadoopSettings;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvResolutionService;
import com.dataiku.dip.containers.exec.KubernetesExecUtils;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.common.CodeBasedThingHelper;
import com.dataiku.dip.dataflow.common.JobProcessExecution;
import com.dataiku.dip.dataflow.exec.AbstractCodeBasedRecipeRunner;
import com.dataiku.dip.dataflow.exec.EnvironmentStash;
import com.dataiku.dip.dataflow.exec.JobExecutionResultHandler;
import com.dataiku.dip.dataflow.exec.SparkExecutionEnginesHelper;
import com.dataiku.dip.dataflow.exec.SparkJobExecutionResultHandler;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.dataflow.pipeline.SparkPipelineRunnableSubgraph;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.logging.SparkLoggingConfigurator;
import com.dataiku.dip.recipes.AbstractSparkRecipeParams;
import com.dataiku.dip.recipes.code.spark.SparkBasedActivityHelper;
import com.dataiku.dip.recipes.code.spark.SparkConfigEnricher;
import com.dataiku.dip.recipes.code.sparksql.SparkK8SDriverLogParser;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.FilesystemACLHandler;
import com.dataiku.dip.security.impersonation.IImpersonationResolverService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.recipes.ServiceUtils;
import com.dataiku.dip.spark.SparkCodes;
import com.dataiku.dip.spark.SparkErrorParser;
import com.dataiku.dip.spark.SparkExecutionConfig;
import com.dataiku.dip.spark.SparkJobHelper;
import com.dataiku.dip.spark.submit.SparkSubmitHelper;
import com.dataiku.dip.spark.submit.SparkSubmitJob;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractSparkBasedRecipeRunner
extends AbstractCodeBasedRecipeRunner {
    private final JobActivity originalActivity;
    private SparkExecutionEnginesHelper trHelper;
    private SparkJobHelper.SparkJobContext context;
    private final CodeEnvResolutionService codeEnvResolutionService;
    @Autowired
    private IImpersonationResolverService impersonationService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.spark.base");

    public AbstractSparkBasedRecipeRunner(JobActivity activity) {
        super(AbstractSparkBasedRecipeRunner.getActivityToUse(activity));
        this.originalActivity = activity;
        this.codeEnvResolutionService = (CodeEnvResolutionService)SpringUtils.getBean(CodeEnvResolutionService.class);
    }

    private static JobActivity getActivityToUse(JobActivity activity) {
        if (activity.getSubgraph() instanceof SparkPipelineRunnableSubgraph) {
            SparkPipelineRunnableSubgraph subgraph = (SparkPipelineRunnableSubgraph)activity.getSubgraph();
            return subgraph.getRoot();
        }
        return activity;
    }

    @Override
    protected JobExecutionResultHandler getExecutionResultHandler() {
        return new SparkJobExecutionResultHandler(this.context){

            @Override
            protected void enrichErrorFile(String languageInfo, SerializedError err) {
                logger.info((Object)("Trying to enrich " + languageInfo + " error"));
                SparkErrorParser.enrichError(languageInfo.toLowerCase(), err);
            }
        };
    }

    protected void runSpark(String languageInfo, AbstractSparkRecipeParams.SparkExecutionEngine executionEngine, SparkExecutionEnginesHelper.SparkRecipeJobBuilder jobBuilder, GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType) throws Exception {
        this.runSpark(languageInfo, executionEngine, jobBuilder, null, cgrouppableProcessType);
    }

    protected void runPySpark(String languageInfo, String envName, AbstractSparkRecipeParams.SparkExecutionEngine executionEngine, SparkExecutionEnginesHelper.SparkRecipeJobBuilder jobBuilder, GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType) throws Exception {
        this.runPySpark(languageInfo, envName, executionEngine, jobBuilder, null, cgrouppableProcessType);
    }

    protected void runSparkR(String languageInfo, String envName, AbstractSparkRecipeParams.SparkExecutionEngine executionEngine, SparkExecutionEnginesHelper.SparkRecipeJobBuilder jobBuilder, GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType) throws Exception {
        this.runSparkR(languageInfo, envName, executionEngine, jobBuilder, null, cgrouppableProcessType);
    }

    protected void runSpark(String languageInfo, AbstractSparkRecipeParams.SparkExecutionEngine executionEngine, SparkExecutionEnginesHelper.SparkRecipeJobBuilder jobBuilder, SparkJobHelper.SparkJobPostProcessor postProcessor, GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType) throws Exception {
        this.doRunSpark(SparkJobHelper.RunMode.SPARK, languageInfo, null, executionEngine, jobBuilder, postProcessor, cgrouppableProcessType);
    }

    protected void runPySpark(String languageInfo, String envName, AbstractSparkRecipeParams.SparkExecutionEngine executionEngine, SparkExecutionEnginesHelper.SparkRecipeJobBuilder jobBuilder, SparkJobHelper.SparkJobPostProcessor postProcessor, GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType) throws Exception {
        this.warnDeprecatedPythonInterpreterVersion(new CodeEnvModel.UsedCodeEnvRef(CodeEnvModel.EnvLang.PYTHON, envName));
        this.doRunSpark(SparkJobHelper.RunMode.PYSPARK, languageInfo, envName, executionEngine, jobBuilder, postProcessor, cgrouppableProcessType);
    }

    protected void runSparkR(String languageInfo, String envName, AbstractSparkRecipeParams.SparkExecutionEngine executionEngine, SparkExecutionEnginesHelper.SparkRecipeJobBuilder jobBuilder, SparkJobHelper.SparkJobPostProcessor postProcessor, GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType) throws Exception {
        this.doRunSpark(SparkJobHelper.RunMode.SPARKR, languageInfo, envName, executionEngine, jobBuilder, postProcessor, cgrouppableProcessType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doRunSpark(SparkJobHelper.RunMode runMode, String languageInfo, String envName, AbstractSparkRecipeParams.SparkExecutionEngine executionEngine, SparkExecutionEnginesHelper.SparkRecipeJobBuilder jobBuilder, SparkJobHelper.SparkJobPostProcessor postProcessor, GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType) throws Exception {
        ClusterSettings clusterSettings = new ClusterSelector().selectForProject(this.authCtxService.getAuthCtx(), this.recipe.getProjectKey());
        HadoopSettings hadoopSettings = clusterSettings.getHadoopSettings();
        SparkSettings sparkSettings = clusterSettings.getSparkSettings();
        List<SimpleKeyValue> conf = SparkJobHelper.composeConf(this.authCtxService.getAuthCtx(), this.recipe.getProjectKey(), sparkSettings, jobBuilder.getRecipeOverrideConf(), jobBuilder.getContextOverrideConf());
        SparkBasedActivityHelper helper = new SparkBasedActivityHelper(this.recipe.getProjectKey(), this.authCtxService.getAuthCtx(), (File)FlowJobUtils.getTmpFolder("sparkbased-recipe", "out"), null);
        helper.configure(this.recipe.getProjectKey(), this.originalActivity, conf);
        new SparkConfigEnricher().setMetastoreConfKeysInKeys(conf);
        this.trHelper = new SparkExecutionEnginesHelper(this.projectKey);
        EnvironmentStash stash = this.prepareEnvStash(helper.getProcessRunDir(), helper.getProcessExtraEnv(), null, envName);
        try {
            switch (executionEngine) {
                case SPARK_SUBMIT: {
                    this.runUsingSparkSubmit(runMode, languageInfo, envName, jobBuilder, postProcessor, hadoopSettings, sparkSettings, conf, helper, cgrouppableProcessType, stash);
                    return;
                }
                default: {
                    throw new Error("Unsupported execution engine:" + String.valueOf((Object)executionEngine));
                }
            }
        }
        finally {
            helper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runUsingSparkSubmit(SparkJobHelper.RunMode runMode, String languageInfo, String envName, SparkExecutionEnginesHelper.SparkRecipeJobBuilder jobBuilder, SparkJobHelper.SparkJobPostProcessor postProcessor, HadoopSettings hadoopSettings, SparkSettings sparkSettings, List<SimpleKeyValue> conf, SparkBasedActivityHelper helper, GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType, EnvironmentStash stash) throws Exception {
        SparkExecutionConfig usedExecutionConfig = sparkSettings.getByName(jobBuilder.getRecipeOverrideConf().inheritConf);
        SparkSubmitHelper sparkSubmitHelper = SparkSubmitHelper.build(this.projectKey, this.authCtxService.getAuthCtx(), sparkSettings, hadoopSettings, null, usedExecutionConfig);
        sparkSubmitHelper.failIfUnsupportedSpark();
        SparkSubmitJob job = jobBuilder.buildSparkJob(sparkSubmitHelper, helper.getProcessRunDir(), sparkSettings, conf);
        ComputeResourceUsage cru = new ComputeResourceUsage();
        sparkSubmitHelper.setComputeResourceUsage(cru);
        for (File file : SparkLoggingConfigurator.copyConfigurationFilesToRunDir(helper.getProcessRunDir())) {
            job.nonSecretGlobalFiles.add(file.getAbsolutePath());
        }
        CodeEnvModel.UsedCodeEnvRef codeEnvRef = this.trHelper.buildUsedCodeEnvRefForSparkSubmitJob(runMode, envName, stash, job);
        switch (runMode) {
            case SPARK: {
                codeEnvRef = null;
                break;
            }
            case PYSPARK: {
                CodeEnvResolutionService.ExecutionEnv executionEnv = new CodeEnvResolutionService.ExecutionEnv();
                executionEnv.cmd = Lists.newArrayList((Object[])new String[]{"python"});
                this.codeEnvResolutionService.setupPySparkCmd(envName, this.projectKey, executionEnv);
                stash.env.putAll(executionEnv.env);
                stash.env.putAll(this.codeEnvResolutionService.getEnvironmentVariablesForPythonCmd(envName, this.projectKey));
                for (Map.Entry<String, String> kv : executionEnv.sparkConf.entrySet()) {
                    job.conf.add(new SimpleKeyValue(kv.getKey(), kv.getValue()));
                }
                codeEnvRef = new CodeEnvModel.UsedCodeEnvRef(CodeEnvModel.EnvLang.PYTHON, envName);
                break;
            }
            case SPARKR: {
                CodeEnvResolutionService.ExecutionEnv executionEnv = new CodeEnvResolutionService.ExecutionEnv();
                executionEnv.cmd = Lists.newArrayList((Object[])new String[]{"R"});
                this.codeEnvResolutionService.setupSparkRCmd(envName, this.projectKey, executionEnv);
                stash.env.putAll(executionEnv.env);
                for (Map.Entry<String, String> kv : executionEnv.sparkConf.entrySet()) {
                    job.conf.add(new SimpleKeyValue(kv.getKey(), kv.getValue()));
                }
                codeEnvRef = new CodeEnvModel.UsedCodeEnvRef(CodeEnvModel.EnvLang.R, envName);
                break;
            }
            default: {
                throw new Error("unreachable");
            }
        }
        if (sparkSubmitHelper.runsInClusterMode(job)) {
            this.context = sparkSubmitHelper.setupRunUsingCluster(runMode, jobBuilder, helper.getProcessRunDir(), job, stash, helper.getJobExecEnv(), codeEnvRef);
        } else {
            boolean manageEventLog;
            boolean bl = manageEventLog = !job.hasConfKey("spark.eventLog.enabled") && (job.hasConfKey("spark.dku.manageEventLog") || usedExecutionConfig.kubernetesSettings.managedKubernetes);
            if (manageEventLog) {
                job.conf.add(new SimpleKeyValue("spark.eventLog.enabled", "true"));
                File eventlogDir = FlowJobUtils.getActivitySubdir("spark-eventlog");
                job.conf.add(new SimpleKeyValue("spark.eventLog.dir", "file:///" + String.valueOf(eventlogDir)));
                JobContext.getCurrentActivityObj().getStatus().hasManagedSparkEventLog = true;
                if (this.impersonationService.isEnabled()) {
                    String userToImpersonate = this.impersonationService.getTargetUser((String)this.projectKey, (AuthCtx)this.authCtxService.getAuthCtx()).unixUser;
                    new FilesystemACLHandler().grantAdditionalFullAccess(eventlogDir, userToImpersonate);
                }
            }
            this.context = sparkSubmitHelper.setupRunUsingClient(runMode, jobBuilder, helper.getProcessRunDir(), job, stash, helper.getJobExecEnv(), codeEnvRef);
        }
        cru.reportStartNoFail();
        List<String> cmd = sparkSubmitHelper.toCommand(job);
        File logFile = FlowJobUtils.getJobTouchedFile("spark-recipe", "spark-submit-out.log");
        JobContext.getCurrentActivityObj().getStatus().addStatutOutput("Spark driver output", logFile, "text/plain");
        if (ServiceUtils.canSqlOnDatabricks(this.authCtxService.getAuthCtx(), this.activity, this.datasetsDAO)) {
            JobContext.getCurrentActivityObj().getStatus().messages.withWarning((InfoMessage.MessageCode)SparkCodes.WARN_SPARK_WITH_DATABRICKS_DATASET, "All source datasets are from the same Databricks connection");
        }
        try {
            this.trHelper.enrichSparkSubmitCommandForCodeEnv(runMode, envName, cmd);
            logger.info((Object)("Execute spark-submit:\n" + StringUtils.join(cmd, (String)" ")));
            this.activity.setStatusMessage("Executing Spark code");
            File tmpDir = helper.getProcessRunDir();
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.directory(tmpDir);
            builder.environment().putAll(stash.getAsEnvVariables(true, true, false));
            builder.command(cmd);
            final SparkK8SDriverLogParser logParser = new SparkK8SDriverLogParser();
            JobProcessExecution jpe = new JobProcessExecution(this.authCtxService.getAuthCtx(), this.projectKey){

                @Override
                protected void prepareExecOutputConsumer(DKUtils.ExecOutputConsumer eoc, DKUtils.LineSubscription fwr) throws Exception {
                    eoc.withOutputConsumer((DKUtils.ExecSubscription)logParser).withErrorConsumer((DKUtils.ExecSubscription)logParser);
                    eoc.withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(Level.INFO)).withOutputConsumer((DKUtils.ExecSubscription)fwr);
                }
            };
            CodeBasedThingHelper.ExecutionResult result = jpe.executeNoFail(builder, null, logFile, cgrouppableProcessType, this.context.impersonatesRemotely());
            SparkJobExecutionResultHandler resultHandler = new SparkJobExecutionResultHandler(this.context){

                @Override
                public void throwFromErrorFileOrLogs(File directory, String languageInfo, CodeBasedThingHelper.ExecutionResult result, KubernetesExecUtils.KubernetesFailureCodeProvider codeProvider) throws Exception {
                    logger.info((Object)("Custom result handler, throw from error file or logs, returnValue is " + result.returnValue));
                    if (result.returnValue == 0 && this.sparkContext != null) {
                        result.returnValue = this.sparkContext.doubleCheckRunStarted();
                    }
                    if (result.returnValue != 0) {
                        logger.info((Object)"Return value is a failure, starting to search for an error");
                        File errorFile = this.sparkContext == null ? new File(directory, "error.json") : new File(this.sparkContext.getLocalRunDir(), "error.json");
                        SerializedError err = this.parseErrorFile(errorFile);
                        if (err != null) {
                            this.enrichErrorFile(languageInfo, err);
                            logger.info((Object)("After enrichment of error file, error is: " + JSON.json((Object)err)));
                            this.throwFromSEEIfNSResolutionFailed(err);
                            Pattern p = Pattern.compile("At line.*py4j\\.protocol\\.Py4JJavaError.*An error occurred while calling o.*savePyDataFrame\\.$");
                            if (err.detailedMessage != null && p.matcher(err.detailedMessage.trim()).find()) {
                                logger.info((Object)"Found unhelpful message in error file (error while savePyDataFrame ...), checking from the logs");
                                if (logParser.hasSomethingInterestingToSay()) {
                                    CodedIOException interestingThing = logParser.getInterestingException();
                                    logger.info((Object)("Log parser found an interesting error: " + JSON.json((Object)interestingThing)));
                                    err.withCode(interestingThing.getCode());
                                    err.appendCause((Throwable)interestingThing);
                                    throw new APIError.SerializedErrorException(err);
                                }
                                logger.info((Object)"Log parser did not find an interesting error");
                            } else {
                                logger.info((Object)"Error message from Spark looks usable directly");
                            }
                            throw new APIError.SerializedErrorException(err);
                        }
                        logger.info((Object)"Did not find a valid error file ...");
                        this.throwFromRemoteNameResolutionErrorInLogs(result.logOutputFile);
                    }
                }

                @Override
                protected void enrichErrorFile(String languageInfo, SerializedError err) {
                    logger.info((Object)("Trying to enrich " + languageInfo + " error"));
                    SparkErrorParser.enrichError(languageInfo.toLowerCase(), err);
                }
            };
            resultHandler.handleExecutionResult(builder.directory(), languageInfo, result);
            if (postProcessor != null) {
                postProcessor.postProcess(this.context);
            }
        }
        finally {
            this.context.close();
            cru.reportCompleteNoFail();
        }
    }
}

