/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.verifier;

import com.dataiku.dip.data.geo.GeoPointUtils;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.FuzzyJoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.verifier.Matcher;
import com.dataiku.dip.shaker.processors.geo.GeoDistanceProcessor;
import com.dataiku.dip.shaker.types.GeoPoint;

public class GeoMatcher
extends Matcher {
    public static final int EARTH_RADIUS_KM = 6371;

    public GeoMatcher(double threshold, Integer relativeTo, boolean debugMode) {
        super(threshold, relativeTo, debugMode);
    }

    @Override
    protected boolean isValidInputs(String query, String candidate) {
        GeoPoint.Coords queryCoord = GeoPoint.convert(query);
        GeoPoint.Coords candidateCoord = GeoPoint.convert(candidate);
        return queryCoord != null && candidateCoord != null;
    }

    @Override
    public double computeDistance(String query, String candidate) {
        GeoPoint.Coords candidateCoord;
        GeoPoint.Coords queryCoord = GeoPoint.convert(query);
        double result = GeoPointUtils.computeDistance(queryCoord, candidateCoord = GeoPoint.convert(candidate), GeoDistanceProcessor.DistanceUnit.KILOMETERS);
        return Double.isNaN(result) ? -1.0 : result;
    }

    @Override
    protected double computeNormalisationFactor(String query, String candidate) {
        return 40030.173592041145;
    }

    @Override
    protected FuzzyJoinRecipePayloadParams.DistanceType getDistanceType() {
        return FuzzyJoinRecipePayloadParams.DistanceType.GEO;
    }
}

