/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.geojoin;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.common.creation.VirtualInputsRecipeCreationSettings;
import com.dataiku.dip.dataflow.exec.geojoin.GeoJoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.geojoin.GeoJoinRecipeSchemaComputer;
import com.dataiku.dip.dataflow.exec.joinlike.VirtualInputBasedRecipeCreationService;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.recipes.common.VirtualInputsSingleOutputRecipeCreatorBase;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.springframework.beans.factory.annotation.Autowired;

public class GeoJoinRecipeCreator
extends VirtualInputsSingleOutputRecipeCreatorBase {
    @Autowired
    VirtualInputBasedRecipeCreationService creationService;

    public GeoJoinRecipeCreator(AuthCtx authCtx, RecipeMeta meta) {
        super(authCtx, meta);
    }

    @Override
    protected void setOutputSchema(SerializedRecipe recipe, String payload, Dataset outputDataset) throws Exception {
        FlowRecipe fr = new FlowRecipe(recipe);
        JobActivity activity = new JobActivity(this.recipesValidationService.getSampleSubgraph(fr));
        GeoJoinRecipeSchemaComputer schemaComputer = (GeoJoinRecipeSchemaComputer)this.meta.buildSchemaComputer(this.authCtx, activity);
        schemaComputer.setPayload(payload);
        outputDataset.setSchema(schemaComputer.getSchema());
    }

    @Override
    protected void setOutputSchema(SerializedRecipe recipe, String payload, StreamingEndpoint outputStreamingEndpoint) throws Exception {
        throw new Error("Unreachable");
    }

    @Override
    protected String makeInitialPayload(SerializedRecipe sr, JsonObject data, Dataset outputDataset) throws Exception {
        VirtualInputsRecipeCreationSettings settings = (VirtualInputsRecipeCreationSettings)JSON.parse((JsonElement)data, VirtualInputsRecipeCreationSettings.class);
        GeoJoinRecipePayloadParams params = new GeoJoinRecipePayloadParams();
        this.creationService.initializeJoinLikePayload(params, settings, this.authCtx, sr, outputDataset);
        return JSON.json((Object)params);
    }

    @Override
    public RecipeCreator.CreationResult copy_NT(String projectKey, SerializedRecipe.SerializedRecipeAndPayload source, JsonObject copyData) throws Exception {
        return super.copy_NT(projectKey, source, copyData, GeoJoinRecipePayloadParams.class);
    }
}

