/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.stream;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.exec.WithFactories;
import com.dataiku.dip.dataflow.exec.WithPushOutputs;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.ProcessorOutputToSIP;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.SingleInputRowProcessor;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.UniversalSingleThreadPusher;
import com.dataiku.dip.datasets.fs.AbstractFSLikeDatasetHandler;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.InputSplitProgressListener;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.Assertions;
import com.dataiku.dip.warnings.WarningsContext;

public class SingleThreadFSLikeDatasetRunnable
implements FlowRunnable,
WithPushOutputs,
WithFactories {
    private final AuthCtx authCtx;
    private final Dataset dataset;
    private final StreamableDatasetSelection selection;
    private final WarningsContext warningsContext;
    private ProcessorOutput out;
    private ColumnFactory cf;
    private RowFactory rf;
    public InputSplitProgressListener listener = new InputSplitProgressListener();

    public SingleThreadFSLikeDatasetRunnable(AuthCtx authCtx, Dataset dataset, StreamableDatasetSelection selection, WarningsContext wc) {
        this.authCtx = authCtx;
        this.dataset = dataset;
        this.selection = selection;
        this.warningsContext = wc;
    }

    @Override
    public void setFactories(ColumnFactory cf, RowFactory rf) {
        assert (this.out != null);
        this.cf = cf;
        this.rf = rf;
        if (this.out instanceof ProcessorOutputToSIP) {
            SingleInputRowProcessor sirp = ((ProcessorOutputToSIP)this.out).getTarget();
            Assertions.assertInstanceof((Object)sirp, WithFactories.class);
            ((WithFactories)sirp).setFactories(cf, rf);
        } else {
            Assertions.assertInstanceof((Object)this.out, WithFactories.class);
            ((WithFactories)this.out).setFactories(cf, rf);
        }
    }

    @Override
    public void setOutput(String name, ProcessorOutput out) {
        this.out = out;
    }

    @Override
    public void run() throws Exception {
        try (DatasetHandler descriptor = DatasetHandlerFactory.build(this.authCtx, this.dataset);){
            assert (descriptor instanceof AbstractFSLikeDatasetHandler);
        }
        UniversalSingleThreadPusher pusher = new UniversalSingleThreadPusher(this.authCtx, this.dataset, this.out, this.cf, this.rf);
        pusher.setDatasetSelection(this.selection);
        pusher.setWarningsContext(this.warningsContext);
        pusher.setListener(this.listener);
        pusher.push();
        this.out.lastRowEmitted();
    }
}

