/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.topn;

import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.cde.ContainerizedDSSEngineAble;
import com.dataiku.dip.dataflow.exec.AbortableRecipeRunner;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.exec.PreRunSchemaPropagationHandler;
import com.dataiku.dip.dataflow.exec.RecipeRunnerWithPayload;
import com.dataiku.dip.dataflow.exec.topn.ContainerizedTopNExecutor;
import com.dataiku.dip.dataflow.exec.topn.TopNRecipeBuiltinExecutor;
import com.dataiku.dip.dataflow.exec.topn.TopNRecipeExecutor;
import com.dataiku.dip.dataflow.exec.topn.TopNRecipeHiveExecutor;
import com.dataiku.dip.dataflow.exec.topn.TopNRecipeImpalaExecutor;
import com.dataiku.dip.dataflow.exec.topn.TopNRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.topn.TopNRecipeSQLExecutor;
import com.dataiku.dip.dataflow.exec.topn.TopNRecipeSparkExecutor;
import com.dataiku.dip.dataflow.exec.topn.TopNRecipeStatusComputer;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.recipes.consistency.CDECompatibilityCheckerService;
import com.dataiku.dip.server.recipes.TopNRecipeService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import org.springframework.beans.factory.annotation.Autowired;

public class TopNRecipeRunner
implements FlowRunnable,
RecipeRunner,
RecipeRunnerWithPayload,
ContainerizedDSSEngineAble,
AbortableRecipeRunner {
    @Autowired
    private TopNRecipeService service;
    @Autowired
    private JobAuthCtxService authCtxService;
    @Autowired
    private CDECompatibilityCheckerService cdeCompatibilityCheckerService;
    private JobActivity activity;
    private FlowRecipe recipe;
    private TopNRecipePayloadParams params;
    private TopNRecipeExecutor executor;
    private String payload;
    private boolean isRunningInContainer;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipe.topn");

    public TopNRecipeRunner(JobActivity activity) {
        this.activity = activity;
        this.recipe = ((RecipeRunnableSubgraph)activity.getSubgraph()).getRecipe();
        this.activity.initStatus();
    }

    @Override
    public void setPayload(String payload) {
        this.payload = payload;
        this.params = this.service.loadParams(payload, this.recipe.getModel());
    }

    @Override
    public void setIsRunningInContainer() {
        this.isRunningInContainer = true;
    }

    @Override
    public void init() throws Exception {
        assert (this.params != null);
        this.recipe.validateExactly1Source();
        SerializedRecipe.SerializedRecipeAndPayload srp = new PreRunSchemaPropagationHandler(this.activity, this.recipe).propagateIfNeeded();
        if (srp != null && srp.payload != null) {
            this.setPayload(srp.payload);
        }
        this.executor = this.getExecutor();
        logger.info((Object)("Using executor: " + this.executor.getClass().getName()));
        this.executor.init();
    }

    private TopNRecipeExecutor getExecutor() throws Exception {
        TopNRecipeStatusComputer dc = new TopNRecipeStatusComputer(this.recipe.getModel(), this.payload);
        TopNRecipeStatusComputer.TopNRecipeStatus recipeStatus = dc.fastStatusIgnorePartitions(this.authCtxService.getAuthCtx());
        RecipeEngineStatus engineToUse = recipeStatus.selectedEngine;
        logger.info((Object)("Selected engine: " + engineToUse.type));
        JobContext.getCurrentActivitySummary().engineType = engineToUse.type;
        switch (engineToUse.type) {
            case "SQL": {
                return new TopNRecipeSQLExecutor(this.activity, this.params);
            }
            case "SPARK": {
                return new TopNRecipeSparkExecutor(this.activity, this.params);
            }
            case "IMPALA": {
                return new TopNRecipeImpalaExecutor(this.activity, this.params, this.params.engineParams.impala);
            }
            case "HIVE": {
                return new TopNRecipeHiveExecutor(this.activity, this.params, this.params.engineParams.hive);
            }
            case "DSS": {
                ContainerExecRuntimeConfig containerConfig = this.cdeCompatibilityCheckerService.getContainerConfig(this.isRunningInContainer, this.authCtxService.getAuthCtx(), this.activity.warnContext, this.params.engineParams.containerSelection, this.recipe.getModel(), this.payload);
                if (containerConfig != null) {
                    logger.info((Object)"Run in container");
                    return new ContainerizedTopNExecutor(this.recipe, this.activity, containerConfig);
                }
                return new TopNRecipeBuiltinExecutor(this.activity, this.params);
            }
        }
        throw new IllegalArgumentException("No engine selected");
    }

    @Override
    public void run() throws Exception {
        logger.info((Object)"Run topn recipe");
        try {
            logger.info((Object)("Params: " + JSON.pretty((Object)this.params)));
        }
        catch (Exception e) {
            logger.error((Object)"Params could not be printed.", (Throwable)e);
        }
        assert (this.executor != null);
        this.executor.run();
    }

    @Override
    public void notifyBeforeAborting() {
        this.executor.notifyBeforeAborting();
    }
}

