/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalayer.memimpl;

import com.dataiku.dip.ProcessorWithResolvedParams;
import com.dataiku.dip.ProcessorWithResourceFiles;
import com.dataiku.dip.ProcessorWithSubProcess;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datalayer.memimpl.MemTableProcessor;
import com.dataiku.dip.security.DSSAuthCtx;
import org.apache.log4j.Logger;

public class MemTableSRPWrapper
implements MemTableProcessor {
    public SingleRowProcessor srp;
    public int processedRows;
    public int outputRows;

    public MemTableSRPWrapper(SingleRowProcessor srp) {
        this.srp = srp;
    }

    @Override
    public void init() throws Exception {
        Object rproc;
        if (this.srp instanceof ProcessorWithResourceFiles) {
            rproc = (ProcessorWithResourceFiles)this.srp;
            rproc.setRequiredFiles(rproc.gatherRequirements());
        }
        if (this.srp instanceof ProcessorWithResolvedParams) {
            rproc = (ProcessorWithResolvedParams)this.srp;
            rproc.resolve(DSSAuthCtx.newNone(), "__DKU_ANY_PROJECT__");
        }
        if (this.srp instanceof ProcessorWithSubProcess) {
            rproc = (ProcessorWithSubProcess)this.srp;
            rproc.spawn(DSSAuthCtx.newNone(), "__DKU_ANY_PROJECT__", false, null);
        }
    }

    @Override
    public void process(MemTable table) throws Exception {
        try {
            this.srp.setColumnFactory((ColumnFactory)table);
            this.srp.init();
            for (MemRow row : table.rows) {
                ++this.processedRows;
                this.srp.processRow((Row)row);
                if (row.isDeleted()) continue;
                ++this.outputRows;
            }
            this.srp.postProcess();
        }
        catch (Exception e) {
            Logger.getLogger((String)"dku.srp.wrapper").error((Object)"Failed during processing of rows, cleanup resources", (Throwable)e);
            this.srp.cancel();
            throw e;
        }
    }

    @Override
    public int processedInputRows() {
        return this.processedRows;
    }

    @Override
    public int generatedOutputRows() {
        return this.outputRows;
    }
}

