/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalayer.window;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.window.WindowRecipePayloadParams;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.RowInputStream;
import com.dataiku.dip.datalayer.sort.NumberedRow;
import com.dataiku.dip.datalayer.sort.RowAndSortMark;
import com.dataiku.dip.datalayer.sort.RowsComparator;
import com.dataiku.dip.datalayer.sort.SortedRowsIterator;
import com.dataiku.dip.datalayer.sort.Sorter;
import com.dataiku.dip.datalayer.sort.SpilledRowsStorage;
import com.dataiku.dip.datalayer.window.AvgAggregation;
import com.dataiku.dip.datalayer.window.ConcatAggregation;
import com.dataiku.dip.datalayer.window.CountAggregation;
import com.dataiku.dip.datalayer.window.CountDistinctAggregation;
import com.dataiku.dip.datalayer.window.FirstNotNullSlider;
import com.dataiku.dip.datalayer.window.FirstOrLastAggregation;
import com.dataiku.dip.datalayer.window.LagAggregation;
import com.dataiku.dip.datalayer.window.LagDiffAggregation;
import com.dataiku.dip.datalayer.window.LastNotNullSlider;
import com.dataiku.dip.datalayer.window.MinOrMaxAggregation;
import com.dataiku.dip.datalayer.window.PartitionFirstWindowSlider;
import com.dataiku.dip.datalayer.window.PartitionLastWindowSlider;
import com.dataiku.dip.datalayer.window.RangeEndWindowSlider;
import com.dataiku.dip.datalayer.window.RangeStartWindowSlider;
import com.dataiku.dip.datalayer.window.RowsDeltaWindowSlider;
import com.dataiku.dip.datalayer.window.StddevAggregation;
import com.dataiku.dip.datalayer.window.SumAggregation;
import com.dataiku.dip.datalayer.window.WindowAggregation;
import com.dataiku.dip.datalayer.window.WindowPartitionSlider;
import com.dataiku.dip.datalayer.window.WindowSlider;
import com.dataiku.dip.datasets.SchemaUtils;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.utils.ErrorContext;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class Windower {
    private final File folder;
    private final WindowRecipePayloadParams.WindowDesc windowDesc;
    private final List<WindowRecipePayloadParams.WindowValue> valuesDesc;
    private final boolean rankDesc;
    private final boolean denseRankDesc;
    private final boolean rowNumberDesc;
    private final boolean cumeDistDesc;
    private final int[] ntilesDesc;
    private final String prefix;
    private final Sorter.MergeSortParams mergeSortParams;
    private final Integer identifierMaxLength;
    private final boolean legacyUnboundedWindowBehavior;
    private Sorter sorter = null;
    private long resetCount = 0L;
    private static Logger logger = Logger.getLogger((String)"dip.windower");

    public Windower(WindowRecipePayloadParams.WindowDesc windowDesc, List<WindowRecipePayloadParams.WindowValue> valuesDesc, boolean rankDesc, boolean denseRankDesc, boolean rowNumberDesc, boolean cumeDistDesc, int[] ntilesDesc, File folder, Sorter.MergeSortParams mergeSortParams, Integer identifierMaxLength, boolean legacyUnboundedWindowBehavior) {
        this.windowDesc = windowDesc;
        this.valuesDesc = valuesDesc;
        this.rankDesc = rankDesc;
        this.denseRankDesc = denseRankDesc;
        this.rowNumberDesc = rowNumberDesc;
        this.cumeDistDesc = cumeDistDesc;
        this.ntilesDesc = ntilesDesc;
        this.folder = folder;
        this.mergeSortParams = mergeSortParams;
        this.identifierMaxLength = identifierMaxLength;
        this.legacyUnboundedWindowBehavior = legacyUnboundedWindowBehavior;
        this.prefix = StringUtils.isBlank((String)windowDesc.prefix) ? "" : windowDesc.prefix + "_";
    }

    public void cancel() throws Exception {
        if (this.sorter != null) {
            this.sorter.cancel();
        }
    }

    public void compute(RowInputStream is, ProcessorOutput out, ColumnFactory inputCf, ColumnFactory outputCf, Schema inputSchema, RowFactory outputRf) throws Exception {
        ArrayList specs = Lists.newArrayList();
        if (this.windowDesc.enablePartitioning) {
            for (String partitioningColumn : this.windowDesc.partitioningColumns) {
                specs.add(new Sorter.SortSpec(partitioningColumn, true));
            }
        }
        if (this.windowDesc.enableOrdering) {
            for (WindowRecipePayloadParams.Order order : this.windowDesc.orders) {
                specs.add(new Sorter.SortSpec(order.column, !order.desc));
            }
        }
        try (SpilledRowsStorage storage = new SpilledRowsStorage(this.folder, SpilledRowsStorage.factoryColumnsOfSchema(inputCf, inputSchema), this.mergeSortParams);){
            WindowPartitionSlider windowLast;
            WindowPartitionSlider windowFirst;
            Sorter.SortSpec spec;
            this.sorter = new Sorter(specs, inputSchema, inputCf, storage, outputRf, outputCf, this.mergeSortParams);
            int totalRowCount = 0;
            Row row = is.next();
            while (row != null) {
                this.sorter.emitRow(row);
                ++totalRowCount;
                row = is.next();
            }
            this.sorter.lastRowEmitted();
            storage.doneWriting();
            logger.info((Object)"Sort for window sort, now iterating");
            if (totalRowCount == 0) {
                return;
            }
            ArrayList partitionSpecs = Lists.newArrayList();
            if (this.windowDesc.enablePartitioning) {
                for (String partitioningColumn : this.windowDesc.partitioningColumns) {
                    Iterator<WindowRecipePayloadParams.Order> spec2 = new Sorter.SortSpec(partitioningColumn, true);
                    ((Sorter.SortSpec)((Object)spec2)).schemaColumn = inputSchema.getColumn(partitioningColumn);
                    ((Sorter.SortSpec)((Object)spec2)).factoryColumn = outputCf.column(partitioningColumn);
                    partitionSpecs.add(spec2);
                }
            }
            RowsComparator partitionComparator = new RowsComparator(partitionSpecs, RowsComparator.NullsOrdering.AUTO);
            ArrayList partitionAndOrderSpecs = Lists.newArrayList();
            if (this.windowDesc.enablePartitioning) {
                for (String partitioningColumn : this.windowDesc.partitioningColumns) {
                    spec = new Sorter.SortSpec(partitioningColumn, true);
                    spec.schemaColumn = inputSchema.getColumn(partitioningColumn);
                    spec.factoryColumn = outputCf.column(partitioningColumn);
                    partitionAndOrderSpecs.add(spec);
                }
            }
            if (this.windowDesc.enableOrdering) {
                for (WindowRecipePayloadParams.Order order : this.windowDesc.orders) {
                    spec = new Sorter.SortSpec(order.column, !order.desc);
                    spec.schemaColumn = inputSchema.getColumn(order.column);
                    spec.factoryColumn = outputCf.column(order.column);
                    partitionAndOrderSpecs.add(spec);
                }
            }
            RowsComparator partitionAndOrderComparator = new RowsComparator(partitionAndOrderSpecs, RowsComparator.NullsOrdering.AUTO);
            HashSet lags = Sets.newHashSet();
            HashSet firstNotNullColumns = Sets.newHashSet();
            HashSet lastNotNullColumns = Sets.newHashSet();
            for (WindowRecipePayloadParams.WindowValue windowValue : this.valuesDesc) {
                if (windowValue.lag || windowValue.lagDiff) {
                    for (int lag : windowValue.getLagValues()) {
                        lags.add(-lag);
                    }
                }
                if (windowValue.lead || windowValue.leadDiff) {
                    for (int lead : windowValue.getLeadValues()) {
                        lags.add(lead);
                    }
                }
                if (windowValue.first && windowValue.firstLastNotNull) {
                    firstNotNullColumns.add(windowValue.column);
                }
                if (!windowValue.last || !windowValue.firstLastNotNull) continue;
                lastNotNullColumns.add(windowValue.column);
            }
            logger.info((Object)("Opening " + lags.size() + " iterators for the leads and lags"));
            HashMap lagIterators = Maps.newHashMap();
            for (Object lag : lags) {
                lagIterators.put(lag, new RowsDeltaWindowSlider(this.sorter.read(), ((Integer)lag).intValue(), false, false));
            }
            logger.info((Object)("Opening " + firstNotNullColumns.size() + " iterators for the first not nulls"));
            HashMap hashMap = Maps.newHashMap();
            for (String firstNotNullColumn : firstNotNullColumns) {
                Column aggregatedColumn = outputCf.column(firstNotNullColumn);
                SchemaColumn aggregatedSchemaColumn = inputSchema.getColumn(firstNotNullColumn);
                hashMap.put(firstNotNullColumn, new FirstNotNullSlider(this.sorter.read(), aggregatedColumn, aggregatedSchemaColumn));
            }
            logger.info((Object)("Opening " + lastNotNullColumns.size() + " iterators for the last not nulls"));
            HashMap lastNotNullIterators = Maps.newHashMap();
            for (String lastNotNullColumn : lastNotNullColumns) {
                Column aggregatedColumn = outputCf.column(lastNotNullColumn);
                SchemaColumn aggregatedSchemaColumn = inputSchema.getColumn(lastNotNullColumn);
                lastNotNullIterators.put(lastNotNullColumn, new LastNotNullSlider(this.sorter.read(), aggregatedColumn, aggregatedSchemaColumn));
            }
            SortedRowsIterator firstIterator = this.sorter.readWithRank(partitionAndOrderComparator);
            SortedRowsIterator lastIterator = this.sorter.read();
            if (this.windowDesc.enableLimits && this.windowDesc.windowLimitMode == WindowRecipePayloadParams.WindowLimitMode.ROWS) {
                windowFirst = this.windowDesc.limitPreceding ? new RowsDeltaWindowSlider(firstIterator, -this.windowDesc.precedingRows, true, false) : new PartitionFirstWindowSlider(firstIterator);
                windowLast = this.windowDesc.limitFollowing ? new RowsDeltaWindowSlider(lastIterator, this.windowDesc.followingRows, false, true) : new PartitionLastWindowSlider(lastIterator);
            } else if (this.windowDesc.enableLimits && this.windowDesc.windowLimitMode == WindowRecipePayloadParams.WindowLimitMode.RANGE) {
                SchemaColumn rangeSchemaColumn = inputSchema.getColumn(this.windowDesc.orders.get((int)0).column);
                Column rangeColumn = outputCf.column(this.windowDesc.orders.get((int)0).column);
                windowFirst = this.windowDesc.limitPreceding ? new RangeStartWindowSlider(firstIterator, this.windowDesc.orders.get((int)0).desc, this.windowDesc.windowLowerBound, this.windowDesc.windowDateRangeUnit, rangeSchemaColumn, rangeColumn) : new PartitionFirstWindowSlider(firstIterator);
                windowLast = this.windowDesc.limitFollowing ? new RangeEndWindowSlider(lastIterator, this.windowDesc.orders.get((int)0).desc, this.windowDesc.windowUpperBound, this.windowDesc.windowDateRangeUnit, rangeSchemaColumn, rangeColumn) : new PartitionLastWindowSlider(lastIterator);
            } else {
                windowFirst = new PartitionFirstWindowSlider(firstIterator);
                windowLast = this.legacyUnboundedWindowBehavior ? new PartitionLastWindowSlider(lastIterator) : new RowsDeltaWindowSlider(lastIterator, 0L, false, true);
            }
            SortedRowsIterator partitionPosition = this.sorter.read();
            SortedRowsIterator windowPosition = this.sorter.readWithRank(partitionAndOrderComparator);
            SchemaUtils.SafeColumnIdentifierSuffixer safeSuffixer = new SchemaUtils.SafeColumnIdentifierSuffixer(this.identifierMaxLength, inputSchema);
            ArrayList aggregations = Lists.newArrayList();
            for (WindowRecipePayloadParams.WindowValue valueDesc : this.valuesDesc) {
                int[] leadValues;
                RowsDeltaWindowSlider slider;
                int[] lagValues;
                Column aggregatedColumn = outputCf.column(valueDesc.column);
                SchemaColumn aggregatedSchemaColumn = inputSchema.getColumn(valueDesc.column);
                if (aggregatedSchemaColumn == null && valueDesc.hasAnyAggr(false)) {
                    throw ErrorContext.iaef((String)"Using aggregation on column \"%s\", which does not exist in input schema or in computed columns", (Object)valueDesc.column, (Object[])new Object[0]);
                }
                if (valueDesc.count) {
                    aggregations.add(new CountAggregation(aggregatedColumn, outputCf.column(safeSuffixer.addSuffix(this.prefix + valueDesc.column, "_count")), aggregatedSchemaColumn));
                }
                if (valueDesc.countDistinct) {
                    aggregations.add(new CountDistinctAggregation(aggregatedColumn, outputCf.column(safeSuffixer.addSuffix(this.prefix + valueDesc.column, "_distinct")), aggregatedSchemaColumn));
                }
                if (valueDesc.sum) {
                    aggregations.add(new SumAggregation(aggregatedColumn, outputCf.column(safeSuffixer.addSuffix(this.prefix + valueDesc.column, "_sum")), aggregatedSchemaColumn));
                }
                if (valueDesc.concat) {
                    aggregations.add(new ConcatAggregation(aggregatedColumn, outputCf.column(safeSuffixer.addSuffix(this.prefix + valueDesc.column, "_concat")), aggregatedSchemaColumn, valueDesc.concatSeparator, valueDesc.concatDistinct));
                }
                if (valueDesc.avg) {
                    aggregations.add(new AvgAggregation(aggregatedColumn, outputCf.column(safeSuffixer.addSuffix(this.prefix + valueDesc.column, "_avg")), aggregatedSchemaColumn));
                }
                if (valueDesc.stddev) {
                    aggregations.add(new StddevAggregation(aggregatedColumn, outputCf.column(safeSuffixer.addSuffix(this.prefix + valueDesc.column, "_stddev")), aggregatedSchemaColumn));
                }
                if (valueDesc.max) {
                    aggregations.add(new MinOrMaxAggregation(aggregatedColumn, outputCf.column(safeSuffixer.addSuffix(this.prefix + valueDesc.column, "_max")), aggregatedSchemaColumn, false));
                }
                if (valueDesc.min) {
                    aggregations.add(new MinOrMaxAggregation(aggregatedColumn, outputCf.column(safeSuffixer.addSuffix(this.prefix + valueDesc.column, "_min")), aggregatedSchemaColumn, true));
                }
                if (valueDesc.first) {
                    WindowPartitionSlider firstSlider = valueDesc.firstLastNotNull ? (WindowSlider)hashMap.get(valueDesc.column) : windowFirst;
                    aggregations.add(new FirstOrLastAggregation(aggregatedColumn, outputCf.column(safeSuffixer.addSuffix(this.prefix + valueDesc.column, "_first")), aggregatedSchemaColumn, firstSlider));
                }
                if (valueDesc.last) {
                    WindowPartitionSlider lastSlider = valueDesc.firstLastNotNull ? (WindowSlider)lastNotNullIterators.get(valueDesc.column) : windowLast;
                    aggregations.add(new FirstOrLastAggregation(aggregatedColumn, outputCf.column(safeSuffixer.addSuffix(this.prefix + valueDesc.column, "_last")), aggregatedSchemaColumn, lastSlider));
                }
                if (valueDesc.lag) {
                    for (int lag : lagValues = valueDesc.getLagValues()) {
                        slider = (RowsDeltaWindowSlider)lagIterators.get(-lag);
                        aggregations.add(new LagAggregation(aggregatedColumn, outputCf.column(safeSuffixer.addSuffix(this.prefix + valueDesc.column, "_lag" + String.valueOf(lag != 1 || lagValues.length > 1 ? Integer.valueOf(lag) : ""))), aggregatedSchemaColumn, slider));
                    }
                }
                if (valueDesc.lead) {
                    leadValues = valueDesc.getLeadValues();
                    for (int lead : leadValues) {
                        slider = (RowsDeltaWindowSlider)lagIterators.get(lead);
                        aggregations.add(new LagAggregation(aggregatedColumn, outputCf.column(safeSuffixer.addSuffix(this.prefix + valueDesc.column, "_lead" + String.valueOf(lead != 1 || leadValues.length > 1 ? Integer.valueOf(lead) : ""))), aggregatedSchemaColumn, slider));
                    }
                }
                if (valueDesc.lagDiff) {
                    for (int lag : lagValues = valueDesc.getLagValues()) {
                        slider = (RowsDeltaWindowSlider)lagIterators.get(-lag);
                        aggregations.add(new LagDiffAggregation(aggregatedColumn, outputCf.column(safeSuffixer.addSuffix(this.prefix + valueDesc.column, "_lag_diff" + String.valueOf(lag != 1 || lagValues.length > 1 ? Integer.valueOf(lag) : ""))), aggregatedSchemaColumn, slider, valueDesc.dateDiffUnit));
                    }
                }
                if (!valueDesc.leadDiff) continue;
                leadValues = valueDesc.getLeadValues();
                for (int lead : leadValues) {
                    slider = (RowsDeltaWindowSlider)lagIterators.get(lead);
                    aggregations.add(new LagDiffAggregation(aggregatedColumn, outputCf.column(safeSuffixer.addSuffix(this.prefix + valueDesc.column, "_lead_diff" + String.valueOf(lead != 1 || leadValues.length > 1 ? Integer.valueOf(lead) : ""))), aggregatedSchemaColumn, slider, valueDesc.dateDiffUnit));
                }
            }
            logger.info((Object)("compute " + aggregations.size() + " for window " + this.windowDesc.prefix));
            WindowPartition windowPartition = this.advancePartition(partitionPosition, partitionPosition.next(), partitionComparator);
            long partitionCount = 0L;
            while (windowPartition != null && windowPartition.first != null && windowPartition.last != null) {
                ++partitionCount;
                if (windowPartition.last.mark.index - windowPartition.first.mark.index > 100000L) {
                    logger.info((Object)("Aggregate on partition [" + windowPartition.first.mark.index + ", " + windowPartition.last.mark.index + "]"));
                } else if (partitionCount % 1000L == 0L) {
                    logger.info((Object)("Aggregated " + windowPartition.last.mark.index + " rows into " + partitionCount + " partitions"));
                }
                this.compute(windowFirst, windowLast, windowPosition, windowPartition, lagIterators, hashMap, lastNotNullIterators, outputCf, outputRf, inputSchema, out, aggregations);
                windowPartition = this.advancePartition(partitionPosition, windowPartition.next, partitionComparator);
            }
            logger.info((Object)("Sorted rows write stats : sorter : " + this.sorter.stats()));
            logger.info((Object)("Sorted rows read stats : position : " + windowPosition.stats()));
            logger.info((Object)("Sorted rows read stats : partition : " + partitionPosition.stats()));
            logger.info((Object)("Sorted rows read stats : first : " + windowFirst.it.stats()));
            logger.info((Object)("Sorted rows read stats : last : " + windowLast.it.stats()));
            for (Map.Entry e : lagIterators.entrySet()) {
                logger.info((Object)("Sorted rows read stats : lag " + String.valueOf(e.getKey()) + " : " + ((RowsDeltaWindowSlider)e.getValue()).it.stats()));
            }
            for (Map.Entry e : hashMap.entrySet()) {
                logger.info((Object)("Sorted rows read stats : first not null " + (String)e.getKey() + " : " + ((FirstNotNullSlider)e.getValue()).it.stats()));
            }
            for (Map.Entry e : lastNotNullIterators.entrySet()) {
                logger.info((Object)("Sorted rows read stats : last not null " + (String)e.getKey() + " : " + ((LastNotNullSlider)e.getValue()).it.stats()));
            }
        }
    }

    public Schema getOutputSchema(Schema inputSchema) {
        Schema outputSchema = new Schema();
        for (SchemaColumn schemaColumn : inputSchema.getColumns()) {
            outputSchema.addColumn(schemaColumn);
        }
        SchemaUtils.SafeColumnIdentifierSuffixer safeSuffixer = new SchemaUtils.SafeColumnIdentifierSuffixer(this.identifierMaxLength, inputSchema);
        for (WindowRecipePayloadParams.WindowValue valueDesc : this.valuesDesc) {
            int[] leadValues;
            int[] lagValues;
            SchemaColumn aggregatedSchemaColumn = inputSchema.getColumn(valueDesc.column);
            if (aggregatedSchemaColumn == null && valueDesc.hasAnyAggr(false)) {
                throw ErrorContext.iaef((String)"Using aggregation on column \"%s\", which does not exist in input schema or in computed columns", (Object)valueDesc.column, (Object[])new Object[0]);
            }
            if (valueDesc.count) {
                outputSchema.addColumn(CountAggregation.buildOutputSchemaColumn(safeSuffixer.addSuffix(this.prefix + valueDesc.column, "_count"), aggregatedSchemaColumn));
            }
            if (valueDesc.countDistinct) {
                outputSchema.addColumn(CountDistinctAggregation.buildOutputSchemaColumn(safeSuffixer.addSuffix(this.prefix + valueDesc.column, "_distinct"), aggregatedSchemaColumn));
            }
            if (valueDesc.sum) {
                outputSchema.addColumn(SumAggregation.buildOutputSchemaColumn(safeSuffixer.addSuffix(this.prefix + valueDesc.column, "_sum"), aggregatedSchemaColumn));
            }
            if (valueDesc.concat) {
                outputSchema.addColumn(ConcatAggregation.buildOutputSchemaColumn(safeSuffixer.addSuffix(this.prefix + valueDesc.column, "_concat"), aggregatedSchemaColumn));
            }
            if (valueDesc.avg) {
                outputSchema.addColumn(AvgAggregation.buildOutputSchemaColumn(safeSuffixer.addSuffix(this.prefix + valueDesc.column, "_avg"), aggregatedSchemaColumn));
            }
            if (valueDesc.stddev) {
                outputSchema.addColumn(StddevAggregation.buildOutputSchemaColumn(safeSuffixer.addSuffix(this.prefix + valueDesc.column, "_stddev"), aggregatedSchemaColumn));
            }
            if (valueDesc.max) {
                outputSchema.addColumn(MinOrMaxAggregation.buildOutputSchemaColumn(safeSuffixer.addSuffix(this.prefix + valueDesc.column, "_max"), aggregatedSchemaColumn));
            }
            if (valueDesc.min) {
                outputSchema.addColumn(MinOrMaxAggregation.buildOutputSchemaColumn(safeSuffixer.addSuffix(this.prefix + valueDesc.column, "_min"), aggregatedSchemaColumn));
            }
            if (valueDesc.first) {
                outputSchema.addColumn(FirstOrLastAggregation.buildOutputSchemaColumn(safeSuffixer.addSuffix(this.prefix + valueDesc.column, "_first"), aggregatedSchemaColumn));
            }
            if (valueDesc.last) {
                outputSchema.addColumn(FirstOrLastAggregation.buildOutputSchemaColumn(safeSuffixer.addSuffix(this.prefix + valueDesc.column, "_last"), aggregatedSchemaColumn));
            }
            if (valueDesc.lag) {
                for (int lag : lagValues = valueDesc.getLagValues()) {
                    outputSchema.addColumn(LagAggregation.buildOutputSchemaColumn(safeSuffixer.addSuffix(this.prefix + valueDesc.column, "_lag" + String.valueOf(lag != 1 || lagValues.length > 1 ? Integer.valueOf(lag) : "")), aggregatedSchemaColumn));
                }
            }
            if (valueDesc.lead) {
                leadValues = valueDesc.getLeadValues();
                for (int lead : leadValues) {
                    outputSchema.addColumn(LagAggregation.buildOutputSchemaColumn(safeSuffixer.addSuffix(this.prefix + valueDesc.column, "_lead" + String.valueOf(lead != 1 || leadValues.length > 1 ? Integer.valueOf(lead) : "")), aggregatedSchemaColumn));
                }
            }
            if (valueDesc.lagDiff) {
                for (int lag : lagValues = valueDesc.getLagValues()) {
                    outputSchema.addColumn(LagDiffAggregation.buildOutputSchemaColumn(safeSuffixer.addSuffix(this.prefix + valueDesc.column, "_lag_diff" + String.valueOf(lag != 1 || lagValues.length > 1 ? Integer.valueOf(lag) : "")), aggregatedSchemaColumn));
                }
            }
            if (!valueDesc.leadDiff) continue;
            leadValues = valueDesc.getLeadValues();
            for (int lead : leadValues) {
                outputSchema.addColumn(LagDiffAggregation.buildOutputSchemaColumn(safeSuffixer.addSuffix(this.prefix + valueDesc.column, "_lead_diff" + String.valueOf(lead != 1 || leadValues.length > 1 ? Integer.valueOf(lead) : "")), aggregatedSchemaColumn));
            }
        }
        if (this.rowNumberDesc) {
            outputSchema.addColumn(this.prefix + "rownumber", Type.BIGINT);
        }
        if (this.rankDesc) {
            outputSchema.addColumn(this.prefix + "rank", Type.BIGINT);
        }
        if (this.denseRankDesc) {
            outputSchema.addColumn(this.prefix + "denserank", Type.BIGINT);
        }
        if (this.cumeDistDesc) {
            outputSchema.addColumn(this.prefix + "cumedist", Type.DOUBLE);
        }
        if (this.ntilesDesc != null) {
            for (Object ntile : (Object)this.ntilesDesc) {
                outputSchema.addColumn(this.prefix + "ntile" + (int)ntile, Type.BIGINT);
            }
        }
        return outputSchema;
    }

    private WindowPartition advancePartition(SortedRowsIterator partitionPosition, RowAndSortMark first, Comparator<NumberedRow> partitionComparator) throws IOException {
        RowAndSortMark last = first;
        RowAndSortMark next = null;
        boolean gotDifference = false;
        while (partitionPosition.hasNext()) {
            next = partitionPosition.next();
            if (partitionComparator.compare(first.row, next.row) == 0) {
                last = next;
                continue;
            }
            gotDifference = true;
            break;
        }
        if (!gotDifference && !partitionPosition.hasNext()) {
            next = null;
        }
        WindowPartition position = new WindowPartition();
        position.first = first;
        position.last = last;
        position.next = next;
        return position;
    }

    private void compute(WindowPartitionSlider windowFirst, WindowPartitionSlider windowLast, SortedRowsIterator windowPosition, WindowPartition partitionPosition, Map<Integer, RowsDeltaWindowSlider> lagIterators, Map<String, FirstNotNullSlider> firstNotNullIterators, Map<String, LastNotNullSlider> lastNotNullIterators, ColumnFactory cf, RowFactory rf, Schema inputSchema, ProcessorOutput out, List<WindowAggregation> aggregations) throws Exception {
        SlidingWindow window = new SlidingWindow(aggregations);
        boolean lagIteratorsReady = false;
        windowPosition.reset(partitionPosition.first);
        for (long i = partitionPosition.first.mark.index; i <= partitionPosition.last.mark.index; ++i) {
            RowAndSortMark rowAndMark = windowPosition.next();
            this.fillWindow(window, rowAndMark, partitionPosition, windowFirst, windowLast);
            if (!lagIteratorsReady) {
                for (RowsDeltaWindowSlider lagIterator : lagIterators.values()) {
                    lagIterator.position(rowAndMark, partitionPosition, partitionPosition.first);
                }
                lagIteratorsReady = true;
            }
            for (RowsDeltaWindowSlider lagIterator : lagIterators.values()) {
                lagIterator.slide(rowAndMark, null, null);
            }
            for (FirstNotNullSlider firstNotNullIterator : firstNotNullIterators.values()) {
                firstNotNullIterator.slide(window.first, window.last);
            }
            for (LastNotNullSlider lastNotNullIterator : lastNotNullIterators.values()) {
                lastNotNullIterator.slide(window.first, window.last);
            }
            window.produceValue(rowAndMark.row.row);
            if (this.rowNumberDesc) {
                rowAndMark.row.row.put(cf.column(this.prefix + "rownumber"), 1L + rowAndMark.mark.index - partitionPosition.first.mark.index);
            }
            if (this.rankDesc) {
                if (window.first != null && window.last != null) {
                    if (window.last.mark.index >= rowAndMark.mark.index && rowAndMark.mark.index >= window.first.mark.index) {
                        if (window.first.mark.rank == rowAndMark.mark.rank) {
                            rowAndMark.row.row.put(cf.column(this.prefix + "rank"), 1);
                        } else {
                            rowAndMark.row.row.put(cf.column(this.prefix + "rank"), 1L + rowAndMark.mark.index - window.first.mark.index - rowAndMark.mark.positionInRank);
                        }
                    } else {
                        rowAndMark.row.row.put(cf.column(this.prefix + "rank"), null);
                    }
                } else {
                    rowAndMark.row.row.put(cf.column(this.prefix + "rank"), null);
                }
            }
            if (this.denseRankDesc) {
                if (window.first != null && window.last != null) {
                    if (window.last.mark.index >= rowAndMark.mark.index && rowAndMark.mark.index >= window.first.mark.index) {
                        rowAndMark.row.row.put(cf.column(this.prefix + "denserank"), 1L + rowAndMark.mark.rank - window.first.mark.rank);
                    } else {
                        rowAndMark.row.row.put(cf.column(this.prefix + "denserank"), null);
                    }
                } else {
                    rowAndMark.row.row.put(cf.column(this.prefix + "denserank"), null);
                }
            }
            if (this.cumeDistDesc) {
                if (window.first != null && window.last != null) {
                    if (window.last.mark.index >= rowAndMark.mark.index && rowAndMark.mark.index >= window.first.mark.index) {
                        long windowRowCount = window.last.mark.index - window.first.mark.index + 1L;
                        rowAndMark.row.row.put(cf.column(this.prefix + "cumedist"), (double)(1L + rowAndMark.mark.index - window.first.mark.index) / (double)windowRowCount);
                    } else {
                        rowAndMark.row.row.put(cf.column(this.prefix + "cumedist"), 1);
                    }
                } else {
                    rowAndMark.row.row.put(cf.column(this.prefix + "cumedist"), null);
                }
            }
            if (this.ntilesDesc != null && this.ntilesDesc.length > 0) {
                if (window.first != null && window.last != null) {
                    if (window.last.mark.index >= rowAndMark.mark.index && rowAndMark.mark.index >= window.first.mark.index) {
                        long windowRowCount = window.last.mark.index - window.first.mark.index + 1L;
                        for (int ntile : this.ntilesDesc) {
                            if (windowRowCount < (long)ntile) {
                                rowAndMark.row.row.put(cf.column(this.prefix + "ntile" + ntile), 1L + (rowAndMark.mark.index - window.first.mark.index));
                                continue;
                            }
                            rowAndMark.row.row.put(cf.column(this.prefix + "ntile" + ntile), 1 + (int)Math.floor((double)ntile * (double)(rowAndMark.mark.index - window.first.mark.index) / (double)windowRowCount));
                        }
                    } else {
                        for (int ntile : this.ntilesDesc) {
                            rowAndMark.row.row.put(cf.column(this.prefix + "ntile" + ntile), null);
                        }
                    }
                } else {
                    for (int ntile : this.ntilesDesc) {
                        rowAndMark.row.row.put(cf.column(this.prefix + "ntile" + ntile), null);
                    }
                }
            }
            out.emitRow(rowAndMark.row.row);
        }
    }

    private void fillWindow(final SlidingWindow window, RowAndSortMark position, WindowPartition partitionPosition, WindowPartitionSlider startIterator, WindowPartitionSlider endIterator) throws IOException {
        WindowSlider.SlideCallback expandCallback = new WindowSlider.SlideCallback(){

            @Override
            public void handle(RowAndSortMark rowAndMark) {
                window.expand(rowAndMark);
            }
        };
        WindowSlider.SlideCallback shrinkCallback = new WindowSlider.SlideCallback(){

            @Override
            public void handle(RowAndSortMark rowAndMark) {
                window.shrink(rowAndMark);
            }
        };
        if (this.windowDesc.enableLimits || !this.legacyUnboundedWindowBehavior) {
            if (window.inited) {
                startIterator.slide(position, shrinkCallback, null);
                endIterator.slide(position, null, expandCallback);
                if (window.needsReset()) {
                    ++this.resetCount;
                    if (this.resetCount % 10000L == 0L) {
                        logger.info((Object)("Done " + this.resetCount + " resets of the window"));
                    }
                    this.fullFillWindow(window, position, partitionPosition, startIterator, endIterator, startIterator.current());
                } else {
                    window.first = startIterator.current();
                    window.last = endIterator.current();
                }
            } else {
                this.fullFillWindow(window, position, partitionPosition, startIterator, endIterator, position);
            }
        } else if (!window.inited) {
            this.fullFillWindow(window, position, partitionPosition, startIterator, endIterator, position);
        }
    }

    private void fullFillWindow(final SlidingWindow window, RowAndSortMark position, WindowPartition partitionPosition, WindowPartitionSlider startIterator, WindowPartitionSlider endIterator, RowAndSortMark windowFirstRow) throws IOException {
        WindowSlider.SlideCallback expandCallback = new WindowSlider.SlideCallback(){

            @Override
            public void handle(RowAndSortMark rowAndMark) {
                window.expand(rowAndMark);
            }
        };
        window.reset();
        startIterator.position(windowFirstRow, partitionPosition, windowFirstRow);
        startIterator.slide(position, null, null);
        if (startIterator.current() == null) {
            endIterator.position(windowFirstRow, partitionPosition, windowFirstRow);
        } else {
            endIterator.position(startIterator.current(), partitionPosition, windowFirstRow);
        }
        if (endIterator.current() != null) {
            expandCallback.handle(endIterator.current());
        }
        endIterator.slide(position, null, expandCallback);
        window.first = startIterator.current();
        window.last = endIterator.current();
        window.inited = true;
    }

    class WindowPartition {
        RowAndSortMark first;
        RowAndSortMark last;
        RowAndSortMark next;

        WindowPartition() {
        }

        public String toString() {
            return "[first=" + String.valueOf(this.first) + " last=" + String.valueOf(this.last) + " next=" + String.valueOf(this.next) + "]";
        }
    }

    private class SlidingWindow {
        private final List<WindowAggregation> aggregations;
        private int currentWindowWidth;
        RowAndSortMark first;
        RowAndSortMark last;
        boolean inited;

        public SlidingWindow(List<WindowAggregation> aggregations) {
            this.aggregations = aggregations;
        }

        public void expand(RowAndSortMark rowAndMark) {
            if (this.first == null) {
                this.first = rowAndMark;
            }
            if (this.last == null || this.last.mark.index < rowAndMark.mark.index) {
                this.last = rowAndMark;
            }
            if (this.currentWindowWidth >= 0) {
                for (WindowAggregation aggregation : this.aggregations) {
                    aggregation.expand(rowAndMark.row.row);
                }
            }
            ++this.currentWindowWidth;
        }

        public void shrink(RowAndSortMark rowAndMark) {
            if (this.currentWindowWidth > 0) {
                for (WindowAggregation aggregation : this.aggregations) {
                    aggregation.shrink(rowAndMark.row.row);
                }
            }
            --this.currentWindowWidth;
        }

        public boolean needsReset() {
            for (WindowAggregation aggregation : this.aggregations) {
                if (!aggregation.needsReset()) continue;
                return true;
            }
            return false;
        }

        public void reset() {
            this.first = null;
            this.last = null;
            this.currentWindowWidth = 0;
            for (WindowAggregation aggregation : this.aggregations) {
                aggregation.reset();
            }
        }

        public void produceValue(Row row) {
            for (WindowAggregation aggregation : this.aggregations) {
                aggregation.produceValue(row);
            }
        }
    }
}

