/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets;

import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import java.io.IOException;

public class DatasetReadiness {
    public ReadinessStatus status;
    public Throwable error;
    public String hash;

    public DatasetReadiness(ReadinessStatus status, Throwable error, String hash) {
        this.status = status;
        this.error = error;
        this.hash = hash;
    }

    public DatasetReadiness copy() {
        return new DatasetReadiness(this.status, this.error, this.hash);
    }

    public String getHashOrThrow() throws IOException, InterruptedException, DKUSecurityException, CodedException {
        if (this.status == ReadinessStatus.ERROR) {
            if (this.error instanceof IOException) {
                throw (IOException)this.error;
            }
            if (this.error instanceof InterruptedException) {
                throw (InterruptedException)this.error;
            }
            if (this.error instanceof DKUSecurityException) {
                throw (DKUSecurityException)this.error;
            }
            if (this.error instanceof CodedException) {
                throw (CodedException)this.error;
            }
            throw new IOException(this.error);
        }
        return this.hash;
    }

    public boolean isReady() {
        return this.status == ReadinessStatus.READY;
    }

    public static DatasetReadiness ready(String hash) {
        return new DatasetReadiness(ReadinessStatus.READY, null, hash);
    }

    public static DatasetReadiness notReady(Throwable error) {
        return new DatasetReadiness(ReadinessStatus.NOT_READY, error, null);
    }

    public static DatasetReadiness error(Throwable error) {
        return new DatasetReadiness(ReadinessStatus.ERROR, error, null);
    }

    public static enum ReadinessStatus {
        READY,
        NOT_READY,
        ERROR;

    }
}

