/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.sql.SAPHANASQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class SchemaUtils
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.utils.schema");

    private static String findUniqueShortenedId(String id, int length, Set<String> shortenedIdsSet, boolean prependZero) {
        Object shortenedId = id.substring(0, length);
        for (int n = 2; n <= 100; ++n) {
            if (!shortenedIdsSet.contains(shortenedId)) {
                return shortenedId;
            }
            if (n == 100) {
                throw new IllegalArgumentException("Cannot shorten more than 100 ids with the same base");
            }
            shortenedId = id.substring(0, length - 2) + (prependZero && n < 10 ? "0" : "") + n;
        }
        return shortenedId;
    }

    public static String getColumnNameToUse(SQLDialect dialect, ResultSetMetaData rsmd, int columnIdx) throws SQLException {
        if (dialect instanceof SAPHANASQLDialect) {
            return rsmd.getColumnLabel(columnIdx);
        }
        return rsmd.getColumnName(columnIdx);
    }

    public static String cleanupColumnName(String columnName) {
        if (columnName.contains("*") || columnName.contains("(")) {
            return columnName.replace('*', '_').replace('(', '_').replace(')', '_');
        }
        return columnName;
    }

    public static Schema union(Schema s1, Schema s2) {
        Schema union = new Schema();
        union.addColumns((Iterable)s1.getColumns());
        Map<String, SchemaColumn> index = SchemaUtils.indexColumns(union);
        for (SchemaColumn col : s2.columns) {
            SchemaColumn previous = index.get(col.getName());
            if (previous == null) {
                union.addColumn(col);
                continue;
            }
            SchemaUtils.mergeColumn(previous, col);
        }
        return union;
    }

    private static void mergeColumn(SchemaColumn col1, SchemaColumn col2) {
        if (col1.getType() != col2.getType()) {
            Type newType = col1.getType().commonSuperType(col2.getType());
            if (newType == null) {
                newType = Type.STRING;
            }
            logger.warn((Object)("Type conflict: " + col1.getType().toString() + "/" + col2.getType().toString() + ": fallback to " + newType.toString()));
            col1.setType(newType);
        } else if (Type.STRING == col1.getType()) {
            col1.withMaxLength(Math.max(col1.getMaxLength(), col2.getMaxLength()));
        }
    }

    public static Schema intersect(Schema s1, Schema s2) {
        Map<String, SchemaColumn> index1 = SchemaUtils.indexColumns(s1);
        Map<String, SchemaColumn> index2 = SchemaUtils.indexColumns(s2);
        Sets.SetView columnNames = Sets.intersection(index1.keySet(), index2.keySet());
        Schema inter = new Schema();
        for (SchemaColumn previous : s1.columns) {
            if (!columnNames.contains(previous.getName())) continue;
            SchemaColumn col = index2.get(previous.getName());
            SchemaUtils.mergeColumn(previous, col);
            inter.addColumn(previous);
        }
        return inter;
    }

    public static Schema lowerCase(Schema s) {
        for (SchemaColumn c2 : s.columns) {
            if (!StringUtils.isNotBlank((String)c2.getName())) continue;
            c2.setName(c2.getName().toLowerCase());
        }
        return s;
    }

    public static Map<String, SchemaColumn> indexColumns(Schema schema) {
        HashMap<String, SchemaColumn> index = new HashMap<String, SchemaColumn>();
        for (SchemaColumn col : schema.columns) {
            index.put(col.getName(), col);
        }
        return index;
    }

    public static void checkSchema(Schema schema) throws IllegalArgumentException {
        if (schema == null || schema.columns == null || schema.columns.size() == 0) {
            throw new IllegalArgumentException("Schema is empty.");
        }
        HashSet<String> usedNames = new HashSet<String>();
        for (SchemaColumn col : schema.columns) {
            if (StringUtils.isBlank((String)col.getName())) {
                throw new IllegalArgumentException("Column has no name.");
            }
            if (usedNames.contains(col.getName())) {
                throw new IllegalArgumentException("Duplicate column name: " + col.getName());
            }
            usedNames.add(col.getName());
            try {
                col.getType();
            }
            catch (NullPointerException e) {
                throw new IllegalArgumentException("Column " + col.getName() + " has no type");
            }
        }
    }

    public static boolean isSafeForImpala(Dataset dataset) {
        for (SchemaColumn column : dataset.getSchema().getColumns()) {
            if (column.getType().isPrimitive()) continue;
            return false;
        }
        return true;
    }

    public static String removeNonWordCharacters(String identifier) {
        return identifier.replaceAll("\\W", "");
    }

    public static void applyOverrides(Schema schema, Map<String, String> outputColumnNameOverrides, boolean lowerCaseColumnsNames) {
        if (outputColumnNameOverrides != null) {
            for (SchemaColumn sc : schema.columns) {
                String override = outputColumnNameOverrides.get(sc.getName());
                if (!StringUtils.isNotBlank((String)override)) continue;
                sc.setName(override);
            }
        }
        if (lowerCaseColumnsNames) {
            SchemaUtils.lowerCase(schema);
        }
    }

    public static void fixupExistingStringColumnsMaxLengths(Schema schema, SQLDialect dialect) {
        for (SchemaColumn column : schema.getColumns()) {
            if (column.getType() != Type.STRING || dialect.getMaxPossibleVarcharLen() <= 0 || column.maxLength <= dialect.getMaxPossibleVarcharLen()) continue;
            logger.infoV("String column '%s' maxLength (%d) is too large for %s's max varchar length (%d), setting to the default length for dialect", new Object[]{column.getName(), column.maxLength, dialect.getId(), dialect.getMaxPossibleVarcharLen()});
            column.withMaxLength(-1);
        }
    }

    public static void fixupImplicitColumns(String connectionType, Schema schema) {
        if (DatasetInspector.isTreasureData(connectionType)) {
            SchemaColumn timeColumn = schema.columns.stream().filter(SchemaUtils::columnNameEqualsTimeIgnoreCase).findFirst().orElse(null);
            if (timeColumn != null) {
                Type timeColumnType = timeColumn.getType();
                if (timeColumnType != Type.BIGINT && timeColumnType != Type.TINYINT && timeColumnType != Type.SMALLINT && timeColumnType != Type.INT) {
                    throw new IllegalStateException("If TreasureData datasets define a column named 'time', it must be of type BIGINT but found type " + String.valueOf(timeColumnType));
                }
                SchemaColumn lastColumn = (SchemaColumn)schema.columns.get(schema.columns.size() - 1);
                if (lastColumn != timeColumn) {
                    schema.columns.remove(timeColumn);
                    schema.columns.add(timeColumn);
                }
            } else {
                timeColumn = new SchemaColumn("time", Type.BIGINT);
                timeColumn.comment = "Unixtime";
                schema.columns.add(timeColumn);
            }
        }
    }

    public static void fixSchemaForComparison(String connectionType, Schema targetSchema, Schema dataSchema) {
        if (DatasetInspector.isTreasureData(connectionType) && dataSchema.getColumns().size() != targetSchema.getColumns().size()) {
            boolean targetSchemaHasTimeColumn = targetSchema.getColumns().stream().anyMatch(SchemaUtils::columnNameEqualsTimeIgnoreCase);
            boolean dataSchemaHasTimeColumn = dataSchema.getColumns().stream().anyMatch(SchemaUtils::columnNameEqualsTimeIgnoreCase);
            if (targetSchemaHasTimeColumn && !dataSchemaHasTimeColumn) {
                targetSchema.getColumns().removeIf(SchemaUtils::columnNameEqualsTimeIgnoreCase);
            }
        }
    }

    private static boolean columnNameEqualsTimeIgnoreCase(SchemaColumn c2) {
        return c2 != null && c2.getName() != null && c2.getName().toLowerCase(Locale.ROOT).equals("time");
    }

    public static class SchemalessSafeColumnIdentifierSuffixer
    extends SafeColumnIdentifierSuffixer {
        public SchemalessSafeColumnIdentifierSuffixer(Integer maxLength) {
            super(maxLength, null);
        }

        @Override
        public String addSuffix(String columnIdentifier, String suffix) {
            String newId;
            String base = this.concat(columnIdentifier, suffix);
            if (!base.equals(newId = this.applySuffix(columnIdentifier, suffix))) {
                logger.warn((Object)("Column identifier '" + base + "' was changed to '" + newId + "'"));
            }
            return newId;
        }

        @Override
        protected String applySuffixUsingMaxLength(String id, String suffix, int maxIdentifierLength) {
            int maxLen = maxIdentifierLength - StringUtils.length((String)suffix);
            int length = Math.min(id.length(), maxLen);
            if (id.length() <= maxLen) {
                if (!this.shortenIdsSet.contains(id)) {
                    this.shortenIdsSet.add(id);
                    this.shortenedIdentifiers.computeIfAbsent(id, k -> new HashMap()).putIfAbsent(length, id);
                    return this.concat(id, suffix);
                }
                if (this.shortenedIdentifiers.containsKey(id) && ((Map)this.shortenedIdentifiers.get(id)).containsKey(length) && id.equals(((Map)this.shortenedIdentifiers.get(id)).get(length))) {
                    return this.concat(id, suffix);
                }
            }
            if (length <= 1) {
                throw new IllegalArgumentException("Identifier '" + id + "' cannot be suffixed with '" + suffix + "' with a max length of " + maxIdentifierLength + " (max length should be at least " + (StringUtils.length((String)suffix) + 2) + " with this suffix)");
            }
            if (this.shortenedIdentifiers.containsKey(id)) {
                if (((Map)this.shortenedIdentifiers.get(id)).containsKey(length)) {
                    return this.concat((String)((Map)this.shortenedIdentifiers.get(id)).get(length), suffix);
                }
            } else {
                this.shortenedIdentifiers.put(id, new HashMap());
            }
            String shortenedId = SchemaUtils.findUniqueShortenedId(id, length, this.shortenIdsSet, true);
            ((Map)this.shortenedIdentifiers.get(id)).put(length, shortenedId);
            this.shortenIdsSet.add(shortenedId);
            assert (shortenedId.length() <= maxLen);
            return this.concat(shortenedId, suffix);
        }
    }

    public static class SafeColumnIdentifierSuffixer {
        protected Map<String, Map<Integer, String>> shortenedIdentifiers = new HashMap<String, Map<Integer, String>>();
        protected Set<String> shortenIdsSet = new HashSet<String>();
        protected Schema schema;
        private Integer maxLength;

        public SafeColumnIdentifierSuffixer(Integer maxLength, Schema schema) {
            this.maxLength = maxLength;
            if (schema != null) {
                this.schema = new Schema();
                for (SchemaColumn col : schema.columns) {
                    this.schema.addColumn(col);
                    this.shortenIdsSet.add(this.concat(col.getName(), null));
                }
            }
        }

        protected String concat(String a, String b) {
            return a + b;
        }

        protected String applySuffix(String id, String suffix) {
            if (this.maxLength != null && this.maxLength > 0) {
                return this.applySuffixUsingMaxLength(id, suffix, this.maxLength);
            }
            return this.concat(id, suffix);
        }

        protected String applySuffixUsingMaxLength(String id, String suffix, int maxIdentifierLength) {
            int maxLength = maxIdentifierLength - StringUtils.length((String)suffix);
            if (id.length() <= maxLength) {
                return this.concat(id, suffix);
            }
            if (maxLength < 7) {
                throw new IllegalArgumentException("Identifier is too long ");
            }
            if (this.shortenedIdentifiers.containsKey(id)) {
                if (this.shortenedIdentifiers.get(id).containsKey(maxLength)) {
                    return this.concat(this.shortenedIdentifiers.get(id).get(maxLength), suffix);
                }
            } else {
                this.shortenedIdentifiers.put(id, new HashMap());
            }
            String shortenedId = SchemaUtils.findUniqueShortenedId(id, maxLength, this.shortenIdsSet, false);
            this.shortenedIdentifiers.get(id).put(maxLength, shortenedId);
            this.shortenIdsSet.add(shortenedId);
            assert (shortenedId.length() <= maxLength);
            return this.concat(shortenedId, suffix);
        }

        public String addSuffix(String columnIdentifier, String suffix) {
            String newId;
            String base = this.concat(columnIdentifier, suffix);
            if (this.schema != null) {
                for (SchemaColumn col : this.schema.columns) {
                    this.applySuffix(col.getName(), suffix);
                }
            }
            if (!base.equals(newId = this.applySuffix(columnIdentifier, suffix))) {
                logger.warn((Object)("Column identifier '" + base + "' was changed to '" + newId + "'"));
            }
            return newId;
        }
    }
}

