/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.custompython;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.custompython.AbstractCustomDatasetHandler;
import com.dataiku.dip.datasets.custompython.CustomDatasetPythonKernel;
import com.dataiku.dip.datasets.custompython.CustomPythonDatasetDesc;
import com.dataiku.dip.datasets.custompython.CustomPythonDatasetMeta;
import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.input.formats.csv.RFC4180CSVParser;
import com.dataiku.dip.input.stream.InputStreamLineReader;
import com.dataiku.dip.input.stream.LineReader;
import com.dataiku.dip.io.PortRangeParams;
import com.dataiku.dip.io.SecretProtectedKernelLink;
import com.dataiku.dip.io.SingleCommandKernelLink;
import com.dataiku.dip.io.SocketBlockLinkKernelException;
import com.dataiku.dip.kernels.DSSKernelBase;
import com.dataiku.dip.kernels.IDSSKernelBase;
import com.dataiku.dip.output.CSVOutputFormatter;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.output.OutputWriter;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.plugins.CustomPythonDatasetsService;
import com.dataiku.dip.plugins.LoadedPythonDataset;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class CustomPythonDatasetHandler
extends AbstractCustomDatasetHandler<CustomPythonDatasetDesc> {
    @Autowired
    private CustomPythonDatasetsService service;
    @Autowired
    private APITicketService apiTicketService;
    private KernelLinkPair kernelLinkPair;
    private static final Logger logger = Logger.getLogger((String)"dku.datasets.custompython");

    public CustomPythonDatasetHandler(AuthCtx authCtx, LoadedPythonDataset desc, Dataset dataset) {
        super(authCtx, desc, dataset);
    }

    @Override
    public void close() throws IOException {
        if (this.kernelLinkPair != null) {
            this.kernelLinkPair.close();
        }
    }

    @Override
    public DatasetHandler.DatasetMeta<?, ?> getMeta() {
        return new CustomPythonDatasetMeta((LoadedPythonDataset)this.desc);
    }

    @Override
    public boolean isParallelWritable() throws Exception {
        return false;
    }

    private void startIfNeeded() throws Exception {
        if (this.kernelLinkPair == null) {
            this.kernelLinkPair = this.createNewKernel();
        }
    }

    private KernelLinkPair createNewKernel() throws Exception {
        SpringUtils.getInstance().autowire((Object)this);
        String envName = new CodeEnvSelector().selectForCustomPythonRecipe(this.desc.ownerPluginId);
        String ticketIdentifier = SecretKeyGenerator.generateSmall();
        APITicketService.Ticket ticket = this.apiTicketService.createTicket(this.authCtx, "custom-dataset-" + this.dataset.getProjectKey() + "-" + ticketIdentifier, null);
        PortRangeParams dssPortRange = ApplicationConfigurator.getPortRangeParams();
        String secret = SecretKeyGenerator.generate((int)16);
        SingleCommandKernelLink link = new SingleCommandKernelLink(secret, dssPortRange);
        String code = this.service.getCode(this.desc.datasetType);
        PluginSettingsResolver.ResolvedSettings expandedPluginSettings = this.service.getExpandedPluginSettings(this.desc.datasetType, this.authCtx, this.dataset.getProjectKey(), this.params.customConfig);
        JsonObject config = expandedPluginSettings.config;
        JsonObject pluginConfig = expandedPluginSettings.pluginConfig;
        CustomDatasetPythonKernel kernel = new CustomDatasetPythonKernel(this.authCtx, link, this.service.getResourceFolder(this.desc.datasetType), this.service.getLibFolder(this.desc.datasetType), this.dataset.getProjectKey(), envName, ticket);
        KernelLinkPair kernelPair = new KernelLinkPair(kernel, link);
        try {
            kernel.start();
            CustomDatasetPythonKernel.InitRequest initRequest = new CustomDatasetPythonKernel.InitRequest(code, config, pluginConfig);
            CustomDatasetPythonKernel.InitResponse initResponse = (CustomDatasetPythonKernel.InitResponse)link.execute((Object)initRequest, CustomDatasetPythonKernel.InitResponse.class, "Failed to initialize kernel");
            if (!initResponse.ok) {
                throw new IOException("Failed to create python kernel for dataset");
            }
        }
        catch (Exception e) {
            if (e instanceof SocketBlockLinkKernelException) {
                ((SocketBlockLinkKernelException)((Object)e)).withLogTail((IDSSKernelBase)kernel);
            }
            kernelPair.terminate();
            throw e;
        }
        return kernelPair;
    }

    @Override
    public Output buildOutput(Partition targetPartition, int targetSplit, int resplitFactor, WarningsContext warningsContext) throws Exception {
        return new CustomPythonOutput(targetPartition);
    }

    @Override
    public Schema getSchema() throws Exception {
        this.startIfNeeded();
        try {
            return ((CustomDatasetPythonKernel.GetSchemaResponse)this.kernelLinkPair.link.execute((Object)new CustomDatasetPythonKernel.GetSchemaRequest(), CustomDatasetPythonKernel.GetSchemaResponse.class, (String)"Failed to get schema")).schema;
        }
        catch (SocketBlockLinkKernelException e) {
            e.withLogTail((IDSSKernelBase)this.kernelLinkPair.kernel);
            throw e;
        }
    }

    @Override
    protected List<String> getRemoteListPartitions(PartitioningScheme scheme) throws Exception {
        this.startIfNeeded();
        try {
            CustomDatasetPythonKernel.ListPartitionsRequest req = new CustomDatasetPythonKernel.ListPartitionsRequest(scheme);
            return ((CustomDatasetPythonKernel.ListPartitionsResponse)this.kernelLinkPair.link.execute((Object)req, CustomDatasetPythonKernel.ListPartitionsResponse.class, (String)"Failed to list partitions")).partitions;
        }
        catch (SocketBlockLinkKernelException e) {
            e.withLogTail((IDSSKernelBase)this.kernelLinkPair.kernel);
            throw e;
        }
    }

    @Override
    protected long getRemoteCountRecords() throws Exception {
        this.startIfNeeded();
        try {
            CustomDatasetPythonKernel.CountRecordsRequest req = new CustomDatasetPythonKernel.CountRecordsRequest(this.dataset.getPartitioningSchema(), null);
            return ((CustomDatasetPythonKernel.CountRecordsResponse)this.kernelLinkPair.link.execute((Object)req, CustomDatasetPythonKernel.CountRecordsResponse.class, (String)"Failed to get record count")).count;
        }
        catch (SocketBlockLinkKernelException e) {
            e.withLogTail((IDSSKernelBase)this.kernelLinkPair.kernel);
            throw e;
        }
    }

    @Override
    protected long getRemotePartitionCountRecords(Partition partition) throws Exception {
        this.startIfNeeded();
        try {
            String partitionId = partition != null ? partition.id() : "NP";
            CustomDatasetPythonKernel.CountRecordsRequest req = new CustomDatasetPythonKernel.CountRecordsRequest(this.dataset.getPartitioningSchema(), partitionId);
            return ((CustomDatasetPythonKernel.CountRecordsResponse)this.kernelLinkPair.link.execute((Object)req, CustomDatasetPythonKernel.CountRecordsResponse.class, (String)"Failed to get record count")).count;
        }
        catch (SocketBlockLinkKernelException e) {
            e.withLogTail((IDSSKernelBase)this.kernelLinkPair.kernel);
            throw e;
        }
    }

    @Override
    protected boolean getRemotePartitionExists(PartitioningScheme scheme, Partition partition) throws Exception {
        this.startIfNeeded();
        try {
            String partitionId = partition != null ? partition.id() : "NP";
            CustomDatasetPythonKernel.PartitionExistsRequest req = new CustomDatasetPythonKernel.PartitionExistsRequest(this.dataset.getPartitioningSchema(), partitionId);
            return ((CustomDatasetPythonKernel.PartitionExistsResponse)this.kernelLinkPair.link.execute((Object)req, CustomDatasetPythonKernel.PartitionExistsResponse.class, (String)"Failed to check partition existence")).exists;
        }
        catch (SocketBlockLinkKernelException e) {
            e.withLogTail((IDSSKernelBase)this.kernelLinkPair.kernel);
            throw e;
        }
    }

    @Override
    protected long remotePush(ProcessorOutput output, ColumnFactory cf, RowFactory rf, long maxRecords, Partition partition) throws Exception {
        this.startIfNeeded();
        Schema schema = this.useReadInfoSchemaRatherThanDatasetSchema ? this.getSchema() : this.dataset.getSchema();
        if (schema != null && schema.getColumns().size() == 0) {
            schema = null;
        }
        String partitionId = partition != null ? partition.id() : "NP";
        PartitioningScheme partitioning = this.forcedPartitioningScheme != null ? this.forcedPartitioningScheme : this.dataset.getPartitioningSchema();
        ArrayList<Column> schemaColumns = new ArrayList<Column>();
        if (schema != null) {
            for (SchemaColumn sc : schema.getColumns()) {
                schemaColumns.add(cf.column(sc.getName()));
            }
        }
        logger.info((Object)("Asking custom dataset to push with settings: schema=" + JSON.json((Object)schema) + " partitioning=" + JSON.json((Object)partitioning) + " limit=" + maxRecords + " partitionId=" + partitionId));
        int readRows = 0;
        CustomDatasetPythonKernel.ReadRowsRequest generateRequest = new CustomDatasetPythonKernel.ReadRowsRequest(schema, partitioning, partitionId, maxRecords);
        PipedOutputStream pos = new PipedOutputStream();
        PipedInputStream pis = new PipedInputStream(pos);
        RFC4180CSVParser parser = new RFC4180CSVParser((LineReader)new InputStreamLineReader((InputStream)pis, StandardCharsets.UTF_8), ',');
        SingleCommandKernelLink.IOCallable commandResult = this.kernelLinkPair.link.executeStreamAsync((Object)generateRequest, (OutputStream)pos);
        try (FutureAborter.AutoCloseableAbortHook aborter = FutureAborter.pushAutoCloseableHook((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    CustomPythonDatasetHandler.this.kernelLinkPair.link.close();
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to close socket to abort dataset read", (Throwable)e);
                }
            }
        });){
            ArrayList<String> out = new ArrayList<String>();
            while (parser.next(out)) {
                if (maxRecords > 0L && (long)readRows >= maxRecords) {
                    break;
                }
                Row r = rf.row();
                if (out.size() == schemaColumns.size()) {
                    for (i = 0; i < out.size(); ++i) {
                        r.put((Column)schemaColumns.get(i), (String)out.get(i));
                    }
                } else if (out.size() == schemaColumns.size() + 1) {
                    for (i = 0; i < schemaColumns.size(); ++i) {
                        r.put((Column)schemaColumns.get(i), (String)out.get(i));
                    }
                    String outOfSchema = (String)out.get(out.size() - 1);
                    JsonObject jo = (JsonObject)JSON.parse((String)outOfSchema, JsonObject.class);
                    for (Map.Entry entry : jo.entrySet()) {
                        if (entry.getValue() != null && ((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            r.put(cf.column((String)entry.getKey()), ((JsonElement)entry.getValue()).getAsString().toString());
                            continue;
                        }
                        if (entry.getValue() == null) continue;
                        r.put(cf.column((String)entry.getKey()), ((JsonElement)entry.getValue()).toString());
                    }
                } else {
                    throw new Exception("Got unexpected number of cols, schema has " + schemaColumns.size() + "  data has " + out.size());
                }
                ++readRows;
                output.emitRow(r);
            }
        }
        byte[] devNull = new byte[0x100000];
        long extra = 0L;
        int read = pis.read(devNull);
        while (read >= 0) {
            extra += (long)read;
            read = pis.read(devNull);
        }
        if (extra > 0L) {
            logger.info((Object)("Read " + extra + " bytes after getting enough rows"));
        }
        commandResult.call();
        SecretProtectedKernelLink.AcknowledgeResponse ack = this.kernelLinkPair.link.acknowledgeLastCall((DSSKernelBase)this.kernelLinkPair.kernel, "finish_read_session", "Failure while reading data from dataset");
        logger.info((Object)("Read " + readRows + " (" + ack.count + " from kernel POV)"));
        return readRows;
    }

    @Override
    protected PartitioningScheme getRemotePartitioningScheme() throws Exception {
        this.startIfNeeded();
        try {
            CustomDatasetPythonKernel.GetPartitioningSchemeRequest req = new CustomDatasetPythonKernel.GetPartitioningSchemeRequest();
            return ((CustomDatasetPythonKernel.GetPartitioningSchemeResponse)this.kernelLinkPair.link.execute((Object)req, CustomDatasetPythonKernel.GetPartitioningSchemeResponse.class, (String)"Failed to get partitioning")).partitioning;
        }
        catch (SocketBlockLinkKernelException e) {
            e.withLogTail((IDSSKernelBase)this.kernelLinkPair.kernel);
            throw e;
        }
    }

    private class KernelLinkPair {
        private final CustomDatasetPythonKernel kernel;
        private final SingleCommandKernelLink link;

        private KernelLinkPair(CustomDatasetPythonKernel kernel, SingleCommandKernelLink link) {
            this.kernel = kernel;
            this.link = link;
        }

        public void close() throws IOException {
            if (this.kernel != null) {
                this.kernel.killNoWaitNoException(false);
                this.link.close();
                this.expireTicket();
            }
        }

        private void terminate() {
            if (this.kernel != null) {
                this.kernel.killNoWaitNoException(false);
                try {
                    this.link.close();
                }
                catch (IOException e) {
                    logger.error((Object)"Failed to close socket to python connector", (Throwable)e);
                }
                this.expireTicket();
            }
        }

        private void expireTicket() {
            APITicketService.Ticket ticket = this.kernel.getTicket();
            if (ticket != null) {
                CustomPythonDatasetHandler.this.apiTicketService.expireTicket(ticket);
            }
        }
    }

    class CustomPythonOutput
    implements Output {
        private final Partition targetPartition;

        CustomPythonOutput(Partition targetPartition) {
            this.targetPartition = targetPartition;
        }

        public OutputWriter getWriter(Output.WriteMode mode) throws IOException {
            boolean supportAppend = ((CustomPythonDatasetDesc)CustomPythonDatasetHandler.this.desc.desc).supportAppend;
            if (!supportAppend && mode == Output.WriteMode.APPEND) {
                throw new IllegalArgumentException("Unsupported APPEND mode for custom python dataset " + CustomPythonDatasetHandler.this.desc.id);
            }
            return new CustomPythonOutputWriter(this.targetPartition, mode);
        }
    }

    class CustomPythonOutputWriter
    extends OutputWriter {
        private final Partition targetPartition;
        private final Output.WriteMode writeMode;
        private OutputStream outputStream;
        private ColumnFactory cf;
        private CSVOutputFormatter formatter;
        private KernelLinkPair writeKernelLinkPair;
        private SingleCommandKernelLink.IOCallable<SecretProtectedKernelLink.AcknowledgeResponse> writeExceptions;

        CustomPythonOutputWriter(Partition targetPartition, Output.WriteMode writeMode) {
            this.targetPartition = targetPartition;
            this.writeMode = writeMode;
        }

        public void emitRow(Row row) throws Exception {
            try {
                this.formatter.format(row, this.cf, this.outputStream);
            }
            catch (IOException e) {
                if (e.getMessage().toLowerCase().contains("pipe closed")) {
                    this.checkWritingSessionCompletion();
                }
                throw e;
            }
        }

        public void lastRowEmitted() throws Exception {
            logger.info((Object)"Last Row emitted on Custom output writer");
            this.formatter.footer(this.cf, this.outputStream);
            this.outputStream.close();
            this.checkWritingSessionCompletion();
        }

        private void checkWritingSessionCompletion() throws IOException {
            try {
                SecretProtectedKernelLink.AcknowledgeResponse writeResponse = (SecretProtectedKernelLink.AcknowledgeResponse)this.writeExceptions.call();
                if (!writeResponse.ok) {
                    throw new SocketBlockLinkKernelException("Failed to write to python dataset", writeResponse.error);
                }
                logger.info((Object)("Wrote " + writeResponse.count + " rows from kernel POV"));
            }
            catch (SocketBlockLinkKernelException e) {
                e.withLogTail((IDSSKernelBase)this.writeKernelLinkPair.kernel);
                throw e;
            }
            this.writeKernelLinkPair.close();
        }

        public void init(ColumnFactory cf) throws Exception {
            this.writeKernelLinkPair = CustomPythonDatasetHandler.this.createNewKernel();
            assert (CustomPythonDatasetHandler.this.forcedPartitioningScheme == null);
            Schema schema = CustomPythonDatasetHandler.this.dataset.getSchema();
            if (schema == null || schema.getColumns() == null || schema.getColumns().size() == 0) {
                schema = null;
            }
            if (schema == null) {
                throw new Exception("Write with no schema not yet supported");
            }
            PartitioningScheme partitioning = CustomPythonDatasetHandler.this.dataset.getPartitioningSchema();
            String partitionId = this.targetPartition.id();
            PipedInputStream pis = new PipedInputStream();
            this.outputStream = new PipedOutputStream(pis);
            this.writeExceptions = this.writeKernelLinkPair.link.executeAsync((Object)new CustomDatasetPythonKernel.WriteRowsRequest(schema, partitioning, partitionId, this.writeMode), (InputStream)pis, SecretProtectedKernelLink.AcknowledgeResponse.class, "Failed to write rows");
            CSVFormatConfig config = CSVFormatConfig.getStandardTabExcelFormat();
            config.setSeparatorStr(",");
            config.parseHeaderRow = false;
            this.formatter = new CSVOutputFormatter(config);
            this.formatter.setOutputSchema(schema);
            this.formatter.header(cf, this.outputStream);
        }

        public long writtenBytes() throws IOException {
            return 0L;
        }

        public void cancel() throws Exception {
            this.writeKernelLinkPair.terminate();
        }
    }
}

