/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.elasticsearch;

public enum ElasticSearchDialect {
    ES_LE_2(true, true, "_aliases", "search_type=count", true, false, "string", "string", true, true, false),
    ES_5(false, false, "_alias", "size=0", false, true, "text", "keyword", false, true, false),
    ES_7(false, false, "_alias", "size=0", false, true, "text", "keyword", false, false, true);

    public final boolean hasScan;
    public final boolean hasRootFilter;
    public final String getAliasesURLSuffix;
    public final String countArgs;
    public final boolean hasIgnoreMappingConflicts;
    public final boolean strictBooleanOptions;
    public final String stringType;
    public final String keywordType;
    public final boolean needsNotAnalyzed;
    public final boolean hasType;
    public final boolean hasTotalHitsAsObject;

    private ElasticSearchDialect(boolean hasScan, boolean hasRootFilter, String getAliasesURLSuffix, String countArgs, boolean hasIgnoreMappingConflicts, boolean strictBooleanOptions, String stringType, String keywordType, boolean needsNotAnalyzed, boolean hasType, boolean hasTotalHitsAsObject) {
        this.hasScan = hasScan;
        this.hasRootFilter = hasRootFilter;
        this.getAliasesURLSuffix = getAliasesURLSuffix;
        this.countArgs = countArgs;
        this.hasIgnoreMappingConflicts = hasIgnoreMappingConflicts;
        this.strictBooleanOptions = strictBooleanOptions;
        this.stringType = stringType;
        this.keywordType = keywordType;
        this.needsNotAnalyzed = needsNotAnalyzed;
        this.hasType = hasType;
        this.hasTotalHitsAsObject = hasTotalHitsAsObject;
    }

    public String getBaseUrl(String address, String index, String type) {
        return this.getBaseUrl(address, index, null, type);
    }

    public String getBaseUrl(String address, String index, String alias, String typeUrl) {
        StringBuilder sb = new StringBuilder();
        sb.append(address);
        sb.append(index);
        if (alias != null && !alias.isEmpty()) {
            sb.append("/");
            sb.append(alias);
        }
        if (this.hasType) {
            sb.append(typeUrl);
        }
        return sb.toString();
    }
}

