/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.datasets.fs.BlobLikeFSProvider;
import com.dataiku.dip.datasets.fs.BlobLikeResplitOutputWriter;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.output.CanListFilesWrittenTo;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.output.OutputWriter;
import com.dataiku.dip.output.ResplittableExtensibleFileOutputWriter;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.warnings.WarningsContext;
import java.io.IOException;
import java.util.List;

class BlobLikeResplitOutput
implements Output,
CanListFilesWrittenTo {
    private final AuthCtx authCtx;
    private final String projectKey;
    private final BlobLikeFSProvider provider;
    private final String basePath;
    private final int splitId;
    private final int resplitFactor;
    private final String formatType;
    private final FormatParams formatParams;
    private final Schema schema;
    private final WarningsContext warningsContext;
    private final String compress;
    private final SerializedDataset.ReadWriteOptions readWriteOptions;
    private long maxSplitChunkSize = 0L;

    public BlobLikeResplitOutput(AuthCtx authCtx, String projectKey, BlobLikeFSProvider provider, String basePath, int splitId, int resplitFactor, String formatType, FormatParams formatParams, Schema schema, WarningsContext warningsContext, String compress, SerializedDataset.ReadWriteOptions readWriteOptions) {
        this.authCtx = authCtx;
        this.projectKey = projectKey;
        this.provider = provider;
        this.basePath = basePath;
        this.splitId = splitId;
        this.resplitFactor = resplitFactor == 0 ? 1 : resplitFactor;
        this.formatType = formatType;
        this.formatParams = formatParams;
        this.schema = schema;
        this.warningsContext = warningsContext;
        this.compress = compress;
        this.readWriteOptions = readWriteOptions;
    }

    public void setMaxSplitChunkSize(long maxSplitChunkSize) {
        this.maxSplitChunkSize = maxSplitChunkSize;
    }

    public OutputWriter getWriter(Output.WriteMode mode) throws IOException, CodedException, DKUSecurityException {
        BlobLikeResplitOutputWriter writer = new BlobLikeResplitOutputWriter(this.authCtx, this.projectKey, this.provider, this.basePath, this.splitId, this.resplitFactor, this.formatType, this.formatParams, this.schema, this.warningsContext, mode, this.compress, this.readWriteOptions);
        writer.setMaxSplitChunkSize(this.maxSplitChunkSize);
        return writer;
    }

    public List<String> list(OutputWriter writer) {
        return ((ResplittableExtensibleFileOutputWriter)writer).gatherWritesInProgress();
    }

    public List<String> recoverList() throws IOException, CodedException, DKUSecurityException {
        return ResplittableExtensibleFileOutputWriter.gatherPathsWrittenToAndNotCommitted(this.provider, this.splitId);
    }
}

