/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.datasets.fs.GCSOutputStream;
import com.dataiku.dip.datasets.fs.gcs.CreateBucketInfo;
import com.dataiku.dip.datasets.fs.gcs.GoogleCloudStorageException;
import com.dataiku.dip.exceptions.DSSInternalErrorException;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.GoogleCloudUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormat;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.dataiku.dss.shadelibgcp.com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.AbstractHttpContent;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.ByteArrayContent;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.EmptyContent;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.GenericUrl;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.HttpBackOffIOExceptionHandler;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.HttpContent;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.HttpHeaders;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.HttpIOExceptionHandler;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.HttpRequest;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.HttpRequestFactory;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.HttpResponse;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.HttpResponseException;
import com.dataiku.dss.shadelibgcp.com.google.api.client.util.BackOff;
import com.dataiku.dss.shadelibgcp.com.google.api.client.util.ExponentialBackOff;
import com.dataiku.dss.shadelibgcp.com.google.api.client.util.escape.CharEscapers;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.StringUtils;

public class GCSclient {
    private static final Map<String, String> NO_PARAMS = null;
    private static final String DSS_LAST_MODIFIED = "dss-last-modified";
    public static final String GCS_API_DEFAULT_ENDPOINT_BASE = "https://www.googleapis.com/";
    private String jsonApi;
    private static final String STORAGE_SCOPE = "https://www.googleapis.com/auth/devstorage.full_control";
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZ").withZone(DateTimeZone.UTC);
    private static final Pattern RANGE_PATTERN = Pattern.compile("^\\s*bytes\\s*=\\s*([0-9]+)\\s*-\\s*([0-9]+)$");
    public HttpRequestFactory requestFactory;
    public HttpRequestFactory patchRequestFactory;
    private final String endpointBase;
    private final GoogleCredential credentials;
    private final String project;
    private final ProxySettings proxySettings;
    private final String userAgent;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.gcs.client");

    @VisibleForTesting
    protected GCSclient() {
        this.credentials = null;
        this.project = null;
        this.proxySettings = null;
        this.endpointBase = null;
        this.userAgent = null;
    }

    public GCSclient(String project, GoogleCredential credentials, ProxySettings proxySettings, String userAgent, String endpointBase) {
        this.project = project;
        this.credentials = credentials.createScoped(Collections.singleton(STORAGE_SCOPE));
        this.proxySettings = proxySettings;
        this.userAgent = userAgent;
        this.endpointBase = endpointBase;
        this.jsonApi = (String)StringUtils.defaultIfBlank((CharSequence)endpointBase, (CharSequence)GCS_API_DEFAULT_ENDPOINT_BASE) + "storage/v1/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpRequestFactory getRequestFactory() throws IOException {
        if (this.requestFactory == null) {
            GCSclient gCSclient = this;
            synchronized (gCSclient) {
                try {
                    this.requestFactory = GoogleCloudUtils.buildRequestFactory(this.proxySettings, this.credentials, false);
                }
                catch (GeneralSecurityException e) {
                    throw new IOException(e);
                }
            }
        }
        return this.requestFactory;
    }

    private HttpRequestFactory getPatchRequestFactory() throws IOException {
        if (this.patchRequestFactory == null) {
            try {
                this.patchRequestFactory = GoogleCloudUtils.buildRequestFactory(this.proxySettings, this.credentials, true);
            }
            catch (GeneralSecurityException e) {
                throw new IOException(e);
            }
        }
        return this.patchRequestFactory;
    }

    public String getResponseAsString(String query) throws IOException {
        return this.getResponseAsString(query, NO_PARAMS);
    }

    @VisibleForTesting
    public String getResponseAsString(String query, Map<String, String> map) throws IOException {
        logger.debug((Object)("Get object " + query + " project " + this.project));
        GenericUrl url = this.buildUrl(query, map);
        url.put("project", (Object)this.project);
        HttpRequest request = this.getRequestFactory().buildGetRequest(url);
        return this.sendRequest(request);
    }

    protected String postResponseAsString(String query, Map<String, String> map) throws IOException {
        logger.debug((Object)("Post object " + query + " project " + this.project));
        GenericUrl url = this.buildUrl(query, map);
        url.put("project", (Object)this.project);
        HttpRequest request = this.getRequestFactory().buildPostRequest(url, (HttpContent)new JsonHttpContent(""));
        return this.sendRequest(request);
    }

    protected String patchResponseAsString(String query, Map<String, String> map, Object body) throws IOException {
        logger.debug((Object)("Patch object " + query + " project " + this.project));
        GenericUrl url = this.buildUrl(query, map);
        url.put("project", (Object)this.project);
        HttpRequest request = this.getPatchRequestFactory().buildPatchRequest(url, (HttpContent)new JsonHttpContent(body));
        return this.sendRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteItem(String uri) throws IOException {
        logger.debug((Object)("Delete object " + uri + " project " + this.project));
        GenericUrl url = new GenericUrl(uri);
        url.put("project", (Object)this.project);
        HttpRequest request = this.getRequestFactory().buildDeleteRequest(url);
        HttpResponse response = this.executeRequest(request);
        logger.debug((Object)"Delete executed ");
        try {
            if (response.getStatusCode() == 404) {
                logger.info((Object)("Unexpected 404 when deleting " + uri));
            } else if (!response.isSuccessStatusCode() || StringUtils.isNotBlank((CharSequence)response.parseAsString().trim())) {
                String errorMsg = String.format("Error on deletion , status code:%s , message:%s", response.getStatusCode(), response.parseAsString());
                throw new GoogleCloudStorageException(errorMsg);
            }
        }
        finally {
            response.disconnect();
        }
    }

    protected void copyItem(String bucket, String from, String to) throws IOException {
        try {
            String fromObjectDef = "b/" + bucket + "/o/" + GCSclient.urlEncode(from);
            String toObjectDef = "b/" + bucket + "/o/" + GCSclient.urlEncode(to);
            String uri = fromObjectDef + "/rewriteTo/" + toObjectDef;
            String responseAsString = this.postResponseAsString(uri, NO_PARAMS);
            GCSRewriteToResponse result = (GCSRewriteToResponse)JSON.parse((String)responseAsString, GCSRewriteToResponse.class);
            int waitTime = 5;
            while (StringUtils.isNotBlank((CharSequence)result.rewriteToken)) {
                Thread.sleep(waitTime);
                if (waitTime < 100) {
                    waitTime *= 2;
                }
                result = (GCSRewriteToResponse)JSON.parse((String)this.postResponseAsString(uri, (Map<String, String>)ImmutableMap.of((Object)"rewriteToken", (Object)result.rewriteToken)), GCSRewriteToResponse.class);
            }
            logger.info((Object)("Rewrite done " + result.done));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException();
        }
    }

    protected HttpResponse getResponse(String uri, Map<String, String> params) throws IOException {
        return this.executeRequest(this.buildGetRequest(uri, params));
    }

    protected HttpRequest buildGetRequest(String uri, Map<String, String> params) throws IOException {
        logger.debug((Object)("query " + uri));
        GenericUrl url = new GenericUrl(uri);
        logger.debug((Object)("url " + url.build()));
        if (params != null) {
            url.putAll(params);
        }
        url.put("project", (Object)this.project);
        return this.getRequestFactory().buildGetRequest(url);
    }

    protected boolean existsItem(String uri) throws IOException {
        HttpRequest request = this.buildGetRequest(uri, NO_PARAMS);
        GCSclient.configureRequest(request);
        HttpResponse response = this.executeRequest(request);
        try {
            String responseBody = response.parseAsString();
            if (response.isSuccessStatusCode()) {
                boolean bl = true;
                return bl;
            }
            if (responseBody != null && responseBody.startsWith("{")) {
                int errorCode;
                GoogleCloudUtils.GoogleCloudErrorResponse errorResponse;
                block12: {
                    errorResponse = (GoogleCloudUtils.GoogleCloudErrorResponse)JSON.parse((String)responseBody, GoogleCloudUtils.GoogleCloudErrorResponse.class);
                    int n = errorCode = errorResponse.error == null ? 0 : errorResponse.error.code;
                    if (errorCode != 404) break block12;
                    boolean bl = false;
                    return bl;
                }
                try {
                    throw new GoogleCloudStorageException(errorCode, GoogleCloudUtils.extractMessage(errorResponse));
                }
                catch (RuntimeException e2) {
                    logger.info((Object)"Failed to decode JSON error", (Throwable)e2);
                }
            }
            if (response.getStatusCode() == 404) {
                boolean bl = false;
                return bl;
            }
            throw new GoogleCloudStorageException(response.getStatusCode(), GoogleCloudUtils.extractErrorMessage(response, responseBody));
        }
        finally {
            response.disconnect();
        }
    }

    protected InitUploadResponse initUpload(String body, Map<String, String> queryParams, Map<String, Object> headers) throws IOException {
        String bucket = queryParams.get("bucket");
        logger.debug((Object)("Init upload on " + bucket));
        String uri = (String)StringUtils.defaultIfBlank((CharSequence)this.endpointBase, (CharSequence)GCS_API_DEFAULT_ENDPOINT_BASE) + "upload/storage/v1/b/" + bucket + "/o";
        GenericUrl url = new GenericUrl(uri);
        logger.debug((Object)("POST " + url.build()));
        url.putAll(queryParams);
        url.put("project", (Object)this.project);
        HttpRequest request = this.getRequestFactory().buildPostRequest(url, (HttpContent)new JsonHttpContent(body));
        HttpResponse response = this.executeRequest(request, headers);
        int statusCode = response.getStatusCode();
        String resumableSessionUri = statusCode == 200 ? response.getHeaders().getLocation() : null;
        return new InitUploadResponse(statusCode, resumableSessionUri);
    }

    protected UploadChunkResponse uploadChunk(GenericUrl url, byte[] data, int offset, int length, Map<String, Object> headers) throws IOException {
        logger.debugV("PUT %s", new Object[]{url.build()});
        HttpRequest request = this.getRequestFactory().buildPutRequest(url, (HttpContent)new ByteArrayContent("application/octet-stream", data, offset, length));
        HttpResponse response = this.executeRequest(request, headers);
        return new UploadChunkResponse(response.getStatusCode(), response.getStatusMessage(), GCSclient.parseRange(response));
    }

    protected UploadChunkResponse resumeUpload(GenericUrl url, Map<String, Object> headers) throws IOException {
        logger.debug((Object)("url " + url.build()));
        HttpRequest request = this.getRequestFactory().buildPutRequest(url, (HttpContent)new ByteArrayContent("application/octet-stream", new byte[0]));
        logger.debug((Object)("content length " + request.getContent().getLength()));
        HttpResponse response = this.executeRequest(request, headers);
        return new UploadChunkResponse(response.getStatusCode(), response.getStatusMessage(), GCSclient.parseRange(response));
    }

    protected HttpResponse cancelUpload(GenericUrl url) throws IOException {
        logger.debugV("DELETE %s", new Object[]{url.build()});
        ImmutableMap headers = ImmutableMap.of((Object)"Content-Length", (Object)ImmutableList.of((Object)"0"));
        HttpRequest request = this.getRequestFactory().buildDeleteRequest(url);
        return this.executeRequest(request, (Map<String, Object>)headers);
    }

    private static void configureRequest(HttpRequest request) {
        request.setThrowExceptionOnExecuteError(false);
        request.setIOExceptionHandler((HttpIOExceptionHandler)new HttpBackOffIOExceptionHandler((BackOff)new ExponentialBackOff()));
    }

    public List<GCSBucket> listBuckets() throws IOException {
        String resp;
        logger.info((Object)"listing GCS buckets");
        try {
            resp = this.getResponseAsString("b");
        }
        catch (Exception e) {
            logger.error((Object)"Cannot not list buckets", (Throwable)e);
            throw new IOException("Cannot not list buckets", e);
        }
        logger.debug((Object)resp);
        GCSBucketList bucketList = (GCSBucketList)JSON.parse((String)resp, GCSBucketList.class);
        for (GCSBucket gcsBucket : bucketList.items) {
            gcsBucket.setClient(this);
        }
        logger.info((Object)("Number of buckets: " + bucketList.items.size()));
        return bucketList.items;
    }

    public GCSBucket getBucket(String bucketName) throws IOException {
        GCSBucket ret;
        try {
            ret = (GCSBucket)JSON.parse((String)this.getResponseAsString("b/" + bucketName), GCSBucket.class);
        }
        catch (GoogleCloudStorageException e) {
            logger.error((Object)("Cannot find bucket " + bucketName), (Throwable)e);
            if (e.getCode() == 404) {
                throw new FileNotFoundException("Cannot find or access bucket " + bucketName);
            }
            throw new IOException("Cannot find or access bucket " + bucketName, e);
        }
        catch (IOException e) {
            throw new IOException("Cannot find or access bucket " + bucketName, e);
        }
        ret.setClient(this);
        return ret;
    }

    public GCSBucket createBucket(CreateBucketInfo createBucketInfo) throws IOException {
        try {
            ImmutableMap params = ImmutableMap.of((Object)"project", (Object)this.project);
            GCSBucket body = new GCSBucket();
            body.name = createBucketInfo.bucketName;
            body.location = createBucketInfo.location;
            body.storageClass = createBucketInfo.storageClass;
            HttpRequest request = this.getRequestFactory().buildPostRequest(this.buildUrl("b", (Map<String, String>)params), (HttpContent)new JsonHttpContent(body));
            String responseBody = this.sendRequest(request);
            GCSBucket result = (GCSBucket)JSON.parse((String)responseBody, GCSBucket.class);
            result.setClient(this);
            return result;
        }
        catch (GoogleCloudStorageException e) {
            throw e;
        }
        catch (Exception e) {
            String errorMessage = String.format("Could not create bucket '%s'. Reason: %s", createBucketInfo.bucketName, ExceptionUtils.getMessageWithCauses((Throwable)e));
            logger.error((Object)errorMessage, (Throwable)e);
            throw new GoogleCloudStorageException(errorMessage, e);
        }
    }

    private static Map<String, String> listParams(String path, int maxResult, @Nullable String pageToken) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("prefix", path);
        params.put("delimiter", "/");
        params.put("maxResults", String.valueOf(maxResult));
        if (pageToken != null) {
            params.put("pageToken", pageToken);
        }
        return params;
    }

    private static String urlEncode(String blobName) {
        return CharEscapers.escapeUriPath((String)blobName);
    }

    private String sendRequest(HttpRequest request) throws IOException {
        logger.debug((Object)(request.getRequestMethod() + " " + String.valueOf(request.getUrl())));
        HttpResponse response = this.executeRequest(request);
        try {
            String responseBody = response.parseAsString();
            if (response.isSuccessStatusCode()) {
                String string = responseBody;
                return string;
            }
            if (responseBody != null && responseBody.startsWith("{")) {
                try {
                    GoogleCloudUtils.GoogleCloudErrorResponse errorResponse = (GoogleCloudUtils.GoogleCloudErrorResponse)JSON.parse((String)responseBody, GoogleCloudUtils.GoogleCloudErrorResponse.class);
                    int errorCode = errorResponse.error == null ? 0 : errorResponse.error.code;
                    throw GCSclient.newGoogleCloudException(errorCode, GoogleCloudUtils.extractMessage(errorResponse));
                }
                catch (RuntimeException e2) {
                    logger.info((Object)"Failed to decode JSON error", (Throwable)e2);
                }
            }
            throw GCSclient.newGoogleCloudException(response.getStatusCode(), GoogleCloudUtils.extractErrorMessage(response, responseBody));
        }
        finally {
            response.disconnect();
        }
    }

    private HttpResponse executeRequest(HttpRequest request) throws IOException {
        if (this.userAgent != null) {
            HttpHeaders headers = request.getHeaders();
            headers.setUserAgent(this.userAgent);
            request.setHeaders(headers);
        }
        GCSclient.configureRequest(request);
        return request.execute();
    }

    private HttpResponse executeRequest(HttpRequest request, Map<String, Object> headers) throws IOException {
        HttpHeaders httpHeaders = request.getHeaders();
        httpHeaders.putAll(headers);
        if (this.userAgent != null) {
            httpHeaders.setUserAgent(this.userAgent);
        }
        request.setHeaders(httpHeaders);
        GCSclient.configureRequest(request);
        return request.execute();
    }

    private static GoogleCloudStorageException newGoogleCloudException(int errorCode, String errorMessage) {
        return new GoogleCloudStorageException(errorCode, errorMessage);
    }

    private GenericUrl buildUrl(String query, Map<String, String> map) {
        String uri = this.jsonApi + query;
        GenericUrl url = new GenericUrl(uri);
        if (map != null) {
            url.putAll(map);
        }
        return url;
    }

    private static Range<Long> parseRange(HttpResponse response) {
        Matcher matcher;
        String range = response.getHeaders().getRange();
        if (range != null && (matcher = RANGE_PATTERN.matcher(range)).matches()) {
            long min = Long.parseLong(matcher.group(1));
            long max = Long.parseLong(matcher.group(2));
            return Range.between((Comparable)Long.valueOf(min), (Comparable)Long.valueOf(max));
        }
        return null;
    }

    private static class JsonHttpContent
    extends AbstractHttpContent {
        private final String data;

        public JsonHttpContent(Object data) {
            super("application/json; charset=UTF-8");
            Preconditions.checkNotNull((Object)data, (Object)"data ");
            this.data = new Gson().toJson(data);
        }

        public void writeTo(OutputStream out) throws IOException {
            out.write(this.data.getBytes(Charsets.UTF_8));
        }
    }

    public static class GCSRewriteToResponse {
        String kind;
        long totalBytesRewritten;
        long objectSize;
        boolean done;
        String rewriteToken;
    }

    protected static class InitUploadResponse {
        public final int statusCode;
        public final String resumableSessionUri;

        public InitUploadResponse(int statusCode, String resumableSessionUri) {
            this.statusCode = statusCode;
            this.resumableSessionUri = resumableSessionUri;
        }
    }

    protected static class UploadChunkResponse {
        public final int statusCode;
        public final String statusMessage;
        public final Range<Long> range;

        public UploadChunkResponse(int statusCode, String statusMessage, Range<Long> range) {
            this.statusCode = statusCode;
            this.statusMessage = statusMessage;
            this.range = range;
        }
    }

    public static class GCSBucketList {
        public String kind;
        public List<GCSBucket> items;
    }

    public static class GCSBucket
    extends GCSCloudItem {
        public String projectNumber;
        public String location;
        public String storageClass;

        public List<GCSBlobFile> list() throws IOException {
            return this.list("", false);
        }

        public List<GCSBlobFile> list(String prefix, boolean recursive) throws IOException {
            HashMap<String, String> props = new HashMap<String, String>();
            ArrayList<GCSBlobFile> ret = new ArrayList<GCSBlobFile>();
            props.put("prefix", prefix);
            if (!recursive) {
                props.put("delimiter", "/");
            }
            String pageToken = null;
            do {
                props.put("pageToken", pageToken);
                GCSBlobFileList result = (GCSBlobFileList)JSON.parse((String)this.getClient().getResponseAsString("b/" + this.name + "/o", props), GCSBlobFileList.class);
                pageToken = result.nextPageToken;
                logger.info((Object)("Already have " + ret.size() + ", received page of " + (result.items.size() + result.prefixes.size()) + " elements"));
                for (GCSBlobFile file : result.items) {
                    if (file.isDirectory() && prefix.equals(file.name)) continue;
                    file.setClient(this.getClient());
                    ret.add(file);
                }
                for (String subDirectory : result.prefixes) {
                    ret.add(this.newFile(subDirectory));
                }
            } while (StringUtils.isNotBlank((CharSequence)pageToken));
            logger.info((Object)("Found " + ret.size() + " elements"));
            return ret;
        }

        public GCSBlobFile getObjectOrSubDirectory(String path, FSProvider.FSBrowseStrategy strategy) throws IOException {
            GCSBlobFileList result;
            String url = "b/" + this.name + "/o";
            GCSBlobFile file = null;
            String pageToken = null;
            if (file == null) {
                logger.debug((Object)"Listing first items");
                result = (GCSBlobFileList)JSON.parse((String)this.getClient().getResponseAsString(url, GCSclient.listParams(path, 32, null)), GCSBlobFileList.class);
                logger.debug((Object)("List returned " + result.items.size() + " objects and " + result.prefixes.size() + " sub-directories"));
                pageToken = result.nextPageToken;
                file = this.findFileOrSubDirectoryInResults(result, path, strategy);
            }
            if (file == null && StringUtils.isNotBlank(pageToken) && !StringUtils.isBlank((CharSequence)path)) {
                logger.debug((Object)"Item not found in first 32 results, checking for actual object existence");
                file = this.getObject(path, strategy);
                if (file != null) {
                    logger.debug((Object)("Found object with name " + path));
                }
            }
            while (file == null && StringUtils.isNotBlank(pageToken)) {
                logger.debug((Object)("Listing next items with prefix " + path));
                result = (GCSBlobFileList)JSON.parse((String)this.getClient().getResponseAsString(url, GCSclient.listParams(path, 512, pageToken)), GCSBlobFileList.class);
                logger.debug((Object)("List returned " + result.items.size() + " files and " + result.prefixes.size() + " sub-directories"));
                pageToken = result.nextPageToken;
                file = this.findFileOrSubDirectoryInResults(result, path, strategy);
            }
            if (file == null) {
                logger.debug((Object)("Cannot find object or sub-directory with name " + path));
            }
            return file;
        }

        public GCSBlobFile getObject(String blobName, FSProvider.FSBrowseStrategy strategy) throws IOException {
            String url = "b/" + this.name + "/o/" + GCSclient.urlEncode(blobName);
            try {
                GCSBlobFile result = (GCSBlobFile)JSON.parse((String)this.getClient().getResponseAsString(url), GCSBlobFile.class);
                if (result.isDirectory() && strategy == FSProvider.FSBrowseStrategy.FILE || !result.isDirectory() && strategy == FSProvider.FSBrowseStrategy.DIRECTORY) {
                    return null;
                }
                result.setClient(this.getClient());
                return result;
            }
            catch (HttpResponseException e) {
                if (e.getStatusCode() == 404) {
                    return null;
                }
                throw new IOException(e);
            }
            catch (GoogleCloudStorageException e) {
                if (e.getCode() == 404) {
                    return null;
                }
                throw new IOException(e);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        public GCSBlobFile getObject(String blobName) throws IOException {
            return this.getObject(blobName, FSProvider.FSBrowseStrategy.FILE_OR_DIRECTORY);
        }

        public GCSBlobFile newFile(String fileName) {
            GCSBlobFile ret = new GCSBlobFile();
            ret.name = PathUtils.slashes((String)fileName, (Boolean)false, null, (boolean)true, (String)"");
            ret.selfLink = this.selfLink + "/o/" + GCSclient.urlEncode(fileName);
            ret.bucket = this.name;
            ret.setClient(this.getClient());
            return ret;
        }

        public String getName() {
            return this.name;
        }

        public void setLastModified(String blobName, long lastModified) throws IOException {
            try {
                String query = "b/" + this.name + "/o/" + GCSclient.urlEncode(blobName);
                HashMap patch = Maps.newHashMap();
                HashMap metadata = Maps.newHashMap();
                patch.put("metadata", metadata);
                metadata.put(GCSclient.DSS_LAST_MODIFIED, DKUDateUtils.isoFormatLocal((long)lastModified));
                this.updated = this.getClient().patchResponseAsString(query, NO_PARAMS, patch);
            }
            catch (HttpResponseException e) {
                if (e.getStatusCode() != 404) {
                    throw new IOException(e);
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        public void delete() throws IOException {
            this.getClient().deleteItem(this.selfLink);
        }

        private GCSBlobFile findFileOrSubDirectoryInResults(GCSBlobFileList list, String path, FSProvider.FSBrowseStrategy strategy) {
            if (strategy == FSProvider.FSBrowseStrategy.FILE || strategy == FSProvider.FSBrowseStrategy.FILE_OR_DIRECTORY) {
                for (GCSBlobFile file : list.items) {
                    file.setClient(this.getClient());
                    if (!Objects.equals(path, PathUtils.makeNotLeadingNoTrailing((String)file.getName()))) continue;
                    logger.debug((Object)("Found object with name " + path));
                    return file;
                }
            }
            if (strategy == FSProvider.FSBrowseStrategy.DIRECTORY || strategy == FSProvider.FSBrowseStrategy.FILE_OR_DIRECTORY) {
                for (String prefix : list.prefixes) {
                    GCSBlobFile file = this.newFile(prefix);
                    if (!Objects.equals(path, PathUtils.makeNotLeadingNoTrailing((String)file.getName()))) continue;
                    logger.debug((Object)("Found sub-directory with name " + path));
                    return file;
                }
            }
            return null;
        }
    }

    public static class GCSBlobFileList {
        public String kind;
        public String nextPageToken;
        public List<GCSBlobFile> items = new ArrayList<GCSBlobFile>();
        public List<String> prefixes = new ArrayList<String>();
    }

    public static class GCSBlobFile
    extends GCSCloudItem {
        public String bucket;
        public String generation;
        public String contentType;
        public String storageClass;
        public String timeStorageClassUpdated;
        public String size;
        public String md5Hash;
        public String crc32c;

        public boolean isDirectory() {
            return this.name.endsWith("/");
        }

        private void assertNotDirectory() throws GoogleCloudStorageException {
            if (this.isDirectory()) {
                throw new GoogleCloudStorageException("The blob is a directory");
            }
        }

        public OutputStream getOutputStream(long size) throws GoogleCloudStorageException {
            this.assertNotDirectory();
            return new GCSOutputStream(this, size);
        }

        public InputStream getInputStream() throws IOException {
            this.assertNotDirectory();
            return this.getClient().getResponse(this.selfLink, (Map<String, String>)ImmutableMap.of((Object)"alt", (Object)"media")).getContent();
        }

        public void delete() throws GoogleCloudStorageException {
            try {
                this.getClient().deleteItem(this.selfLink);
            }
            catch (IOException e) {
                throw new GoogleCloudStorageException("couldn't delete blob ", e);
            }
        }

        public void copy(String to) throws GoogleCloudStorageException {
            this.assertNotDirectory();
            try {
                this.getClient().copyItem(this.bucket, this.name, to);
            }
            catch (IOException e) {
                throw new GoogleCloudStorageException("Couldn't copy blob " + this.name, e);
            }
        }

        public boolean exists() {
            try {
                return this.getClient().existsItem(this.selfLink);
            }
            catch (Exception e) {
                logger.warn((Object)"Unexpected error, assuming blob doesn't exists", (Throwable)e);
                return false;
            }
        }

        public void makeEmpty() throws IOException {
            String uri = "https://www.googleapis.com/upload/storage/v1/b/" + this.bucket + "/o?uploadType=media&name=" + GCSclient.urlEncode(this.name);
            HashMap<String, Object> headers = new HashMap<String, Object>();
            headers.put("Content-Length", Collections.singletonList(0L));
            headers.put("Content-Type", Collections.singletonList("application/octet-stream"));
            GenericUrl url = new GenericUrl(uri);
            logger.debug((Object)("url " + url.build()));
            url.put("project", (Object)this.getClient().project);
            HttpRequest request = this.getClient().getRequestFactory().buildPostRequest(url, (HttpContent)new EmptyContent());
            request.setRequestMethod("POST");
            HttpResponse resp = this.getClient().executeRequest(request, headers);
            if (resp.getStatusCode() != 200) {
                throw new IOException("Could not make blob empty");
            }
        }

        public String getName() {
            return this.name;
        }

        public long getSize() {
            if (this.isDirectory()) {
                return 0L;
            }
            return Long.valueOf(this.size);
        }

        public long getLastModified() {
            if (this.metadata != null && this.metadata.containsKey(GCSclient.DSS_LAST_MODIFIED)) {
                try {
                    return DATE_FORMAT.parseMillis((String)this.metadata.get(GCSclient.DSS_LAST_MODIFIED));
                }
                catch (Exception e) {
                    logger.debug((Object)"Unable to parse dss-last-modified metadata", (Throwable)e);
                }
            }
            return this.updated != null ? DATE_FORMAT.parseMillis(this.updated) : 0L;
        }

        public GCSBlobFile withName(String name) {
            this.name = name;
            return this;
        }
    }

    public static abstract class GCSCloudItem {
        public String kind;
        public String id;
        public String name;
        public String selfLink;
        public String timeCreated;
        public String updated;
        public String metageneration;
        public Map<String, String> metadata;
        public List<GCSCloudItemACL> acl;
        public String etag;
        private GCSclient client;

        public void setClient(GCSclient c2) {
            if (this.client != null) {
                throw new DSSInternalErrorException("Trying to allocate a GCS client twice");
            }
            this.client = c2;
        }

        protected GCSclient getClient() {
            return this.client;
        }
    }

    public static class GCSCloudItemACL {
        String king;
        String id;
        String selfLink;
        String bucket;
        String object;
        String entity;
        String role;
        String email;
        String entityId;
        String domain;
        String etag;
        long generation;
        GCSTeam projectTeam;
    }

    public static class GCSTeam {
        String projectNumber;
        String string;
    }
}

