/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.EC2Connection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.StreamDatasetUtils;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.fs.FSLikeDatasetTestHandler;
import com.dataiku.dip.datasets.fs.FSProviderFactory;
import com.dataiku.dip.datasets.fs.FSTestProvider;
import com.dataiku.dip.datasets.fs.S3DatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.input.InputSplit;
import com.dataiku.dip.input.stream.StreamsInputSplit;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class S3DatasetTestHandler
extends FSLikeDatasetTestHandler {
    @Autowired
    private PasswordEncryptionService symetricCryptoService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.input.s3");

    public S3DatasetTestHandler(AuthCtx authCtx, S3DatasetHandler handlerForData, DatasetHandler handlerForName, Dataset dataset) {
        super(authCtx, handlerForData, handlerForName, dataset);
    }

    @Override
    public InputSplit testConnection(FSLikeDatasetTestHandler.FSLikeDatasetTestResult ret) throws Exception {
        EC2Connection conn;
        BuiltinFSDatasets.S3DatasetConfig config = this.dataset.getParamsAs(BuiltinFSDatasets.S3DatasetConfig.class);
        try {
            conn = ConnectionsDAO.get().getMandatoryConnectionAs(this.handlerForData.authCtx, config.connection, EC2Connection.class);
            try (FSTestProvider testProvider = FSProviderFactory.getTestProvider(this.handlerForData.authCtx, "S3", config, conn);){
                ret.connectionMetadata.putAll(testProvider.test(false));
            }
        }
        catch (Exception e) {
            logger.warn((Object)"S3 connection test failed", (Throwable)e);
            ret.connectionError = new SerializedError((Throwable)e, false);
            return null;
        }
        if (StringUtils.isNotBlank((String)conn.params.chbucket) || StringUtils.isNotBlank((String)config.bucket)) {
            try {
                InputSplit sampleSplit = this.handlerForData.getSampleSplit();
                if (sampleSplit instanceof StreamsInputSplit) {
                    ret.empty = StreamDatasetUtils.isStreamEmpty((StreamsInputSplit)sampleSplit);
                }
                ret.connectionOK = true;
                return sampleSplit;
            }
            catch (Exception e) {
                logger.info((Object)"Connection test failed", (Throwable)e);
                ret.connectionError = new SerializedError((Throwable)e, false);
                return null;
            }
        }
        ret.connectionError = new SerializedError((Throwable)new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "S3 bucket not specified"), false);
        return null;
    }

    @Override
    public InfoMessage.InfoMessages checkManagedDatasetNameSafety(String newDatasetName) {
        S3DatasetHandler handler = (S3DatasetHandler)this.handlerForData;
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        try {
            if (handler.getProvider().stat(newDatasetName) != null) {
                ret.withWarningV((InfoMessage.MessageCode)DatasetCodes.WARN_DATASET_MANAGED_UNSAFE_NAME, "Objects already already exists under key '%s', they may get overwritten", new Object[]{newDatasetName});
            }
        }
        catch (Exception e) {
            logger.info((Object)"Failed to check if the new dataset name is safe", (Throwable)e);
            ret.withWarning((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_GENERIC_ERROR, "Failed to check if the new dataset name is safe, there could be a problem with the database: " + ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
        return ret;
    }
}

