/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.directory;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.directory.NodesDirectory;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.backend.BackendEvent;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.IsolationLevel;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NodesDirectoryService {
    @Autowired
    private PubSubService pubSubService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private PasswordEncryptionService passwordEncryptionService;
    private RelFile file = RelFile.fromPath((String)"nodes-directory.json");
    private static DKULogger logger = DKULogger.getLogger((String)"dku.nodesdirectory");

    private NodesDirectory get(TransactionRef t, boolean unsafe) throws IOException {
        if (t.exists(this.file)) {
            if (unsafe) {
                return (NodesDirectory)t.readObjectUnsafe(this.file, NodesDirectory.class);
            }
            return (NodesDirectory)t.readObject(this.file, NodesDirectory.class);
        }
        return new NodesDirectory();
    }

    public NodesDirectory getNodesDirectory_AutoTXN() {
        NodesDirectory nodesDirectory;
        block8: {
            Transaction t = this.transactionService.retrieveOrBeginRead(IsolationLevel.YOLO);
            try {
                nodesDirectory = this.get((TransactionRef)t, false);
                if (t == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (t != null) {
                        try {
                            t.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed reading nodes directory", e);
                }
            }
            t.close();
        }
        return nodesDirectory;
    }

    public NodesDirectory.NodeRef getCurrentNodeUnsafe_AutoTXN() {
        NodesDirectory nd = this.getNodesDirectoryUnsafe_AutoTXN();
        String nodeId = DKUApp.getNodeId();
        if (StringUtils.isBlank((String)nodeId)) {
            throw new IllegalArgumentException("Current node does not have a nodeid, can't look it up in the nodes directory");
        }
        return (NodesDirectory.NodeRef)nd.getById(nodeId).orElseThrow(() -> new IllegalArgumentException("Current node id not found in directory"));
    }

    public NodesDirectory getNodesDirectoryUnsafe_AutoTXN() {
        NodesDirectory nodesDirectory;
        block8: {
            Transaction t = this.transactionService.retrieveOrBeginRead(IsolationLevel.YOLO);
            try {
                nodesDirectory = this.get((TransactionRef)t, true);
                if (t == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (t != null) {
                        try {
                            t.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed reading nodes directory", e);
                }
            }
            t.close();
        }
        return nodesDirectory;
    }

    public void saveNodesDirectory(NodesDirectory newDirectory) throws IOException {
        RWTransactionRef ref = TransactionContext.retrieveWrite();
        newDirectory.encryptFields(this.passwordEncryptionService);
        ref.writeObject(this.file, (Object)newDirectory);
        this.pubSubService.publishAfterTransaction((DSSEvent)new NodesDirectoryUpdated());
    }

    public class NodesDirectoryUpdated
    extends BackendEvent {
        public static final String NAME = "nodes-directory-updated";

        public String getName() {
            return NAME;
        }
    }
}

