/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docgen.flow.placeholders.recipe;

import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowManagedFolder;
import com.dataiku.dip.dataflow.graph.FlowModelEvaluationStore;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.graph.FlowSavedModel;
import com.dataiku.dip.dataflow.graph.GraphNode;
import com.dataiku.dip.docgen.flow.FlowDocumentContext;
import com.dataiku.dip.docgen.flow.FlowPlaceholder;
import com.dataiku.dip.docgen.resolver.IterableDescription;
import com.dataiku.dip.docgen.resolver.PlaceholderExpectedException;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.mec.ModelEvaluationStore;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class RecipeInputsOutputsIterable<O>
implements FlowPlaceholder.IterablePlaceholder<SerializedRecipe, O> {
    private final Class<O> outputClazz;
    private final String replacement;
    private final boolean isOutput;

    RecipeInputsOutputsIterable(Class<O> outputClazz, String replacement, boolean isOutput) {
        this.outputClazz = outputClazz;
        this.replacement = replacement;
        this.isOutput = isOutput;
    }

    @Override
    public IterableDescription<SerializedRecipe, O> getDescription() {
        return IterableDescription.iterablePlaceholder(SerializedRecipe.class, this.outputClazz, this.replacement);
    }

    protected <T extends FlowComputable> Stream<T> getFlowItemStream(FlowDocumentContext context, SerializedRecipe recipe, Class<T> flowItemClazz) throws PlaceholderExpectedException {
        FlowRecipe fr = context.getProjectFlowGraph().getRecipe(recipe.getProjectKey(), recipe.getDisplayName());
        List<? extends GraphNode> resultAsNodes = this.isOutput ? fr.getSuccessors() : fr.getPredecessors();
        return resultAsNodes.stream().filter(flowItemClazz::isInstance).map(flowItemClazz::cast);
    }

    public static class ModelEvaluationStores
    extends RecipeInputsOutputsIterable<ModelEvaluationStore> {
        public ModelEvaluationStores(boolean isOutput) {
            super(ModelEvaluationStore.class, "$model_evaluation_store", isOutput);
        }

        @Override
        public Collection<ModelEvaluationStore> resolve(FlowDocumentContext context, SerializedRecipe recipe) throws PlaceholderExpectedException {
            return this.getFlowItemStream(context, recipe, FlowModelEvaluationStore.class).map(FlowModelEvaluationStore::getModelEvaluationStore).collect(Collectors.toList());
        }
    }

    public static class SavedModels
    extends RecipeInputsOutputsIterable<SavedModel> {
        public SavedModels(boolean isOutput) {
            super(SavedModel.class, "$model", isOutput);
        }

        @Override
        public Collection<SavedModel> resolve(FlowDocumentContext context, SerializedRecipe recipe) throws PlaceholderExpectedException {
            return this.getFlowItemStream(context, recipe, FlowSavedModel.class).map(FlowSavedModel::getSavedModel).collect(Collectors.toList());
        }
    }

    public static class Folders
    extends RecipeInputsOutputsIterable<ManagedFolder> {
        public Folders(boolean isOutput) {
            super(ManagedFolder.class, "$folder", isOutput);
        }

        @Override
        public Collection<ManagedFolder> resolve(FlowDocumentContext context, SerializedRecipe recipe) throws PlaceholderExpectedException {
            return this.getFlowItemStream(context, recipe, FlowManagedFolder.class).map(FlowManagedFolder::getManagedFolder).collect(Collectors.toList());
        }
    }

    public static class Datasets
    extends RecipeInputsOutputsIterable<SerializedDataset> {
        public Datasets(boolean isOutput) {
            super(SerializedDataset.class, "$dataset", isOutput);
        }

        @Override
        public Collection<SerializedDataset> resolve(FlowDocumentContext context, SerializedRecipe recipe) throws PlaceholderExpectedException {
            return context.getSerializedDatasets(this.getFlowItemStream(context, recipe, FlowDataset.class).collect(Collectors.toList()));
        }
    }
}

