/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards;

import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.univariate.LeveneTestNSamp;
import com.dataiku.dip.eda.compute.grouping.Grouping;
import com.dataiku.dip.eda.compute.stats.LeveneCenter;
import com.dataiku.dip.eda.worksheets.cards.bivariate_header.BivariateHistogramCard;
import com.dataiku.dip.eda.worksheets.cards.common.AbstractNSampTestCard;
import com.dataiku.dip.eda.worksheets.cards.common.CompiledCard;
import com.dataiku.dip.eda.worksheets.cards.common.RecipeCompatibleCard;
import com.dataiku.dip.eda.worksheets.models.Variable;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;

public class LeveneTestNSampCard
extends AbstractNSampTestCard
implements RecipeCompatibleCard {
    public static final String TYPE = "levene_nsamp";
    public LeveneCenter center;
    @Nullable
    public Double proportionToTrim;

    public LeveneTestNSampCard(Variable xColumn, Variable yColumn, List<String> yValues, int maxGroups, LeveneCenter center, @Nullable Double proportionToTrim) {
        this.xColumn = xColumn;
        this.yColumn = yColumn;
        this.yValues = yValues;
        this.maxGroups = maxGroups;
        this.center = center;
        this.proportionToTrim = proportionToTrim;
    }

    private LeveneTestNSampCard() {
    }

    @Override
    protected CompiledCard compileNoSplitNoFilter() {
        return new AbstractNSampTestCard.AbstractCompiledNSampTestCard(){

            @Override
            protected Computation getTestComputation(Grouping grouping) {
                return new LeveneTestNSamp(LeveneTestNSampCard.this.xColumn.name, grouping, LeveneTestNSampCard.this.center, LeveneTestNSampCard.this.proportionToTrim);
            }

            @Override
            protected LeveneTestNSampCardResult buildTestCardResult(ComputationResult result, List<String> warnings, List<AbstractNSampTestCard.GroupInfo> groups, AbstractNSampTestCard.GroupInfo allGroups, BivariateHistogramCard.BivariateHistogramData histogramData) {
                LeveneTestNSamp.LeveneTestNSampResult levene = result.as(LeveneTestNSamp.LeveneTestNSampResult.class);
                ImmutableList allWarnings = ImmutableList.builder().addAll(result.collectWarnings()).addAll(warnings).build();
                return new LeveneTestNSampCardResult((List<String>)allWarnings, groups, allGroups, histogramData, levene.pvalue, levene.statistic, levene.centers);
            }
        };
    }

    public static class LeveneTestNSampCardResult
    extends AbstractNSampTestCard.AbstractNSampleTestCardResult {
        public double pvalue;
        public double statistic;
        public double[] centers;

        public LeveneTestNSampCardResult(List<String> warnings, List<AbstractNSampTestCard.GroupInfo> groups, AbstractNSampTestCard.GroupInfo allGroups, BivariateHistogramCard.BivariateHistogramData histogramData, double pvalue, double statistic, double[] centers) {
            this.warnings = warnings;
            this.groups = groups;
            this.allGroups = allGroups;
            this.histogramData = histogramData;
            this.pvalue = pvalue;
            this.statistic = statistic;
            this.centers = centers;
        }

        private LeveneTestNSampCardResult() {
        }
    }
}

