/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.export.output;

import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dataflow.streaming.DatasetWriter;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.RowInputStream;
import com.dataiku.dip.datasets.ManagedDatasetsHelper;
import com.dataiku.dip.export.ExportParams;
import com.dataiku.dip.export.ExportService;
import com.dataiku.dip.export.output.ExportOutput;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.recipes.ManagedDatasetsCreationService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.datasets.DatasetDeletionService;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.services.NeverBuiltComputablesCacheService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsDeletionService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.utils.DKULogger;

public class ExportToDataset
implements ExportOutput {
    private DatasetAccessService datasetAccessService;
    private DatasetSaveService datasetSaveService;
    private ConnectionsDAO connectionsDAO;
    private ExportParams params;
    private Dataset outputDataset;
    private DatasetDeletionService deletionService;
    private ProjectsService projectsService;
    private TransactionService transactionService;
    private ManagedDatasetsCreationService managedDatasetsCreationService;
    private AuthCtx authCtx;
    private ColumnFactory columnFactory;
    DKULogger logger = DKULogger.getLogger(ExportToDataset.class);

    public ExportToDataset(AuthCtx authCtx, DatasetAccessService datasetAccessService, DatasetSaveService datasetSaveService, DatasetDeletionService deletionService, ProjectsService projectsService, ExportParams params, TransactionService transactionService, ConnectionsDAO connectionsDAO, ManagedDatasetsCreationService managedDatasetsCreationService) {
        this.authCtx = authCtx;
        this.datasetAccessService = datasetAccessService;
        this.datasetSaveService = datasetSaveService;
        this.params = params;
        this.deletionService = deletionService;
        this.projectsService = projectsService;
        this.transactionService = transactionService;
        this.connectionsDAO = connectionsDAO;
        this.managedDatasetsCreationService = managedDatasetsCreationService;
    }

    @Override
    public void initialize(ExportService.LocalExportJob job, Schema schema, ColumnFactory cf) throws Exception {
        this.columnFactory = cf;
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(this.params.user);){
            this.projectsService.checkPerm(this.authCtx, this.params.destinationDatasetProjectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            if (this.params.overwriteDestinationDataset) {
                this.outputDataset = this.datasetAccessService.getMandatory(this.params.destinationDatasetProjectKey, this.params.destinationDatasetName);
                if (this.outputDataset.getPartitioningSchema().isPartitioned()) {
                    throw new Exception("It is not possible to use a partitioned dataset \"" + this.params.destinationDatasetName + "\" as export output");
                }
                Dataset oldDataset = Dataset.fromSerialized(this.outputDataset.serialize());
                oldDataset.setSchema(schema);
                ManagedDatasetsHelper.copySchema(this.authCtx, oldDataset.getSchema(), this.outputDataset);
                this.datasetSaveService.save(this.params.destinationDatasetProjectKey, this.params.destinationDatasetName, this.outputDataset.serialize(), this.params.user);
                t.commit("Update schema of " + this.outputDataset.getFullName() + " before filling it with export data");
            } else {
                if (this.datasetAccessService.getOrNull(this.params.destinationDatasetProjectKey, this.params.destinationDatasetName) != null) {
                    throw new Exception("Dataset \"" + this.params.destinationDatasetName + "\" already exists");
                }
                DSSConnection connection = this.connectionsDAO.getMandatoryConnection(this.authCtx, this.params.destinationDatasetConnection);
                String outputDatasetType = connection.getMainManagedDatasetType();
                this.outputDataset = new Dataset();
                this.outputDataset.setFullName(this.params.destinationDatasetProjectKey + "." + this.params.destinationDatasetName);
                this.outputDataset.setType(outputDatasetType);
                ManagedDatasetsCreationService.ManagedDatasetCreationSpecificSettings specificSettings = new ManagedDatasetsCreationService.ManagedDatasetCreationSpecificSettings();
                specificSettings.formatOptionId = this.managedDatasetsCreationService.getDefaultFormatOption(connection);
                DatasetHandlerFactory.getMeta(this.outputDataset).fillManagedDatasetParams(this.outputDataset, connection, specificSettings);
                this.outputDataset.fixupSchemaPerDatasetConstraint(this.authCtx, schema);
                this.outputDataset.setSchema(schema);
                SerializedDataset sds = this.outputDataset.serialize();
                DatasetSaveService.DatasetCreationContext dsCtx = DatasetSaveService.DatasetCreationContext.buildDefault();
                this.datasetSaveService.create(this.params.destinationDatasetProjectKey, sds, dsCtx, this.params.user);
                TaggableObjectsService.TaggableObjectRef ref = new TaggableObjectsService.TaggableObjectRef(sds);
                ((NeverBuiltComputablesCacheService)SpringUtils.getBean(NeverBuiltComputablesCacheService.class)).remove(ref);
                t.commit("Created dataset " + this.outputDataset.getFullName() + " from export");
            }
        }
    }

    @Override
    public void stream(RowInputStream stream) throws Exception {
        try (DatasetWriter writingSession = DatasetWriter.build(this.authCtx, this.outputDataset, "", Output.WriteMode.OVERWRITE, null, this.columnFactory);){
            try {
                writingSession.appendFromRowStream(stream);
            }
            catch (Exception e) {
                try {
                    writingSession.cancel();
                }
                catch (Exception e2) {
                    this.logger.error((Object)"Unable to cancel export", (Throwable)e2);
                }
                TaggableObjectsDeletionService.DeletionOptions options = new TaggableObjectsDeletionService.DeletionOptions();
                options.dropData = true;
                options.dropMetastoreTable = false;
                this.deletionService.clearDatasetForDeletion_NT(this.authCtx, this.outputDataset, options);
                try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(this.params.user);){
                    this.deletionService.performDeletion(this.outputDataset, null, this.authCtx, false);
                    t.commit("Deleted dataset " + this.outputDataset.getFullName() + " because export failed");
                }
                throw e;
            }
        }
    }

    @Override
    public long getWrittenBytes() throws Exception {
        return -1L;
    }

    @Override
    public void close() {
    }

    @Override
    public void checkFeasability(ExportService.LocalExportJob job) {
    }
}

