/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.exposition;

import com.dataiku.dip.utils.NginxUtils;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public interface ExposedEndpointConsumer {
    public void registerPort(ExposedEndpoint var1) throws Exception;

    public void deregisterPort(ExposedEndpoint var1) throws Exception;

    public static class ExposedEndpoint {
        public String expositionType;
        public String id;
        public String scheme;
        public String host;
        public int port;
        public String path;
        public Map<String, String> proxiedHeaders;
        public ExposedEndpointAvailability availability;
        public String forcedUrl;
        public boolean shouldAddPublicApiPath = true;

        public ExposedEndpoint(String expositionType, String id, String scheme, String host, int port, String path, ExposedEndpointAvailability availability) {
            this.expositionType = expositionType;
            this.path = path;
            this.availability = availability;
            this.id = StringUtils.defaultIfBlank((String)id, (String)"");
            this.scheme = StringUtils.defaultIfBlank((String)scheme, (String)"http");
            this.host = StringUtils.defaultIfBlank((String)host, (String)"127.0.0.1");
            this.port = port;
        }

        public ExposedEndpoint(String expositionType, String id, String scheme, String host, int port, String path, ExposedEndpointAvailability availability, boolean shouldAddPublicApiPath) {
            this(expositionType, id, scheme, host, port, path, availability);
            this.shouldAddPublicApiPath = shouldAddPublicApiPath;
        }

        public String getUrl() {
            String pathPart;
            String string = pathPart = StringUtils.isNotBlank((String)this.path) ? "/" + this.path : "";
            if (StringUtils.isNotBlank((String)this.forcedUrl)) {
                return String.format("%s%s", this.forcedUrl, pathPart);
            }
            String hostPart = NginxUtils.ensureSafe((String)this.host);
            String portPart = this.port > 0 ? ":" + this.port : "";
            return String.format("%s://%s%s%s", this.scheme, hostPart, portPart, pathPart);
        }

        public Map<String, String> getProxiedHeaders() {
            if (this.proxiedHeaders == null) {
                return Maps.newHashMap();
            }
            return this.proxiedHeaders;
        }

        public ExposedEndpoint withForcedUrl(String forcedUrl) {
            this.forcedUrl = forcedUrl;
            return this;
        }

        public ExposedEndpoint withHeaders(Map<String, String> proxiedHeaders) {
            this.proxiedHeaders = proxiedHeaders;
            return this;
        }
    }

    public static enum ExposedEndpointAvailability {
        PUBLIC,
        CLUSTER,
        LOCAL;

    }
}

