/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.exposition.custom;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.custom.CustomJavaElementService;
import com.dataiku.dip.custom.PluginComponentDescValidator;
import com.dataiku.dip.exposition.ExpositionDesc;
import com.dataiku.dip.exposition.ExpositionRegistry;
import com.dataiku.dip.exposition.custom.CustomExpositionMeta;
import com.dataiku.dip.exposition.custom.LoadedExposition;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class CustomExpositionsService
extends CustomJavaElementService<ExpositionDesc, LoadedExposition> {
    @Override
    public String getFolderName() {
        return "java-expositions";
    }

    @Override
    public String getPrefix() {
        return "exposition";
    }

    @Override
    protected String getCodeExtension(LoadedExposition desc) {
        return ".java";
    }

    @Override
    protected void removeElement(LoadedExposition desc) {
        ExpositionRegistry.deregister(desc.expositionType);
    }

    @Override
    protected String makeType(String pluginId, String elementId) {
        return "jexposition_" + pluginId + "_" + elementId;
    }

    @Override
    protected LoadedExposition load(String elementType, String pluginId, String elementId, File file) throws IOException {
        LoadedExposition loaded = new LoadedExposition(elementType, pluginId, elementId, (ExpositionDesc)JSON.parseFile((File)file, ExpositionDesc.class));
        CustomExpositionMeta meta = new CustomExpositionMeta(loaded, this);
        ExpositionRegistry.register(meta);
        return loaded;
    }

    @Override
    public Class<ExpositionDesc> getDescClass() {
        return ExpositionDesc.class;
    }

    @Override
    public Class<LoadedExposition> getLoadedDescClass() {
        return LoadedExposition.class;
    }

    @Override
    public InfoMessage.InfoMessages validate(String componentId, String pluginId, final ExpositionDesc desc) {
        return new PluginComponentDescValidator(componentId){

            @Override
            public InfoMessage.InfoMessages validate() {
                this.genericValidateMeta(desc.meta);
                if (StringUtils.isBlank((String)desc.metaClass)) {
                    this.withFatal("Java plugin exposition require a \"metaClass\" field.");
                }
                return this.messages;
            }
        }.validate();
    }
}

