/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.expressions;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.expressions.ExpressionError;
import com.dataiku.dip.expressions.PreviousRowsRequirements;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.shaker.types.DatetimeNoTz;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.LocalDate;
import com.dataiku.dss.shadelib.org.joda.time.LocalDateTime;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInstant;
import com.dataiku.dss.shadelib.org.joda.time.ReadablePartial;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.dataiku.dss.shadelib.org.joda.time.format.ISODateTimeFormat;
import com.google.gson.JsonArray;
import com.google.gson.JsonPrimitive;
import com.google.refine.expr.EvalError;
import com.google.refine.expr.Evaluable;
import com.google.refine.expr.ExpressionUtils;
import com.google.refine.expr.ParsingException;
import com.google.refine.expr.functions.Get;
import com.google.refine.expr.functions.aggregations.AggregatedFunction;
import com.google.refine.expr.functions.arrays.ArgsToArray;
import com.google.refine.grel.ControlFunctionRegistry;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.GrelControlFunctionRegistry;
import com.google.refine.grel.Parser;
import com.google.refine.grel.ast.ControlCallExpr;
import com.google.refine.grel.ast.FieldAccessorExpr;
import com.google.refine.grel.ast.FunctionCallExpr;
import com.google.refine.grel.ast.LiteralExpr;
import com.google.refine.grel.ast.OperatorCallExpr;
import com.google.refine.grel.ast.VariableExpr;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class Expression {
    private static final String VARIABLES_KEYWORD = "variables";
    private static final String DELIMITER = ", ";
    private static final List<String> CONCAT_OPERATORS = Collections.singletonList("+");
    private static final List<String> ARITHMETIC_OPERATORS = Arrays.asList("+", "-", "*", "/", "//", "%");
    private static final List<String> HIGH_PRIORITY_ARITHMETIC_OPERATORS = Arrays.asList("*", "/", "//", "%");
    private static final List<String> LOW_PRIORITY_ARITHMETIC_OPERATORS = Arrays.asList("+", "-");
    public Evaluable evaluable;
    public VariablesContext variablesContext;
    private final Schema schema;
    private final SQLQueryWithSchema sqlQueryWithSchema;
    private final DateTimeFormatter isoFormatter = ISODateTimeFormat.dateTime().withZone(DateTimeZone.UTC);
    private final DateTimeFormatter dateOnlyFormatter = ISODateTimeFormat.date().withZone(DateTimeZone.UTC);
    private final DateTimeFormatter datetimeNoTzFormatter = DatetimeNoTz.CANONICAL_FORMATTER;
    private ColumnFactory cf;
    private String strExpression = "";
    private int rowIndex;
    private static final Logger logger = Logger.getLogger((String)"dku.grelExpression");

    public Expression(String strExpression) {
        this(strExpression, (Schema)null);
    }

    public Expression(String strExpression, ControlFunctionRegistry registryOverride) {
        this(strExpression, null, null, null, false, true, registryOverride);
    }

    public Expression(String strExpression, Schema schema) {
        this(strExpression, schema, null);
    }

    public Expression(String strExpression, SQLQueryWithSchema sqlQueryWithSchema) {
        this(strExpression, sqlQueryWithSchema, sqlQueryWithSchema.getCurrentSchema(), null, false, false);
    }

    public Expression(String strExpression, Schema schema, Properties bindings) {
        this(strExpression, null, schema, bindings, false, false);
    }

    public Expression(String strExpression, SQLQueryWithSchema sqlQueryWithSchema, Schema schema, Properties bindings, boolean avoidRepeatingFormulaInError) {
        this(strExpression, sqlQueryWithSchema, schema, bindings, avoidRepeatingFormulaInError, false);
    }

    public Expression(String strExpression, SQLQueryWithSchema sqlQueryWithSchema, Schema schema, Properties bindings, boolean avoidRepeatingFormulaInError, boolean avoidIncorrectFormulaPrefix) {
        this(strExpression, sqlQueryWithSchema, schema, bindings, avoidRepeatingFormulaInError, avoidIncorrectFormulaPrefix, GrelControlFunctionRegistry.getInstance());
    }

    public Expression(String strExpression, SQLQueryWithSchema sqlQueryWithSchema, Schema schema, Properties bindings, boolean avoidRepeatingFormulaInError, boolean avoidIncorrectFormulaPrefix, ControlFunctionRegistry registry) {
        if (strExpression != null && !strExpression.isEmpty()) {
            try {
                Parser p = new Parser(strExpression, registry);
                this.evaluable = p.getExpression();
                this.strExpression = strExpression;
            }
            catch (ParsingException e) {
                String prefix;
                String string = prefix = avoidIncorrectFormulaPrefix ? "" : "Incorrect formula: ";
                if (avoidRepeatingFormulaInError) {
                    throw new IllegalArgumentException(prefix + e.getMessage(), e);
                }
                throw new IllegalArgumentException(prefix + "'" + strExpression + "' : " + e.getMessage(), e);
            }
        }
        this.sqlQueryWithSchema = sqlQueryWithSchema;
        this.schema = schema;
        this.checkVariables(bindings);
    }

    public String getString() {
        return this.strExpression;
    }

    public void setColumnFactory(ColumnFactory cf) {
        this.cf = cf;
    }

    public void setVariablesContext(VariablesContext vc) {
        this.variablesContext = vc;
    }

    public Object evaluate(Row row) {
        return this.evaluate(row, null);
    }

    public Object evaluate(Row row, @Nullable List<Map<String, Object>> previousRows) {
        if (this.isEmpty()) {
            return null;
        }
        assert (this.cf != null);
        Properties bindings = new Properties();
        ExpressionUtils.bind(bindings, this.cf, row, this.rowIndex++, null, this.variablesContext, previousRows);
        return this.evaluate(bindings);
    }

    public Object evaluateWithRawTypes(Row row) {
        if (this.isEmpty()) {
            return null;
        }
        assert (this.cf != null);
        Properties bindings = new Properties();
        ExpressionUtils.bind(bindings, this.cf, row, this.rowIndex++, null, this.variablesContext, null);
        return this.evaluateWithRawTypes(bindings);
    }

    public boolean isTrueish(Row row) {
        Object o = this.evaluate(row);
        return o != null && !o.equals(false) && !o.equals(0) && (!(o instanceof String) || !((String)o).isEmpty() && !((String)o).equalsIgnoreCase("false")) && !(o instanceof ExpressionError) && !(o instanceof EvalError);
    }

    private Object evaluateWithRawTypes(Properties bindings) {
        if (this.isEmpty()) {
            return null;
        }
        Object out = this.evaluable.evaluate(bindings);
        if (out != null) {
            if (out instanceof EvalError) {
                out = new ExpressionError((EvalError)out);
            } else if (out instanceof DateTime) {
                out = this.isoFormatter.print((ReadableInstant)((DateTime)out));
            } else if (out instanceof Date) {
                out = this.isoFormatter.print(((Date)out).getTime());
            }
        }
        return out;
    }

    private Object evaluate(Properties bindings) {
        if (this.isEmpty()) {
            return null;
        }
        Object out = this.evaluable.evaluate(bindings);
        if (out != null) {
            if (out instanceof EvalError) {
                out = new ExpressionError((EvalError)out);
            } else if (out instanceof DateTime) {
                out = this.isoFormatter.print((ReadableInstant)((DateTime)out));
            } else if (out instanceof Date) {
                out = this.isoFormatter.print(((Date)out).getTime());
            } else if (out instanceof LocalDate) {
                LocalDate localDate = (LocalDate)out;
                out = this.dateOnlyFormatter.print((ReadablePartial)localDate);
            } else if (out instanceof LocalDateTime) {
                LocalDateTime localDateTime = (LocalDateTime)out;
                out = this.datetimeNoTzFormatter.print((ReadablePartial)localDateTime);
            } else if (out instanceof Object[]) {
                out = JSON.json((Object)out);
            } else if (out instanceof List) {
                out = JSON.json((Object)out);
            } else if (out instanceof JsonArray) {
                out = JSON.json((Object)out);
            } else if (out instanceof JsonPrimitive) {
                JsonPrimitive primitive = (JsonPrimitive)out;
                if (primitive.isBoolean()) {
                    out = primitive.getAsBoolean();
                } else if (primitive.isString()) {
                    out = primitive.getAsString();
                } else if (primitive.isNumber()) {
                    out = primitive.getAsNumber();
                }
            }
        }
        return out;
    }

    public String makeAcceptable(String columnName) {
        if (this.sqlQueryWithSchema != null) {
            return this.sqlQueryWithSchema.makeAcceptable(columnName);
        }
        return columnName;
    }

    public SchemaColumn getSchemaColumnIfKnown(String columnName) {
        if (this.sqlQueryWithSchema != null) {
            return this.sqlQueryWithSchema.getCurrentColumn(columnName);
        }
        if (this.schema != null) {
            return this.schema.getColumn(columnName);
        }
        return null;
    }

    private void checkVariables(Properties bindings) {
        if (this.schema == null) {
            return;
        }
        List<String> vars = this.getVariables();
        for (String variable : vars) {
            SchemaColumn col;
            if (VARIABLES_KEYWORD.equals(variable)) continue;
            variable = this.makeAcceptable(variable);
            if (bindings != null && bindings.containsKey(variable) || (col = this.schema.getColumn(variable)) != null) continue;
            String suggestion = this.getColumnSuggestion(variable);
            String errorMsg = "Column \"" + variable + "\" doesn't exist. ";
            if (suggestion != null) {
                errorMsg = errorMsg + "Did you mean \"" + suggestion + "\"?";
            }
            throw new IllegalArgumentException(errorMsg);
        }
    }

    private String getColumnSuggestion(String name) {
        if (StringUtils.isBlank((String)name)) {
            return null;
        }
        int minLevenshtein = Integer.MAX_VALUE;
        String suggestion = null;
        for (SchemaColumn sc : this.schema.columns) {
            int distance = StringUtils.getLevenshteinDistance((String)name, (String)sc.getName());
            if (distance >= minLevenshtein || !((double)distance < (double)name.length() * 0.55)) continue;
            minLevenshtein = distance;
            suggestion = sc.getName();
        }
        return suggestion;
    }

    public boolean isEmpty() {
        return this.evaluable == null;
    }

    public List<String> getVariables() {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            Expression.getVariablesRec(this.evaluable, ret, false);
        }
        catch (Exception e) {
            logger.info((Object)"Failed to gather GREL column info", (Throwable)e);
        }
        return ret;
    }

    public static void getVariablesRec(Evaluable ev, List<String> list, boolean literalAsColumnName) throws SecurityException, IllegalArgumentException {
        boolean treatFirstArgumentAsColumnName = false;
        Evaluable[] args = null;
        if (ev instanceof ControlCallExpr) {
            args = ((ControlCallExpr)ev)._args;
        } else if (ev instanceof FunctionCallExpr) {
            FunctionCallExpr functionCallExpr = (FunctionCallExpr)ev;
            args = functionCallExpr._args;
            treatFirstArgumentAsColumnName = functionCallExpr._function.treatFirstArgumentAsColumnName();
        } else if (ev instanceof OperatorCallExpr) {
            args = ((OperatorCallExpr)ev)._args;
        } else if (!(ev instanceof FieldAccessorExpr)) {
            String variableName;
            if (ev instanceof LiteralExpr) {
                Object literalExprValue = ((LiteralExpr)ev)._value;
                if (literalExprValue != null && literalAsColumnName) {
                    list.add(literalExprValue.toString());
                }
            } else if (ev instanceof VariableExpr && !VARIABLES_KEYWORD.equals(variableName = ev.toString())) {
                list.add(variableName);
            }
        }
        if (args != null) {
            int evaluablesLength = args.length;
            for (int i = 0; i < evaluablesLength; ++i) {
                Expression.getVariablesRec(args[i], list, i == 0 && treatFirstArgumentAsColumnName);
            }
        }
    }

    public boolean hasPlusWithNotNumeric() {
        return Expression.hasArithmeticOperatorWithNotNumeric(this.evaluable, this.cf, false, CONCAT_OPERATORS);
    }

    public boolean hasArithmeticOperatorWithNotNumeric() {
        return Expression.hasArithmeticOperatorWithNotNumeric(this.evaluable, this.cf, false, ARITHMETIC_OPERATORS);
    }

    private static boolean hasArithmeticOperatorWithNotNumeric(Evaluable ev, ColumnFactory cf, boolean checkType, List<String> operatorsToCheck) {
        if (ev instanceof ControlCallExpr) {
            for (Evaluable arg : ((ControlCallExpr)ev)._args) {
                if (!Expression.hasArithmeticOperatorWithNotNumeric(arg, cf, false, operatorsToCheck)) continue;
                return true;
            }
            return false;
        }
        if (ev instanceof FunctionCallExpr) {
            FunctionCallExpr functionCallExpr = (FunctionCallExpr)ev;
            Documentation documentation = functionCallExpr._function.getDocumentation();
            for (Evaluable arg : functionCallExpr._args) {
                if (!Expression.hasArithmeticOperatorWithNotNumeric(arg, cf, checkType && documentation != null && !"number".equalsIgnoreCase(documentation.returns), operatorsToCheck)) continue;
                return true;
            }
            return false;
        }
        if (ev instanceof OperatorCallExpr) {
            OperatorCallExpr operatorCallExpr = (OperatorCallExpr)ev;
            for (Evaluable arg : operatorCallExpr._args) {
                boolean isArithmeticOperator = operatorsToCheck.contains(operatorCallExpr._op);
                if (!Expression.hasArithmeticOperatorWithNotNumeric(arg, cf, isArithmeticOperator, operatorsToCheck)) continue;
                return true;
            }
            return false;
        }
        if (ev instanceof FieldAccessorExpr) {
            return checkType;
        }
        if (ev instanceof LiteralExpr && checkType) {
            return !(((LiteralExpr)ev)._value instanceof Number);
        }
        if (ev instanceof VariableExpr && checkType) {
            return Expression.isVariableNotNumeric((VariableExpr)ev, cf);
        }
        return false;
    }

    private static boolean isVariableNotNumeric(VariableExpr ev, ColumnFactory cf) {
        String columnName = ev.getName();
        Column cfColumn = cf.getColumn(columnName);
        if (cfColumn instanceof MemColumn) {
            MemColumn column = (MemColumn)cfColumn;
            SchemaColumn schemaColumn = column.recipeSchemaColumn != null ? column.recipeSchemaColumn.column : column.datasetSchemaColumn;
            return schemaColumn != null && !schemaColumn.getType().isNumeric();
        }
        return false;
    }

    private static boolean isNotNumeric(Evaluable ev, ColumnFactory cf) {
        if (ev instanceof ControlCallExpr) {
            for (Evaluable arg : ((ControlCallExpr)ev)._args) {
                if (!Expression.isNotNumeric(arg, cf)) continue;
                return true;
            }
            return false;
        }
        if (ev instanceof FunctionCallExpr) {
            FunctionCallExpr functionCallExpr = (FunctionCallExpr)ev;
            Documentation documentation = functionCallExpr._function.getDocumentation();
            return documentation != null && !"number".equalsIgnoreCase(documentation.returns);
        }
        if (ev instanceof OperatorCallExpr) {
            OperatorCallExpr operatorCallExpr = (OperatorCallExpr)ev;
            for (Evaluable arg : operatorCallExpr._args) {
                if (!Expression.isNotNumeric(arg, cf)) continue;
                return true;
            }
            return false;
        }
        if (ev instanceof FieldAccessorExpr) {
            return true;
        }
        if (ev instanceof LiteralExpr) {
            return !(((LiteralExpr)ev)._value instanceof Number);
        }
        if (ev instanceof VariableExpr) {
            return Expression.isVariableNotNumeric((VariableExpr)ev, cf);
        }
        return false;
    }

    private static boolean isNotNumeric(Evaluable[] evaluables, ColumnFactory cf) {
        for (Evaluable evaluable : evaluables) {
            if (!Expression.isNotNumeric(evaluable, cf)) continue;
            return true;
        }
        return false;
    }

    public void fixup(String fixName) {
        if ("arithmeticOperators".equals(fixName)) {
            this.fixupArithmeticOperators();
        } else {
            this.fixupPlus();
        }
    }

    public void fixupPlus() {
        this.evaluable = Expression.fixEvaluablePlus(this.evaluable, this.cf);
        this.strExpression = Expression.prettyPrint(this.evaluable);
    }

    private static Evaluable[] fixEvaluablePlus(Evaluable[] evs, ColumnFactory cf) {
        return (Evaluable[])Arrays.stream(evs).map(ev -> Expression.fixEvaluablePlus(ev, cf)).toArray(Evaluable[]::new);
    }

    private static Evaluable fixEvaluablePlus(Evaluable ev, ColumnFactory cf) {
        if (ev instanceof ControlCallExpr) {
            ControlCallExpr ctrlExpr = (ControlCallExpr)ev;
            return new ControlCallExpr(Expression.fixEvaluablePlus(ctrlExpr._args, cf), ctrlExpr._control);
        }
        if (ev instanceof FunctionCallExpr) {
            FunctionCallExpr funcExpr = (FunctionCallExpr)ev;
            return new FunctionCallExpr(Expression.fixEvaluablePlus(funcExpr._args, cf), funcExpr._function);
        }
        if (ev instanceof OperatorCallExpr) {
            OperatorCallExpr opExpr = (OperatorCallExpr)ev;
            if (Objects.equals(opExpr._op, "+") && Expression.isNotNumeric(opExpr._args, cf)) {
                return new FunctionCallExpr(Expression.fixEvaluablePlus(opExpr._args, cf), GrelControlFunctionRegistry.getInstance().getFunction("concat"));
            }
            return new OperatorCallExpr(Expression.fixEvaluablePlus(opExpr._args, cf), opExpr._op);
        }
        if (ev instanceof FieldAccessorExpr) {
            FieldAccessorExpr fieldExpr = (FieldAccessorExpr)ev;
            return new FieldAccessorExpr(Expression.fixEvaluablePlus(fieldExpr._inner, cf), fieldExpr._fieldName);
        }
        return ev;
    }

    public void fixupArithmeticOperators() {
        this.evaluable = Expression.fixEvaluableArithmeticOperators(this.evaluable, this.cf);
        this.strExpression = Expression.prettyPrint(this.evaluable);
    }

    private static Evaluable[] fixEvaluableArithmeticOperators(Evaluable[] evs, ColumnFactory cf) {
        return (Evaluable[])Arrays.stream(evs).map(ev -> Expression.fixEvaluableArithmeticOperators(ev, cf)).toArray(Evaluable[]::new);
    }

    private static Evaluable fixEvaluableArithmeticOperators(Evaluable ev, ColumnFactory cf) {
        if (ev instanceof OperatorCallExpr) {
            OperatorCallExpr opExpr = (OperatorCallExpr)ev;
            if (Expression.isHighPriorityArithmeticOperator(opExpr) && Expression.isNotNumeric(opExpr._args, cf)) {
                Evaluable[] fixedArgs = Expression.fixEvaluableArithmeticOperators(opExpr._args, cf);
                if (Expression.isNotNumeric(fixedArgs, cf)) {
                    return new OperatorCallExpr(Expression.toNumberWrapper(fixedArgs, cf), opExpr._op);
                }
                return new OperatorCallExpr(fixedArgs, opExpr._op);
            }
            return new OperatorCallExpr(Expression.fixEvaluableArithmeticOperators(opExpr._args, cf), opExpr._op);
        }
        if (ev instanceof ControlCallExpr) {
            ControlCallExpr ctrlExpr = (ControlCallExpr)ev;
            return new ControlCallExpr(Expression.fixEvaluableArithmeticOperators(ctrlExpr._args, cf), ctrlExpr._control);
        }
        if (ev instanceof FunctionCallExpr) {
            FunctionCallExpr funcExpr = (FunctionCallExpr)ev;
            return new FunctionCallExpr(Expression.fixEvaluableArithmeticOperators(funcExpr._args, cf), funcExpr._function);
        }
        if (ev instanceof FieldAccessorExpr) {
            FieldAccessorExpr fieldExpr = (FieldAccessorExpr)ev;
            return new FieldAccessorExpr(Expression.fixEvaluableArithmeticOperators(fieldExpr._inner, cf), fieldExpr._fieldName);
        }
        return ev;
    }

    private static boolean isHighPriorityArithmeticOperator(Evaluable ev) {
        return ev instanceof OperatorCallExpr && HIGH_PRIORITY_ARITHMETIC_OPERATORS.contains(((OperatorCallExpr)ev)._op);
    }

    private static boolean isLowPriorityArithmeticOperator(Evaluable ev) {
        return ev instanceof OperatorCallExpr && LOW_PRIORITY_ARITHMETIC_OPERATORS.contains(((OperatorCallExpr)ev)._op);
    }

    private static Evaluable[] toNumberWrapper(Evaluable[] evs, ColumnFactory cf) {
        return (Evaluable[])Arrays.stream(evs).map(ev -> Expression.toNumberWrapper(ev, cf)).toArray(Evaluable[]::new);
    }

    private static Evaluable toNumberWrapper(Evaluable ev, ColumnFactory cf) {
        if (Expression.isNotNumeric(ev, cf)) {
            return new FunctionCallExpr(new Evaluable[]{ev}, GrelControlFunctionRegistry.getInstance().getFunction("toNumber"));
        }
        return ev;
    }

    private static String prettyPrint(Evaluable ev) {
        return Expression.prettyPrint(ev, null);
    }

    private static String prettyPrint(Evaluable ev, @Nullable Evaluable parent) {
        if (ev instanceof ControlCallExpr) {
            StringJoiner joiner = new StringJoiner(DELIMITER);
            for (Evaluable arg : ((ControlCallExpr)ev)._args) {
                joiner.add(Expression.prettyPrint(arg));
            }
            return StringUtils.uncapitalize((String)((ControlCallExpr)ev)._control.getClass().getSimpleName()) + "(" + String.valueOf(joiner) + ")";
        }
        if (ev instanceof FunctionCallExpr) {
            return Expression.functionCall((FunctionCallExpr)ev);
        }
        if (ev instanceof OperatorCallExpr) {
            StringJoiner joiner = new StringJoiner(" " + ((OperatorCallExpr)ev)._op + " ");
            for (Evaluable arg : ((OperatorCallExpr)ev)._args) {
                joiner.add(Expression.prettyPrint(arg, ev));
            }
            String result = joiner.toString().trim();
            return Expression.isLowPriorityArithmeticOperator(ev) && Expression.isHighPriorityArithmeticOperator(parent) ? "(" + result + ")" : result;
        }
        if (ev instanceof FieldAccessorExpr) {
            return Expression.prettyPrint(((FieldAccessorExpr)ev)._inner) + "." + ((FieldAccessorExpr)ev)._fieldName;
        }
        if (ev instanceof VariableExpr || ev instanceof LiteralExpr) {
            return ev.toString();
        }
        return ev.toString();
    }

    private static String functionCall(FunctionCallExpr ev) {
        ArrayList<String> args = new ArrayList<String>(ev._args.length);
        for (Evaluable arg : ev._args) {
            args.add(Expression.prettyPrint(arg));
        }
        if (ev._function instanceof Get && args.size() == 2) {
            return (String)args.get(0) + "[" + (String)args.get(1) + "]";
        }
        String argsJoined = String.join((CharSequence)DELIMITER, args);
        if (ev._function instanceof ArgsToArray) {
            return "[" + argsJoined + "]";
        }
        String name = ev._function.getClass().getSimpleName();
        if (ev._function instanceof AggregatedFunction) {
            name = ((AggregatedFunction)ev._function).prettyName();
        }
        return StringUtils.uncapitalize((String)name) + "(" + argsJoined + ")";
    }

    public boolean requirePreviousRows() {
        return new PreviousRowsRequirements(this.evaluable).requirePreviousRows();
    }

    public Map<String, Integer> getNumberOfPreviousRowsRequiredByColumns() {
        return new PreviousRowsRequirements(this.evaluable).getCountByColumns();
    }
}

