/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.externalinfras.azureml.datamodel;

import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLVersionedResource;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLVersionedResourceIdentifier;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

public class AzureMLEnvironment
extends AzureMLVersionedResource {
    private static final String CONFIG_YAML_IMAGE_FIELD = "__AZ_ENVIRONMENT_IMAGE__";
    private static final String CONFIG_YAML_READINESS_ROUTE_FIELD = "__AZ_READINESS_ROUTE__";
    public static final String AZUREML_ENVIRONMENT_RESOURCE = "environment";
    public static final String AZUREML_ENVIRONMENT_RESOURCE_LABEL = "Environment";
    public static final int ENVIRONMENT_NAME_MAX_LENGTH = 255;
    public String image;
    @Nullable
    private String serviceId;

    public AzureMLEnvironment() {
    }

    public AzureMLEnvironment(AzureMLVersionedResourceIdentifier resourceId) {
        super(resourceId);
    }

    public AzureMLEnvironment(AzureMLVersionedResourceIdentifier resourceId, String serviceId) {
        super(resourceId);
        this.serviceId = serviceId;
    }

    @Override
    public String getResourceType() {
        return AZUREML_ENVIRONMENT_RESOURCE;
    }

    @Override
    public String getResourceTypeLabel() {
        return AZUREML_ENVIRONMENT_RESOURCE_LABEL;
    }

    private String replaceReadinessRouteYamlField(String yaml) {
        String isAliveRoute = "/isAlive";
        if (Objects.nonNull(this.serviceId)) {
            isAliveRoute = String.format("/monitoring/api/%s/isAliveSimple", this.serviceId);
        }
        return yaml.replace(CONFIG_YAML_READINESS_ROUTE_FIELD, isAliveRoute);
    }

    @Override
    public String toYamlConfig() throws IOException {
        String yaml = super.replaceBaseYamlFields().replace(CONFIG_YAML_IMAGE_FIELD, this.image);
        return this.replaceReadinessRouteYamlField(yaml);
    }
}

