/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.formats;

import com.dataiku.common.stereotype.PartOfPublicAPI;
import com.dataiku.dip.BuiltinsLoader;
import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datasets.SerializedDatasetAdapter;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.UnavailableDSSObjectException;
import com.dataiku.dip.formats.FormatCodes;
import com.dataiku.dip.formats.FormatMeta;
import com.dataiku.dip.formats.custom.CustomJavaFormatMeta;
import com.dataiku.dip.formats.custom.CustomPythonFormatMeta;
import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.input.formats.FormatExtractor;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.ParamDesc;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class FormatFactory {
    private static final Map<String, FormatMeta<?, ?>> formatsLibrary = new LinkedHashMap();

    public static FormatExtractor buildExtractor(String type, FormatParams params, AuthCtx authCtx, String projectKey) throws CodedException {
        return FormatFactory.getMeta(type).build(authCtx, projectKey, params);
    }

    public static OutputFormatter buildFormatter(AuthCtx authCtx, String projectKey, String type, FormatParams params) {
        return FormatFactory.getMeta(type).buildFormatter(authCtx, projectKey, params);
    }

    public static synchronized FormatMeta<?, ?> getMeta(String type) {
        if (formatsLibrary.containsKey(type)) {
            return formatsLibrary.get(type);
        }
        if (StringUtils.isBlank((String)type)) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)FormatCodes.ERR_FORMAT_TYPE_MISSING, "Missing format type");
        }
        if (type.startsWith("format_") || type.startsWith("jformat_")) {
            throw UnavailableDSSObjectException.fromObjectTypeAndType("format", type);
        }
        if ("excel".equals(type) && !BuiltinsLoader.apachePoiAvailable()) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)FormatCodes.ERR_FORMAT_EXCEL_NOT_SUPPORTED_WITH_JAVA7, "Unsupported file format: " + type);
        }
        throw new Error("Unknown format type: " + type);
    }

    public static synchronized boolean has(String type) {
        return formatsLibrary.containsKey(type);
    }

    public static synchronized Iterable<FormatMeta<?, ?>> getAllMeta() {
        return new ArrayList(formatsLibrary.values());
    }

    public static synchronized void registerFormatType(FormatMeta<?, ?> meta) {
        SerializedDatasetAdapter.registerFormatType(meta.getType(), meta.paramsClass());
        formatsLibrary.put(meta.getType(), meta);
    }

    public static synchronized void deregisterFormatType(String type) {
        SerializedDatasetAdapter.deregisterFormatType(type);
        formatsLibrary.remove(type);
    }

    public static List<String> getCommonCharsetsInRankingOrder() {
        return Lists.newArrayList((Object[])new String[]{"utf8", "iso-8859-1", "iso-8859-15", "ascii", "utf-16", "utf-16BE", "utf-16LE", "utf-32", "utf-32BE", "utf-32LE", "cp1252", "Big5"});
    }

    public static ParamDesc getStandardCompressionMethods() {
        return ParamDesc.advancedSelect("compress", "File Compression", "Algorithm used for file compression", new String[]{"", "gz"}, new String[]{"None", "GZip"});
    }

    public static ParamDesc getStandardCompressionMethods(TranslationService translationService, String lang) {
        if (translationService == null) {
            return FormatFactory.getStandardCompressionMethods();
        }
        return ParamDesc.advancedSelect("compress", translationService.translateNoContext(lang, "STANDARD_COMPRESSION_METHODS.LABEL", "File Compression", new Object[0]), translationService.translateNoContext(lang, "STANDARD_COMPRESSION_METHODS.DESCRIPTION", "Algorithm used for file compression", new Object[0]), new String[]{"", "gz"}, new String[]{translationService.translateNoContext(lang, "STANDARD_COMPRESSION_METHODS.NONE", "None", new Object[0]), "GZip"});
    }

    @PartOfPublicAPI
    public static class SerializedCustomFormatType
    extends SerializedFormatType {
        public final String ownerPluginId;

        public SerializedCustomFormatType(CustomJavaFormatMeta t, TranslationService translationService, String lang) {
            super(t, translationService, lang);
            this.ownerPluginId = t.getLoadedDesc().getOwnerPluginId();
        }

        public SerializedCustomFormatType(CustomPythonFormatMeta t, TranslationService translationService, String lang) {
            super(t, translationService, lang);
            this.ownerPluginId = t.getLoadedDesc().getOwnerPluginId();
        }
    }

    @PartOfPublicAPI
    public static class SerializedFormatType {
        public final String name;
        public final String description;
        public final ParamDesc[] params;

        public SerializedFormatType(FormatMeta<?, ?> t, TranslationService translationService, String lang) {
            t.setTranslation(translationService, lang);
            this.name = t.getType();
            this.description = t.getLabel();
            this.params = t.getParams();
        }
    }
}

