/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.formats.excel.xssfb;

import com.dataiku.dip.formats.excel.xssfb.XSSFBCellHeader;
import com.dataiku.dip.formats.excel.xssfb.XSSFBCellStyle;
import com.dataiku.dip.formats.excel.xssfb.XSSFBNumberUtils;
import com.dataiku.dip.formats.excel.xssfb.XSSFBStylesTable;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.BuiltinFormats;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.CellType;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.DataFormatter;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.RichTextString;
import com.dataiku.dss.shadelibpoi.org.apache.poi.util.LittleEndian;
import com.dataiku.dss.shadelibpoi.org.apache.poi.util.LittleEndianInputStream;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.binary.XSSFBParseException;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.binary.XSSFBRecordType;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.binary.XSSFBUtils;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.model.SharedStrings;
import java.io.IOException;
import java.io.InputStream;

public class XSSFBSheetHandler {
    private final SharedStrings stringsTable;
    private final XSSFBSheetContentHandler handler;
    private final XSSFBStylesTable styles;
    private final DataFormatter dataFormatter;
    private final byte[] rkBuffer = new byte[8];
    private final StringBuilder xlWideStringBuffer = new StringBuilder();
    private final XSSFBCellHeader cellBuffer = new XSSFBCellHeader();
    private final boolean use1904Dates;
    private final LittleEndianInputStream is;
    private int lastEndedRow = -1;
    private int lastStartedRow = -1;
    private int currentRow;

    public XSSFBSheetHandler(InputStream is, XSSFBStylesTable styles, SharedStrings stringTable, XSSFBSheetContentHandler sheetContentsHandler, DataFormatter dataFormatter, boolean use1904Dates) {
        this.is = new LittleEndianInputStream(is);
        this.styles = styles;
        this.stringsTable = stringTable;
        this.handler = sheetContentsHandler;
        this.dataFormatter = dataFormatter;
        this.use1904Dates = use1904Dates;
    }

    public boolean parse() throws IOException {
        int bInt;
        do {
            if ((bInt = this.is.read()) != -1) continue;
            return true;
        } while (this.readNext((byte)bInt));
        return false;
    }

    private boolean readNext(byte b1) {
        int recordId;
        if ((b1 >> 7 & 1) == 1) {
            byte b2 = this.is.readByte();
            b1 = (byte)(b1 & 0xFFFFFF7F);
            b2 = (byte)(b2 & 0xFFFFFF7F);
            recordId = (b2 << 7) + b1;
        } else {
            recordId = b1;
        }
        long recordLength = 0L;
        boolean halt = false;
        for (int i = 0; i < 4 && !halt; ++i) {
            byte b = this.is.readByte();
            halt = (b >> 7 & 1) == 0;
            b = (byte)(b & 0xFFFFFF7F);
            recordLength += (long)b << i * 7;
        }
        byte[] buff = new byte[(int)recordLength];
        this.is.readFully(buff);
        return this.handleRecord(recordId, buff);
    }

    private boolean handleRecord(int id, byte[] data) throws XSSFBParseException {
        XSSFBRecordType type = XSSFBRecordType.lookup((int)id);
        switch (type) {
            case BrtRowHdr: {
                int rw = XSSFBNumberUtils.castToInt(LittleEndian.getUInt((byte[])data, (int)0));
                if (rw > 0x100000) {
                    throw new XSSFBParseException("Row number beyond allowable range: " + rw);
                }
                this.currentRow = rw;
                this.startRow(this.currentRow);
                return false;
            }
            case BrtCellIsst: {
                this.handleBrtCellIsst(data);
                break;
            }
            case BrtCellSt: {
                this.handleCellSt(data);
                break;
            }
            case BrtCellRk: {
                this.handleCellRk(data);
                break;
            }
            case BrtCellReal: {
                this.handleCellReal(data);
                break;
            }
            case BrtCellBool: {
                this.handleBoolean(data);
                break;
            }
            case BrtCellError: {
                this.handleCellError(data);
                break;
            }
            case BrtCellBlank: {
                this.beforeCellValue(data);
                break;
            }
            case BrtFmlaString: {
                this.handleFmlaString(data);
                break;
            }
            case BrtFmlaNum: {
                this.handleFmlaNum(data);
                break;
            }
            case BrtFmlaBool: {
                this.handleFmlaBool(data);
                break;
            }
            case BrtFmlaError: {
                this.handleFmlaError(data);
                break;
            }
            case BrtEndSheetData: {
                this.endRow(this.lastStartedRow);
            }
        }
        return true;
    }

    private void beforeCellValue(byte[] data) {
        XSSFBCellHeader.parse(data, 0, this.currentRow, this.cellBuffer);
    }

    private void handleCellValue(CellType cellType, Object value, XSSFBCellStyle cellStyle, String formattedValue) {
        this.handler.cell(this.currentRow, this.cellBuffer.getColNum(), cellType, value, cellStyle, formattedValue);
    }

    private void handleFmlaNum(byte[] data) {
        this.beforeCellValue(data);
        double val = LittleEndian.getDouble((byte[])data, (int)XSSFBCellHeader.length);
        XSSFBCellStyle cellStyle = this.getCellStyle(this.cellBuffer.getStyleIdx());
        this.handleCellValue(CellType.NUMERIC, val, cellStyle, this.formatVal(val, cellStyle));
    }

    private void handleFmlaBool(byte[] data) {
        this.beforeCellValue(data);
        boolean val = data[XSSFBCellHeader.length] == 1;
        String formattedVal = val ? "TRUE" : "FALSE";
        XSSFBCellStyle cellStyle = this.getCellStyle(this.cellBuffer.getStyleIdx());
        this.handleCellValue(CellType.BOOLEAN, val, cellStyle, formattedVal);
    }

    private void handleCellSt(byte[] data) {
        this.beforeCellValue(data);
        this.xlWideStringBuffer.setLength(0);
        XSSFBUtils.readXLWideString((byte[])data, (int)XSSFBCellHeader.length, (StringBuilder)this.xlWideStringBuffer);
        String val = this.xlWideStringBuffer.toString();
        this.handleCellValue(CellType.STRING, val, null, val);
    }

    private void handleFmlaString(byte[] data) {
        this.beforeCellValue(data);
        this.xlWideStringBuffer.setLength(0);
        XSSFBUtils.readXLWideString((byte[])data, (int)XSSFBCellHeader.length, (StringBuilder)this.xlWideStringBuffer);
        String val = this.xlWideStringBuffer.toString();
        this.handleCellValue(CellType.STRING, val, null, val);
    }

    private void handleCellError(byte[] data) {
        this.beforeCellValue(data);
        this.handleCellValue(CellType.ERROR, null, null, null);
    }

    private void handleFmlaError(byte[] data) {
        this.beforeCellValue(data);
        this.handleCellValue(CellType.ERROR, null, null, null);
    }

    private void handleBoolean(byte[] data) {
        this.beforeCellValue(data);
        boolean val = data[XSSFBCellHeader.length] == 1;
        String formattedVal = val ? "TRUE" : "FALSE";
        XSSFBCellStyle cellStyle = this.getCellStyle(this.cellBuffer.getStyleIdx());
        this.handleCellValue(CellType.BOOLEAN, val, cellStyle, formattedVal);
    }

    private void handleCellReal(byte[] data) {
        this.beforeCellValue(data);
        double val = LittleEndian.getDouble((byte[])data, (int)XSSFBCellHeader.length);
        XSSFBCellStyle cellStyle = this.getCellStyle(this.cellBuffer.getStyleIdx());
        this.handleCellValue(CellType.NUMERIC, val, cellStyle, this.formatVal(val, cellStyle));
    }

    private void handleCellRk(byte[] data) {
        this.beforeCellValue(data);
        double val = this.rkNumber(data, XSSFBCellHeader.length);
        XSSFBCellStyle cellStyle = this.getCellStyle(this.cellBuffer.getStyleIdx());
        this.handleCellValue(CellType.NUMERIC, val, cellStyle, this.formatVal(val, cellStyle));
    }

    private void handleBrtCellIsst(byte[] data) {
        this.beforeCellValue(data);
        int idx = XSSFBNumberUtils.castToInt(LittleEndian.getUInt((byte[])data, (int)XSSFBCellHeader.length));
        RichTextString rtss = this.stringsTable.getItemAt(idx);
        String val = rtss.getString();
        this.handleCellValue(CellType.STRING, val, null, val);
    }

    private void startRow(int row) {
        if (row != this.lastStartedRow) {
            if (this.lastStartedRow != this.lastEndedRow) {
                this.endRow(this.lastStartedRow);
            }
            this.handler.startRow(row);
            this.lastStartedRow = row;
        }
    }

    private void endRow(int row) {
        if (this.lastEndedRow != row) {
            this.handler.endRow();
            this.lastEndedRow = row;
        }
    }

    private String formatVal(double val, XSSFBCellStyle cellStyle) {
        return this.dataFormatter.formatRawCellContents(val, (int)cellStyle.getDataFormat(), cellStyle.getDataFormatString(), this.use1904Dates);
    }

    private XSSFBCellStyle getCellStyle(int styleIdx) {
        String formatString = this.styles.getNumberFormatString(styleIdx);
        short styleIndex = this.styles.getNumberFormatIndex(styleIdx);
        if (formatString == null) {
            formatString = BuiltinFormats.getBuiltinFormat((int)0);
            styleIndex = 0;
        }
        return new XSSFBCellStyle(styleIndex, formatString);
    }

    private double rkNumber(byte[] data, int offset) {
        double d;
        byte b0 = data[offset];
        boolean numDivBy100 = (b0 & 1) == 1;
        boolean floatingPoint = (b0 >> 1 & 1) == 0;
        b0 = (byte)(b0 & 0xFFFFFFFE);
        this.rkBuffer[4] = b0 = (byte)(b0 & 0xFFFFFFFD);
        System.arraycopy(data, offset + 1, this.rkBuffer, 5, 3);
        if (floatingPoint) {
            d = LittleEndian.getDouble((byte[])this.rkBuffer);
        } else {
            int rawInt = LittleEndian.getInt((byte[])this.rkBuffer, (int)4);
            d = rawInt >> 2;
        }
        d = numDivBy100 ? d / 100.0 : d;
        return d;
    }

    public static interface XSSFBSheetContentHandler {
        public void startRow(int var1);

        default public void endRow() {
        }

        public void cell(int var1, int var2, CellType var3, Object var4, XSSFBCellStyle var5, String var6);
    }
}

