/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.hive.massimport;

import com.dataiku.dip.cluster.ClusterProperty;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.HadoopSettings;
import com.dataiku.dip.connections.AzureConnection;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.EC2Connection;
import com.dataiku.dip.connections.GCSConnection;
import com.dataiku.dip.connections.HDFSAbleConnection;
import com.dataiku.dip.connections.HDFSConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.fs.HDFSDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.formats.avro.AvroFormatConfig;
import com.dataiku.dip.formats.avro.AvroFormatMeta;
import com.dataiku.dip.formats.delta.DeltaFormat;
import com.dataiku.dip.hive.HiveConfigurator;
import com.dataiku.dip.hive.HiveSchemaHandler;
import com.dataiku.dip.hive.massimport.HivePartitionGuesser;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.input.formats.csv.CSVFormatExtractor;
import com.dataiku.dip.input.formats.hive.orcfile.ORCFileFormatConfig;
import com.dataiku.dip.input.formats.hive.orcfile.ORCFileFormatMeta;
import com.dataiku.dip.input.formats.hive.rcfile.RCFileFormatConfig;
import com.dataiku.dip.input.formats.hive.rcfile.RCFileFormatMeta;
import com.dataiku.dip.input.formats.hive.sequencefile.SequenceFileFormatConfig;
import com.dataiku.dip.input.formats.hive.sequencefile.SequenceFileFormatMeta;
import com.dataiku.dip.input.formats.parquet.ParquetFormatConfig;
import com.dataiku.dip.input.formats.parquet.ParquetFormatMeta;
import com.dataiku.dip.partitioning.Dimension;
import com.dataiku.dip.partitioning.ExactValueDimension;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.StringTransmogrifier;
import com.dataiku.dss.shadelib.org.apache.http.client.utils.URIBuilder;
import com.dataiku.hproxy.model.hive.ColumnSchema;
import com.dataiku.hproxy.model.hive.PartitionSchema;
import com.dataiku.hproxy.model.hive.TableSchema;
import com.google.common.base.Joiner;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;

public class HiveImportabilityChecker {
    private static Logger logger = Logger.getLogger((String)"dku.hive.import.check");

    public HiveImportabilityChecker() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public HiveTableImportCandidate computeTableImportCandidate(String projectKey, String clusterId, AuthCtx authCtx, String database, String table, PossibleConnection selectedConnection, TableSchema tableSchema, StringTransmogrifier st2, List<HDFSAbleConnection> connections, Map<String, SQLUtils.SQLTable> alreadyImported) throws Exception {
        logger.debug((Object)("Computing import candidate db=" + database + " table=" + table + " selectedConnection=" + JSON.json((Object)selectedConnection)));
        HiveTableImportCandidate ret = new HiveTableImportCandidate();
        ret.table = table;
        ret.databaseName = database;
        if (alreadyImported != null) {
            HashSet<String> existingDatasetNames = new HashSet<String>();
            for (Map.Entry<String, SQLUtils.SQLTable> e : alreadyImported.entrySet()) {
                if (!table.equals(e.getValue().getTable()) || !database.equals(e.getValue().getSchemaNullIfBlank())) continue;
                existingDatasetNames.add(e.getKey());
            }
            ret.existingDatasetsNames = existingDatasetNames;
        }
        try {
            if (selectedConnection != null && selectedConnection.type == PossibleConnection.Type.HIVE) {
                logger.info((Object)"Preparing an import as Hive dataset");
                if (!HiveConfigurator.hiveAvailable(authCtx, projectKey)) {
                    ret.messages.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)ImportCodes.ERR_IMPORT_FAILED, (String)"Cannot import as Hive dataset because Hive is not enabled"));
                    return ret;
                }
                ret.newDataset = HiveImportabilityChecker.tableSchemaToHiveserver2Dataset(tableSchema, database, table, AbstractSQLDatasetHandler.ReadTemporalMode.AS_STRING, AbstractSQLDatasetHandler.ReadTemporalMode.AS_IS);
                if (tableSchema.partitionColumns != null && tableSchema.partitionColumns.size() > 1) {
                    ret.messages.addMessage(InfoMessage.warning((InfoMessage.MessageCode)ImportCodes.ERR_IMPORT_TABLE_PARTITIONING, (String)("The table '" + table + "' has more than 1 partitioning column, not importing the partitioning scheme")));
                }
                if (ret.newDataset.partitioning != null && ret.newDataset.partitioning.isPartitioned()) {
                    tableSchema.location = "/";
                    for (PartitionSchema partition : tableSchema.partitions) {
                        partition.location = "/" + Joiner.on((String)"/").join((Iterable)partition.keys);
                    }
                    this.tryGetPartitioning(table, tableSchema, ret);
                }
            } else if (selectedConnection != null && selectedConnection.type == PossibleConnection.Type.FILES) {
                logger.info((Object)"Preparing an import as files-based dataset");
                sdh = HiveImportabilityChecker.tableSchemaToHDFSAbleDataset(authCtx, database, table, tableSchema, connections, clusterId);
                if (sdh.mustParseAsHiveDataset) {
                    logger.warn((Object)(" --> But must import as Hive: " + sdh.forcedHiveDatasetReason.message));
                    ret.messages.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)ImportCodes.ERR_IMPORT_IMPORTABILITY_CHECK_FAILED, (String)("The table '" + table + "' can only be imported as Hive, not files-based: " + sdh.forcedHiveDatasetReason.message)));
                    return ret;
                }
                ret.newDataset = sdh.dataset;
                if (tableSchema.partitionColumns.size() > 0) {
                    this.tryGetPartitioning(table, tableSchema, ret);
                }
            } else if (selectedConnection == null) {
                logger.info((Object)"Preparing an import as any-possible");
                sdh = HiveImportabilityChecker.tableSchemaToHDFSAbleDataset(authCtx, database, table, tableSchema, connections, clusterId);
                if (sdh.mustParseAsHiveDataset) {
                    logger.info((Object)(" --> Must import as Hive: " + sdh.forcedHiveDatasetReason.message));
                    ret.newDataset = sdh.dataset;
                } else {
                    ret.newDataset = sdh.dataset;
                    ret.possibleConnections.addAll(sdh.possibleFileConnections);
                }
                if (tableSchema.partitionColumns.size() > 0) {
                    this.tryGetPartitioning(table, tableSchema, ret);
                }
                if (HiveConfigurator.hiveAvailable(authCtx, projectKey)) {
                    ret.possibleConnections.add(PossibleConnection.hive());
                }
                if (ret.possibleConnections.size() > 0) {
                    ret.selectedConnection = ret.possibleConnections.get(0);
                }
            }
            ret.columnCount = ret.newDataset.getSchema().getColumns().size();
            ret.hivePartitionCount = tableSchema.partitions.size();
            if (ret.newDataset.partitioning != null) {
                ret.partitionColumnCount = ret.newDataset.partitioning.getDimensionNames().size();
            }
            if (st2 != null) {
                ret.datasetName = ret.newDataset.name = st2.transmogrify(table);
            }
        }
        catch (Throwable t) {
            logger.error((Object)"Import check failed", t);
            ret.datasetName = ret.table;
            ret.messages.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)ImportCodes.ERR_IMPORT_IMPORTABILITY_CHECK_FAILED, (String)ExceptionUtils.getMessageWithCauses((Throwable)t)));
        }
        return ret;
    }

    private void tryGetPartitioning(String table, TableSchema tableSchema, HiveTableImportCandidate ret) {
        try {
            this.fillPartitionInfo(ret.newDataset, tableSchema);
        }
        catch (Exception ex) {
            logger.warn((Object)"Table is partitioned but the partitioning scheme was not detected. Falling back to non-partitioned.", (Throwable)ex);
            StringBuilder columnList = new StringBuilder();
            for (ColumnSchema column : tableSchema.partitionColumns) {
                ret.newDataset.getSchema().addColumn(HiveSchemaHandler.dssColumnFromHiveColumnDef(column.name, column.type, ret.newDataset.typeSystemVersion).withComment(column.comment));
                if (columnList.length() > 0) {
                    columnList.append(", ");
                }
                columnList.append(column.name);
            }
            ret.messages.addMessage(InfoMessage.warning((InfoMessage.MessageCode)ImportCodes.WARN_IMPORT_PARTITION_DETECTION_FAILED, (String)("The following columns are partitioning columns in the Hive table '" + table + "': " + columnList.toString() + ". Error : \n" + ExceptionUtils.getMessageWithCauses((Throwable)ex))));
        }
    }

    private void fillPartitionInfo(SerializedDataset newDataset, TableSchema tableSchema) throws Exception {
        PartitioningScheme partitioning = new HivePartitionGuesser().guessPatternAndTypes(tableSchema);
        if (partitioning == null) {
            throw new Exception("Unable to detect the partitions' file path pattern");
        }
        newDataset.partitioning = partitioning;
    }

    public static SerializedDatasetOrHiveDataset tableSchemaToHDFSAbleDataset(AuthCtx authCtx, String database, String table, TableSchema tableSchema, List<HDFSAbleConnection> connections, String clusterId) throws Exception {
        SerializedDataset ret;
        SerializedDatasetOrHiveDataset sdh = new SerializedDatasetOrHiveDataset();
        sdh.dataset = ret = new SerializedDataset();
        if (tableSchema.tableType != null && tableSchema.tableType.toLowerCase().contains("view")) {
            sdh.mustParseAsHiveDataset = true;
            sdh.forcedHiveDatasetReason = InfoMessage.warning((String)("The table '" + table + "' has type " + tableSchema.tableType + ", it cannot be imported as a files-based dataset"));
            ret.type = "HDFS";
        } else {
            String serDe = tableSchema.serde;
            TreeMap<String, String> serDeProps = new TreeMap<String, String>(tableSchema.serdeProps);
            TreeMap tblProps = new TreeMap(tableSchema.parameters);
            String inputFormat = tableSchema.inputFormat;
            String hdfsLocation = tableSchema.location;
            if (StringUtils.isEmpty((String)serDe)) {
                logger.warn((Object)("Failed tableSchema is " + JSON.pretty((Object)tableSchema)));
                throw new IllegalArgumentException("Failed to gather required information from Hive data : no serDe");
            }
            if (StringUtils.isEmpty((String)inputFormat) && !"delta".equals(serDe)) {
                logger.warn((Object)("Failed tableSchema is " + JSON.pretty((Object)tableSchema)));
                throw new IllegalArgumentException("Failed to gather required information from Hive data : no input format");
            }
            if (StringUtils.isEmpty((String)hdfsLocation)) {
                logger.warn((Object)("Failed tableSchema is " + JSON.pretty((Object)tableSchema)));
                throw new IllegalArgumentException("Failed to gather required information from Hive data : no location on HDFS");
            }
            HadoopSettings hadoopSettings = new ClusterSelector().selectForCluster(authCtx, clusterId, "__builtin__").getHadoopSettings();
            Configuration configuration = new Configuration();
            for (ClusterProperty kv : hadoopSettings.extraConf) {
                configuration.set(kv.key, kv.value);
            }
            String defaultFs = StringUtils.defaultIfBlank((String)configuration.get("fs.defaultFS"), (String)"hdfs://");
            URI defaultFsURI = new URIBuilder(defaultFs).build();
            URI hdfsURI = new URI(hdfsLocation);
            hdfsURI = HiveImportabilityChecker.fillURIWithDefaultFS(defaultFsURI, hdfsURI);
            String pathToMatch = hdfsURI.getPath();
            HDFSAbleConnection foundConnection = null;
            for (HDFSAbleConnection connection : connections) {
                try {
                    String recRoot = connection.getResolvedHDFSRoot(authCtx, null);
                    if (!StringUtils.isNotBlank((String)recRoot)) continue;
                    URI connectionRootURI = new URI(recRoot);
                    connectionRootURI = HiveImportabilityChecker.fillURIWithDefaultFS(defaultFsURI, connectionRootURI);
                    boolean schemeMatch = hdfsURI.getScheme() == null && connectionRootURI.getScheme() == null || hdfsURI.getScheme() != null && hdfsURI.getScheme().equals(connectionRootURI.getScheme());
                    boolean hostMatch = hdfsURI.getHost() == null && connectionRootURI.getHost() == null || hdfsURI.getHost() != null && hdfsURI.getHost().equals(connectionRootURI.getHost());
                    boolean portMatch = (hdfsURI.getPort() < 0 ? 8020 : hdfsURI.getPort()) == (connectionRootURI.getPort() < 0 ? 8020 : connectionRootURI.getPort());
                    boolean pathMatch = hdfsURI.getPath().startsWith(connectionRootURI.getPath());
                    if (!schemeMatch && hostMatch && portMatch && pathMatch && HiveImportabilityChecker.isMapRFSConfusion(hdfsURI, connectionRootURI)) {
                        logger.info((Object)("Considering that scheme matches between table=" + String.valueOf(hdfsURI) + " connection=" + String.valueOf(connectionRootURI)));
                        schemeMatch = true;
                    }
                    if (!schemeMatch && hostMatch && portMatch && pathMatch && HiveImportabilityChecker.isS3S3AConfusion(hdfsURI, connectionRootURI)) {
                        logger.info((Object)("Considering that scheme matches between table=" + String.valueOf(hdfsURI) + " connection=" + String.valueOf(connectionRootURI)));
                        schemeMatch = true;
                    }
                    if (schemeMatch && hostMatch && portMatch && pathMatch) {
                        foundConnection = connection;
                        sdh.possibleFileConnections.add(PossibleConnection.hdfsAble(connection));
                    }
                    logger.info((Object)("Compare hdfsURI: " + String.valueOf(hdfsURI) + " vs: " + String.valueOf(connectionRootURI) + " s=" + schemeMatch + " h=" + hostMatch + " p=" + portMatch + " pp=" + pathMatch));
                }
                catch (Exception e) {
                    logger.warn((Object)("Cannot import into connection " + connection.getName()), (Throwable)e);
                    logger.warn((Object)("Failed tableSchema is " + JSON.pretty((Object)tableSchema)));
                }
            }
            if (foundConnection == null) {
                sdh.mustParseAsHiveDataset = true;
                sdh.forcedHiveDatasetReason = InfoMessage.warning((String)("No HDFS connection contains table location: " + hdfsLocation));
                ret.type = "HDFS";
            } else {
                String recRoot = foundConnection.getResolvedHDFSRoot(authCtx, null);
                AbstractFSDatasetHandler.AbstractFSConfig dsParams = switch (((DSSConnection)((Object)foundConnection)).getType()) {
                    case "HDFS" -> {
                        ret.type = "HDFS";
                        HDFSDatasetHandler.Config hdfsParams = new HDFSDatasetHandler.Config();
                        hdfsParams.metastoreSynchronizationEnabled = false;
                        yield hdfsParams;
                    }
                    case "EC2" -> {
                        ret.type = "S3";
                        BuiltinFSDatasets.S3DatasetConfig s3Params = new BuiltinFSDatasets.S3DatasetConfig();
                        s3Params.metastoreSynchronizationEnabled = false;
                        s3Params.bucket = hdfsURI.getHost();
                        yield s3Params;
                    }
                    case "GCS" -> {
                        ret.type = "GCS";
                        BuiltinFSDatasets.GCSDatasetConfig gcsParams = new BuiltinFSDatasets.GCSDatasetConfig();
                        gcsParams.metastoreSynchronizationEnabled = false;
                        gcsParams.bucket = hdfsURI.getHost();
                        yield gcsParams;
                    }
                    case "Azure" -> {
                        ret.type = "Azure";
                        BuiltinFSDatasets.AzureBlobDatasetConfig azureParams = new BuiltinFSDatasets.AzureBlobDatasetConfig();
                        azureParams.metastoreSynchronizationEnabled = false;
                        azureParams.container = hdfsURI.getUserInfo();
                        yield azureParams;
                    }
                    default -> throw new IllegalStateException("Unexpected connection type " + ((DSSConnection)((Object)foundConnection)).getType());
                };
                URI connectionRootURI = new URI(recRoot);
                dsParams.connection = foundConnection.getName();
                String connectionRootURIPath = connectionRootURI.getPath();
                dsParams.path = pathToMatch.substring(connectionRootURIPath.length());
                ret.setParams(dsParams);
                if ("org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe".equals(serDe) && "org.apache.hadoop.mapred.SequenceFileInputFormat".equals(inputFormat)) {
                    config = new SequenceFileFormatConfig();
                    config.setSerdeClass(serDe);
                    config.setSerdeProperties(serDeProps);
                    ret.formatType = SequenceFileFormatMeta.META.getType();
                    ret.setFormatParams(config);
                } else if ("org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe".equals(serDe) && "org.apache.hadoop.mapred.TextInputFormat".equals(inputFormat)) {
                    ret.formatType = CSVFormatExtractor.META.getType();
                    CSVFormatConfig cf = new CSVFormatConfig();
                    cf.style = CSVFormatConfig.CSVStyle.ESCAPE_ONLY_NO_QUOTE;
                    if (serDeProps.containsKey("field.delim")) {
                        cf.setSeparatorStr((String)serDeProps.get("field.delim"));
                    } else {
                        cf.setSeparatorStr("\\u0001");
                    }
                    if (serDeProps.containsKey("escape.delim")) {
                        cf.setEscapeStr(((String)serDeProps.get("escape.delim")).replace("\\\\", "\\"));
                    } else {
                        cf.style = CSVFormatConfig.CSVStyle.NO_ESCAPE_NO_QUOTE;
                    }
                    cf.arrayMapFormat = CSVFormatConfig.CSVComplexTypeSerialization.hive;
                    cf.dateSerializationFormat = CSVFormatConfig.DateSerializationFormat.HIVE;
                    ret.setFormatParams(cf);
                } else if ("org.apache.hadoop.hive.ql.io.RCFileInputFormat".equals(inputFormat)) {
                    config = new RCFileFormatConfig();
                    config.setSerdeClass(serDe);
                    config.setSerdeProperties(serDeProps);
                    ret.formatType = RCFileFormatMeta.META.getType();
                    ret.setFormatParams(config);
                } else if ("org.apache.hadoop.hive.ql.io.orc.OrcSerde".equals(serDe)) {
                    String compressionStr;
                    config = new ORCFileFormatConfig();
                    config.setSerdeProperties(serDeProps);
                    ret.formatType = ORCFileFormatMeta.META.getType();
                    ret.setFormatParams(config);
                    String string = compressionStr = tblProps.containsKey("orc.compress") ? ((String)tblProps.get("orc.compress")).toUpperCase() : null;
                    if (StringUtils.isNotBlank(compressionStr)) {
                        try {
                            ((ORCFileFormatConfig)config).compressionMethod = ORCFileFormatConfig.CompressionMethod.valueOf(compressionStr);
                        }
                        catch (IllegalArgumentException e) {
                            logger.info((Object)("ORC compression " + compressionStr + " not handled by DSS, ignoring (re-synchronizing the table will drop the compression setting)"));
                        }
                    }
                } else if ("org.apache.hadoop.hive.serde2.avro.AvroSerDe".equals(serDe)) {
                    ret.formatType = AvroFormatMeta.META.getType();
                    ret.setFormatParams(new AvroFormatConfig());
                } else if ("org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe".equals(serDe)) {
                    String compressionStr;
                    ret.formatType = ParquetFormatMeta.META.getType();
                    config = new ParquetFormatConfig();
                    ret.setFormatParams(config);
                    String string = compressionStr = tblProps.containsKey("parquet.compression") ? ((String)tblProps.get("parquet.compression")).toUpperCase() : null;
                    if (StringUtils.isNotBlank(compressionStr)) {
                        try {
                            ((ParquetFormatConfig)config).parquetCompressionMethod = ParquetFormatConfig.CompressionMethod.valueOf(compressionStr);
                        }
                        catch (IllegalArgumentException e) {
                            logger.info((Object)("Parquet compression " + compressionStr + " not handled by DSS, ignoring (re-synchronizing the table will drop the compression setting)"));
                        }
                    }
                } else if ("delta".equals(serDe)) {
                    ret.formatType = DeltaFormat.META.getType();
                    ret.setFormatParams(new DeltaFormat.Config());
                }
                if (ret.getParams() instanceof HDFSDatasetHandler.Config) {
                    hdfsConfig = ret.getParamsAs(HDFSDatasetHandler.Config.class);
                    hdfsConfig.hiveDatabase = database;
                    hdfsConfig.hiveTableName = table;
                } else if (ret.getParams() instanceof AbstractFSDatasetHandler.AbstractMetastoreAwareFSConfig) {
                    hdfsConfig = ret.getParamsAs(AbstractFSDatasetHandler.AbstractMetastoreAwareFSConfig.class);
                    ((AbstractFSDatasetHandler.AbstractMetastoreAwareFSConfig)hdfsConfig).metastoreDatabaseName = database;
                    ((AbstractFSDatasetHandler.AbstractMetastoreAwareFSConfig)hdfsConfig).metastoreTableName = table;
                } else {
                    throw new IllegalStateException("Unexpected dataset type " + ret.type);
                }
            }
        }
        ret.setSchema(new Schema());
        ret.getSchema().userModified = true;
        for (ColumnSchema cs2 : tableSchema.columns) {
            ret.getSchema().addColumn(HiveSchemaHandler.dssColumnFromHiveColumnDef(cs2.name, cs2.type, SerializedDataset.TypeSystemVersion.V2).withComment(cs2.comment));
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("From table schema " + tableSchema.name + ", built dataset: " + JSON.pretty((Object)ret)));
        }
        return sdh;
    }

    public static SerializedDataset tableSchemaToHiveserver2Dataset(TableSchema tableSchema, String database, String table, AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode, AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode) {
        SerializedDataset ret = new SerializedDataset();
        ret.type = "hiveserver2";
        AbstractSQLDatasetHandler.AbstractSQLConfig dsParams = new AbstractSQLDatasetHandler.AbstractSQLConfig();
        dsParams.mode = "table";
        dsParams.table = table;
        dsParams.schema = database;
        dsParams.connection = "@virtual(hive-jdbc):" + dsParams.schema;
        ret.setSchema(new Schema());
        ret.getSchema().userModified = true;
        for (ColumnSchema cs2 : tableSchema.columns) {
            ret.getSchema().addColumn(HiveSchemaHandler.dssColumnFromHiveColumnDef(cs2.name, cs2.type, datetimenotzReadMode, dateonlyReadMode).withComment(cs2.comment));
        }
        ret.partitioning = new PartitioningScheme();
        if (tableSchema.partitionColumns != null && !tableSchema.partitionColumns.isEmpty()) {
            for (ColumnSchema column : tableSchema.partitionColumns) {
                ret.getSchema().addColumn(HiveSchemaHandler.dssColumnFromHiveColumnDef(column.name, column.type, datetimenotzReadMode, dateonlyReadMode).withComment(column.comment));
            }
            if (tableSchema.partitionColumns.size() >= 1) {
                dsParams.partitioningType = "custom";
                for (ColumnSchema cs2 : tableSchema.partitionColumns) {
                    ret.partitioning.addDimension((Dimension)new ExactValueDimension(cs2.name));
                }
            }
        }
        ret.setParams(dsParams);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("From table schema " + tableSchema.name + ", built dataset: " + JSON.pretty((Object)ret)));
        }
        return ret;
    }

    private static URI fillURIWithDefaultFS(URI defaultFsURI, URI hdfsURI) throws URISyntaxException {
        if (hdfsURI.getScheme() == null) {
            if (hdfsURI.getHost() == null) {
                logger.info((Object)"No scheme nor host, taking what's in default fs");
                return new URIBuilder(hdfsURI).setHost(defaultFsURI.getHost()).setPort(defaultFsURI.getPort()).setScheme(defaultFsURI.getScheme()).build();
            }
            logger.info((Object)"No scheme, taking what's in default fs");
            return new URIBuilder(hdfsURI).setScheme(defaultFsURI.getScheme()).build();
        }
        if (hdfsURI.getHost() == null) {
            logger.info((Object)"No host, taking what's in default fs");
            return new URIBuilder(hdfsURI).setHost(defaultFsURI.getHost()).setPort(defaultFsURI.getPort()).build();
        }
        return hdfsURI;
    }

    private static boolean isMapRFSConfusion(URI hdfsURI, URI connectionRootURI) {
        String hdfs = hdfsURI.getScheme();
        String root = connectionRootURI.getScheme();
        return "maprfs".equals(hdfs) && "hdfs".equals(root) || "hdfs".equals(hdfs) && "maprfs".equals(root);
    }

    private static boolean isS3S3AConfusion(URI a, URI b) {
        String aScheme = a.getScheme();
        String bScheme = b.getScheme();
        return "s3".equals(aScheme) && "s3a".equals(bScheme) || "s3a".equals(aScheme) && "s3".equals(bScheme);
    }

    public static class HiveTableImportCandidate {
        public String sourceVirtualConnection;
        public String table;
        public String databaseName;
        public String datasetName;
        public Set<String> existingDatasetsNames;
        public InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        public List<PossibleConnection> possibleConnections = new ArrayList<PossibleConnection>();
        public PossibleConnection selectedConnection;
        public transient SerializedDataset newDataset;
        public SerializedDataset dataset;
        public int columnCount;
        public int partitionColumnCount;
        public int hivePartitionCount;
        public boolean isView;

        public static HiveTableImportCandidate ofError(String database, String table, Throwable e) {
            HiveTableImportCandidate ret = new HiveTableImportCandidate();
            ret.table = table;
            ret.databaseName = database;
            ret.datasetName = ret.table;
            ret.messages.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)ImportCodes.ERR_IMPORT_IMPORTABILITY_CHECK_FAILED, (String)ExceptionUtils.getMessageWithCauses((Throwable)e)));
            return ret;
        }
    }

    public static class PossibleConnection {
        public Type type;
        public String label;
        public String id;
        public String connectionName;

        public static PossibleConnection hive() {
            PossibleConnection pc = new PossibleConnection();
            pc.type = Type.HIVE;
            pc.label = "As Hive dataset";
            pc.id = "hive";
            return pc;
        }

        public static PossibleConnection hdfsAble(HDFSAbleConnection connection) {
            PossibleConnection pc = new PossibleConnection();
            pc.type = Type.FILES;
            pc.connectionName = connection.getName();
            if (connection instanceof HDFSConnection) {
                pc.label = pc.connectionName + " (HDFS dataset)";
            } else if (connection instanceof EC2Connection) {
                pc.label = pc.connectionName + " (S3 dataset)";
            } else if (connection instanceof AzureConnection) {
                pc.label = pc.connectionName + " (Azure Blob dataset)";
            } else if (connection instanceof GCSConnection) {
                pc.label = pc.connectionName + " (GCS dataset)";
            }
            pc.id = pc.connectionName + "_" + connection.getClass().getSimpleName();
            return pc;
        }

        public static enum Type {
            HIVE,
            FILES;

        }
    }

    public static enum ImportCodes implements InfoMessage.MessageCode
    {
        INFO_IMPORT_SUCCESS("Table imported", null),
        INFO_IMPORT_INDEX_SUCCESS("Index or alias imported", null),
        ERR_IMPORT_FAILED("Could not import table", InfoMessage.FixabilityCategory.UNKNOWN),
        ERR_IMPORT_INDEX_FAILED("Could not import index or alias", InfoMessage.FixabilityCategory.UNKNOWN),
        ERR_IMPORT_TABLE_IS_VIEW("Hive table is a view, not files", InfoMessage.FixabilityCategory.USER_CONFIG),
        ERR_IMPORT_TABLE_PARTITIONING("Cannot import partitioning columns of Hive table/view", InfoMessage.FixabilityCategory.UNKNOWN),
        ERR_IMPORT_IMPORTABILITY_CHECK_FAILED("Could not check importability of table", InfoMessage.FixabilityCategory.UNKNOWN),
        WARN_IMPORT_PARTITION_DETECTION_FAILED("Could not detect the partitioning scheme", InfoMessage.FixabilityCategory.UNKNOWN);

        private final String title;
        private final InfoMessage.FixabilityCategory fixability;

        private ImportCodes(String title, InfoMessage.FixabilityCategory fixability) {
            this.title = title;
            this.fixability = fixability;
        }

        public String getCode() {
            return this.name();
        }

        public String getCodeTitle() {
            return this.title;
        }

        public InfoMessage.FixabilityCategory getFixability() {
            return this.fixability;
        }
    }

    public static class SerializedDatasetOrHiveDataset {
        public SerializedDataset dataset;
        public InfoMessage forcedHiveDatasetReason;
        public boolean mustParseAsHiveDataset;
        public List<PossibleConnection> possibleFileConnections = new ArrayList<PossibleConnection>();
    }

    public static class HiveTablesImportCandidates {
        public List<HiveTableImportCandidate> tables = new ArrayList<HiveTableImportCandidate>();

        public HiveTablesImportCandidates(List<HiveTableImportCandidate> tables) {
            this.tables = tables;
        }

        public HiveTablesImportCandidates() {
        }
    }
}

