/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.labeling.region;

import com.dataiku.dip.labeling.Annotation;
import com.dataiku.dip.labeling.ImageLabelingTask;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.labeling.classification.SimpleClassificationAnnotationRegionDispatcher;
import com.dataiku.dip.labeling.entityextraction.SimpleEntityExtractionRegionDispatcher;
import com.dataiku.dip.labeling.freetext.FreeTextAnnotationRegionDispatcher;
import com.dataiku.dip.labeling.objectdetection.SimpleObjectDetectionRegionDispatcher;
import com.dataiku.dip.labeling.region.LabelingRegionDispatcher;

public class LabelingRegionDispatcherFactory {
    public static LabelingRegionDispatcher<? extends Annotation> getDispatcher(LabelingTask task) {
        switch (task.type) {
            case OBJECT_DETECTION: {
                return new SimpleObjectDetectionRegionDispatcher(((ImageLabelingTask)task).objectDetectionIOUConflictThreshold);
            }
            case NAMED_ENTITY_EXTRACTION: {
                return new SimpleEntityExtractionRegionDispatcher();
            }
            case IMAGE_CLASSIFICATION: 
            case RECORD_CLASSIFICATION: 
            case TEXT_CLASSIFICATION: {
                return new SimpleClassificationAnnotationRegionDispatcher();
            }
            case RECORD_FREETEXT: {
                return new FreeTextAnnotationRegionDispatcher();
            }
        }
        throw new IllegalArgumentException("Cannot list regions for labeling task with type: " + String.valueOf((Object)task.type));
    }
}

