/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.mec.engine;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.containers.exec.ContainerExecConfigSelector;
import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.io.SimplePythonKernel;
import com.dataiku.dip.io.SimplePythonKernelFactory;
import com.dataiku.dip.mec.engine.DriftKernelProtocol;
import com.dataiku.dip.mec.engine.DriftRunner;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.GuavaCacheMetrics;
import com.dataiku.dip.utils.Params;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.springframework.stereotype.Service;

@Service
public class DriftKernelCachingService {
    public static final String CACHE_NAME = "drift.kernels";
    private static final int KERNEL_CACHE_DEFAULT_EXPIRATION_TIME_IN_MINUTES = 10;
    public static final String KERNEL_CACHE_EXPIRATION_MINUTES_CONFIG_KEY = "dku.caches.drift.kernels.expirationMn";
    private final Cache<String, DriftRunner> driftRunnerCache;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.mec.compute.cache");

    public DriftKernelCachingService() {
        Params p = ApplicationConfigurator.getParams();
        long kernelCacheExpirationTimeMn = p.getLongParam(KERNEL_CACHE_EXPIRATION_MINUTES_CONFIG_KEY, 10L);
        logger.infoV("Init drift.kernels kernel cache with expirationMn %d", new Object[]{kernelCacheExpirationTimeMn});
        this.driftRunnerCache = CacheBuilder.newBuilder().expireAfterAccess(kernelCacheExpirationTimeMn, TimeUnit.MINUTES).removalListener((RemovalListener)new RemovalListener<String, DriftRunner>(){

            public void onRemoval(RemovalNotification<String, DriftRunner> removalNotification) {
                try {
                    ((DriftRunner)removalNotification.getValue()).close();
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to remove kernel", (Throwable)e);
                }
            }
        }).build();
        DSSMetrics.registry().registerAll(GuavaCacheMetrics.cacheMetricsSet((String)CACHE_NAME, this.driftRunnerCache));
    }

    @Nullable
    public DriftRunner getIfPresent(Object o) {
        return (DriftRunner)this.driftRunnerCache.getIfPresent(o);
    }

    public void put(String s, DriftRunner driftRunner) {
        this.driftRunnerCache.put((Object)s, (Object)driftRunner);
    }

    public synchronized DriftRunner getCachedDriftRunner(DSSAuthCtx owner, String projectKey) throws Exception {
        String containerExecConfig = new ContainerExecConfigSelector().selectConfName_autoTXN(owner, projectKey, new ContainerExecSelection(ContainerExecSelection.ContainerExecMode.INHERIT));
        String kernelId = projectKey + "-" + containerExecConfig;
        DriftRunner driftRunner = this.getIfPresent(kernelId);
        if (driftRunner == null || driftRunner.isDeadKernel()) {
            logger.info((Object)("No existing drift kernel was found for id " + kernelId + " , starting one"));
            SimplePythonKernel kernel = SimplePythonKernelFactory.prepareKernel(owner, projectKey, GeneralSettingsDAO.CGrouppableProcessType.ML_KERNEL, null, "dataiku.modelevaluation.server", false, containerExecConfig, "drift");
            DriftKernelProtocol protocol = new DriftKernelProtocol(kernel);
            driftRunner = new DriftRunner(protocol);
            this.put(kernelId, driftRunner);
        } else {
            logger.info((Object)("A drift kernel is already up for " + kernelId + " : using it for computation"));
        }
        return driftRunner;
    }

    public void cleanUp() {
        logger.info((Object)"Cleaning up drift kernel cache");
        this.driftRunnerCache.cleanUp();
    }

    public void invalidateAll() {
        logger.info((Object)"Invalidating drift kernel cache");
        this.driftRunnerCache.invalidateAll();
    }
}

