/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.engines;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowInputStream;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datasets.DatasetSelection;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.UniversalSingleThreadPuller;
import com.dataiku.dip.futures.DSSFuturePayloadUtils;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricComputation;
import com.dataiku.dip.metrics.MetricComputer;
import com.dataiku.dip.metrics.MetricsComputationService;
import com.dataiku.dip.metrics.MetricsEngineDesc;
import com.dataiku.dip.metrics.engines.MetricsEngine;
import com.dataiku.dip.metrics.engines.MetricsEngineRun;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class DSSMetricsEngine
implements MetricsEngine {
    private final Dataset dataset;
    private final Partition partition;
    private final DSSMetricsEngineConfig config;
    private final MetricsEngineDesc.MetricsEngineContext context;

    public DSSMetricsEngine(Dataset dataset, Partition partition, DSSMetricsEngineConfig config, MetricsEngineDesc.MetricsEngineContext context) {
        this.dataset = dataset;
        this.partition = partition;
        this.config = config;
        this.context = context;
    }

    @Override
    public Map<Metric, String> compute(List<MetricComputation> computations, MetricsComputationService.MetricsEngineRunReport report, FutureService futureService, AuthCtx authCtx, Map<String, String> alreadyComputed) throws Exception {
        DSSMetricsEngineComputationThread ft = new DSSMetricsEngineComputationThread((DSSAuthCtx)this.context.user, this.dataset, this.config.selection, this.partition, computations, alreadyComputed);
        FutureResponse fr = futureService.runFuture(ft, 100L, new TypeToken<FutureResponse<List<MetricsComputationService.ValuedMetric>>>(){});
        fr = futureService.waitForFinalResponse(fr);
        if (!fr.hasResult || fr.result == null) {
            throw new Exception("No result from metric computation, check logs of the future thread");
        }
        HashMap metricsValues = Maps.newHashMap();
        for (MetricsComputationService.ValuedMetric valuedMetric : (List)fr.result) {
            metricsValues.put(valuedMetric.metric, valuedMetric.value);
        }
        return metricsValues;
    }

    public static FuturePayload buildFuturePayload(Dataset dataset) {
        FuturePayload fp = new FuturePayload();
        fp.action = "metrics_dss_computation";
        fp.targets.add(DSSFuturePayloadUtils.forDataset(dataset).withPart("metrics"));
        fp.displayName = "Compute metrics using Stream engine on " + dataset.getFullName();
        return fp;
    }

    public static class DSSMetricsEngineConfig {
        public boolean active = true;
        public StreamableDatasetSelection selection = StreamableDatasetSelection.full();
    }

    public static class DSSMetricsEngineComputationThread
    extends SimpleFutureThread<List<MetricsComputationService.ValuedMetric>> {
        private final Dataset dataset;
        private final Partition partition;
        private final StreamableDatasetSelection selection;
        private final List<MetricComputation> computations;
        private final Map<String, String> alreadyComputed;
        private final FuturePayload futurePayload;
        private static DKULogger logger;

        public DSSMetricsEngineComputationThread(DSSAuthCtx user, Dataset dataset, StreamableDatasetSelection selection, Partition partition, List<MetricComputation> computations, Map<String, String> alreadyComputed) {
            super((AuthCtx)user);
            this.dataset = dataset;
            this.partition = partition;
            this.selection = selection;
            this.computations = computations;
            this.alreadyComputed = alreadyComputed;
            this.futurePayload = DSSMetricsEngine.buildFuturePayload(dataset);
        }

        @Override
        public double getDangerosity() {
            return 1.0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected List<MetricsComputationService.ValuedMetric> compute() throws Exception {
            final StreamColumnFactory cf = new StreamColumnFactory();
            final HashMap columnByName = Maps.newHashMap();
            for (SchemaColumn column : this.dataset.getSchema().getColumns()) {
                columnByName.put(column.getName(), column);
            }
            DSSMetricsEngineCallbacks callbacks = new DSSMetricsEngineCallbacks(){

                @Override
                public Dataset getDataset() {
                    return dataset;
                }

                @Override
                public StreamColumnFactory getColumnFactory() {
                    return cf;
                }

                @Override
                public Map<String, SchemaColumn> getColumnByName() {
                    return columnByName;
                }

                @Override
                public VariablesContext getVariablesContext() {
                    try {
                        VariablesService variablesService = (VariablesService)SpringUtils.getBean(VariablesService.class);
                        return variablesService != null ? variablesService.getForProject(dataset.getProjectKey()) : null;
                    }
                    catch (NoSuchBeanDefinitionException e) {
                        logger.info((Object)"No variables context available for DSS Metrics engine", (Throwable)e);
                        return null;
                    }
                }
            };
            StreamableDatasetSelection datasetSelection = this.selection;
            if (!MetricsComputationService.isFullDataset(this.dataset, this.partition)) {
                datasetSelection.partitionSelectionMethod = DatasetSelection.PartitionSelectionMethod.SELECTED;
                datasetSelection.selectedPartitions = Lists.newArrayList((Object[])new String[]{this.partition.id()});
            }
            DSSMetricsEngineComputer computer = (DSSMetricsEngineComputer)this.computations.get((int)0).computer;
            DSSMetricsEngineComputer.DSSComputerSession session = computer.start(callbacks, this.computations, this.alreadyComputed);
            WarningsContext warningsContext = new WarningsContext();
            try {
                Row row;
                RowInputStream is = UniversalSingleThreadPuller.pull(this.owner, this.dataset, datasetSelection, (ColumnFactory)cf, warningsContext);
                while ((row = is.next()) != null && computer.accumulate(row, session)) {
                }
                Map<Metric, String> metricsValues = computer.getAggregates(session);
                ArrayList ret = Lists.newArrayList();
                for (Map.Entry<Metric, String> e : metricsValues.entrySet()) {
                    ret.add(new MetricsComputationService.ValuedMetric(e.getKey(), e.getValue()));
                }
                ArrayList arrayList = ret;
                return arrayList;
            }
            finally {
                try {
                    computer.cleanup(session);
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to cleanup metrics aggregator", (Throwable)e);
                }
            }
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        static {
            JSON.registerAdapter(DSSMetricsEngineComputationThread.class, (Object)new JSON.Adapter<DSSMetricsEngineComputationThread>(){

                public DSSMetricsEngineComputationThread deserialize(JsonElement jsonElement, Type scriptType, JsonDeserializationContext ctx) throws JsonParseException {
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    DSSAuthCtx owner = (DSSAuthCtx)((Object)ctx.deserialize(jsonObj.get("owner"), DSSAuthCtx.class));
                    String datasetFullName = jsonObj.get("datasetFullName").getAsString();
                    SerializedDataset serializedDataset = (SerializedDataset)ctx.deserialize(jsonObj.get("dataset"), SerializedDataset.class);
                    Dataset dataset = Dataset.fromSerialized(datasetFullName, serializedDataset);
                    StreamableDatasetSelection selection = (StreamableDatasetSelection)((Object)ctx.deserialize(jsonObj.get("selection"), StreamableDatasetSelection.class));
                    String partitionId = jsonObj.get("partitionId").getAsString();
                    Partition partition = dataset.getPartitioningSchema() != null ? MetricsComputationService.makePartitionFromId(dataset.getPartitioningSchema(), partitionId) : Partition.newNP();
                    ArrayList computations = Lists.newArrayList();
                    JsonArray computersArray = jsonObj.get("computers").getAsJsonArray();
                    JsonArray metricsArray = jsonObj.get("metrics").getAsJsonArray();
                    Map alreadyComputed = (Map)ctx.deserialize(jsonObj.get("alreadyComputed"), new TypeToken<Map<String, String>>(){}.getType());
                    for (int i = 0; i < computersArray.size(); ++i) {
                        DSSMetricsEngineComputer computer;
                        JsonObject computerObj = computersArray.get(i).getAsJsonObject();
                        String computerClassName = computerObj.get("computerClassName").getAsString();
                        try {
                            computer = (DSSMetricsEngineComputer)Class.forName(computerClassName).newInstance();
                        }
                        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                            throw new JsonParseException("Unknown computer class " + computerClassName, (Throwable)e);
                        }
                        computer.readJson(computerObj, ctx);
                        Metric metric = (Metric)ctx.deserialize(metricsArray.get(i), Metric.class);
                        Probe probe = (Probe)ctx.deserialize(computerObj.get("probe"), Probe.class);
                        computations.add(new MetricComputation(probe, computer, metric, 0.0));
                    }
                    DSSMetricsEngineComputationThread ft = new DSSMetricsEngineComputationThread(owner, dataset, selection, partition, computations, alreadyComputed);
                    return ft;
                }

                public JsonElement serialize(DSSMetricsEngineComputationThread ft, Type type, JsonSerializationContext ctx) {
                    JsonObject ret = new JsonObject();
                    ret.add("owner", ctx.serialize((Object)ft.owner));
                    ret.addProperty("datasetFullName", ft.dataset.getFullName());
                    ret.add("dataset", ctx.serialize((Object)ft.dataset.serialize()));
                    ret.add("selection", ctx.serialize((Object)ft.selection));
                    ret.add("partitionId", ctx.serialize((Object)ft.partition.id()));
                    JsonArray computersArray = new JsonArray();
                    JsonArray metricsArray = new JsonArray();
                    for (MetricComputation computation : ft.computations) {
                        JsonObject computerObj = ((DSSMetricsEngineComputer)computation.computer).writeJson(ctx);
                        computerObj.addProperty("computerClassName", computation.computer.getClass().getName());
                        computerObj.add("probe", ctx.serialize((Object)computation.probe));
                        computersArray.add((JsonElement)computerObj);
                        metricsArray.add(ctx.serialize((Object)computation.metric, Metric.class));
                    }
                    ret.add("computers", (JsonElement)computersArray);
                    ret.add("metrics", (JsonElement)metricsArray);
                    ret.add("alreadyComputed", ctx.serialize(ft.alreadyComputed));
                    return ret;
                }
            });
            logger = DKULogger.getLogger((String)"dku.metrics.stream");
        }
    }

    public static interface DSSMetricsEngineCallbacks {
        public StreamColumnFactory getColumnFactory();

        public Dataset getDataset();

        public Map<String, SchemaColumn> getColumnByName();

        public VariablesContext getVariablesContext();
    }

    public static abstract class DSSMetricsEngineComputer
    extends MetricComputer.DSSEngineComputer {
        public abstract DSSComputerSession start(DSSMetricsEngineCallbacks var1, List<MetricComputation> var2, Map<String, String> var3) throws Exception;

        public abstract boolean accumulate(Row var1, DSSComputerSession var2) throws Exception;

        public abstract Map<Metric, String> getAggregates(DSSComputerSession var1) throws Exception;

        public abstract void cleanup(DSSComputerSession var1) throws Exception;

        public abstract JsonObject writeJson(JsonSerializationContext var1);

        public abstract void readJson(JsonObject var1, JsonDeserializationContext var2);

        public boolean canComputeWith(List<MetricComputation> handledComputations, List<MetricComputation> otherComputations) {
            return false;
        }

        public static interface DSSComputerSession {
        }
    }

    public static class DSSMetricsEngineRun
    extends MetricsEngineRun {
        public DSSMetricsEngineRun() {
            super(MetricsEngineDesc.DSSEngine);
        }

        public DSSMetricsEngineRun(double cost, List<MetricComputation> computations, int pass) {
            super(MetricsEngineDesc.DSSEngine, cost, computations, pass);
        }

        @Override
        protected MetricsEngineRun subset(double cost, List<MetricComputation> computations) {
            return new DSSMetricsEngineRun(cost, computations, this.pass);
        }

        @Override
        public boolean canMergeWith(MetricsEngineRun other) {
            int maxComputationCount = DKUApp.getParams().getIntParam("dku.metricsEngine.dss.maxMetricsPerRun", Integer.valueOf(500));
            return super.canMergeWith(other) && this.countAfterMergeStaysBelow(other, maxComputationCount) && ((DSSMetricsEngineComputer)this.getComputations().get((int)0).computer).canComputeWith(this.getComputations(), other.getComputations());
        }
    }
}

