/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.builders;

import com.dataiku.dip.pivot.UnsupportedOperation;
import com.dataiku.dip.pivot.backend.common.ResponseValidator;
import com.dataiku.dip.pivot.backend.common.highcardinality.BinsAndTensorsSafetyChecks;
import com.dataiku.dip.pivot.backend.common.highcardinality.PostPruneSafetyChecks;
import com.dataiku.dip.pivot.backend.dss.DataTensor;
import com.dataiku.dip.pivot.backend.dss.GenericDataTensor;
import com.dataiku.dip.pivot.backend.dss.LongDataTensor;
import com.dataiku.dip.pivot.backend.model.Aggregation;
import com.dataiku.dip.pivot.backend.model.AxisElt;
import com.dataiku.dip.pivot.backend.model.PivotTableAggregatedRequest;
import com.dataiku.dip.pivot.backend.model.PivotTableTensorRequest;
import com.dataiku.dip.pivot.backend.model.PivotTableTensorResponse;
import com.dataiku.dip.pivot.backend.sql.binners.AxisBinner;
import com.dataiku.dip.pivot.backend.sql.binners.BinnerBuilder;
import com.dataiku.dip.pivot.backend.sql.binners.DoubleAxisBinner;
import com.dataiku.dip.pivot.backend.sql.binners.LongAxisBinner;
import com.dataiku.dip.pivot.backend.sql.binners.StringAxisBinner;
import com.dataiku.dip.pivot.backend.sql.builders.BasicStatsBuilder;
import com.dataiku.dip.pivot.backend.sql.builders.InMemoryResultSet;
import com.dataiku.dip.pivot.backend.sql.utils.NullableDoubleArrayList;
import com.dataiku.dip.pivot.backend.sql.utils.NullableLongArrayList;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public class TensorPivotBuilder {
    private final PivotTableTensorRequest req;
    private final BasicStatsBuilder.BasicStats stats;

    public TensorPivotBuilder(PivotTableTensorRequest req, BasicStatsBuilder.BasicStats stats) {
        this.req = req;
        this.stats = stats;
    }

    public PivotTableTensorResponse parseResponse(InMemoryResultSet main, List<InMemoryResultSet> axes) throws SQLException, BinsAndTensorsSafetyChecks.MemoryLimitExceededException {
        int i;
        PivotTableTensorResponse resp = new PivotTableTensorResponse(axes.size(), this.req);
        ArrayList<AxisBinner> binners = new ArrayList<AxisBinner>();
        BinnerBuilder builder = new BinnerBuilder(this.stats, this.req.computeSubTotals);
        for (int i2 = 0; i2 < axes.size(); ++i2) {
            int bins;
            InMemoryResultSet imrs = axes.get(i2);
            if (imrs != null) {
                bins = builder.getNbBins(this.req.axes[i2], imrs.axes[0]);
                BinsAndTensorsSafetyChecks.failIfTensorWouldBeTooLargeOrTooManyBins((PivotTableAggregatedRequest)this.req, new int[]{bins}, imrs.aggregations == null ? 0L : (long)imrs.aggregations.size());
                binners.add(builder.buildFromAxis(this.req.axes[i2], imrs.axes[0]));
                continue;
            }
            bins = builder.getNbBins(this.req.axes[i2], main.axes[i2]);
            BinsAndTensorsSafetyChecks.failIfTensorWouldBeTooLargeOrTooManyBins((PivotTableAggregatedRequest)this.req, new int[]{bins}, 1L);
            binners.add(builder.buildFromData(this.req.axes[i2], main.axes[i2]));
        }
        int[] axisLengths = new int[axes.size()];
        for (i = 0; i < axes.size(); ++i) {
            resp.axisLabels[i] = ((AxisBinner)binners.get(i)).getAxisElts();
            axisLengths[i] = resp.axisLabels[i].size();
        }
        BinsAndTensorsSafetyChecks.failIfTensorWouldBeTooLargeOrTooManyBins((PivotTableAggregatedRequest)this.req, axisLengths, this.req.aggregations.size());
        PostPruneSafetyChecks.checkTensorResponse(this.req, resp);
        resp.counts = new LongDataTensor(axisLengths);
        for (i = 0; i < this.req.aggregations.size(); ++i) {
            DataTensor matrix = new GenericDataTensor.Builder<Object>().clazz(Object.class).axisLengths(axisLengths).build();
            resp.aggregations.add(matrix);
        }
        int binCount = main.counts.size();
        int[][] binIndexes = new int[axes.size()][];
        boolean[] otherBinIsEmpty = new boolean[axes.size()];
        int[] otherBinIndexes = new int[axes.size()];
        for (int j = 0; j < axes.size(); ++j) {
            int binIdx;
            int i3;
            Object data;
            binIndexes[j] = new int[binCount];
            int[] bins = binIndexes[j];
            AxisBinner binner = (AxisBinner)binners.get(j);
            AxisElt otherBin = binner.getOtherBin();
            otherBinIndexes[j] = otherBin == null ? -1 : otherBin.binIndex;
            otherBinIsEmpty[j] = true;
            if (binner instanceof LongAxisBinner) {
                data = (NullableLongArrayList)((Object)main.axes[j]);
                LongAxisBinner longBinner = (LongAxisBinner)binner;
                for (i3 = 0; i3 < binCount; ++i3) {
                    bins[i3] = binIdx = longBinner.assign(((NullableLongArrayList)((Object)data)).getNullable(i3));
                    int n = j;
                    otherBinIsEmpty[n] = otherBinIsEmpty[n] & binIdx != otherBinIndexes[j];
                }
                continue;
            }
            if (binner instanceof DoubleAxisBinner) {
                data = (NullableDoubleArrayList)((Object)main.axes[j]);
                DoubleAxisBinner doubleBinner = (DoubleAxisBinner)binner;
                for (i3 = 0; i3 < binCount; ++i3) {
                    bins[i3] = binIdx = doubleBinner.assign(((NullableDoubleArrayList)((Object)data)).getNullable(i3));
                    int n = j;
                    otherBinIsEmpty[n] = otherBinIsEmpty[n] & binIdx != otherBinIndexes[j];
                }
                continue;
            }
            if (binner instanceof StringAxisBinner) {
                data = (ArrayList)main.axes[j];
                StringAxisBinner stringBinner = (StringAxisBinner)binner;
                for (i3 = 0; i3 < binCount; ++i3) {
                    bins[i3] = binIdx = stringBinner.assign((String)((ArrayList)data).get(i3));
                    int n = j;
                    otherBinIsEmpty[n] = otherBinIsEmpty[n] & binIdx != otherBinIndexes[j];
                }
                continue;
            }
            throw new UnsupportedOperation("Unsupported type");
        }
        BitSet aggrsFilled = new BitSet(resp.aggregations.size());
        for (int i4 = 0; i4 < binCount; ++i4) {
            int j;
            int[] coords = new int[axes.size()];
            for (j = 0; j < axes.size(); ++j) {
                coords[j] = binIndexes[j][i4];
            }
            resp.counts.put(coords, main.counts.get(i4));
            for (j = 0; j < resp.aggregations.size(); ++j) {
                Object v = main.aggregations.get(j).get(i4, true);
                DataTensor tensor = (DataTensor)resp.aggregations.get(j);
                if (((Aggregation)this.req.aggregations.get((int)j)).function == Aggregation.Function.COUNTD && !aggrsFilled.get(j)) {
                    this.fillTensorAxes(axes, j, tensor);
                    aggrsFilled.set(j);
                }
                if (main.aggregations.get((int)j).nonNullCounts != null) {
                    tensor.incrementNonNullCount(coords, main.aggregations.get((int)j).nonNullCounts[i4]);
                }
                if (v == null) continue;
                tensor.set(coords, v, true);
            }
        }
        for (long v : resp.counts.tensor) {
            resp.afterFilterRecords += v;
        }
        TIntHashSet axisIndexWhereToDropOtherBinSet = new TIntHashSet(axes.size() + 1, 1.0f, -1);
        for (int j = 0; j < axes.size(); ++j) {
            if (otherBinIndexes[j] == -1 || !otherBinIsEmpty[j]) continue;
            axisIndexWhereToDropOtherBinSet.add(j);
        }
        if (!axisIndexWhereToDropOtherBinSet.isEmpty()) {
            resp = this.dropOtherBin((TIntSet)axisIndexWhereToDropOtherBinSet, otherBinIndexes, axes, resp);
        }
        resp.aggregations.forEach(DataTensor::replaceInvalidValues);
        ResponseValidator.validateNonEmptyAxes(resp.counts);
        return resp;
    }

    private PivotTableTensorResponse dropOtherBin(TIntSet axisIndexWhereToDropOtherBinSet, int[] otherBinIndexes, List<InMemoryResultSet> axes, PivotTableTensorResponse resp) {
        PivotTableTensorResponse newResp = new PivotTableTensorResponse(axes.size(), this.req);
        int[] axisLengths = this.dropOtherBinFromAxisLabels(axisIndexWhereToDropOtherBinSet, otherBinIndexes, axes, resp, newResp);
        this.dropOtherBinFromCountTensor(axisIndexWhereToDropOtherBinSet, otherBinIndexes, resp, newResp, axisLengths);
        newResp.aggregations = new ArrayList();
        for (DataTensor ddt : resp.aggregations) {
            this.dropOtherBinFromAggregationTensorAndNonNullCounts(axisIndexWhereToDropOtherBinSet, otherBinIndexes, ddt, axisLengths, newResp);
        }
        newResp.afterFilterRecords = resp.afterFilterRecords;
        return newResp;
    }

    private int[] dropOtherBinFromAxisLabels(TIntSet axisIndexWhereToDropOtherBinSet, int[] otherBinIndexes, List<InMemoryResultSet> axes, PivotTableTensorResponse resp, PivotTableTensorResponse newResp) {
        int[] axisLengths = new int[axes.size()];
        for (int i = 0; i < axes.size(); ++i) {
            if (axisIndexWhereToDropOtherBinSet.contains(i)) {
                for (AxisElt elt : resp.axisLabels[i]) {
                    if (elt.binIndex == otherBinIndexes[i]) continue;
                    newResp.axisLabels[i].add(elt);
                }
                axisLengths[i] = resp.axisLabels[i].size() - 1;
                continue;
            }
            newResp.axisLabels[i] = resp.axisLabels[i];
            axisLengths[i] = resp.axisLabels[i].size();
        }
        return axisLengths;
    }

    private void dropOtherBinFromCountTensor(TIntSet axisIndexWhereToDropOtherBinSet, int[] otherBinIndexes, PivotTableTensorResponse resp, PivotTableTensorResponse newResp, int[] axisLengths) {
        newResp.counts = new LongDataTensor(axisLengths);
        int writeIndex = 0;
        for (int readIdx = 0; readIdx < resp.counts.tensor.length; ++readIdx) {
            int[] coordinates = resp.counts.getCoordinates(readIdx);
            if (this.hasOtherBinToDropInCoordinates(coordinates, axisIndexWhereToDropOtherBinSet, otherBinIndexes)) continue;
            newResp.counts.tensor[writeIndex] = resp.counts.tensor[readIdx];
            ++writeIndex;
        }
    }

    private void dropOtherBinFromAggregationTensorAndNonNullCounts(TIntSet axisIndexWhereToDropOtherBinSet, int[] otherBinIndexes, DataTensor<?> dataTensor, int[] axisLengths, PivotTableTensorResponse newResp) {
        boolean hasNonNullCount = dataTensor.nonNullCounts != null && dataTensor.nonNullCounts.length == dataTensor.getTensor().length;
        DataTensor<?> newDataTensor = new GenericDataTensor.Builder<Object>().clazz(Object.class).axisLengths(axisLengths).initNonNullCounts(hasNonNullCount).build();
        newDataTensor.type = dataTensor.type;
        newResp.aggregations.add(newDataTensor);
        int writeIndex = 0;
        for (int readIdx = 0; readIdx < dataTensor.getTensor().length; ++readIdx) {
            int[] coordinates = dataTensor.getCoordinates(readIdx);
            if (this.hasOtherBinToDropInCoordinates(coordinates, axisIndexWhereToDropOtherBinSet, otherBinIndexes)) continue;
            newDataTensor.set(writeIndex, dataTensor.get(readIdx, true));
            if (hasNonNullCount) {
                newDataTensor.nonNullCounts[writeIndex] = dataTensor.nonNullCounts[readIdx];
            }
            ++writeIndex;
        }
        if (hasNonNullCount) {
            for (int i = 0; i < dataTensor.axesNonNullCounts.length; ++i) {
                if (axisIndexWhereToDropOtherBinSet.contains(i)) {
                    int writeIndex2 = 0;
                    for (int j = 0; j < dataTensor.axesNonNullCounts[i].length; ++j) {
                        if (j == otherBinIndexes[i]) continue;
                        newDataTensor.axesNonNullCounts[i][writeIndex2] = dataTensor.axesNonNullCounts[i][j];
                        ++writeIndex2;
                    }
                    continue;
                }
                newDataTensor.axesNonNullCounts[i] = dataTensor.axesNonNullCounts[i];
            }
        }
    }

    private boolean hasOtherBinToDropInCoordinates(int[] coordinates, TIntSet axisIndexWhereToDropOtherBinSet, int[] otherBinIndexes) {
        for (int axisIndex : axisIndexWhereToDropOtherBinSet) {
            if (coordinates[axisIndex] != otherBinIndexes[axisIndex]) continue;
            return true;
        }
        return false;
    }

    private void fillTensorAxes(List<InMemoryResultSet> axes, int j, DataTensor<Object> tensor) {
        if (axes == null || tensor == null) {
            return;
        }
        block0: for (int axis = 0; axis < axes.size(); ++axis) {
            int y = 0;
            while ((long)y < axes.get((int)axis).count) {
                InMemoryResultSet inMemoryResultSet = axes.get(axis);
                if (inMemoryResultSet == null) {
                    axis = axes.size();
                    continue block0;
                }
                tensor.setAxis(axis, y, inMemoryResultSet.aggregations.get(j).get(y));
                ++y;
            }
        }
    }
}

