/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.cache;

import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.model.FilterFacet;
import com.dataiku.dip.pivot.backend.model.RowFilter;
import com.dataiku.dip.pivot.backend.sql.cache.LRUList;
import com.dataiku.dip.pivot.backend.sql.utils.FilterUtils;
import com.dataiku.dip.pivot.frontend.model.ChartFilter;
import com.dataiku.dip.utils.JSON;
import java.util.ArrayList;
import java.util.List;

public class FacetCache {
    private LRUList<CachedFacet> data;

    public FacetCache(int size) {
        this.data = new LRUList(size);
    }

    public synchronized CachedFacet findExactMatch(List<RowFilter> filters, RowFilter rf) {
        for (CachedFacet cf : this.data) {
            if (!FilterUtils.isEquivalent(filters, cf.filters) || !FilterUtils.isSameFacet(rf, cf.rf)) continue;
            return cf;
        }
        return null;
    }

    public synchronized FilterFacet reconstructFacet(List<RowFilter> filters, RowFilter rf) {
        if (rf.columnType == AxisDef.Type.NUMERICAL || rf.columnType == AxisDef.Type.DATE && rf.dateFilterType == ChartFilter.DateFilterType.RANGE) {
            List<CachedFacet> lessRestrictive = this.findWithLessRestrictiveFilters(filters, rf);
            List<CachedFacet> moreRestrictive = this.findWithMoreRestrictiveFilters(filters, rf);
            Double minValue = null;
            Double maxValue = null;
            double globalMaxValue = Double.MIN_VALUE;
            double globalMinValue = Double.MAX_VALUE;
            for (CachedFacet less : lessRestrictive) {
                for (CachedFacet more : moreRestrictive) {
                    if (less.facet.minValue == more.facet.minValue) {
                        minValue = less.facet.minValue;
                    }
                    if (less.facet.maxValue == more.facet.maxValue) {
                        maxValue = less.facet.maxValue;
                    }
                    globalMaxValue = Math.max(globalMaxValue, Math.max(less.facet.globalMaxValue, more.facet.globalMaxValue));
                    globalMinValue = Math.min(globalMinValue, Math.min(less.facet.globalMinValue, more.facet.globalMinValue));
                }
                if (maxValue == null || minValue == null) continue;
                FilterFacet output = new FilterFacet();
                output.maxValue = maxValue;
                output.minValue = minValue;
                output.globalMinValue = globalMinValue;
                output.globalMaxValue = globalMaxValue;
                return output;
            }
        }
        return null;
    }

    public synchronized FilterFacet get(List<RowFilter> filters, RowFilter rf) {
        CachedFacet cachedFacet = this.findExactMatch(filters, rf);
        if (cachedFacet != null) {
            return cachedFacet.facet;
        }
        FilterFacet facet = this.reconstructFacet(filters, rf);
        if (facet != null) {
            return facet;
        }
        return null;
    }

    public synchronized List<CachedFacet> findWithLessRestrictiveFilters(List<RowFilter> filters, RowFilter rf) {
        ArrayList<CachedFacet> rfs = new ArrayList<CachedFacet>();
        for (CachedFacet cf : this.data) {
            if (!FilterUtils.isIncludedIn(filters, cf.filters) || !FilterUtils.isSameFacet(rf, cf.rf)) continue;
            rfs.add(cf);
        }
        return rfs;
    }

    public synchronized List<CachedFacet> findWithMoreRestrictiveFilters(List<RowFilter> filters, RowFilter rf) {
        ArrayList<CachedFacet> rfs = new ArrayList<CachedFacet>();
        for (CachedFacet cf : this.data) {
            if (!FilterUtils.isIncludedIn(cf.filters, filters) || !FilterUtils.isSameFacet(rf, cf.rf)) continue;
            rfs.add(cf);
        }
        return rfs;
    }

    public synchronized void put(List<RowFilter> filters, RowFilter rf, FilterFacet facet) {
        CachedFacet cf = new CachedFacet();
        cf.facet = (FilterFacet)JSON.deepCopy((Object)facet);
        cf.rf = (RowFilter)JSON.deepCopy((Object)rf);
        cf.filters = FilterUtils.intersectAndSort(filters);
        this.data.addAndCollect(cf);
    }

    public static class CachedFacet {
        public List<RowFilter> filters;
        public RowFilter rf;
        public FilterFacet facet;
    }
}

