/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.executors;

import com.dataiku.dip.pivot.backend.sql.utils.ConnectionPool;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.resourceusage.SQLComputeResourceUsage;
import java.sql.SQLException;

public final class SqlExecutionHelper {
    public static void execute(ConnectionPool.PooledConnection connection, ConnectionPool.ManagedStatement stmt, String sql, boolean reportCRU) throws SQLException, InterruptedException {
        SqlExecutionHelper.executeNoInterruptCheck(connection, stmt, sql, reportCRU);
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException("Thread: " + Thread.currentThread().getName() + " got interrupted when executing: " + sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeNoInterruptCheck(ConnectionPool.PooledConnection connection, ConnectionPool.ManagedStatement stmt, String sql, boolean reportCRU) throws SQLException {
        ComputeResourceUsage cru = reportCRU ? SQLComputeResourceUsage.forSQLQuery(connection.getSqlConnection(), sql).reportStartNoFail() : null;
        try {
            stmt.get().execute(sql);
        }
        finally {
            if (cru != null) {
                cru.reportCompleteNoFail();
            }
        }
    }

    public static void execute(ConnectionPool.ManagedPreparedStatement stmt) throws SQLException {
        stmt.get().execute();
    }
}

